/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositeEntry;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositeTableRow;

public class CompositingControl
extends Composite
implements SelectionListener {
    private Table tblComposits;
    private List<CompositeTableRow> rows = new ArrayList<CompositeTableRow>();
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public CompositingControl(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new FillLayout());
        this.tblComposits = new Table((Composite)this, 0x20000000);
        this.tblComposits.setHeaderVisible(true);
        this.tblComposits.setLinesVisible(true);
        this.tblComposits.setEnabled(true);
        TableColumn tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(70);
        tableColumn.setResizable(false);
        tableColumn.setText("Active");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(330);
        tableColumn.setResizable(true);
        tableColumn.setText("Layer");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(190);
        tableColumn.setResizable(false);
        tableColumn.setText("Weight (%)");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(120);
        tableColumn.setResizable(false);
        tableColumn.setText("Operation");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(40);
        tableColumn.setResizable(false);
        tableColumn.setText("R");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(40);
        tableColumn.setResizable(false);
        tableColumn.setText("G");
        tableColumn = new TableColumn(this.tblComposits, 0);
        tableColumn.setWidth(40);
        tableColumn.setResizable(false);
        tableColumn.setText("B");
    }

    private void clearRows() {
        Iterator<CompositeTableRow> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.tblComposits.removeAll();
        this.rows.clear();
    }

    public void updateTable(final List<CompositeEntry> list) {
        final CompositingControl compositingControl = this;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CompositingControl.this.clearRows();
                int n = 0;
                while (n < list.size()) {
                    CompositeEntry compositeEntry = (CompositeEntry)list.get(n);
                    CompositeTableRow compositeTableRow = new CompositeTableRow(compositeEntry, CompositingControl.this.tblComposits, compositingControl, n == 0);
                    CompositingControl.this.rows.add(compositeTableRow);
                    ++n;
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ArrayList<CompositeEntry> arrayList = new ArrayList<CompositeEntry>();
        for (CompositeTableRow compositeTableRow : this.rows) {
            arrayList.add(compositeTableRow.convertToCompositeEntry());
        }
        selectionEvent.data = arrayList;
        this.notifySelectionListeners(selectionEvent);
    }

    private void notifySelectionListeners(SelectionEvent selectionEvent) {
        Iterator<SelectionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().widgetSelected(selectionEvent);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }
}

