/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositeEntry;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositingControl;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.CompositeOp;

public class CompositeTableRow
implements SelectionListener {
    private Spinner spinner;
    private Slider slider;
    private Button chkActive;
    private Button chkRed;
    private Button chkGreen;
    private Button chkBlue;
    private Composite panel;
    private Combo op;
    private String name;

    public CompositeTableRow(CompositeEntry compositeEntry, Table table, CompositingControl compositingControl, boolean bl) {
        this.name = compositeEntry.getName();
        TableItem tableItem = new TableItem(table, 0x20000000);
        TableEditor tableEditor = new TableEditor(table);
        tableEditor.horizontalAlignment = 0x1000000;
        tableEditor.grabHorizontal = true;
        this.chkActive = new Button((Composite)table, 32);
        this.chkActive.setSelection(true);
        this.chkActive.addSelectionListener((SelectionListener)compositingControl);
        tableEditor.setEditor((Control)this.chkActive, tableItem, 0);
        TableEditor tableEditor2 = new TableEditor(table);
        tableEditor2.horizontalAlignment = 0x1000000;
        tableEditor2.grabHorizontal = true;
        this.panel = new Composite((Composite)table, 0);
        this.panel.setLayout((Layout)new GridLayout(2, true));
        this.slider = new Slider(this.panel, 264);
        this.slider.setValues((int)(compositeEntry.getWeight() * 100.0f), 0, 104, 5, 1, 5);
        this.slider.addSelectionListener((SelectionListener)this);
        this.slider.addSelectionListener((SelectionListener)compositingControl);
        this.spinner = new Spinner(this.panel, 0x20000000);
        this.spinner.setMinimum(0);
        this.spinner.setMaximum(100);
        this.spinner.setSelection((int)(compositeEntry.getWeight() * 100.0f));
        this.spinner.addSelectionListener((SelectionListener)compositingControl);
        this.spinner.addSelectionListener((SelectionListener)this);
        this.panel.pack();
        tableEditor2.setEditor((Control)this.panel, tableItem, 2);
        tableItem.setText(1, this.name);
        TableEditor tableEditor3 = new TableEditor(table);
        tableEditor3.horizontalAlignment = 0x1000000;
        tableEditor3.grabHorizontal = true;
        tableEditor3.grabVertical = true;
        this.op = new Combo((Composite)table, 0);
        this.op.add("ADD");
        this.op.add("SUBTRACT");
        this.op.add("MULTIPLY");
        this.op.add("DIVIDE");
        this.op.add("MINIMUM");
        this.op.add("MAXIMUM");
        this.op.select(this.convertOperationToInt(compositeEntry.getOperation()));
        this.op.pack();
        this.op.addSelectionListener((SelectionListener)compositingControl);
        this.op.setEnabled(!bl);
        tableEditor3.setEditor((Control)this.op, tableItem, 3);
        TableEditor tableEditor4 = new TableEditor(table);
        tableEditor4.horizontalAlignment = 0x1000000;
        tableEditor4.grabHorizontal = true;
        tableEditor4.grabVertical = true;
        this.chkRed = new Button((Composite)table, 32);
        this.chkRed.setSelection(true);
        this.chkRed.pack();
        this.chkRed.addSelectionListener((SelectionListener)compositingControl);
        tableEditor4.setEditor((Control)this.chkRed, tableItem, 4);
        TableEditor tableEditor5 = new TableEditor(table);
        tableEditor5.horizontalAlignment = 0x1000000;
        tableEditor5.grabHorizontal = true;
        tableEditor5.grabVertical = true;
        this.chkGreen = new Button((Composite)table, 32);
        this.chkGreen.pack();
        this.chkGreen.setSelection(true);
        this.chkGreen.addSelectionListener((SelectionListener)compositingControl);
        tableEditor5.setEditor((Control)this.chkGreen, tableItem, 5);
        TableEditor tableEditor6 = new TableEditor(table);
        tableEditor6.horizontalAlignment = 0x1000000;
        tableEditor6.grabHorizontal = true;
        tableEditor6.grabVertical = true;
        this.chkBlue = new Button((Composite)table, 32);
        this.chkBlue.pack();
        this.chkBlue.setSelection(true);
        this.chkBlue.addSelectionListener((SelectionListener)compositingControl);
        tableEditor6.setEditor((Control)this.chkBlue, tableItem, 6);
    }

    public CompositeEntry convertToCompositeEntry() {
        byte by = (byte)(this.chkRed.getSelection() ? 1 : 0);
        by = (byte)(by + (byte)(this.chkGreen.getSelection() ? 2 : 0));
        by = (byte)(by + (byte)(this.chkBlue.getSelection() ? 4 : 0));
        float f = (float)this.spinner.getSelection() / 100.0f;
        if (!this.chkActive.getSelection()) {
            f = 0.0f;
        }
        CompositeEntry compositeEntry = new CompositeEntry(this.name, f, this.convertToOperationFromInt(this.op.getSelectionIndex()), by);
        return compositeEntry;
    }

    private CompositeOp convertToOperationFromInt(int n) {
        switch (n) {
            case 0: {
                return CompositeOp.ADD;
            }
            case 1: {
                return CompositeOp.SUBTRACT;
            }
            case 2: {
                return CompositeOp.MULTIPLY;
            }
            case 3: {
                return CompositeOp.DIVIDE;
            }
            case 4: {
                return CompositeOp.MAX;
            }
            case 5: {
                return CompositeOp.MIN;
            }
        }
        return CompositeOp.ADD;
    }

    private int convertOperationToInt(CompositeOp compositeOp) {
        switch (compositeOp) {
            case ADD: {
                return 0;
            }
            case SUBTRACT: {
                return 1;
            }
            case MULTIPLY: {
                return 2;
            }
            case DIVIDE: {
                return 3;
            }
            case MIN: {
                return 4;
            }
            case MAX: {
                return 5;
            }
        }
        return 0;
    }

    public void dispose() {
        this.spinner.dispose();
        this.slider.dispose();
        this.op.dispose();
        this.chkBlue.dispose();
        this.chkGreen.dispose();
        this.chkRed.dispose();
        this.panel.dispose();
        this.chkActive.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.spinner)) {
            this.slider.setSelection(this.spinner.getSelection());
        } else {
            this.spinner.setSelection(this.slider.getSelection() <= 100 ? this.slider.getSelection() : 100);
        }
    }
}

