/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.actions;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.ImageExplorerDirectoryChooseAction;
import uk.ac.diamond.scisoft.analysis.rcp.util.FileComparator;
import uk.ac.diamond.scisoft.analysis.rcp.util.FileCompareMode;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;

public class MonitorDirectoryAction
extends AbstractHandler {
    boolean monitorActive = false;
    private static final Logger logger = LoggerFactory.getLogger(MonitorDirectoryAction.class);
    private static final int TIMEOUT = 5000;
    private HashMap<String, Boolean> compare = new HashMap();

    private void fillUpCompareHash(List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.compare.put(iterator.next(), true);
        }
    }

    public boolean isMonitorActive() {
        return this.monitorActive;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final ImageExplorerView imageExplorerView = (ImageExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView");
        if (imageExplorerView != null) {
            Command command = executionEvent.getCommand();
            boolean bl = HandlerUtil.toggleCommandState((Command)command);
            if (!bl) {
                final String string = imageExplorerView.getDirPath();
                if (string != null && string.length() > 0) {
                    this.monitorActive = true;
                    imageExplorerView.setMonitorActive(this.monitorActive);
                    Job job = new Job("Scan directory"){

                        protected IStatus run(IProgressMonitor iProgressMonitor) {
                            if (MonitorDirectoryAction.this.monitorActive) {
                                List<String> list = imageExplorerView.getLoadedFiles();
                                if (list != null && list.size() > 0) {
                                    MonitorDirectoryAction.this.compare.clear();
                                    MonitorDirectoryAction.this.fillUpCompareHash(list);
                                    File file = new File(string);
                                    File[] fileArray = file.listFiles();
                                    if (fileArray.length > 0) {
                                        ArrayList<File> arrayList = ImageExplorerDirectoryChooseAction.filterImages(fileArray, imageExplorerView.getExtensionsFilter());
                                        Collections.sort(arrayList, new FileComparator(FileCompareMode.datetime));
                                        Iterator<File> iterator = arrayList.iterator();
                                        while (iterator.hasNext()) {
                                            String string2 = iterator.next().getAbsolutePath();
                                            if (MonitorDirectoryAction.this.compare.get(string2) != null) continue;
                                            GuiBean guiBean = new GuiBean();
                                            guiBean.put(GuiParameters.PLOTID, (Serializable)UUID.randomUUID());
                                            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
                                            guiBean.put(GuiParameters.PLOTMODE, (Serializable)GuiPlotMode.IMGEXPL);
                                            GuiUpdate guiUpdate = new GuiUpdate(imageExplorerView.getPartName(), guiBean);
                                            imageExplorerView.update((Object)this, guiUpdate);
                                        }
                                    }
                                }
                                this.schedule(5000L);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(false);
                    job.setPriority(50);
                    job.schedule(5000L);
                } else {
                    command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)Boolean.FALSE);
                    logger.info("No active directory selected reverse monitor state");
                }
            } else {
                this.monitorActive = false;
                imageExplorerView.setMonitorActive(this.monitorActive);
            }
        } else {
            logger.info("Couldn't find view to load for");
        }
        return Boolean.FALSE;
    }
}

