/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.env.IProcessFactory;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectPyDevConsoleHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(InjectPyDevConsoleHandler.class);
    public static String COMMAND_ID = "uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.injectPyDevConsole";
    public static String CREATE_NEW_CONSOLE_PARAM = String.valueOf(COMMAND_ID) + ".createNewConsoleAlways";
    public static String VIEW_NAME_PARAM = String.valueOf(COMMAND_ID) + ".viewName";
    public static String SETUP_SCISOFTPY_PARAM = String.valueOf(COMMAND_ID) + ".addScisoftPySetup";
    public static String INJECT_COMMANDS_PARAM = String.valueOf(COMMAND_ID) + ".commandToInject";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        try {
            ScriptConsole scriptConsole = null;
            if (!Boolean.parseBoolean(executionEvent.getParameter(CREATE_NEW_CONSOLE_PARAM))) {
                scriptConsole = this.getActiveScriptConsole("org.python.pydev.debug.newconsole.PydevConsole");
            }
            if (scriptConsole == null) {
                new PydevConsoleFactory().createConsole(this.getConsole(), this.createPythonCommands(true, executionEvent));
            } else {
                this.sendCommands(executionEvent, scriptConsole);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot open console", (Throwable)exception);
            throw new ExecutionException("Cannot open console", (Throwable)exception);
        }
        return null;
    }

    void sendCommands(ExecutionEvent executionEvent, ScriptConsole scriptConsole) throws BadLocationException {
        StyledText styledText;
        ScriptConsoleViewer scriptConsoleViewer;
        PydevConsole pydevConsole = (PydevConsole)scriptConsole;
        IDocument iDocument = pydevConsole.getDocument();
        String string = this.createPythonCommands(false, executionEvent);
        if (string != null) {
            iDocument.replace(iDocument.getLength(), 0, string);
        }
        if (InteractiveConsolePrefs.getFocusConsoleOnSendCommand() && (scriptConsoleViewer = pydevConsole.getViewer()) != null && (styledText = scriptConsoleViewer.getTextWidget()) != null) {
            styledText.setFocus();
        }
    }

    String createPythonCommands(boolean bl, ExecutionEvent executionEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        SetupScisoftpy setupScisoftpy = SetupScisoftpy.valueOfIgnoreCase(executionEvent.getParameter(SETUP_SCISOFTPY_PARAM));
        if (setupScisoftpy.setupScisoftpy(bl)) {
            stringBuffer.append("# Importing scisoftpy.\n");
            stringBuffer.append("import scisoftpy as dnp\n");
        }
        if (executionEvent.getParameter(VIEW_NAME_PARAM) != null && !"".equals(executionEvent.getParameter(VIEW_NAME_PARAM))) {
            String string = executionEvent.getParameter(VIEW_NAME_PARAM);
            stringBuffer.append("# Connecting to plot '" + string + "'.\n");
            stringBuffer.append("dnp.plot.setdefname('" + string + "')\n");
        }
        if (executionEvent.getParameter(INJECT_COMMANDS_PARAM) != null && !"".equals(executionEvent.getParameter(INJECT_COMMANDS_PARAM))) {
            stringBuffer.append(executionEvent.getParameter(INJECT_COMMANDS_PARAM));
        }
        return stringBuffer.toString();
    }

    private PydevConsoleInterpreter getConsole() throws Exception {
        IProcessFactory iProcessFactory = new IProcessFactory();
        IProcessFactory.PydevConsoleLaunchInfo pydevConsoleLaunchInfo = iProcessFactory.createInteractiveLaunch();
        if (pydevConsoleLaunchInfo == null) {
            return null;
        }
        List list = iProcessFactory.getNaturesUsed();
        return PydevConsoleFactory.createPydevInterpreter((IProcessFactory.PydevConsoleLaunchInfo)pydevConsoleLaunchInfo, (List)list);
    }

    private ScriptConsole getActiveScriptConsole(String string) {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            List<IViewPart> list = this.getConsoleParts(iWorkbenchPage, false);
            if (list.size() == 0) {
                list = this.getConsoleParts(iWorkbenchPage, true);
            }
            if (list.size() > 0) {
                IConsole iConsole;
                IConsoleView iConsoleView = null;
                long l = Long.MIN_VALUE;
                if (list.size() == 1) {
                    iConsoleView = (IConsoleView)list.get(0);
                } else {
                    int n = 0;
                    while (n < list.size()) {
                        PydevConsole pydevConsole;
                        ScriptConsoleViewer scriptConsoleViewer;
                        long l2;
                        IConsoleView iConsoleView2 = (IConsoleView)list.get(n);
                        IConsole iConsole2 = iConsoleView2.getConsole();
                        if (iConsole2 instanceof PydevConsole && (l2 = (scriptConsoleViewer = (pydevConsole = (PydevConsole)iConsole2).getViewer()).getLastChangeMillis()) > l) {
                            l = l2;
                            iConsoleView = iConsoleView2;
                        }
                        ++n;
                    }
                }
                if (iConsoleView != null && (iConsole = iConsoleView.getConsole()) instanceof ScriptConsole && iConsole.getType().equals(string)) {
                    return (ScriptConsole)iConsole;
                }
            }
        }
        return null;
    }

    private List<IViewPart> getConsoleParts(IWorkbenchPage iWorkbenchPage, boolean bl) {
        IViewReference[] iViewReferenceArray;
        ArrayList<IViewPart> arrayList = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray2 = iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart iViewPart;
            IViewReference iViewReference = iViewReferenceArray2[n2];
            if (iViewReference.getId().equals("org.eclipse.ui.console.ConsoleView") && (iViewPart = iViewReference.getView(bl)) != null) {
                arrayList.add(iViewPart);
                if (bl) {
                    return arrayList;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static class SetupSciSoftPyParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            SetupScisoftpy[] setupScisoftpyArray = SetupScisoftpy.values();
            int n = setupScisoftpyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SetupScisoftpy setupScisoftpy = setupScisoftpyArray[n2];
                hashMap.put(setupScisoftpy.getDisplay(), setupScisoftpy.toString());
                ++n2;
            }
            return hashMap;
        }
    }

    public static enum SetupScisoftpy {
        ALWAYS("Yes"){

            @Override
            public boolean setupScisoftpy(boolean bl) {
                return true;
            }
        }
        ,
        NEVER("No"){

            @Override
            public boolean setupScisoftpy(boolean bl) {
                return false;
            }
        }
        ,
        NEWONLY("Only if a new console is created"){

            @Override
            public boolean setupScisoftpy(boolean bl) {
                return bl;
            }
        };

        private final String display;

        private SetupScisoftpy(String string2) {
            this.display = string2;
        }

        public String getDisplay() {
            return this.display;
        }

        public static SetupScisoftpy valueOfIgnoreCase(String string) {
            SetupScisoftpy[] setupScisoftpyArray = SetupScisoftpy.values();
            int n = setupScisoftpyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SetupScisoftpy setupScisoftpy = setupScisoftpyArray[n2];
                if (setupScisoftpy.toString().equalsIgnoreCase(string)) {
                    return setupScisoftpy;
                }
                ++n2;
            }
            return NEWONLY;
        }

        public abstract boolean setupScisoftpy(boolean var1);
    }
}

