/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.util.FileComparator;
import uk.ac.diamond.scisoft.analysis.rcp.util.FileCompareMode;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class ImageExplorerDirectoryChooseAction
extends AbstractHandler {
    public static final String[] LISTOFSUFFIX = new String[]{".png", ".jpg", ".tif", ".tiff", ".mar", ".cbf", ".dat", ".img", ".raw", ".mccd", ".cif", ".imgcif", ".jpeg"};
    private static final Logger logger = LoggerFactory.getLogger(ImageExplorerDirectoryChooseAction.class);

    public static ArrayList<File> filterImages(File[] fileArray, List<String> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray.length) {
            int n2 = 0;
            while (n2 < LISTOFSUFFIX.length) {
                if (fileArray[n].getAbsolutePath().toLowerCase().endsWith(LISTOFSUFFIX[n2])) {
                    if (list != null) {
                        Iterator<String> iterator = list.iterator();
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            if (!fileArray[n].getAbsolutePath().toLowerCase().endsWith(iterator.next())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList.add(fileArray[n]);
                        }
                    } else {
                        arrayList.add(fileArray[n]);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ImageExplorerView imageExplorerView = (ImageExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView");
        if (imageExplorerView != null) {
            DirectoryDialog directoryDialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
            directoryDialog.setFilterPath(imageExplorerView.getDirPath());
            String string = directoryDialog.open();
            if (string != null) {
                ImageExplorerDirectoryChooseAction.setImageFolder(string, imageExplorerView.getExtensionsFilter());
                imageExplorerView.setLocationText(string);
            }
        } else {
            logger.info("Couldn't find view to load for");
        }
        return Boolean.FALSE;
    }

    public static boolean setImageFolder(String string) {
        return ImageExplorerDirectoryChooseAction.setImageFolder(string, null);
    }

    public static boolean setImageFolder(String string, List<String> list) {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        if (iWorkbenchPage == null) {
            return false;
        }
        boolean bl = true;
        final ImageExplorerView imageExplorerView = (ImageExplorerView)iWorkbenchPage.findView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView");
        if (imageExplorerView != null) {
            imageExplorerView.setDirPath(string);
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                ArrayList<File> arrayList = ImageExplorerDirectoryChooseAction.filterImages(fileArray, list);
                Collections.sort(arrayList, new FileComparator(FileCompareMode.name));
                if (arrayList.size() > 0) {
                    final ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
                    Iterator<File> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        arrayList2.add(iterator.next().getAbsolutePath());
                    }
                    imageExplorerView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            imageExplorerView.update(ImageExplorerView.FOLDER_UPDATE_MARKER, arrayList2);
                        }
                    });
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

