/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.RMIClientProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.IPlotWindowManagerRMI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;

public class RMIPlotWindowManger
implements IPlotWindowManagerRMI {
    private static final Logger logger = LoggerFactory.getLogger(RMIPlotWindowManger.class);
    private static IPlotWindowManagerRMI manager;

    public static IPlotWindowManagerRMI getManager() {
        try {
            if (manager == null) {
                manager = (IPlotWindowManagerRMI)RMIClientProvider.getInstance().lookup(null, "RMIPlotWindowManager");
            }
            return manager;
        }
        catch (Exception exception) {
            logger.error("Unable to obtain IPlotWindowManagerRMI manager", (Throwable)exception);
            return null;
        }
    }

    public static void clearManager() {
        manager = null;
    }

    public String openDuplicateView(final String string) throws RemoteException {
        try {
            final String[] stringArray = new String[1];
            final Exception[] exceptionArray = new Exception[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        stringArray[0] = PlotWindow.getManager().openDuplicateView(null, string);
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
            if (exceptionArray[0] != null) {
                throw exceptionArray[0];
            }
            return stringArray[0];
        }
        catch (Exception exception) {
            logger.error("Unexpected error during remote call", (Throwable)exception);
            throw new RemoteException("Unexpected error during remote call", exception);
        }
    }

    public String openView(final String string) throws RemoteException {
        try {
            final String[] stringArray = new String[1];
            final Exception[] exceptionArray = new Exception[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        stringArray[0] = PlotWindow.getManager().openView(null, string);
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
            if (exceptionArray[0] != null) {
                throw exceptionArray[0];
            }
            return stringArray[0];
        }
        catch (Exception exception) {
            logger.error("Unexpected error during remote call", (Throwable)exception);
            throw new RemoteException("Unexpected error during remote call", exception);
        }
    }

    public String[] getOpenViews() throws RemoteException {
        try {
            final String[][] stringArray = new String[1][];
            final Exception[] exceptionArray = new Exception[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        stringArray[0] = PlotWindow.getManager().getOpenViews();
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
            if (exceptionArray[0] != null) {
                throw exceptionArray[0];
            }
            return stringArray[0];
        }
        catch (Exception exception) {
            logger.error("Unexpected error during remote call", (Throwable)exception);
            throw new RemoteException("Unexpected error during remote call", exception);
        }
    }
}

