/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IIsBeingObserved;
import gda.observable.IObservable;
import gda.observable.IObserver;
import gda.observable.ObservableComponent;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.AnalysisRpcServerProvider;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.RMIServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotWindowManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.RMIPlotWindowManger;
import uk.ac.diamond.scisoft.analysis.rcp.rpc.AnalysisRpcSyncExecDispatcher;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class PlotWindowManager
implements IPlotWindowManager,
IObservable,
IIsBeingObserved {
    private static Logger logger = LoggerFactory.getLogger(PlotWindowManager.class);
    private static PlotWindowManager manager;
    private Map<String, IPlotWindow> viewMap = new HashMap<String, IPlotWindow>();
    private Map<String, String> knownViews = new HashMap<String, String>();
    private Map<String, String> knownPlotViews = new HashMap<String, String>();
    private ObservableComponent observable = new ObservableComponent();

    public static synchronized PlotWindowManager getPrivateManager() {
        if (manager == null) {
            manager = new PlotWindowManager();
            try {
                RMIServerProvider.getInstance().exportAndRegisterObject("RMIPlotWindowManager", (Remote)((Object)new RMIPlotWindowManger()));
            }
            catch (Exception exception) {
                logger.error("Unable to register PlotWindowManager for use over RMI", (Throwable)exception);
            }
            try {
                AnalysisRpcSyncExecDispatcher analysisRpcSyncExecDispatcher = new AnalysisRpcSyncExecDispatcher(IPlotWindowManager.class, manager);
                AnalysisRpcServerProvider.getInstance().addHandler("PlotWindowManager", (IAnalysisRpcHandler)analysisRpcSyncExecDispatcher);
            }
            catch (Exception exception) {
                logger.error("Unable to register PlotWindowManager as RPC service", (Throwable)exception);
            }
        }
        return manager;
    }

    private PlotWindowManager() {
        this(PlatformUI.getWorkbench().getViewRegistry().getViews());
    }

    protected PlotWindowManager(IViewDescriptor[] iViewDescriptorArray) {
        if (iViewDescriptorArray != null) {
            IViewDescriptor[] iViewDescriptorArray2 = iViewDescriptorArray;
            int n = iViewDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewDescriptor iViewDescriptor = iViewDescriptorArray2[n2];
                this.knownViews.put(iViewDescriptor.getLabel(), iViewDescriptor.getId());
                if (iViewDescriptor.getId().startsWith("uk.ac.diamond.scisoft.analysis.rcp.plotView")) {
                    this.knownPlotViews.put(iViewDescriptor.getLabel(), iViewDescriptor.getId());
                }
                ++n2;
            }
        }
    }

    public void registerPlotWindow(IPlotWindow iPlotWindow) {
        this.viewMap.put(iPlotWindow.getName(), iPlotWindow);
        this.observable.notifyIObservers((Object)this, null);
    }

    public void unregisterPlotWindow(IPlotWindow iPlotWindow) {
        this.viewMap.remove(iPlotWindow.getName());
        this.observable.notifyIObservers((Object)this, null);
    }

    @Override
    public String openDuplicateView(IWorkbenchPage iWorkbenchPage, String string) {
        try {
            DataBean dataBean;
            Object object;
            if (iWorkbenchPage == null && (object = this.viewMap.get(string)) != null) {
                iWorkbenchPage = object.getPage();
            }
            object = this.getUniqueName(string, iWorkbenchPage);
            this.openViewInternal(this.getPage(iWorkbenchPage), (String)object);
            PlotServer plotServer = this.getPlotServer();
            GuiBean guiBean = plotServer.getGuiState(string);
            if (guiBean != null) {
                plotServer.updateGui((String)object, guiBean.copy());
            }
            if ((dataBean = plotServer.getData(string)) != null) {
                plotServer.setData((String)object, dataBean.copy());
            }
            return object;
        }
        catch (Exception exception) {
            logger.error("Unable to duplicate plot view " + string, (Throwable)exception);
            return null;
        }
    }

    @Override
    public String openView(IWorkbenchPage iWorkbenchPage, String string) {
        try {
            if (string == null) {
                string = this.getUniqueName("Plot 0", iWorkbenchPage);
            }
            this.openViewInternal(iWorkbenchPage, string);
            return string;
        }
        catch (PartInitException partInitException) {
            logger.error("Unable to open new plot view " + string, (Throwable)partInitException);
            return null;
        }
    }

    protected void openViewInternal(IWorkbenchPage iWorkbenchPage, String string) throws PartInitException {
        if (this.knownViews.containsKey(string)) {
            this.getPage(iWorkbenchPage).showView(this.knownViews.get(string));
        } else {
            this.getPage(iWorkbenchPage).showView("uk.ac.diamond.scisoft.analysis.rcp.plotViewMultiple", string, 1);
        }
    }

    @Override
    public String[] getOpenViews() {
        Set<String> set = this.viewMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    protected IWorkbenchPage getPage(IWorkbenchPage iWorkbenchPage) throws NullPointerException {
        if (iWorkbenchPage == null) {
            try {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
            catch (NullPointerException nullPointerException) {
                Collection<IPlotWindow> collection = this.viewMap.values();
                Iterator<IPlotWindow> iterator = collection.iterator();
                if (iterator.hasNext()) {
                    return iterator.next().getPage();
                }
                throw new NullPointerException("Unable to obtain a workbench page to open view from");
            }
        }
        return iWorkbenchPage;
    }

    protected PlotServer getPlotServer() {
        return PlotServerProvider.getPlotServer();
    }

    private String getUniqueName(String string, IWorkbenchPage iWorkbenchPage) {
        try {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getAllPossibleViews(iWorkbenchPage)));
            int n = string.lastIndexOf(32);
            if (n >= 0) {
                String string2;
                String string3 = string.substring(n + 1);
                int n2 = Integer.parseInt(string3);
                String string4 = string.substring(0, n + 1);
                do {
                    string2 = String.valueOf(string4) + ++n2;
                    if (n2 <= 1000000 && n2 > 0) continue;
                    throw new NumberFormatException();
                } while (this.knownViews.containsKey(string2) || hashSet.contains(string2));
                return string2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this.getUniqueName(String.valueOf(string) + " 0", iWorkbenchPage);
    }

    public String[] getAllPossibleViews(IWorkbenchPage iWorkbenchPage) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(this.getOpenViews()));
        hashSet.addAll(this.knownPlotViews.keySet());
        if (iWorkbenchPage != null) {
            try {
                IViewReference[] iViewReferenceArray;
                IViewReference[] iViewReferenceArray2 = iViewReferenceArray = this.getPage(iWorkbenchPage).getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference iViewReference = iViewReferenceArray2[n2];
                    if ("uk.ac.diamond.scisoft.analysis.rcp.plotViewMultiple".equals(iViewReference.getId())) {
                        hashSet.add(iViewReference.getSecondaryId());
                    }
                    ++n2;
                }
            }
            catch (NullPointerException nullPointerException) {
                logger.error("Failed to add list of view references", (Throwable)nullPointerException);
            }
        }
        try {
            hashSet.addAll(Arrays.asList(this.getPlotServer().getGuiNames()));
        }
        catch (Exception exception) {
            logger.error("Failed to add list of Gui Names from Plot Server", (Throwable)exception);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public boolean IsBeingObserved() {
        return this.observable.IsBeingObserved();
    }

    public void addIObserver(IObserver iObserver) {
        this.observable.addIObserver(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observable.deleteIObserver(iObserver);
    }

    public void deleteIObservers() {
        this.observable.deleteIObservers();
    }
}

