/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotWindowManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DStackUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIComplete;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot2DMultiUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot2DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotScatter2DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotScatter3DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotSurf3DUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindowManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.SimpleLock;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.InjectPyDevConsoleHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class PlotWindow
implements IObserver,
IObservable,
IPlotWindow {
    public static final String RPC_SERVICE_NAME = "PlotWindowManager";
    public static final String RMI_SERVICE_NAME = "RMIPlotWindowManager";
    private static Logger logger = LoggerFactory.getLogger(PlotWindow.class);
    private DataSetPlotter mainPlotter;
    private IPlotUI plotUI = null;
    private boolean isUpdatePlot = false;
    private Composite parentComp;
    private IWorkbenchPage page = null;
    private IActionBars bars;
    private String name;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private IGuiInfoManager manager = null;
    private IUpdateNotificationListener notifyListener = null;
    private DataBean myBeanMemory;
    protected Action duplicateWindowAction;
    protected Action saveGraphAction;
    protected Action copyGraphAction;
    protected Action printGraphAction;
    protected CommandContributionItem openPyDevConsoleCCI;
    protected CommandContributionItem updateDefaultPlotCCI;
    protected CommandContributionItem getPlotBeanCCI;
    protected String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    protected String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    protected String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    protected String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    protected String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    protected String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    protected String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    protected String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    protected String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private boolean exclusiveToolars = false;
    SimpleLock simpleLock = new SimpleLock();

    public static IPlotWindowManager getManager() {
        return PlotWindowManager.getPrivateManager();
    }

    public PlotWindow(Composite composite, GuiPlotMode guiPlotMode, IActionBars iActionBars, IWorkbenchPage iWorkbenchPage, String string) {
        this(composite, guiPlotMode, null, null, iActionBars, iWorkbenchPage, string);
    }

    public PlotWindow(Composite composite, GuiPlotMode guiPlotMode, IGuiInfoManager iGuiInfoManager, IUpdateNotificationListener iUpdateNotificationListener, IActionBars iActionBars, IWorkbenchPage iWorkbenchPage, String string) {
        this.manager = iGuiInfoManager;
        this.notifyListener = iUpdateNotificationListener;
        this.parentComp = composite;
        this.page = iWorkbenchPage;
        if (guiPlotMode == null) {
            guiPlotMode = GuiPlotMode.ONED;
        }
        this.mainPlotter = new DataSetPlotter(PlottingMode.ONED, composite, true);
        this.mainPlotter.setAxisModes(AxisMode.LINEAR, AxisMode.LINEAR, AxisMode.LINEAR);
        this.parentComp = composite;
        this.bars = iActionBars;
        this.name = string;
        composite.setLayout((Layout)new FillLayout());
        this.mainPlotter.setXAxisLabel("X-Axis");
        this.mainPlotter.setYAxisLabel("Y-Axis");
        this.mainPlotter.setZAxisLabel("Z-Axis");
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED)) {
            this.setup1D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED)) {
            this.setupMulti1DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD)) {
            this.setup2D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D)) {
            this.setup2DSurface();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D)) {
            this.setupScatter2DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D)) {
            this.setupScatter3DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.MULTI2D)) {
            this.setupMulti2D();
        }
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                if (controlEvent.widget.equals(PlotWindow.this.parentComp)) {
                    PlotWindow.this.parentComp.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PlotWindow.this.mainPlotter.refresh(false);
                        }
                    });
                }
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        PlotWindowManager.getPrivateManager().registerPlotWindow(this);
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.page;
    }

    public IPlotUI getPlotUI() {
        return this.plotUI;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void processPlotUpdate(DataBean dataBean) {
        if (dataBean.getGuiPlotMode() != null) {
            if (this.parentComp.isDisposed()) {
                throw new IllegalStateException("parentComp is already disposed");
            }
            if (this.parentComp.getDisplay().getThread() != Thread.currentThread()) {
                this.updatePlotMode(dataBean.getGuiPlotMode(), true);
            } else {
                this.updatePlotMode(dataBean.getGuiPlotMode(), false);
            }
        }
        if (dataBean.getGuiParameters() != null) {
            this.processGUIUpdate(dataBean.getGuiParameters());
        }
        try {
            this.doBlock();
            this.plotUI.processPlotUpdate(dataBean, this.isUpdatePlot);
            this.myBeanMemory = dataBean;
        }
        finally {
            this.undoBlock();
        }
    }

    private void removePreviousActions() {
        IContributionItem[] iContributionItemArray = this.bars.getToolBarManager().getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
        this.bars.getToolBarManager().removeAll();
        this.bars.getMenuManager().removeAll();
        this.bars.getStatusLineManager().removeAll();
    }

    private void cleanUpFromOldMode(boolean bl) {
        this.isUpdatePlot = false;
        this.mainPlotter.unregisterUI(this.plotUI);
        if (this.plotUI != null) {
            this.plotUI.deleteIObservers();
            this.plotUI.deactivate(bl);
            this.removePreviousActions();
        }
    }

    private void addCommonActions() {
        HashMap<String, String> hashMap;
        CommandContributionItemParameter commandContributionItemParameter;
        if (this.duplicateWindowAction == null) {
            this.duplicateWindowAction = new Action("Create Duplicate Plot", 1){

                public void run() {
                    PlotWindow.getManager().openDuplicateView(PlotWindow.this.page, PlotWindow.this.name);
                }
            };
            this.duplicateWindowAction.setText("Duplicate Plot");
            this.duplicateWindowAction.setToolTipText("Open an additional Plot View with a duplicate of this plot's data");
        }
        if (this.saveGraphAction == null) {
            this.saveGraphAction = new Action(){
                private String filename;

                public void run() {
                    FileDialog fileDialog = new FileDialog(PlotWindow.this.parentComp.getShell(), 8192);
                    String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                    if (this.filename != null) {
                        fileDialog.setFilterPath(new File(this.filename).getParent());
                    } else {
                        String string = "/";
                        String string2 = SWT.getPlatform();
                        if (string2.equals("win32") || string2.equals("wpf")) {
                            string = "c:\\";
                        }
                        fileDialog.setFilterPath(string);
                    }
                    fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                    fileDialog.setFilterExtensions(stringArray);
                    this.filename = fileDialog.open();
                    if (this.filename == null) {
                        return;
                    }
                    PlotWindow.this.mainPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
                }
            };
            this.saveGraphAction.setText(this.saveButtonText);
            this.saveGraphAction.setToolTipText(this.saveToolTipText);
            this.saveGraphAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        }
        if (this.copyGraphAction == null) {
            this.copyGraphAction = new Action(){

                public void run() {
                    PlotWindow.this.mainPlotter.copyGraph();
                }
            };
            this.copyGraphAction.setText(this.copyButtonText);
            this.copyGraphAction.setToolTipText(this.copyToolTipText);
            this.copyGraphAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        }
        if (this.printGraphAction == null) {
            this.printGraphAction = new Action(){

                public void run() {
                    PlotWindow.this.mainPlotter.printGraph();
                }
            };
            this.printGraphAction.setText(this.printButtonText);
            this.printGraphAction.setToolTipText(this.printToolTipText);
            this.printGraphAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        }
        if (this.openPyDevConsoleCCI == null) {
            commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, InjectPyDevConsoleHandler.COMMAND_ID, 8);
            commandContributionItemParameter.label = "Open New Plot Scripting";
            commandContributionItemParameter.icon = AnalysisRCPActivator.getImageDescriptor("icons/application_osx_terminal.png");
            hashMap = new HashMap();
            hashMap.put(InjectPyDevConsoleHandler.CREATE_NEW_CONSOLE_PARAM, Boolean.TRUE.toString());
            hashMap.put(InjectPyDevConsoleHandler.VIEW_NAME_PARAM, this.getName());
            hashMap.put(InjectPyDevConsoleHandler.SETUP_SCISOFTPY_PARAM, InjectPyDevConsoleHandler.SetupScisoftpy.ALWAYS.toString());
            commandContributionItemParameter.parameters = hashMap;
            this.openPyDevConsoleCCI = new CommandContributionItem(commandContributionItemParameter);
        }
        if (this.updateDefaultPlotCCI == null) {
            commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, InjectPyDevConsoleHandler.COMMAND_ID, 8);
            commandContributionItemParameter.label = "Set Current Plot As Scripting Default";
            hashMap = new HashMap<String, String>();
            hashMap.put(InjectPyDevConsoleHandler.VIEW_NAME_PARAM, this.getName());
            commandContributionItemParameter.parameters = hashMap;
            this.updateDefaultPlotCCI = new CommandContributionItem(commandContributionItemParameter);
        }
        if (this.getPlotBeanCCI == null) {
            commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, InjectPyDevConsoleHandler.COMMAND_ID, 8);
            commandContributionItemParameter.label = "Get Plot Bean in Plot Scripting";
            hashMap = new HashMap();
            hashMap.put(InjectPyDevConsoleHandler.INJECT_COMMANDS_PARAM, "bean=dnp.plot.getbean('" + this.getName() + "')");
            commandContributionItemParameter.parameters = hashMap;
            this.getPlotBeanCCI = new CommandContributionItem(commandContributionItemParameter);
        }
        if (this.bars.getMenuManager().getItems().length > 0) {
            this.bars.getMenuManager().add((IContributionItem)new Separator());
        }
        this.bars.getMenuManager().add((IAction)this.saveGraphAction);
        this.bars.getMenuManager().add((IAction)this.copyGraphAction);
        this.bars.getMenuManager().add((IAction)this.printGraphAction);
        this.bars.getMenuManager().add((IContributionItem)new Separator());
        this.bars.getMenuManager().add((IContributionItem)this.openPyDevConsoleCCI);
        this.bars.getMenuManager().add((IContributionItem)this.updateDefaultPlotCCI);
        this.bars.getMenuManager().add((IContributionItem)this.getPlotBeanCCI);
        this.bars.getMenuManager().add((IContributionItem)new Separator());
        this.bars.getMenuManager().add((IAction)this.duplicateWindowAction);
        this.bars.getMenuManager().add((IContributionItem)new Separator());
    }

    private void setup1D() {
        this.mainPlotter.setMode(PlottingMode.ONED);
        this.plotUI = new Plot1DUIComplete(this, this.manager, this.bars, this.parentComp, this.getPage(), this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setup2D() {
        this.mainPlotter.setMode(PlottingMode.TWOD);
        this.plotUI = new Plot2DUI(this, this.mainPlotter, this.manager, this.parentComp, this.getPage(), this.bars, this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setupMulti2D() {
        this.mainPlotter.setMode(PlottingMode.MULTI2D);
        this.plotUI = new Plot2DMultiUI(this, this.mainPlotter, this.manager, this.parentComp, this.getPage(), this.bars, this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setup2DSurface() {
        this.mainPlotter.useWindow(true);
        this.mainPlotter.setMode(PlottingMode.SURF2D);
        this.plotUI = new PlotSurf3DUI(this, this.mainPlotter, this.parentComp, this.getPage(), this.bars, this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setupMulti1DPlot() {
        this.mainPlotter.setMode(PlottingMode.ONED_THREED);
        this.plotUI = new Plot1DStackUI(this, this.bars, this.mainPlotter, this.parentComp, this.page);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setupScatter2DPlot() {
        this.mainPlotter.setMode(PlottingMode.SCATTER2D);
        this.plotUI = new PlotScatter2DUI(this, this.bars, this.mainPlotter, this.parentComp, this.page, this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    private void setupScatter3DPlot() {
        this.mainPlotter.setMode(PlottingMode.SCATTER3D);
        this.plotUI = new PlotScatter3DUI(this, this.mainPlotter, this.parentComp, this.getPage(), this.bars, this.name);
        this.addCommonActions();
        this.bars.updateActionBars();
    }

    public void updatePlotMode(GuiPlotMode guiPlotMode) {
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED) && this.mainPlotter.getMode() != PlottingMode.ONED) {
            this.cleanUpFromOldMode(true);
            this.setup1D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED) && this.mainPlotter.getMode() != PlottingMode.ONED_THREED) {
            this.cleanUpFromOldMode(true);
            this.setupMulti1DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD) && this.mainPlotter.getMode() != PlottingMode.TWOD) {
            this.cleanUpFromOldMode(true);
            this.setup2D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D) && this.mainPlotter.getMode() != PlottingMode.SURF2D) {
            this.cleanUpFromOldMode(true);
            this.setup2DSurface();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D) && this.mainPlotter.getMode() != PlottingMode.SCATTER2D) {
            this.cleanUpFromOldMode(true);
            this.setupScatter2DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D) && this.mainPlotter.getMode() != PlottingMode.SCATTER3D) {
            this.cleanUpFromOldMode(true);
            this.setupScatter3DPlot();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.MULTI2D) && this.mainPlotter.getMode() != PlottingMode.MULTI2D) {
            this.cleanUpFromOldMode(true);
            this.setupMulti2D();
        } else if (guiPlotMode.equals((Object)GuiPlotMode.EMPTY) && this.mainPlotter.getMode() != PlottingMode.EMPTY) {
            this.clearPlot();
        }
    }

    public void clearPlot() {
        if (this.mainPlotter != null) {
            this.mainPlotter.emptyPlot();
            this.mainPlotter.refresh(true);
        }
    }

    private void updatePlotModeAsync(GuiPlotMode guiPlotMode) {
        if (guiPlotMode.equals((Object)GuiPlotMode.ONED) && this.mainPlotter.getMode() != PlottingMode.ONED) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setup1D();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.ONED_THREED) && this.mainPlotter.getMode() != PlottingMode.ONED_THREED) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setupMulti1DPlot();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.TWOD) && this.mainPlotter.getMode() != PlottingMode.TWOD) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setup2D();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SURF2D) && this.mainPlotter.getMode() != PlottingMode.SURF2D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setup2DSurface();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER2D) && this.mainPlotter.getMode() != PlottingMode.SCATTER2D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setupScatter2DPlot();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.SCATTER3D) && this.mainPlotter.getMode() != PlottingMode.SCATTER3D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setupScatter3DPlot();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.MULTI2D) && this.mainPlotter.getMode() != PlottingMode.MULTI2D) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.cleanUpFromOldMode(true);
                        PlotWindow.this.setupMulti2D();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        } else if (guiPlotMode.equals((Object)GuiPlotMode.EMPTY) && this.mainPlotter.getMode() != PlottingMode.EMPTY) {
            this.doBlock();
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotWindow.this.clearPlot();
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                }
            });
        }
    }

    public void updatePlotMode(GuiBean guiBean, boolean bl) {
        if (guiBean != null && guiBean.containsKey((Object)GuiParameters.PLOTMODE)) {
            GuiPlotMode guiPlotMode = (GuiPlotMode)guiBean.get((Object)GuiParameters.PLOTMODE);
            this.updatePlotMode(guiPlotMode, bl);
        }
    }

    public void updatePlotMode(GuiPlotMode guiPlotMode, boolean bl) {
        if (guiPlotMode != null) {
            if (bl) {
                this.updatePlotModeAsync(guiPlotMode);
            } else {
                this.updatePlotMode(guiPlotMode);
            }
        }
    }

    public boolean isUpdatePlot() {
        return this.isUpdatePlot;
    }

    public void setUpdatePlot(boolean bl) {
        this.isUpdatePlot = bl;
    }

    public void processGUIUpdate(GuiBean guiBean) {
        String string;
        this.isUpdatePlot = false;
        if (guiBean.containsKey((Object)GuiParameters.PLOTMODE)) {
            if (this.parentComp.getDisplay().getThread() != Thread.currentThread()) {
                this.updatePlotMode(guiBean, true);
            } else {
                this.updatePlotMode(guiBean, false);
            }
        }
        if (guiBean.containsKey((Object)GuiParameters.TITLE)) {
            string = (String)((Object)guiBean.get((Object)GuiParameters.TITLE));
            this.parentComp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotWindow.this.doBlock();
                    try {
                        PlotWindow.this.mainPlotter.setTitle(string);
                    }
                    finally {
                        PlotWindow.this.undoBlock();
                    }
                    PlotWindow.this.mainPlotter.refresh(true);
                }
            });
        }
        if (guiBean.containsKey((Object)GuiParameters.PLOTOPERATION) && (string = (String)((Object)guiBean.get((Object)GuiParameters.PLOTOPERATION))).equals("UPDATE")) {
            this.isUpdatePlot = true;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA) || guiBean.containsKey((Object)GuiParameters.ROIDATALIST)) {
            this.plotUI.processGUIUpdate(guiBean);
        }
    }

    public void notifyHistogramChange(HistogramDataUpdate histogramDataUpdate) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, (Object)histogramDataUpdate);
        }
    }

    public void update(Object object, Object object2) {
        if (object instanceof HistogramView) {
            HistogramUpdate histogramUpdate = (HistogramUpdate)object2;
            this.mainPlotter.applyColourCast(histogramUpdate);
            this.mainPlotter.refresh(false);
            if (this.plotUI instanceof Plot2DUI) {
                Plot2DUI plot2DUI = (Plot2DUI)this.plotUI;
                plot2DUI.getSidePlotView().sendHistogramUpdate(histogramUpdate);
            }
        }
    }

    public DataSetPlotter getMainPlotter() {
        return this.mainPlotter;
    }

    public void dispose() {
        PlotWindowManager.getPrivateManager().unregisterPlotWindow(this);
        if (this.plotUI != null) {
            this.plotUI.deactivate(false);
            this.plotUI.dispose();
        }
        try {
            if (this.mainPlotter != null) {
                this.mainPlotter.cleanUp();
            }
        }
        catch (Exception exception) {
            logger.debug("Cannot clean up main plotter!", (Throwable)exception);
        }
        this.deleteIObservers();
        this.mainPlotter = null;
        this.plotUI = null;
        System.gc();
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void notifyUpdateFinished() {
        if (this.notifyListener != null) {
            this.notifyListener.updateProcessed();
        }
    }

    public boolean isExclusiveToolars() {
        return this.exclusiveToolars;
    }

    public void setExclusiveToolars(boolean bl) {
        this.exclusiveToolars = bl;
    }

    public DataBean getDataBean() {
        return this.myBeanMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBlock() {
        logger.debug("doBlock " + Thread.currentThread().getId());
        SimpleLock simpleLock = this.simpleLock;
        synchronized (simpleLock) {
            if (this.simpleLock.isLocked()) {
                try {
                    logger.debug("doBlock  - waiting " + Thread.currentThread().getId());
                    this.simpleLock.wait();
                    logger.debug("doBlock  - locking " + Thread.currentThread().getId());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                logger.debug("doBlock  - waiting not needed " + Thread.currentThread().getId());
            }
            this.simpleLock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoBlock() {
        SimpleLock simpleLock = this.simpleLock;
        synchronized (simpleLock) {
            logger.debug("undoBlock " + Thread.currentThread().getId());
            this.simpleLock.unlock();
            this.simpleLock.notifyAll();
        }
    }
}

