/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.SurfPlotStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.DataWindowView;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class PlotSurf3DUI
extends AbstractPlotUI
implements IObserver {
    private IWorkbenchPage page;
    private AxisValues xAxis = null;
    private AxisValues yAxis = null;
    private AxisValues zAxis = null;
    private PlotWindow plotWindow = null;
    private DataSetPlotter mainPlotter;
    private Composite parent;
    private HistogramView histogramView;
    private DataWindowView dataWindowView;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private Action boundingBox;
    private Action xCoordGrid;
    private Action yCoordGrid;
    private Action zCoordGrid;
    private Action saveGraph;
    private Action copyGraph;
    private Action printGraph;
    private Action displayFilled;
    private Action displayWireframe;
    private Action displayLinegraph;
    private Action displayPoint;
    private Action resetView;
    private Action zAxisScaleLinear;
    private Action zAxisScaleLog;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private static final Logger logger = LoggerFactory.getLogger(PlotSurf3DUI.class);

    public PlotSurf3DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.parent = composite;
        this.page = iWorkbenchPage;
        this.plotWindow = plotWindow;
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        this.zAxis = new AxisValues();
        this.mainPlotter = dataSetPlotter;
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        try {
            this.histogramView = (HistogramView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        try {
            this.dataWindowView = (DataWindowView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.DataWindowView", string, 3);
            if (this.histogramView != null) {
                this.histogramView.addIObserver(this.dataWindowView);
            }
            this.dataWindowView.addIObserver(this);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        if (this.dataWindowView == null) {
            logger.warn("Cannot find data window");
        }
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                PlotSurf3DUI.this.mainPlotter.resetView();
                PlotSurf3DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.boundingBox = new Action("", 2){

            public void run() {
                dataSetPlotter.enableBoundingBox(PlotSurf3DUI.this.boundingBox.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.boundingBox.setText("Bounding box on/off");
        this.boundingBox.setToolTipText("Bounding box on/off");
        this.boundingBox.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/box.png"));
        this.boundingBox.setChecked(true);
        this.xCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.xCoordGrid.setChecked(true);
        this.xCoordGrid.setText("X grid lines ON/OFF");
        this.xCoordGrid.setToolTipText("Toggle x axis grid lines on/off");
        this.xCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify_rot.png"));
        this.yCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.yCoordGrid.setChecked(true);
        this.yCoordGrid.setText("Y grid lines ON/OFF");
        this.yCoordGrid.setToolTipText("Toggle y axis grid lines on/off");
        this.yCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify.png"));
        this.zCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.zCoordGrid.setChecked(true);
        this.zCoordGrid.setText("Z grid lines ON/OFF");
        this.zCoordGrid.setToolTipText("Toggle z axis grid lines on/off");
        this.zCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                dataSetPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                dataSetPlotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                dataSetPlotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.boundingBox);
        iToolBarManager.add((IAction)this.xCoordGrid);
        iToolBarManager.add((IAction)this.yCoordGrid);
        iToolBarManager.add((IAction)this.zCoordGrid);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.update(true);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.displayFilled = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.FILLED);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayFilled.setText("Filled mode");
        this.displayFilled.setDescription("Render the graph in filled mode");
        this.displayWireframe = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.WIREFRAME);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayWireframe.setText("Wireframe mode");
        this.displayWireframe.setDescription("Render the graph in wireframe mode");
        this.displayLinegraph = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.LINEGRAPH);
                dataSetPlotter.refresh(true);
            }
        };
        this.displayLinegraph.setText("Linegraph mode");
        this.displayLinegraph.setDescription("Render the graph in linegraph mode");
        this.displayPoint = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.POINTS);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayPoint.setText("Point mode");
        this.displayPoint.setDescription("Render the graph in dot mode");
        this.zAxisScaleLinear = new Action(){

            public void run() {
                dataSetPlotter.setYAxisScaling(ScaleType.LINEAR);
            }
        };
        this.zAxisScaleLinear.setText("Z-Axis scale linear");
        this.zAxisScaleLinear.setToolTipText("Change the Z-Axis scaling to be linear");
        this.zAxisScaleLog = new Action(){

            public void run() {
                dataSetPlotter.setYAxisScaling(ScaleType.LN);
            }
        };
        this.zAxisScaleLog.setText("Z-Axis scale logarithmic");
        this.zAxisScaleLog.setToolTipText("Change the Z-Axis scaling to be logarithmic (natural)");
        MenuManager menuManager = new MenuManager("Z-Axis");
        menuManager.add((IAction)this.zAxisScaleLinear);
        menuManager.add((IAction)this.zAxisScaleLog);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IAction)this.displayFilled);
        iMenuManager.add((IAction)this.displayWireframe);
        iMenuManager.add((IAction)this.displayLinegraph);
        iMenuManager.add((IAction)this.displayPoint);
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            Object object;
            Object object2;
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            AbstractDataset abstractDataset = dataBean.getAxis("x-axis");
            AbstractDataset abstractDataset2 = dataBean.getAxis("y-axis");
            AbstractDataset abstractDataset3 = dataBean.getAxis("z-axis");
            this.xAxis.clear();
            this.yAxis.clear();
            this.zAxis.clear();
            this.mainPlotter.setAxisModes(abstractDataset == null ? AxisMode.LINEAR : AxisMode.CUSTOM, abstractDataset2 == null ? AxisMode.LINEAR : AxisMode.CUSTOM, abstractDataset3 == null ? AxisMode.LINEAR : AxisMode.CUSTOM);
            if (abstractDataset != null) {
                if (abstractDataset.getName() != null && abstractDataset.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(abstractDataset.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                this.xAxis.setValues(abstractDataset);
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
            } else {
                this.mainPlotter.setXAxisLabel("X-Axis");
            }
            if (abstractDataset2 != null) {
                if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                    this.mainPlotter.setYAxisLabel(abstractDataset2.getName());
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                this.yAxis.setValues(abstractDataset2);
                this.mainPlotter.setYAxisValues(this.yAxis);
            } else {
                this.mainPlotter.setYAxisLabel("Y-Axis");
            }
            if (abstractDataset3 != null) {
                if (abstractDataset3.getName() != null && abstractDataset3.getName().length() > 0) {
                    this.mainPlotter.setZAxisLabel(abstractDataset3.getName());
                } else {
                    this.mainPlotter.setZAxisLabel("Z-Axis");
                }
                this.zAxis.setValues(abstractDataset3);
                this.mainPlotter.setZAxisValues(this.zAxis);
            } else {
                this.mainPlotter.setZAxisLabel("Z-Axis");
            }
            this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
            while (iterator.hasNext()) {
                object2 = (DataSetWithAxisInformation)iterator.next();
                object = object2.getData();
                list2.add((AbstractDataset)object);
            }
            if (list2.get(0) instanceof AbstractCompoundDataset) {
                logger.warn("Surface plotting of CompoundDatasets is currently not supported!");
                this.plotWindow.notifyUpdateFinished();
            } else {
                object2 = new HistogramDataUpdate((IDataset)list2.get(0));
                try {
                    this.mainPlotter.replaceAllPlots(list2);
                }
                catch (PlotException plotException) {
                    plotException.printStackTrace();
                }
                object = this.page.getActivePart().getTitle();
                if (!((String)object).equals("Dataset Inspector") && !((String)object).equals("Dataset Plot")) {
                    this.mainPlotter.setTitle((String)object);
                }
                this.dataWindowView.setData((IDataset)list2.get(0), this.xAxis, this.yAxis);
                this.parent.getDisplay().asyncExec(new Runnable((HistogramDataUpdate)object2){
                    private final /* synthetic */ HistogramDataUpdate val$histoUpdate;
                    {
                        this.val$histoUpdate = histogramDataUpdate;
                    }

                    @Override
                    public void run() {
                        PlotSurf3DUI.this.mainPlotter.refresh(true);
                        PlotSurf3DUI.this.plotWindow.notifyHistogramChange(this.val$histoUpdate);
                        PlotSurf3DUI.this.plotWindow.notifyUpdateFinished();
                    }
                });
            }
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.histogramView.deleteIObserver(this.dataWindowView);
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            iWorkbenchPage.hideView((IViewPart)this.dataWindowView);
        }
        this.plotWindow.deleteIObserver(this.histogramView);
    }

    @Override
    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    @Override
    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    @Override
    public void deleteIObservers() {
        this.observers.clear();
    }

    public void update(Object object, Object object2) {
        if (object2 instanceof SurfacePlotROI) {
            SurfacePlotROI surfacePlotROI = (SurfacePlotROI)object2;
            this.mainPlotter.setDataWindowPosition(surfacePlotROI);
            this.mainPlotter.refresh(false);
        }
    }
}

