/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class PlotScatter3DUI
extends AbstractPlotUI {
    private Composite parent;
    private PlotWindow plotWindow;
    private AxisValues xAxis;
    private AxisValues yAxis;
    private AxisValues zAxis;
    private DataSetPlotter mainPlotter;
    private Action boundingBox;
    private Action saveGraph;
    private Action copyGraph;
    private Action printGraph;
    private Action useTransparency;
    private Action renderEdgeOnly;
    private Action uniformSize;
    private Action xLabelTypeRound = null;
    private Action xLabelTypeFloat = null;
    private Action xLabelTypeExponent = null;
    private Action xLabelTypeSI = null;
    private Action yLabelTypeRound = null;
    private Action yLabelTypeFloat = null;
    private Action yLabelTypeExponent = null;
    private Action yLabelTypeSI = null;
    private Action zLabelTypeRound = null;
    private Action zLabelTypeFloat = null;
    private Action zLabelTypeExponent = null;
    private Action zLabelTypeSI = null;
    private HistogramView histogramView;
    private Action resetView;
    private IWorkbenchPage page;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");

    public PlotScatter3DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.parent = composite;
        this.plotWindow = plotWindow;
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        this.zAxis = new AxisValues();
        this.mainPlotter = dataSetPlotter;
        this.page = iWorkbenchPage;
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        try {
            this.histogramView = (HistogramView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                PlotScatter3DUI.this.mainPlotter.resetView();
                PlotScatter3DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.boundingBox = new Action("", 2){

            public void run() {
                dataSetPlotter.enableBoundingBox(PlotScatter3DUI.this.boundingBox.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.boundingBox.setText("Bounding box on/off");
        this.boundingBox.setToolTipText("Bounding box on/off");
        this.boundingBox.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/box.png"));
        this.boundingBox.setChecked(true);
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                dataSetPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                dataSetPlotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                dataSetPlotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.boundingBox);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Print"));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.update(true);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.useTransparency = new Action("", 2){

            public void run() {
                dataSetPlotter.useTransparency(PlotScatter3DUI.this.useTransparency.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.useTransparency.setText("Use transparency");
        this.useTransparency.setToolTipText("Switch on/off transparency");
        this.renderEdgeOnly = new Action("", 2){

            public void run() {
                if (PlotScatter3DUI.this.renderEdgeOnly.isChecked()) {
                    dataSetPlotter.useTransparency(true);
                } else {
                    dataSetPlotter.useTransparency(PlotScatter3DUI.this.useTransparency.isChecked());
                }
                dataSetPlotter.useDrawOutlinesOnly(PlotScatter3DUI.this.renderEdgeOnly.isChecked());
            }
        };
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeRound.setChecked(true);
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the y-axis to integer numbers");
        this.yLabelTypeRound.setChecked(true);
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        this.zLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setZTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeRound.setText("Z-Axis labels integer");
        this.zLabelTypeRound.setToolTipText("Change the labelling on the z-axis to integer numbers");
        this.zLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeFloat.setText("Z-Axis labels real");
        this.zLabelTypeFloat.setToolTipText("Change the labelling on the z-axis to real numbers");
        this.zLabelTypeFloat.setChecked(true);
        this.zLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeExponent.setText("Z-Axis labels exponents");
        this.zLabelTypeExponent.setToolTipText("Change the labelling on the z-axis to using exponents");
        this.zLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setZTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeSI.setText("Z-Axis labels SI units");
        this.zLabelTypeSI.setToolTipText("Change the labelling on the z-axis to using SI units");
        this.renderEdgeOnly.setText("Draw outlines only");
        this.renderEdgeOnly.setToolTipText("Switch on/off drawing outlines only");
        this.uniformSize = new Action("", 2){

            public void run() {
                dataSetPlotter.useUniformSize(PlotScatter3DUI.this.uniformSize.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.uniformSize.setText("Uniform size");
        this.uniformSize.setToolTipText("Switch on/off uniform point size");
        iMenuManager.add((IAction)this.useTransparency);
        iMenuManager.add((IAction)this.renderEdgeOnly);
        iMenuManager.add((IAction)this.uniformSize);
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        MenuManager menuManager3 = new MenuManager("Z-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        iMenuManager.add((IContributionItem)menuManager3);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        menuManager3.add((IAction)this.zLabelTypeFloat);
        menuManager3.add((IAction)this.zLabelTypeRound);
        menuManager3.add((IAction)this.zLabelTypeExponent);
        menuManager3.add((IAction)this.zLabelTypeSI);
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            AbstractDataset abstractDataset = dataBean.getAxis("x-axis");
            AbstractDataset abstractDataset2 = dataBean.getAxis("y-axis");
            AbstractDataset abstractDataset3 = dataBean.getAxis("z-axis");
            if (abstractDataset != null && abstractDataset2 != null && abstractDataset3 != null) {
                Object object;
                Object object2;
                if (!bl) {
                    this.xAxis.clear();
                    this.yAxis.clear();
                    this.zAxis.clear();
                    if (abstractDataset.getName() != null && abstractDataset.getName().length() > 0) {
                        this.mainPlotter.setXAxisLabel(abstractDataset.getName());
                    } else {
                        this.mainPlotter.setXAxisLabel("X-Axis");
                    }
                    if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                        this.mainPlotter.setYAxisLabel(abstractDataset2.getName());
                    } else {
                        this.mainPlotter.setYAxisLabel("Y-Axis");
                    }
                    if (abstractDataset3.getName() != null && abstractDataset3.getName().length() > 0) {
                        this.mainPlotter.setZAxisLabel(abstractDataset3.getName());
                    } else {
                        this.mainPlotter.setZAxisLabel("Z-Axis");
                    }
                }
                this.xAxis.setValues(abstractDataset);
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
                this.yAxis.setValues(abstractDataset2);
                this.mainPlotter.setYAxisValues(this.yAxis);
                this.zAxis.setValues(abstractDataset3);
                this.mainPlotter.setZAxisValues(this.zAxis);
                this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                while (iterator.hasNext()) {
                    object2 = (DataSetWithAxisInformation)iterator.next();
                    object = object2.getData();
                    list2.add((AbstractDataset)object);
                }
                if (!bl) {
                    try {
                        this.mainPlotter.replaceAllPlots(list2);
                    }
                    catch (PlotException plotException) {
                        plotException.printStackTrace();
                    }
                } else {
                    object2 = (IDataset)list2.get(0);
                    object = this.mainPlotter.getCurrentDataSet();
                    int n = object.getSize();
                    int n2 = object2.getSize();
                    int n3 = 0;
                    while (n3 < n2) {
                        object.set(object2.getObject(new int[]{n3}), new int[]{n3 + n});
                        ++n3;
                    }
                    list2.set(0, (AbstractDataset)object);
                    try {
                        this.mainPlotter.replaceAllPlots(list2);
                    }
                    catch (PlotException plotException) {
                        plotException.printStackTrace();
                    }
                }
                object2 = this.page.getActivePart().getTitle();
                if (!((String)object2).equals("Dataset Inspector") && !((String)object2).equals("Dataset Plot")) {
                    this.mainPlotter.setTitle((String)object2);
                }
                object = new HistogramDataUpdate((IDataset)list2.get(0));
                this.parent.getDisplay().asyncExec(new Runnable((HistogramDataUpdate)object){
                    private final /* synthetic */ HistogramDataUpdate val$histoUpdate;
                    {
                        this.val$histoUpdate = histogramDataUpdate;
                    }

                    @Override
                    public void run() {
                        PlotScatter3DUI.this.mainPlotter.refresh(true);
                        PlotScatter3DUI.this.plotWindow.notifyHistogramChange(this.val$histoUpdate);
                        PlotScatter3DUI.this.plotWindow.notifyUpdateFinished();
                    }
                });
            }
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.plotWindow.deleteIObserver(this.histogramView);
        this.page.hideView((IViewPart)this.histogramView);
    }
}

