/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJob;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJobType;

public class PlotConsumer
implements Runnable,
IObservable {
    private static final transient Logger logger = LoggerFactory.getLogger(PlotConsumer.class);
    private PlotServer plotServer;
    private String viewName;
    private boolean terminate = false;
    private boolean updateFinished = true;
    private int numberOfJobs = 0;
    private Set<IObserver> observers = Collections.synchronizedSet(new LinkedHashSet());
    private List<PlotJob> jobList = Collections.synchronizedList(new LinkedList());
    private static final int TIMEOUTTILLNEXTJOB = 100;

    public PlotConsumer(PlotServer plotServer, String string) {
        this.plotServer = plotServer;
        this.viewName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJob(PlotJob plotJob) {
        if (plotJob.getType() == PlotJobType.GUI) {
            this.jobList.add(plotJob);
            ++this.numberOfJobs;
        } else {
            boolean bl = false;
            List<PlotJob> list = this.jobList;
            synchronized (list) {
                for (PlotJob plotJob2 : this.jobList) {
                    if (plotJob2.getType() != PlotJobType.Data) continue;
                    this.jobList.remove(plotJob2);
                    bl = true;
                    break;
                }
                this.jobList.add(plotJob);
            }
            if (!bl) {
                ++this.numberOfJobs;
            }
        }
        this.notify();
    }

    public void stop() {
        this.terminate = true;
        this.updateFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: while (!this.terminate) {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    while (this.numberOfJobs == 0) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
            try {
                object = null;
                GuiBean guiBean = this.jobList;
                synchronized (guiBean) {
                    object = this.jobList.get(0);
                    this.jobList.remove(0);
                }
                --this.numberOfJobs;
                switch (((PlotJob)object).getType()) {
                    case Data: {
                        guiBean = this.plotServer.getData(this.viewName);
                        if (guiBean != null) {
                            Object object2;
                            logger.debug("Consuming a job for " + this.viewName);
                            Iterator<IObserver> iterator = this.observers.iterator();
                            this.updateFinished = false;
                            while (iterator.hasNext()) {
                                object2 = iterator.next();
                                object2.update((Object)this, (Object)guiBean);
                            }
                            object2 = this;
                            synchronized (object2) {
                                while (!this.updateFinished) {
                                    this.wait();
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block19;
                    }
                    case GUI: {
                        guiBean = ((PlotJob)object).getGuiBean();
                        if (guiBean == null) continue block19;
                        for (Object object2 : this.observers) {
                            object2.update((Object)this, (Object)guiBean);
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.removeAll(this.observers);
    }

    public synchronized void dataUpdateFinished() {
        this.updateFinished = true;
        this.notify();
    }
}

