/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;

public class PlotColorUtility {
    static Color[] GRAPH_DEFAULT_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255), new Color(255, 0, 0), new Color(204, 0, 204), new Color(204, 0, 0), new Color(0, 153, 51), new Color(102, 0, 102), new Color(255, 102, 255), new Color(255, 155, 0), new Color(204, 255, 0), new Color(51, 255, 51), new Color(102, 255, 255), new Color(102, 102, 255), new Color(153, 153, 0), new Color(204, 204, 205), new Color(255, 204, 204)};
    private static final Plot1DStyles[] GRAPH_DEFAULT_STYLES = new Plot1DStyles[GRAPH_DEFAULT_COLORS.length];
    private static final int[] GRAPH_DEFAULT_LINEWIDTHS = new int[GRAPH_DEFAULT_COLORS.length];
    private static Map<String, Color> nameCache;

    static {
        int n = 0;
        while (n < GRAPH_DEFAULT_COLORS.length) {
            PlotColorUtility.GRAPH_DEFAULT_STYLES[n] = Plot1DStyles.SOLID;
            PlotColorUtility.GRAPH_DEFAULT_LINEWIDTHS[n] = 1;
            ++n;
        }
    }

    public static int getSize() {
        return GRAPH_DEFAULT_COLORS.length;
    }

    public static final Color getDefaultColour(int n) {
        return GRAPH_DEFAULT_COLORS[n % GRAPH_DEFAULT_COLORS.length];
    }

    public static final Plot1DStyles getDefaultStyle(int n) {
        return GRAPH_DEFAULT_STYLES[n % GRAPH_DEFAULT_STYLES.length];
    }

    public static final int getDefaultLineWidth(int n) {
        return GRAPH_DEFAULT_LINEWIDTHS[n % GRAPH_DEFAULT_LINEWIDTHS.length];
    }

    public static final Color getDefaultColour(int n, String string) {
        if (nameCache == null) {
            nameCache = new HashMap<String, Color>(1000);
        }
        if (nameCache.containsKey(string)) {
            return nameCache.get(string);
        }
        Color color = PlotColorUtility.getDefaultColour(n);
        nameCache.put(string, color);
        if (nameCache.size() > 1000) {
            nameCache.clear();
        }
        return color;
    }

    public static final void setDefaultColour(int n, Color color) {
        if (n < GRAPH_DEFAULT_COLORS.length) {
            PlotColorUtility.GRAPH_DEFAULT_COLORS[n] = color;
        }
    }

    public static final void setDefaultStyle(int n, Plot1DStyles plot1DStyles) {
        if (n < GRAPH_DEFAULT_STYLES.length) {
            PlotColorUtility.GRAPH_DEFAULT_STYLES[n] = plot1DStyles;
        }
    }

    public static final void setDefaultLineWidth(int n, int n2) {
        if (n < GRAPH_DEFAULT_LINEWIDTHS.length) {
            PlotColorUtility.GRAPH_DEFAULT_LINEWIDTHS[n] = n2;
        }
    }
}

