/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.awt.Color;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;

public class PlotAppearanceDialog
extends Dialog
implements SelectionListener {
    private Button btnOk;
    private List lstGraphs;
    private Label lblColour;
    private Button btnColour;
    private Button btnCancel;
    private Label lblStyle;
    private Combo cmbStyle;
    private Combo cmbWidth;
    private Label lblWidth;
    private Plot1DGraphTable graphTable = null;
    private Plot1DGraphTable copyGraphTable = null;
    private Shell shell;
    private boolean update = false;

    public PlotAppearanceDialog(Shell shell) {
        super(shell);
    }

    public PlotAppearanceDialog(Shell shell, Plot1DGraphTable plot1DGraphTable) {
        this(shell);
        this.graphTable = plot1DGraphTable;
        if (this.graphTable != null) {
            this.copyGraphTable = new Plot1DGraphTable();
            int n = 0;
            while (n < this.graphTable.getLegendSize()) {
                Plot1DAppearance plot1DAppearance = this.graphTable.getLegendEntry(n);
                Plot1DAppearance plot1DAppearance2 = new Plot1DAppearance(plot1DAppearance.getColour(), plot1DAppearance.getStyle(), plot1DAppearance.getLineWidth(), plot1DAppearance.getName(), plot1DAppearance.isVisible());
                this.copyGraphTable.addEntryOnLegend(plot1DAppearance2);
                ++n;
            }
        }
    }

    public boolean open() {
        Shell shell = this.getParent();
        this.shell = new Shell(shell, 67696);
        this.shell.setSize(418, 280);
        this.shell.setText("Set appearance of a graph");
        this.shell.setImage(AnalysisRCPActivator.getImageDescriptor("icons/color_wheel.png").createImage());
        this.shell.setLayout((Layout)new GridLayout(6, false));
        this.lstGraphs = new List((Composite)this.shell, 2560);
        GridData gridData = new GridData(4, 4, true, true, 6, 1);
        gridData.heightHint = 173;
        gridData.widthHint = 378;
        this.lstGraphs.setLayoutData((Object)gridData);
        this.lstGraphs.addSelectionListener((SelectionListener)this);
        this.lblColour = new Label((Composite)this.shell, 0);
        this.lblColour.setText("Colour:");
        this.btnColour = new Button((Composite)this.shell, 0);
        gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 41;
        this.btnColour.setLayoutData((Object)gridData);
        this.btnColour.addSelectionListener((SelectionListener)this);
        this.lblStyle = new Label((Composite)this.shell, 0);
        gridData = new GridData(0x1000000, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 43;
        this.lblStyle.setLayoutData((Object)gridData);
        this.lblStyle.setText("Style:");
        this.cmbStyle = new Combo((Composite)this.shell, 0);
        gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 69;
        this.cmbStyle.setLayoutData((Object)gridData);
        this.cmbStyle.add("Solid");
        this.cmbStyle.add("Dashed");
        this.cmbStyle.add("Points");
        this.cmbStyle.add("Solid with points");
        this.cmbStyle.add("Dashed with points");
        this.cmbStyle.select(0);
        this.cmbStyle.addSelectionListener((SelectionListener)this);
        this.lblWidth = new Label((Composite)this.shell, 64);
        gridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 60;
        this.lblWidth.setLayoutData((Object)gridData);
        this.lblWidth.setText("Width:");
        this.cmbWidth = new Combo((Composite)this.shell, 0);
        gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 69;
        this.cmbWidth.setLayoutData((Object)gridData);
        this.cmbWidth.add("0.5");
        this.cmbWidth.add("1.0");
        this.cmbWidth.add("2.0");
        this.cmbWidth.add("4.0");
        this.cmbWidth.add("8.0");
        this.cmbWidth.select(1);
        this.cmbWidth.addSelectionListener((SelectionListener)this);
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        this.btnOk = new Button((Composite)this.shell, 0);
        this.btnOk.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.btnOk.setText("Update");
        this.btnOk.addSelectionListener((SelectionListener)this);
        new Label((Composite)this.shell, 0);
        this.btnCancel = new Button((Composite)this.shell, 0);
        this.btnCancel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addSelectionListener((SelectionListener)this);
        new Label((Composite)this.shell, 0);
        if (this.copyGraphTable != null) {
            int n = 0;
            while (n < this.copyGraphTable.getLegendSize()) {
                Plot1DAppearance plot1DAppearance = this.copyGraphTable.getLegendEntry(n);
                this.lstGraphs.add(plot1DAppearance.getName());
                ++n;
            }
        }
        this.shell.open();
        Display display = shell.getDisplay();
        if (this.copyGraphTable != null && this.copyGraphTable.getLegendSize() > 0) {
            this.lstGraphs.select(0);
            this.updateWidgets();
        }
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.update;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void updateWidgets() {
        Plot1DAppearance plot1DAppearance = this.copyGraphTable.getLegendEntry(this.lstGraphs.getSelectionIndex());
        if (plot1DAppearance.getStyle() == Plot1DStyles.SOLID) {
            this.cmbStyle.select(0);
        } else if (plot1DAppearance.getStyle() == Plot1DStyles.DASHED) {
            this.cmbStyle.select(1);
        } else if (plot1DAppearance.getStyle() == Plot1DStyles.POINT) {
            this.cmbStyle.select(2);
        } else if (plot1DAppearance.getStyle() == Plot1DStyles.SOLID_POINT) {
            this.cmbStyle.select(3);
        } else if (plot1DAppearance.getStyle() == Plot1DStyles.DASHED_POINT) {
            this.cmbStyle.select(4);
        }
        Color color = plot1DAppearance.getColour();
        RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        org.eclipse.swt.graphics.Color color2 = new org.eclipse.swt.graphics.Color((Device)this.btnColour.getDisplay(), rGB);
        this.btnColour.setForeground(color2);
        this.btnColour.setBackground(color2);
        this.cmbWidth.select(plot1DAppearance.getLineWidth() >> 1);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object;
        Object object2;
        Plot1DAppearance plot1DAppearance;
        if (selectionEvent.getSource().equals(this.lstGraphs)) {
            this.updateWidgets();
        }
        if (selectionEvent.getSource().equals(this.cmbStyle)) {
            plot1DAppearance = this.copyGraphTable.getLegendEntry(this.lstGraphs.getSelectionIndex());
            if (this.cmbStyle.getSelectionIndex() == 0) {
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
            } else if (this.cmbStyle.getSelectionIndex() == 1) {
                plot1DAppearance.setStyle(Plot1DStyles.DASHED);
            } else if (this.cmbStyle.getSelectionIndex() == 2) {
                plot1DAppearance.setStyle(Plot1DStyles.POINT);
            } else if (this.cmbStyle.getSelectionIndex() == 3) {
                plot1DAppearance.setStyle(Plot1DStyles.SOLID_POINT);
            } else if (this.cmbStyle.getSelectionIndex() == 4) {
                plot1DAppearance.setStyle(Plot1DStyles.DASHED_POINT);
            }
        }
        if (selectionEvent.getSource().equals(this.cmbWidth)) {
            plot1DAppearance = this.copyGraphTable.getLegendEntry(this.lstGraphs.getSelectionIndex());
            plot1DAppearance.setLineWidth(this.cmbWidth.getSelectionIndex() << 1);
        }
        if (selectionEvent.getSource().equals(this.btnColour) && this.lstGraphs.getSelectionIndex() >= 0) {
            plot1DAppearance = this.copyGraphTable.getLegendEntry(this.lstGraphs.getSelectionIndex());
            object2 = new ColorDialog(this.getParent().getShell());
            object2.setText("Line colour");
            object2.setRGB(new RGB(255, 0, 0));
            object = object2.open();
            if (object != null) {
                plot1DAppearance.setColour(new Color(((RGB)object).red, ((RGB)object).green, ((RGB)object).blue));
                org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)this.btnColour.getDisplay(), (RGB)object);
                this.btnColour.setForeground(color);
                this.btnColour.setBackground(color);
            }
        }
        if (selectionEvent.getSource().equals(this.btnCancel)) {
            this.shell.close();
        }
        if (selectionEvent.getSource().equals(this.btnOk)) {
            if (this.copyGraphTable != null) {
                this.update = true;
                int n = 0;
                while (n < this.copyGraphTable.getLegendSize()) {
                    object2 = this.copyGraphTable.getLegendEntry(n);
                    object = this.graphTable.getLegendEntry(n);
                    ((Plot1DAppearance)object).setColour(((Plot1DAppearance)object2).getColour());
                    ((Plot1DAppearance)object).setStyle(((Plot1DAppearance)object2).getStyle());
                    ((Plot1DAppearance)object).setLineWidth(((Plot1DAppearance)object2).getLineWidth());
                    ++n;
                }
                this.copyGraphTable.clearLegend();
            }
            this.shell.close();
        }
    }
}

