/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.SidePlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;
import uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView;

public class Plot2DUI
extends AbstractPlotUI {
    public static final String STATUSITEMID = "uk.ac.dimaond.scisoft.analysis.rcp.plotting.Plot2DUI";
    private static HashMap<String, Integer> logScaleSettings = new HashMap();
    private DataSetPlotter mainPlotter;
    private Composite compParent;
    private IWorkbenchPage page;
    private String plotViewID;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private PlotWindow plotWindow;
    private HistogramView histogramView;
    private Action resetView;
    private Action printGraph;
    private Action monitorValues;
    private Action saveGraph;
    private Action copyGraph;
    private Action canvasAspect;
    private AxisValues xAxis = null;
    private AxisValues yAxis = null;
    private Action xLabelTypeRound = null;
    private Action xLabelTypeFloat = null;
    private Action xLabelTypeExponent = null;
    private Action xLabelTypeSI = null;
    private Action yLabelTypeRound = null;
    private Action yLabelTypeFloat = null;
    private Action yLabelTypeExponent = null;
    private Action yLabelTypeSI = null;
    private Action colourCastLinear = null;
    private Action colourCastLog = null;
    private Action gradientMode = null;
    private Action axisVisibility = null;
    private IGuiInfoManager manager = null;
    private List<Action> switchToTabs;
    private HistogramDataUpdate histoUpdate = null;
    private static final Logger logger = LoggerFactory.getLogger(Plot2DUI.class);
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");

    public Plot2DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, IGuiInfoManager iGuiInfoManager, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.mainPlotter = dataSetPlotter;
        this.compParent = composite;
        this.plotWindow = plotWindow;
        this.page = iWorkbenchPage;
        this.plotViewID = string;
        this.manager = iGuiInfoManager;
        this.initHistogramView(this.plotViewID);
        this.mainPlotter.registerUI(this);
        this.mainPlotter.enableImageScrollBars(this.getPreferenceScrollBars());
        this.initSidePlotView();
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        iActionBars.updateActionBars();
    }

    public void initHistogramView(String string) {
        try {
            this.histogramView = (HistogramView)this.page.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            logger.error("Failed to initialized histogram View");
        }
    }

    @Override
    public ISidePlotView initSidePlotView() {
        try {
            SidePlotView sidePlotView = this.getSidePlotView();
            sidePlotView.setPlotView(this.plotWindow.getMainPlotter(), this.manager);
            sidePlotView.setSwitchActions(this.switchToTabs);
            return sidePlotView;
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug("Cannot initiate side plot view", (Throwable)illegalStateException);
            return null;
        }
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            boolean bl2;
            DataSetWithAxisInformation dataSetWithAxisInformation;
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            AbstractDataset abstractDataset = dataBean.getAxis("x-axis");
            AbstractDataset abstractDataset2 = dataBean.getAxis("y-axis");
            this.xAxis.clear();
            this.yAxis.clear();
            this.mainPlotter.setAxisModes(abstractDataset == null ? AxisMode.LINEAR : AxisMode.CUSTOM, abstractDataset2 == null ? AxisMode.LINEAR : AxisMode.CUSTOM, AxisMode.LINEAR);
            if (abstractDataset != null) {
                if (abstractDataset.getName() != null && abstractDataset.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(abstractDataset.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                this.xAxis.setValues(abstractDataset);
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
            } else {
                this.mainPlotter.setXAxisLabel("X-Axis");
            }
            if (abstractDataset2 != null) {
                if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                    this.mainPlotter.setYAxisLabel(abstractDataset2.getName());
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                this.yAxis.setValues(abstractDataset2);
                this.mainPlotter.setYAxisValues(this.yAxis);
            } else {
                this.mainPlotter.setYAxisLabel("Y-Axis");
            }
            this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
            while (iterator.hasNext()) {
                dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                AbstractDataset abstractDataset3 = dataSetWithAxisInformation.getData();
                list2.add(abstractDataset3);
            }
            this.histoUpdate = new HistogramDataUpdate((IDataset)list2.get(0));
            try {
                this.mainPlotter.replaceAllPlots(list2);
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            this.mainPlotter.setTitle(((AbstractDataset)list2.get(0)).getName());
            this.compParent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Plot2DUI.this.getSidePlotView().processPlotUpdate();
                    Plot2DUI.this.plotWindow.notifyUpdateFinished();
                }
            });
            dataSetWithAxisInformation = (AbstractDataset)list2.get(0);
            boolean bl3 = bl2 = dataSetWithAxisInformation instanceof RGBDataset || dataSetWithAxisInformation instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)dataSetWithAxisInformation).getElementsPerItem() == 3 || ((AbstractCompoundDataset)dataSetWithAxisInformation).getElementsPerItem() == 4);
            if (!bl2) {
                this.plotWindow.notifyHistogramChange(this.histoUpdate);
            } else {
                this.mainPlotter.refresh(true);
            }
        }
    }

    public HistogramView getHistogramView() {
        return this.histogramView;
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeRound.setChecked(true);
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the y-axis to integer numbers");
        this.yLabelTypeRound.setChecked(true);
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        this.colourCastLinear = new Action("", 8){

            public void run() {
                dataSetPlotter.setZAxisScaling(ScaleType.LINEAR);
                dataSetPlotter.refresh(true);
                Plot2DUI.this.histogramView.setScaling(ScaleType.LINEAR);
                logScaleSettings.put(Plot2DUI.this.histogramView.getPartName(), 0);
            }
        };
        this.colourCastLinear.setChecked(this.getPreferenceColourScaleChoice() == 0);
        this.colourCastLinear.setText("Linear mapping colours");
        this.colourCastLinear.setToolTipText("Apply linear colour mapping to image");
        this.colourCastLog = new Action("", 8){

            public void run() {
                dataSetPlotter.setZAxisScaling(ScaleType.LN);
                dataSetPlotter.refresh(true);
                Plot2DUI.this.histogramView.setScaling(ScaleType.LN);
                logScaleSettings.put(Plot2DUI.this.histogramView.getPartName(), 1);
            }
        };
        this.colourCastLog.setText("Logarithmic mapping colours");
        this.colourCastLog.setToolTipText("Apply logarithmic colour mapping to image");
        this.colourCastLog.setChecked(this.getPreferenceColourScaleChoice() != 0);
        if (this.colourCastLog.isChecked()) {
            dataSetPlotter.setZAxisScaling(ScaleType.LN);
            this.histogramView.setScaling(ScaleType.LN);
        }
        this.gradientMode = new Action("", 2){

            public void run() {
                dataSetPlotter.setGradientImageMode(Plot2DUI.this.gradientMode.isChecked());
            }
        };
        this.gradientMode.setText("Switch to gradient mode");
        this.gradientMode.setToolTipText("Switches display to gradient mode shows magnitude of gradients");
        this.axisVisibility = new Action("", 2){

            public void run() {
                dataSetPlotter.setAxisVisibility(Plot2DUI.this.axisVisibility.isChecked());
            }
        };
        this.axisVisibility.setText("Show Axis");
        this.axisVisibility.setToolTipText("Switches on/off Axis visibility");
        this.axisVisibility.setChecked(true);
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        iMenuManager.add((IAction)this.colourCastLinear);
        iMenuManager.add((IAction)this.colourCastLog);
        iMenuManager.add((IAction)this.gradientMode);
        iMenuManager.add((IAction)this.axisVisibility);
        iMenuManager.update(true);
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                Plot2DUI.this.mainPlotter.resetView();
                Plot2DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.monitorValues = new Action("", 2){

            public void run() {
                dataSetPlotter.setPlotActionEnabled(Plot2DUI.this.monitorValues.isChecked());
            }
        };
        this.monitorValues.setText("Monitor position");
        this.monitorValues.setToolTipText("Monitor the position in the image");
        this.monitorValues.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/monitor.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                dataSetPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                dataSetPlotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                dataSetPlotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        this.canvasAspect = new Action("", 2){

            public void run() {
                dataSetPlotter.imagePlotSetCanvasAspectRatio(Plot2DUI.this.canvasAspect.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.canvasAspect.setText("Canvas");
        this.canvasAspect.setToolTipText("Switch between canvas/data aspect ratio");
        this.canvasAspect.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_out.png"));
        iToolBarManager.add((IContributionItem)new Separator());
        try {
            this.switchToTabs = this.getSidePlotView().createSwitchActions(this);
            for (Action action : this.switchToTabs) {
                iToolBarManager.add((IAction)action);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.monitorValues);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Canvas"));
        iToolBarManager.add((IAction)this.canvasAspect);
        iToolBarManager.update(true);
    }

    @Override
    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    @Override
    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    @Override
    public void deleteIObservers() {
        this.observers.clear();
    }

    @Override
    public void disposeOverlays() {
        this.getSidePlotView().disposeOverlays();
    }

    @Override
    public void deactivate(boolean bl) {
        this.histoUpdate = null;
        this.plotWindow.deleteIObserver(this.histogramView);
        try {
            this.getSidePlotView().deactivate(bl);
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            this.page.hideView((IViewPart)this.histogramView);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
        this.getSidePlotView().updateGUI(guiBean);
    }

    @Override
    public SidePlotView getSidePlotView() {
        return SidePlotUtils.getSidePlotView(this.page, this.plotViewID);
    }

    private boolean getPreferenceScrollBars() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("plotView.plot2DshowScrollbar") ? iPreferenceStore.getDefaultBoolean("plotView.plot2DshowScrollbar") : iPreferenceStore.getBoolean("plotView.plot2DshowScrollbar");
    }

    private int getPreferenceColourScaleChoice() {
        String string;
        if (this.histogramView != null && logScaleSettings.get(this.histogramView.getPartName()) != null) {
            return logScaleSettings.get(this.histogramView.getPartName());
        }
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        if (this.histogramView != null && !iPreferenceStore.isDefault(String.valueOf(string = this.histogramView.getPartName()) + "." + "plotView.plot2Dscaling")) {
            return iPreferenceStore.getInt(String.valueOf(string) + "." + "plotView.plot2Dscaling");
        }
        return iPreferenceStore.isDefault("plotView.plot2Dscaling") ? iPreferenceStore.getDefaultInt("plotView.plot2Dscaling") : iPreferenceStore.getInt("plotView.plot2Dscaling");
    }
}

