/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class Plot2DMultiUI
extends AbstractPlotUI {
    private DataSetPlotter mainPlotter;
    private Composite compParent;
    private PlotWindow plotWindow;
    private IWorkbenchPage page;
    private String plotViewID;
    private AxisValues xAxis;
    private AxisValues yAxis;
    private HistogramView histogramView;
    private Action xLabelTypeRound;
    private Action xLabelTypeFloat;
    private Action xLabelTypeExponent;
    private Action xLabelTypeSI;
    private Action yLabelTypeRound;
    private Action yLabelTypeFloat;
    private Action yLabelTypeExponent;
    private Action yLabelTypeSI;
    private Action resetView;
    private Action saveGraph;
    private Action copyGraph;
    private Action printGraph;
    private Action canvasAspect;
    private HistogramDataUpdate histoUpdate;
    private static final Logger logger = LoggerFactory.getLogger(Plot2DMultiUI.class);
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");

    public Plot2DMultiUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, IGuiInfoManager iGuiInfoManager, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.mainPlotter = dataSetPlotter;
        this.compParent = composite;
        this.plotWindow = plotWindow;
        this.page = iWorkbenchPage;
        this.plotViewID = string;
        this.initHistogramView(this.plotViewID);
        this.mainPlotter.registerUI(this);
        this.initSidePlotView();
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        iActionBars.updateActionBars();
    }

    public void initHistogramView(String string) {
        try {
            this.histogramView = (HistogramView)this.page.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            logger.error("Failed to initialized histogram View");
        }
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeRound.setChecked(true);
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the y-axis to integer numbers");
        this.yLabelTypeRound.setChecked(true);
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        iMenuManager.update(true);
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                Plot2DMultiUI.this.mainPlotter.resetView();
                Plot2DMultiUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                dataSetPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                dataSetPlotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                dataSetPlotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        this.canvasAspect = new Action("", 2){

            public void run() {
                dataSetPlotter.imagePlotSetCanvasAspectRatio(Plot2DMultiUI.this.canvasAspect.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.canvasAspect.setText("Canvas");
        this.canvasAspect.setToolTipText("Switch between canvas/data aspect ratio");
        this.canvasAspect.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_out.png"));
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Canvas"));
        iToolBarManager.add((IAction)this.canvasAspect);
        iToolBarManager.update(true);
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            AbstractDataset abstractDataset = dataBean.getAxis("x-axis");
            AbstractDataset abstractDataset2 = dataBean.getAxis("y-axis");
            this.xAxis.clear();
            this.yAxis.clear();
            this.mainPlotter.setAxisModes(abstractDataset == null ? AxisMode.LINEAR : AxisMode.CUSTOM, abstractDataset2 == null ? AxisMode.LINEAR : AxisMode.CUSTOM, AxisMode.LINEAR);
            if (abstractDataset != null) {
                if (abstractDataset.getName() != null && abstractDataset.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(abstractDataset.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                this.xAxis.setValues(abstractDataset);
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
            } else {
                this.mainPlotter.setXAxisLabel("X-Axis");
            }
            if (abstractDataset2 != null) {
                if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                    this.mainPlotter.setYAxisLabel(abstractDataset2.getName());
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                this.yAxis.setValues(abstractDataset2);
                this.mainPlotter.setYAxisValues(this.yAxis);
            } else {
                this.mainPlotter.setYAxisLabel("Y-Axis");
            }
            this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
            while (iterator.hasNext()) {
                DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                AbstractDataset abstractDataset3 = dataSetWithAxisInformation.getData();
                list2.add(abstractDataset3);
            }
            try {
                this.mainPlotter.replaceAllPlots(list2);
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            this.mainPlotter.setTitle(((AbstractDataset)list2.get(0)).getName());
            this.compParent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Plot2DMultiUI.this.plotWindow.notifyUpdateFinished();
                }
            });
            boolean bl2 = true;
            for (AbstractDataset abstractDataset3 : list2) {
                bl2 &= abstractDataset3 instanceof RGBDataset || abstractDataset3 instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)abstractDataset3).getElementsPerItem() == 3 || ((AbstractCompoundDataset)abstractDataset3).getElementsPerItem() == 4);
            }
            if (!bl2) {
                for (AbstractDataset abstractDataset3 : list2) {
                    if (abstractDataset3 instanceof RGBDataset || abstractDataset3 instanceof AbstractCompoundDataset) continue;
                    this.histoUpdate = new HistogramDataUpdate((IDataset)abstractDataset3);
                    break;
                }
                this.plotWindow.notifyHistogramChange(this.histoUpdate);
            } else {
                this.mainPlotter.refresh(true);
            }
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.histoUpdate = null;
        this.plotWindow.deleteIObserver(this.histogramView);
        this.page.hideView((IViewPart)this.histogramView);
    }
}

