/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotDataTableDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.SidePlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView;

public class Plot1DUIComplete
extends Plot1DUIAdapter {
    public static final String STATUSITEMID = "uk.ac.dimaond.scisoft.analysis.rcp.plotting.Plot1DUI";
    private static final String STATUSSTRING = "Pos: ";
    private StatusLineContributionItem statusLine;
    private AxisValues xAxis;
    private IWorkbenchPage page;
    private String plotViewID;
    private PlotWindow plotWindow;
    private List<Action> switchToTabs;
    private IGuiInfoManager manager;

    public Plot1DUIComplete(PlotWindow plotWindow, IGuiInfoManager iGuiInfoManager, IActionBars iActionBars, Composite composite, IWorkbenchPage iWorkbenchPage, String string) {
        super(plotWindow.getMainPlotter(), composite, string);
        this.page = iWorkbenchPage;
        this.plotWindow = plotWindow;
        this.plotViewID = string;
        this.xAxis = new AxisValues();
        this.manager = iGuiInfoManager;
        this.initSidePlotView();
        this.buildToolActions(iActionBars.getToolBarManager());
        this.buildMenuActions(iActionBars.getMenuManager());
        this.buildStatusLineItems(iActionBars.getStatusLineManager());
    }

    @Override
    public ISidePlotView initSidePlotView() {
        try {
            SidePlotView sidePlotView = this.getSidePlotView();
            sidePlotView.setPlotView(this.plotWindow.getMainPlotter(), this.manager);
            sidePlotView.setSwitchActions(this.switchToTabs);
            return sidePlotView;
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug("Cannot initiate side plot view", (Throwable)illegalStateException);
            return null;
        }
    }

    @Override
    public SidePlotView getSidePlotView() {
        return SidePlotUtils.getSidePlotView(this.page, this.plotViewID);
    }

    @Override
    public void deactivate(boolean bl) {
        super.deactivate(bl);
        try {
            this.getSidePlotView().deactivate(bl);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Override
    public void buildStatusLineItems(IStatusLineManager iStatusLineManager) {
        this.statusLine = new StatusLineContributionItem(STATUSITEMID);
        this.statusLine.setText(STATUSSTRING);
        iStatusLineManager.add((IContributionItem)this.statusLine);
    }

    @Override
    public void buildMenuActions(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        iMenuManager.add((IAction)this.yAxisScaleLinear);
        iMenuManager.add((IAction)this.yAxisScaleLog);
    }

    @Override
    public void buildToolActions(IToolBarManager iToolBarManager) {
        try {
            this.switchToTabs = this.getSidePlotView().createSwitchActions(this);
            for (Action action : this.switchToTabs) {
                iToolBarManager.add((IAction)action);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Data"));
        iToolBarManager.add((IAction)this.displayPlotPos);
        iToolBarManager.add((IAction)this.rightClickOnGraphAction);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "History"));
        iToolBarManager.add((IAction)this.addToHistory);
        iToolBarManager.add((IAction)this.removeFromHistory);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Zoom"));
        iToolBarManager.add((IAction)this.activateRegionZoom);
        iToolBarManager.add((IAction)this.activateAreaZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.resetZoomAction);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Appearance"));
        iToolBarManager.add((IAction)this.changeColour);
        iToolBarManager.add((IAction)this.activateXgrid);
        iToolBarManager.add((IAction)this.activateYgrid);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "Menu"));
        iToolBarManager.update(true);
    }

    @Override
    public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
        if (plotActionEvent instanceof PlotActionComplexEvent) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotDataTableDialog plotDataTableDialog = new PlotDataTableDialog(Plot1DUIComplete.this.parent.getShell(), (PlotActionComplexEvent)plotActionEvent);
                    plotDataTableDialog.open();
                }
            });
        } else {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String string = plotActionEvent.getPosition().length > 2 ? String.format("%s %g (%g):%g", Plot1DUIComplete.STATUSSTRING, plotActionEvent.getPosition()[0], plotActionEvent.getPosition()[2], plotActionEvent.getPosition()[1]) : String.format("%s %g:%g", Plot1DUIComplete.STATUSSTRING, plotActionEvent.getPosition()[0], plotActionEvent.getPosition()[1]);
                    Plot1DUIComplete.this.statusLine.setText(string);
                }
            });
        }
        super.plotActionPerformed(plotActionEvent);
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            Serializable serializable;
            Object object;
            DataSetWithAxisInformation dataSetWithAxisInformation;
            Object object2;
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            this.xAxis.clear();
            AbstractDataset abstractDataset = dataBean.getAxis("x-axis");
            AbstractDataset abstractDataset2 = dataBean.getAxis("2nd x-axis");
            AxisValues axisValues = null;
            AxisMode axisMode = AxisMode.LINEAR;
            LinkedList<AxisValues> linkedList = null;
            if (abstractDataset != null) {
                object2 = abstractDataset.getName();
                if (object2 != null && ((String)object2).length() > 0) {
                    this.plotter.setXAxisLabel((String)object2);
                } else {
                    this.plotter.setXAxisLabel("X-Axis");
                }
                this.xAxis.setValues(abstractDataset);
                axisMode = AxisMode.CUSTOM;
            } else {
                object2 = dataBean.getAxis("x-axis0");
                this.plotter.setXAxisLabel("X-Axis");
                if (object2 != null) {
                    axisMode = AxisMode.CUSTOM;
                    linkedList = new LinkedList<AxisValues>();
                }
                this.plotter.setXAxisLabel("X-Axis");
            }
            object2 = this.plotter.getColourTable();
            ((Plot1DGraphTable)object2).clearLegend();
            this.plotter.setAxisModes(axisMode, AxisMode.LINEAR, AxisMode.LINEAR);
            if (abstractDataset != null) {
                this.plotter.setXAxisValues(this.xAxis, list.size());
            }
            if (abstractDataset2 != null) {
                String string = "X-Axis 2";
                if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                    string = abstractDataset2.getName();
                }
                axisValues = new AxisValues(abstractDataset2);
                this.plotter.setSecondaryXAxisValues(axisValues, string);
            } else {
                this.plotter.setSecondaryXAxisValues(null, "");
            }
            int n = 0;
            while (iterator.hasNext()) {
                dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                AbstractDataset abstractDataset3 = dataSetWithAxisInformation.getData();
                if (linkedList != null) {
                    object = "x-axis" + n;
                    AbstractDataset abstractDataset4 = dataBean.getAxis((String)object);
                    if (abstractDataset4 != null) {
                        serializable = new AxisValues(abstractDataset4);
                        linkedList.add((AxisValues)serializable);
                    }
                    ++n;
                }
                object = new Plot1DAppearance(PlotColorUtility.getDefaultColour(((Plot1DGraphTable)object2).getLegendSize()), PlotColorUtility.getDefaultStyle(((Plot1DGraphTable)object2).getLegendSize()), PlotColorUtility.getDefaultLineWidth(((Plot1DGraphTable)object2).getLegendSize()), abstractDataset3.getName());
                ((Plot1DGraphTable)object2).addEntryOnLegend((Plot1DAppearance)object);
                list2.add(abstractDataset3);
            }
            dataSetWithAxisInformation = new ArrayList();
            int n2 = 0;
            while (n2 < list2.size()) {
                object = ((AbstractDataset)list2.get(n2)).getName();
                if (object != null) {
                    dataSetWithAxisInformation.add(object);
                }
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder("Y-Axis");
            if (dataSetWithAxisInformation.size() > 0) {
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append((String)dataSetWithAxisInformation.get(0));
                int n3 = 1;
                while (n3 < dataSetWithAxisInformation.size()) {
                    stringBuilder.append(", ");
                    stringBuilder.append((String)dataSetWithAxisInformation.get(n3));
                    ++n3;
                }
            }
            if (stringBuilder.length() > 50) {
                stringBuilder.delete(47, stringBuilder.length());
                stringBuilder.append("...");
            }
            this.plotter.setYAxisLabel(stringBuilder.toString());
            int n4 = this.plotter.getNumHistory();
            int n5 = 0;
            while (n5 < n4) {
                serializable = new Plot1DAppearance(PlotColorUtility.getDefaultColour(((Plot1DGraphTable)object2).getLegendSize()), PlotColorUtility.getDefaultStyle(((Plot1DGraphTable)object2).getLegendSize()), PlotColorUtility.getDefaultLineWidth(((Plot1DGraphTable)object2).getLegendSize()), "History " + (n5 + 1));
                ((Plot1DGraphTable)object2).addEntryOnLegend((Plot1DAppearance)serializable);
                ++n5;
            }
            this.plotter.setPlotUpdateOperation(bl);
            try {
                if (linkedList != null) {
                    this.plotter.replaceAllPlots(list2, linkedList);
                } else {
                    this.plotter.replaceAllPlots(list2);
                }
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            String string = this.page.getActivePart().getTitle();
            if (!string.equals("Dataset Inspector") && !string.equals("Dataset Plot")) {
                this.plotter.setTitle(string);
            }
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Plot1DUIComplete.this.plotter.refresh(true);
                    Plot1DUIComplete.this.plotter.updateAllAppearance();
                    Plot1DUIComplete.this.getSidePlotView().processPlotUpdate();
                    Plot1DUIComplete.this.plotWindow.notifyUpdateFinished();
                }
            });
        }
    }
}

