/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import com.swtdesigner.ResourceManager;
import gda.observable.IObserver;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IActionBars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotAppearanceDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;

public class Plot1DUIAdapter
extends AbstractPlotUI {
    public static final String HISTORYSTRING = "History";
    protected List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    protected DataSetPlotter plotter;
    protected Composite parent;
    protected Action zoomAction;
    protected Action resetZoomAction;
    protected Action activateRegionZoom;
    protected Action activateAreaZoom;
    protected Action displayPlotPos;
    protected Action addToHistory;
    protected Action removeFromHistory;
    protected Action rightClickOnGraphAction;
    protected Action changeColour;
    protected Action activateXgrid;
    protected Action activateYgrid;
    protected Action xLabelTypeRound;
    protected Action xLabelTypeFloat;
    protected Action xLabelTypeExponent;
    protected Action xLabelTypeSI;
    protected Action yLabelTypeRound;
    protected Action yLabelTypeFloat;
    protected Action yLabelTypeExponent;
    protected Action yLabelTypeSI;
    protected Action yAxisScaleLog;
    protected Action yAxisScaleLinear;
    protected Action saveGraph;
    protected Action copyGraph;
    protected Action printGraph;
    protected Action toggleXAxisErrorBars;
    protected Action toggleYAxisErrorBars;
    protected Action toggleZAxisErrorBars;
    protected String viewName;
    protected String xAxisModePref;
    protected String yAxisModePref;
    protected String xGridLinePref;
    protected String yGridLinePref;
    protected String numAppsPref;
    protected static final Logger logger = LoggerFactory.getLogger(Plot1DUIAdapter.class);
    protected String[] listPrintScaleText = new String[]{ResourceProperties.getResourceString("PRINT_LISTSCALE_0"), ResourceProperties.getResourceString("PRINT_LISTSCALE_1"), ResourceProperties.getResourceString("PRINT_LISTSCALE_2"), ResourceProperties.getResourceString("PRINT_LISTSCALE_3"), ResourceProperties.getResourceString("PRINT_LISTSCALE_4"), ResourceProperties.getResourceString("PRINT_LISTSCALE_5"), ResourceProperties.getResourceString("PRINT_LISTSCALE_6")};
    protected String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    protected String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    protected String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    protected String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    protected String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    protected String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    protected String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    protected String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    protected String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private Set<PlotActionEventListener> plotListeners;

    public Plot1DUIAdapter(DataSetPlotter dataSetPlotter, Composite composite, String string) {
        this.parent = composite;
        this.plotter = dataSetPlotter;
        this.viewName = string;
        this.createAllActions();
        this.readAndSetPreferences();
        this.plotter.registerUI(this);
    }

    public Plot1DUIAdapter(IActionBars iActionBars, DataSetPlotter dataSetPlotter, Composite composite, String string) {
        this(dataSetPlotter, composite, string);
        this.buildToolActions(iActionBars.getToolBarManager());
        this.buildMenuActions(iActionBars.getMenuManager());
        this.buildStatusLineItems(iActionBars.getStatusLineManager());
    }

    protected IAction createShowLegend() {
        return Plot1DUIAdapter.createShowLegend(this.plotter);
    }

    public static IAction createShowLegend(final DataSetPlotter dataSetPlotter) {
        Action action = new Action("Show legend", 2){

            public void run() {
                if (dataSetPlotter == null) {
                    return;
                }
                dataSetPlotter.setUseLegend(this.isChecked());
            }
        };
        action.setImageDescriptor(ResourceManager.getImageDescriptor(Plot1DUIAdapter.class, "/icons/application_tile_vertical.png"));
        return action;
    }

    public Plot1DUIAdapter(IToolBarManager iToolBarManager, DataSetPlotter dataSetPlotter, Composite composite, String string) {
        this(dataSetPlotter, composite, string);
        this.buildToolActions(iToolBarManager);
    }

    public void buildMenuActions(IMenuManager iMenuManager) {
    }

    public void buildStatusLineItems(IStatusLineManager iStatusLineManager) {
    }

    public void buildToolActions(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.activateRegionZoom);
        iToolBarManager.add((IAction)this.activateAreaZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.changeColour);
        iToolBarManager.add((IAction)this.activateXgrid);
        iToolBarManager.add((IAction)this.activateYgrid);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
    }

    protected void createAllActions() {
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.xAxisModePref, 1);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setXTickLabelFormat(TickFormatting.plainMode);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.xAxisModePref, 0);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setXTickLabelFormat(TickFormatting.useExponent);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.xAxisModePref, 2);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setXTickLabelFormat(TickFormatting.useSIunits);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.xAxisModePref, 3);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.yAxisModePref, 1);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYTickLabelFormat(TickFormatting.plainMode);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.yAxisModePref, 0);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYTickLabelFormat(TickFormatting.useExponent);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.yAxisModePref, 2);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYTickLabelFormat(TickFormatting.useSIunits);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.yAxisModePref, 3);
                Plot1DUIAdapter.this.plotter.refresh(true);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        this.yAxisScaleLinear = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYAxisScaling(ScaleType.LINEAR);
            }
        };
        this.yAxisScaleLinear.setText("Y-Axis scale linear");
        this.yAxisScaleLinear.setToolTipText("Change the Y-Axis scaling to be linear");
        this.yAxisScaleLog = new Action("", 8){

            public void run() {
                Plot1DUIAdapter.this.plotter.setYAxisScaling(ScaleType.LN);
            }
        };
        this.yAxisScaleLog.setText("Y-Axis scale logarithmic");
        this.yAxisScaleLog.setToolTipText("Change the Y-Axis scaling to be logarithmic (natural)");
        this.addToHistory = new Action(){

            public void run() {
                Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(Plot1DUIAdapter.this.plotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + (Plot1DUIAdapter.this.plotter.getNumHistory() + 1));
                Plot1DUIAdapter.this.plotter.getColourTable().addEntryOnLegend(plot1DAppearance);
                Plot1DUIAdapter.this.plotter.pushGraphOntoHistory();
                Plot1DUIAdapter.this.notifyObservers();
                Plot1DUIAdapter.this.plotter.refresh(false);
            }
        };
        this.addToHistory.setText("Add current line to history");
        this.addToHistory.setToolTipText("Adds the current line to the plot history");
        this.addToHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_put.png"));
        this.removeFromHistory = new Action(){

            public void run() {
                if (Plot1DUIAdapter.this.plotter.getNumHistory() > 0) {
                    Plot1DUIAdapter.this.plotter.getColourTable().deleteLegendEntry(Plot1DUIAdapter.this.plotter.getColourTable().getLegendSize() - 1);
                    Plot1DUIAdapter.this.plotter.popGraphFromHistory();
                    Plot1DUIAdapter.this.plotter.refresh(true);
                }
            }
        };
        this.removeFromHistory.setText("Remove last line from history");
        this.removeFromHistory.setToolTipText("Remove the last line from the plot history");
        this.removeFromHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_remove.png"));
        this.zoomAction = new Action(){

            public void run() {
                Plot1DUIAdapter.this.plotter.undoZoom();
            }
        };
        this.zoomAction.setText("Undo zoom");
        this.zoomAction.setToolTipText("Undo a zoom level");
        this.zoomAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/minify.png"));
        this.resetZoomAction = new Action(){

            public void run() {
                Plot1DUIAdapter.this.plotter.resetZoom();
            }
        };
        this.resetZoomAction.setText("Reset zoom");
        this.resetZoomAction.setToolTipText("Reset to no zoom");
        this.resetZoomAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/magifier_zoom_reset.png"));
        this.changeColour = new Action(){

            public void run() {
                PlotAppearanceDialog plotAppearanceDialog = new PlotAppearanceDialog(Plot1DUIAdapter.this.parent.getShell(), Plot1DUIAdapter.this.plotter.getColourTable());
                boolean bl = plotAppearanceDialog.open();
                if (bl) {
                    Plot1DUIAdapter.this.plotter.updateAllAppearance();
                    Plot1DUIAdapter.this.plotter.refresh(true);
                    Plot1DUIAdapter.this.updatePrefFromAppearance(Plot1DUIAdapter.this.plotter.getColourTable());
                }
            }
        };
        this.changeColour.setText("Change Plot appearance");
        this.changeColour.setToolTipText("Change the appearance of a plot");
        this.changeColour.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/color_wheel.png"));
        this.activateRegionZoom = new Action("", 2){

            public void run() {
                Plot1DUIAdapter.this.activateAreaZoom.setChecked(false);
                Plot1DUIAdapter.this.plotter.setZoomEnabled(Plot1DUIAdapter.this.activateRegionZoom.isChecked());
                Plot1DUIAdapter.this.plotter.setZoomMode(false);
                Plot1DUIAdapter.this.plotter.setPlotUpdateOperation(Plot1DUIAdapter.this.activateRegionZoom.isChecked());
            }
        };
        this.activateRegionZoom.setText("Region Zoom");
        this.activateRegionZoom.setToolTipText("Region zoom mode");
        this.activateRegionZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/magnify.png"));
        this.activateAreaZoom = new Action("", 2){

            public void run() {
                Plot1DUIAdapter.this.activateRegionZoom.setChecked(false);
                Plot1DUIAdapter.this.plotter.setZoomEnabled(Plot1DUIAdapter.this.activateAreaZoom.isChecked());
                Plot1DUIAdapter.this.plotter.setZoomMode(true);
                Plot1DUIAdapter.this.plotter.setPlotUpdateOperation(Plot1DUIAdapter.this.activateAreaZoom.isChecked());
            }
        };
        this.activateAreaZoom.setText("Area Zoom");
        this.activateAreaZoom.setToolTipText("Area zoom mode");
        this.activateAreaZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/zoom_in.png"));
        this.displayPlotPos = new Action("", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.setPlotActionEnabled(Plot1DUIAdapter.this.displayPlotPos.isChecked());
            }
        };
        this.displayPlotPos.setText("Display graph position");
        this.displayPlotPos.setToolTipText("Display the position on the graph");
        this.displayPlotPos.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/Cross-Hairs.png"));
        this.activateXgrid = new Action("", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.setTickGridLines(Plot1DUIAdapter.this.activateXgrid.isChecked(), Plot1DUIAdapter.this.activateYgrid.isChecked(), false);
                Plot1DUIAdapter.this.plotter.refresh(false);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.xGridLinePref, !Plot1DUIAdapter.this.activateXgrid.isChecked());
            }
        };
        this.activateXgrid.setChecked(true);
        this.activateXgrid.setText("X grid lines ON/OFF");
        this.activateXgrid.setToolTipText("Toggle x axis grid lines on/off");
        this.activateXgrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify_rot.png"));
        this.activateYgrid = new Action("", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.setTickGridLines(Plot1DUIAdapter.this.activateXgrid.isChecked(), Plot1DUIAdapter.this.activateYgrid.isChecked(), false);
                Plot1DUIAdapter.this.plotter.refresh(false);
                AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(Plot1DUIAdapter.this.yGridLinePref, !Plot1DUIAdapter.this.activateYgrid.isChecked());
            }
        };
        this.activateYgrid.setChecked(true);
        this.activateYgrid.setText("Y grid lines ON/OFF");
        this.activateYgrid.setToolTipText("Toggle y axis grid lines on/off");
        this.activateYgrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(Plot1DUIAdapter.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                Plot1DUIAdapter.this.plotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                Plot1DUIAdapter.this.plotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                Plot1DUIAdapter.this.plotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        this.rightClickOnGraphAction = new Action("Activate right click action.\nWith this action enabled you can right click on the graph to show the data within the current zoom area.\n\nPlease click precisely on the data you require.", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.setPlotRightClickActionEnabled(Plot1DUIAdapter.this.rightClickOnGraphAction.isChecked());
                if (Plot1DUIAdapter.this.rightClickOnGraphAction.isChecked()) {
                    Plot1DUIAdapter.this.displayPlotPos.setChecked(false);
                    Plot1DUIAdapter.this.plotter.setPlotActionEnabled(false);
                }
            }
        };
        this.rightClickOnGraphAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/Data-Analyse.png"));
        this.toggleXAxisErrorBars = new Action("Toggle x-Axis Error Bars", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.toggleErrorBars(Plot1DUIAdapter.this.toggleXAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleYAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleZAxisErrorBars.isChecked());
            }
        };
        this.toggleXAxisErrorBars.setChecked(true);
        this.toggleXAxisErrorBars.setText("Toggle x-Axis Error Bars");
        this.toggleXAxisErrorBars.setToolTipText("Toggle x-Axis Error Bars");
        this.toggleYAxisErrorBars = new Action("Toggle y-Axis Error Bars", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.toggleErrorBars(Plot1DUIAdapter.this.toggleXAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleYAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleZAxisErrorBars.isChecked());
            }
        };
        this.toggleYAxisErrorBars.setChecked(true);
        this.toggleYAxisErrorBars.setText("Toggle y-Axis Error Bars");
        this.toggleYAxisErrorBars.setToolTipText("Toggle y-Axis Error Bars");
        this.toggleZAxisErrorBars = new Action("Toggle z-Axis Error Bars", 2){

            public void run() {
                Plot1DUIAdapter.this.plotter.toggleErrorBars(Plot1DUIAdapter.this.toggleXAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleYAxisErrorBars.isChecked(), Plot1DUIAdapter.this.toggleZAxisErrorBars.isChecked());
            }
        };
        this.toggleYAxisErrorBars.setChecked(true);
        this.toggleZAxisErrorBars.setText("Toggle z-Axis Error Bars");
        this.toggleZAxisErrorBars.setToolTipText("Toggle z-Axis Error Bars");
    }

    public void addZoomListener(IPropertyChangeListener iPropertyChangeListener) {
        this.activateAreaZoom.addPropertyChangeListener(iPropertyChangeListener);
        this.activateRegionZoom.addPropertyChangeListener(iPropertyChangeListener);
    }

    public void removeZoomListener(IPropertyChangeListener iPropertyChangeListener) {
        this.activateAreaZoom.removePropertyChangeListener(iPropertyChangeListener);
        this.activateRegionZoom.removePropertyChangeListener(iPropertyChangeListener);
    }

    public void addPositionSwitchListener(IPropertyChangeListener iPropertyChangeListener) {
        this.displayPlotPos.addPropertyChangeListener(iPropertyChangeListener);
    }

    public void removePositionSwitchListener(IPropertyChangeListener iPropertyChangeListener) {
        this.displayPlotPos.removePropertyChangeListener(iPropertyChangeListener);
    }

    protected void notifyObservers() {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, null);
        }
    }

    @Override
    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    @Override
    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    @Override
    public void deleteIObservers() {
        this.observers.removeAll(this.observers);
    }

    public void addPlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        if (this.plotListeners == null) {
            this.plotListeners = new LinkedHashSet<PlotActionEventListener>(3);
        }
        this.plotListeners.add(plotActionEventListener);
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
        if (this.plotListeners != null) {
            for (PlotActionEventListener plotActionEventListener : this.plotListeners) {
                plotActionEventListener.plotActionPerformed(plotActionEvent);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.plotListeners != null) {
            this.plotListeners.clear();
        }
        this.plotListeners = null;
    }

    private String convertColourToString(Color color) {
        return color.getRed() + ";" + color.getGreen() + ";" + color.getBlue();
    }

    private Color convertStringToColour(String string) {
        String[] stringArray = string.split(";");
        try {
            return new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    private void updatePrefFromAppearance(Plot1DGraphTable plot1DGraphTable) {
        AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(this.numAppsPref, plot1DGraphTable.getLegendSize());
        int n = 0;
        while (n < plot1DGraphTable.getLegendSize()) {
            Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n);
            String string = String.valueOf(this.viewName) + ".app.Colour" + n;
            String string2 = String.valueOf(this.viewName) + ".app.LineWidth" + n;
            String string3 = String.valueOf(this.viewName) + ".app.Style" + n;
            AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(string, this.convertColourToString(plot1DAppearance.getColour()));
            AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(string2, plot1DAppearance.getLineWidth());
            int n2 = 0;
            switch (plot1DAppearance.getStyle()) {
                case SOLID: {
                    n2 = 0;
                    break;
                }
                case DASHED: {
                    n2 = 1;
                    break;
                }
                case POINT: {
                    n2 = 2;
                    break;
                }
                case SOLID_POINT: {
                    n2 = 3;
                    break;
                }
                case DASHED_POINT: {
                    n2 = 4;
                }
            }
            AnalysisRCPActivator.getDefault().getPreferenceStore().setValue(string3, n2);
            ++n;
        }
    }

    private void updateAppearanceFromPref(int n) {
        int n2 = 0;
        while (n2 < n) {
            String string = String.valueOf(this.viewName) + ".app.Colour" + n2;
            String string2 = String.valueOf(this.viewName) + ".app.LineWidth" + n2;
            String string3 = String.valueOf(this.viewName) + ".app.Style" + n2;
            String string4 = AnalysisRCPActivator.getDefault().getPreferenceStore().getString(string);
            int n3 = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt(string2);
            int n4 = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt(string3);
            Plot1DStyles plot1DStyles = Plot1DStyles.SOLID;
            switch (n4) {
                case 1: {
                    plot1DStyles = Plot1DStyles.DASHED;
                    break;
                }
                case 2: {
                    plot1DStyles = Plot1DStyles.POINT;
                    break;
                }
                case 3: {
                    plot1DStyles = Plot1DStyles.SOLID_POINT;
                    break;
                }
                case 4: {
                    plot1DStyles = Plot1DStyles.DASHED_POINT;
                    break;
                }
                default: {
                    plot1DStyles = Plot1DStyles.SOLID;
                }
            }
            PlotColorUtility.setDefaultColour(n2, this.convertStringToColour(string4));
            PlotColorUtility.setDefaultStyle(n2, plot1DStyles);
            PlotColorUtility.setDefaultLineWidth(n2, n3);
            ++n2;
        }
    }

    protected void readAndSetPreferences() {
        this.xAxisModePref = String.valueOf(this.viewName) + ".xAxisLabelMode";
        this.yAxisModePref = String.valueOf(this.viewName) + ".yAxisLabelMode";
        this.numAppsPref = String.valueOf(this.viewName) + ".numAppearance";
        this.xGridLinePref = String.valueOf(this.viewName) + ".showXgrid";
        this.yGridLinePref = String.valueOf(this.viewName) + ".showYgrid";
        int n = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt(this.xAxisModePref);
        int n2 = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt(this.yAxisModePref);
        int n3 = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt(this.numAppsPref);
        boolean bl = !AnalysisRCPActivator.getDefault().getPreferenceStore().getBoolean(this.xGridLinePref);
        boolean bl2 = !AnalysisRCPActivator.getDefault().getPreferenceStore().getBoolean(this.yGridLinePref);
        switch (n) {
            case 0: {
                this.plotter.setXTickLabelFormat(TickFormatting.plainMode);
                this.xLabelTypeFloat.setChecked(true);
                break;
            }
            case 1: {
                this.plotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                this.xLabelTypeRound.setChecked(true);
                break;
            }
            case 2: {
                this.plotter.setXTickLabelFormat(TickFormatting.useExponent);
                this.xLabelTypeExponent.setChecked(true);
                break;
            }
            case 3: {
                this.plotter.setXTickLabelFormat(TickFormatting.useSIunits);
                this.xLabelTypeSI.setChecked(true);
                break;
            }
            default: {
                this.plotter.setXTickLabelFormat(TickFormatting.plainMode);
                this.xLabelTypeFloat.setChecked(true);
            }
        }
        switch (n2) {
            case 0: {
                this.plotter.setYTickLabelFormat(TickFormatting.plainMode);
                this.yLabelTypeFloat.setChecked(true);
                break;
            }
            case 1: {
                this.plotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                this.yLabelTypeRound.setChecked(true);
                break;
            }
            case 2: {
                this.plotter.setYTickLabelFormat(TickFormatting.useExponent);
                this.yLabelTypeExponent.setChecked(true);
                break;
            }
            case 3: {
                this.plotter.setYTickLabelFormat(TickFormatting.useSIunits);
                this.yLabelTypeSI.setChecked(true);
                break;
            }
            default: {
                this.plotter.setYTickLabelFormat(TickFormatting.plainMode);
                this.yLabelTypeFloat.setChecked(true);
            }
        }
        this.plotter.setTickGridLines(bl, bl2, false);
        this.activateXgrid.setChecked(bl);
        this.activateYgrid.setChecked(bl2);
        this.updateAppearanceFromPref(n3);
    }
}

