/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.awt.Color;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotAppearanceDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;

public class Plot1DStackUI
extends AbstractPlotUI {
    private IWorkbenchPage page;
    private AxisValues xAxis = null;
    private AxisValues zAxis = null;
    private DataSetPlotter mainPlotter;
    private Composite parent;
    private Action xLabelTypeRound;
    private Action xLabelTypeFloat;
    private Action xLabelTypeExponent;
    private Action xLabelTypeSI;
    private Action zoomAction;
    private Action activateRegionZoom;
    private Action activateAreaZoom;
    private Action changeColour;
    private Action colourLegend;
    private Action tooglePerspectiveAction;
    private Action resetView;
    private Action boundingBox;
    private PlotWindow plotWindow;
    private boolean setInitialPersp = false;

    public Plot1DStackUI(PlotWindow plotWindow, IActionBars iActionBars, DataSetPlotter dataSetPlotter, Composite composite, IWorkbenchPage iWorkbenchPage) {
        this.parent = composite;
        this.page = iWorkbenchPage;
        this.plotWindow = plotWindow;
        this.xAxis = new AxisValues();
        this.zAxis = new AxisValues();
        this.mainPlotter = dataSetPlotter;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell(), dataSetPlotter.getColourTable());
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.setInitialPersp = false;
    }

    @Override
    public void disposeOverlays() {
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        List list = dataBean.getData();
        if (list != null) {
            Object object;
            AbstractDataset abstractDataset;
            boolean bl2 = false;
            Iterator iterator = list.iterator();
            List<AbstractDataset> list2 = Collections.synchronizedList(new LinkedList());
            this.xAxis.clear();
            AxisMode axisMode = AxisMode.LINEAR;
            AxisMode axisMode2 = AxisMode.LINEAR;
            AbstractDataset abstractDataset2 = dataBean.getAxis("x-axis");
            if (abstractDataset2 != null) {
                if (abstractDataset2.getName() != null && abstractDataset2.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(abstractDataset2.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                axisMode = AxisMode.CUSTOM;
                this.xAxis.setValues(abstractDataset2);
                this.mainPlotter.setXAxisValues(this.xAxis, list.size());
            } else {
                abstractDataset = dataBean.getAxis("x-axis0");
                this.mainPlotter.setXAxisLabel("X-Axis");
                if (abstractDataset != null) {
                    axisMode = AxisMode.CUSTOM;
                    bl2 = true;
                }
            }
            this.mainPlotter.setYAxisLabel("Y-Axis");
            abstractDataset = dataBean.getAxis("z-axis");
            if (abstractDataset != null) {
                if (abstractDataset.getName() != null && abstractDataset.getName().length() > 0) {
                    this.mainPlotter.setZAxisLabel(abstractDataset.getName());
                } else {
                    this.mainPlotter.setZAxisLabel("Z-Axis");
                }
                this.zAxis.clear();
                axisMode2 = AxisMode.CUSTOM;
                this.zAxis.setValues(abstractDataset);
                this.mainPlotter.setZAxisValues(this.zAxis);
            } else {
                this.mainPlotter.setZAxisLabel("Z-Axis");
                this.mainPlotter.setZAxisValues(null);
            }
            this.mainPlotter.setAxisModes(axisMode, AxisMode.LINEAR, axisMode2);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.plainMode);
            this.mainPlotter.setYTickLabelFormat(TickFormatting.plainMode);
            this.mainPlotter.setZTickLabelFormat(TickFormatting.plainMode);
            Plot1DGraphTable plot1DGraphTable = this.mainPlotter.getColourTable();
            plot1DGraphTable.clearLegend();
            int n = 0;
            LinkedList<AxisValues> linkedList = null;
            if (bl2) {
                linkedList = new LinkedList<AxisValues>();
            }
            while (iterator.hasNext()) {
                Object object2;
                object = (DataSetWithAxisInformation)iterator.next();
                AbstractDataset abstractDataset3 = object.getData();
                if (bl2) {
                    object2 = "x-axis" + n;
                    AbstractDataset abstractDataset4 = dataBean.getAxis((String)object2);
                    if (abstractDataset4 != null) {
                        AxisValues axisValues = new AxisValues(abstractDataset4);
                        linkedList.add(axisValues);
                    }
                    ++n;
                }
                object2 = new Plot1DAppearance(this.colourLegend.isChecked() ? PlotColorUtility.getDefaultColour(plot1DGraphTable.getLegendSize()) : Color.BLACK, Plot1DStyles.SOLID, abstractDataset3.getName());
                plot1DGraphTable.addEntryOnLegend((Plot1DAppearance)object2);
                list2.add(abstractDataset3);
            }
            this.mainPlotter.setPlotUpdateOperation(bl);
            if (bl2) {
                try {
                    this.mainPlotter.replaceAllPlots(list2, linkedList);
                }
                catch (PlotException plotException) {
                    plotException.printStackTrace();
                }
            } else {
                try {
                    this.mainPlotter.replaceAllPlots(list2);
                }
                catch (PlotException plotException) {}
            }
            object = this.page.getActivePart().getTitle();
            if (!((String)object).equals("Dataset Inspector") && !((String)object).equals("Dataset Plot")) {
                this.mainPlotter.setTitle((String)object);
            }
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!Plot1DStackUI.this.setInitialPersp) {
                        Plot1DStackUI.this.mainPlotter.setPerspectiveCamera(Plot1DStackUI.this.getCameraPerspectiveChoice() == 1, false);
                        Plot1DStackUI.this.setInitialPersp = true;
                    }
                    Plot1DStackUI.this.mainPlotter.refresh(true);
                    Plot1DStackUI.this.mainPlotter.updateAllAppearance();
                    Plot1DStackUI.this.plotWindow.notifyUpdateFinished();
                }
            });
        }
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell, final Plot1DGraphTable plot1DGraphTable) {
        this.zoomAction = new Action(){

            public void run() {
                dataSetPlotter.undoZoom();
            }
        };
        this.zoomAction.setText("Undo zoom");
        this.zoomAction.setToolTipText("Undo a zoom level");
        this.zoomAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/minify.png"));
        this.colourLegend = new Action("", 2){

            public void run() {
                Plot1DGraphTable plot1DGraphTable = dataSetPlotter.getColourTable();
                int n = 0;
                while (n < plot1DGraphTable.getLegendSize()) {
                    Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n);
                    plot1DAppearance.setColour(Plot1DStackUI.this.colourLegend.isChecked() ? PlotColorUtility.getDefaultColour(n) : Color.BLACK);
                    ++n;
                }
                dataSetPlotter.updateAllAppearance();
                dataSetPlotter.refresh(true);
            }
        };
        this.colourLegend.setText("Use colours");
        this.colourLegend.setToolTipText("Switch between monochrome and colour");
        this.colourLegend.setChecked(true);
        this.colourLegend.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/rainbow.png"));
        this.changeColour = new Action(){

            public void run() {
                PlotAppearanceDialog plotAppearanceDialog = new PlotAppearanceDialog(shell, plot1DGraphTable);
                boolean bl = plotAppearanceDialog.open();
                if (bl) {
                    dataSetPlotter.updateAllAppearance();
                    dataSetPlotter.refresh(true);
                }
            }
        };
        this.changeColour.setText("Change Plot appearance");
        this.changeColour.setToolTipText("Change the appearance of a plot");
        this.changeColour.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/color_wheel.png"));
        this.activateRegionZoom = new Action("", 2){

            public void run() {
                Plot1DStackUI.this.activateAreaZoom.setChecked(false);
                dataSetPlotter.setZoomEnabled(Plot1DStackUI.this.activateRegionZoom.isChecked());
                dataSetPlotter.setZoomMode(false);
            }
        };
        this.activateRegionZoom.setText("Region Zoom");
        this.activateRegionZoom.setToolTipText("Region zoom mode");
        this.activateRegionZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/magnify.png"));
        this.activateAreaZoom = new Action("", 2){

            public void run() {
                Plot1DStackUI.this.activateRegionZoom.setChecked(false);
                dataSetPlotter.setZoomEnabled(Plot1DStackUI.this.activateAreaZoom.isChecked());
                dataSetPlotter.setZoomMode(true);
            }
        };
        this.activateAreaZoom.setText("Area Zoom");
        this.activateAreaZoom.setToolTipText("Area zoom mode");
        this.activateAreaZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/zoom_in.png"));
        this.tooglePerspectiveAction = new Action("", 2){

            public void run() {
                dataSetPlotter.setPerspectiveCamera(Plot1DStackUI.this.tooglePerspectiveAction.isChecked(), true);
            }
        };
        this.tooglePerspectiveAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/camera_add.png"));
        this.tooglePerspectiveAction.setText("Switch Ortho/Persp");
        this.tooglePerspectiveAction.setToolTipText("Switch between orthographic and perspective view");
        this.tooglePerspectiveAction.setChecked(this.getCameraPerspectiveChoice() == 1);
        this.resetView = new Action(){

            public void run() {
                Plot1DStackUI.this.mainPlotter.resetView();
                Plot1DStackUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.boundingBox = new Action("", 2){

            public void run() {
                dataSetPlotter.enableBoundingBox(Plot1DStackUI.this.boundingBox.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.boundingBox.setText("Bounding box on/off");
        this.boundingBox.setToolTipText("Bounding box on/off");
        this.boundingBox.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/box.png"));
        this.boundingBox.setChecked(true);
        iToolBarManager.add((IAction)this.activateRegionZoom);
        iToolBarManager.add((IAction)this.activateAreaZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.colourLegend);
        iToolBarManager.add((IAction)this.changeColour);
        iToolBarManager.add((IAction)this.tooglePerspectiveAction);
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.boundingBox);
        iToolBarManager.update(true);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.xLabelTypeRound = new Action(){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeFloat = new Action(){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action(){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action(){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        iMenuManager.add((IAction)this.xLabelTypeRound);
        iMenuManager.add((IAction)this.xLabelTypeFloat);
        iMenuManager.add((IAction)this.xLabelTypeExponent);
        iMenuManager.add((IAction)this.xLabelTypeSI);
    }

    private int getCameraPerspectiveChoice() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("plotView.multi1Dcamera") ? iPreferenceStore.getDefaultInt("plotView.multi1Dcamera") : iPreferenceStore.getInt("plotView.multi1Dcamera");
    }
}

