/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import java.awt.Color;
import java.io.Serializable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.TableCanvas;

public class Plot1DAppearance
implements Serializable {
    private Color plotColour;
    private Plot1DStyles plotStyle;
    private int lineWidth;
    private String plotName;
    private boolean visible;

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, int n, String string, boolean bl) {
        this.plotColour = color;
        this.plotStyle = plot1DStyles;
        this.lineWidth = n;
        this.plotName = string;
        this.visible = bl;
    }

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, int n, String string) {
        this(color, plot1DStyles, n, string, true);
    }

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, String string) {
        this(color, plot1DStyles, 2, string, true);
    }

    public Plot1DAppearance(Color color, String string) {
        this(color, Plot1DStyles.SOLID, 1, string, true);
    }

    public Color getColour() {
        return this.plotColour;
    }

    public void setColour(Color color) {
        this.plotColour = color;
    }

    public Plot1DStyles getStyle() {
        return this.plotStyle;
    }

    public void setStyle(Plot1DStyles plot1DStyles) {
        this.plotStyle = plot1DStyles;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public String getName() {
        return this.plotName;
    }

    public void setName(String string) {
        this.plotName = string;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void updateGraph(DefaultLineShader defaultLineShader, DefaultGeometryShader defaultGeometryShader) {
        defaultLineShader.setDiffuseColor(this.plotColour);
        defaultLineShader.setLineWidth(Double.valueOf(this.lineWidth));
        switch (this.plotStyle) {
            case SOLID: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
                break;
            }
            case DASHED: {
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
                defaultLineShader.setLineStipple(Boolean.valueOf(true));
                break;
            }
            case POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(false));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                defaultPointShader.setPointSize(Double.valueOf(this.lineWidth));
                break;
            }
            case SOLID_POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                double d = (double)this.lineWidth * 4.0;
                if (d < 4.0) {
                    d = 4.0;
                }
                defaultPointShader.setPointSize(Double.valueOf(d));
                break;
            }
            case DASHED_POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(true));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                double d = (double)this.lineWidth * 4.0;
                if (d < 4.0) {
                    d = 4.0;
                }
                defaultPointShader.setPointSize(Double.valueOf(d));
            }
        }
    }

    public void updateGraph(DefaultPointShader defaultPointShader) {
        defaultPointShader.setDiffuseColor(this.plotColour);
    }

    public void updateCanvas(TableCanvas tableCanvas) {
        RGB rGB = new RGB(this.plotColour.getRed(), this.plotColour.getGreen(), this.plotColour.getBlue());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)tableCanvas.getDisplay(), rGB);
        tableCanvas.setStyle(this.plotStyle);
        tableCanvas.setColour(color);
    }

    public void drawApp(int n, int n2, GC gC, Display display, boolean bl) {
        RGB rGB = new RGB(this.plotColour.getRed(), this.plotColour.getGreen(), this.plotColour.getBlue());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)display, rGB);
        gC.setBackground(color);
        switch (this.plotStyle) {
            case SOLID: 
            case SOLID_POINT: {
                if (bl) {
                    gC.fillRectangle(n, n2, 2, 30);
                    break;
                }
                gC.fillRectangle(n, n2, 30, 2);
                break;
            }
            case DASHED: 
            case DASHED_POINT: {
                int n3 = 3;
                int n4 = 0;
                while (n4 < 4) {
                    if (bl) {
                        gC.fillRectangle(n, n2 + n4 * 2 * n3, 2, n3);
                    } else {
                        gC.fillRectangle(n + n4 * 2 * n3, n2, n3, 2);
                    }
                    ++n4;
                }
                break;
            }
            case POINT: {
                int n3 = 3;
                int n5 = 0;
                while (n5 < 4) {
                    if (bl) {
                        gC.fillOval(n, n2 + n5 * 2 * n3, n3 >> 1, n3 >> 1);
                    } else {
                        gC.fillOval(n + n5 * 2 * n3, n2, n3 >> 1, n3 >> 1);
                    }
                    ++n5;
                }
                break;
            }
        }
        if (bl) {
            gC.setAdvanced(true);
            color.dispose();
            Transform transform = new Transform((Device)display);
            transform.rotate(90.0f);
            transform.translate((float)(n2 + 35), (float)(-n - 10));
            gC.setTransform(transform);
            gC.setBackground(display.getSystemColor(1));
            gC.drawText(this.plotName.substring(0, Math.min(15, this.plotName.length())), 0, 0);
            transform.translate((float)(-n2 - 35), (float)(n + 10));
            transform.rotate(-90.0f);
            gC.setTransform(transform);
            transform.dispose();
        } else {
            gC.setBackground(display.getSystemColor(1));
            gC.drawText(this.plotName.substring(0, Math.min(15, this.plotName.length())), n + 35, n2 - 10);
        }
    }

    public void drawApp(int n, int n2, GC gC, Display display, boolean bl, int n3) {
        RGB rGB = new RGB(this.plotColour.getRed(), this.plotColour.getGreen(), this.plotColour.getBlue());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)display, rGB);
        gC.setBackground(color);
        switch (this.plotStyle) {
            case SOLID: 
            case SOLID_POINT: {
                if (bl) {
                    gC.fillRectangle(n, n2, 2 * n3, 30 * n3);
                    break;
                }
                gC.fillRectangle(n, n2, 30 * n3, 2 * n3);
                break;
            }
            case DASHED: 
            case DASHED_POINT: {
                int n4 = 3;
                int n5 = 0;
                while (n5 < 4) {
                    if (bl) {
                        gC.fillRectangle(n, n2 + n5 * 2 * n4, 2 * n3, n4 * n3);
                    } else {
                        gC.fillRectangle(n + n5 * 2 * n4, n2, n4 * n3, 2 * n3);
                    }
                    ++n5;
                }
                break;
            }
            case POINT: {
                int n4 = 3;
                int n6 = 0;
                while (n6 < 4) {
                    if (bl) {
                        gC.fillOval(n, n2 + n6 * 2 * n4, (n4 >> 1) * n3, (n4 >> 1) * n3);
                    } else {
                        gC.fillOval(n + n6 * 2 * n4, n2, (n4 >> 1) * n3, (n4 >> 1) * n3);
                    }
                    ++n6;
                }
                break;
            }
        }
        if (bl) {
            gC.setAdvanced(true);
            color.dispose();
            Transform transform = new Transform((Device)display);
            transform.rotate(90.0f);
            transform.translate((float)(n2 + 35), (float)(-n - 75));
            transform.scale((float)n3, (float)n3);
            gC.setTransform(transform);
            gC.setBackground(display.getSystemColor(1));
            gC.drawText(this.plotName.substring(0, Math.min(15, this.plotName.length())), 0, 0);
            transform.translate((float)(-n2 - 35), (float)(n + 10));
            transform.rotate(-90.0f);
            gC.setTransform(transform);
            transform.dispose();
        } else {
            gC.setAdvanced(true);
            color.dispose();
            Transform transform = new Transform((Device)display);
            transform.translate((float)(n + 75), (float)(n2 - 25));
            transform.scale((float)n3, (float)n3);
            gC.setTransform(transform);
            gC.setBackground(display.getSystemColor(1));
            gC.drawText(this.plotName.substring(0, Math.min(15, this.plotName.length())), 0, 0);
            gC.setTransform(transform);
            transform.dispose();
        }
    }
}

