/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import javax.vecmath.Vector3d;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;

public class InfoBoxComponent
extends Composite {
    private Table tblInfo;
    private TableItem item;
    private boolean isDiffractionImg;

    InfoBoxComponent(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new FillLayout());
        this.tblInfo = new Table((Composite)this, 0x20000000);
        this.tblInfo.setHeaderVisible(true);
        this.tblInfo.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("X position");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("Y position");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(80);
        tableColumn.setText("Data value");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("q X (1/\u00c5)");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("q Y (1/\u00c5)");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("q Z (1/\u00c5)");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("2\u03b8 (\u00b0)");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(95);
        tableColumn.setText("Resolution (\u00c5)");
        tableColumn = new TableColumn(this.tblInfo, 0);
        tableColumn.setWidth(82);
        tableColumn.setText("Dataset name");
        this.item = new TableItem(this.tblInfo, 0x20000000);
        this.item.setText(0, "----");
        this.item.setText(1, "----");
        this.item.setText(2, "----");
        this.item.setText(3, "----");
        this.item.setText(4, "----");
        this.item.setText(5, "----");
        this.item.setText(6, "----");
        this.item.setText(7, "----");
    }

    public void setPositionInfo(double d, double d2, double d3) {
        this.item.setText(0, String.format("%4.4f", d));
        this.item.setText(1, String.format("%4.4f", d2));
        this.item.setText(2, String.format("%4.4f", d3));
    }

    public void isDiffractionImage(boolean bl) {
        this.isDiffractionImg = bl;
        if (!this.isDiffractionImg) {
            this.tblInfo.getColumn(3).setWidth(0);
            this.tblInfo.getColumn(4).setWidth(0);
            this.tblInfo.getColumn(5).setWidth(0);
            this.tblInfo.getColumn(6).setWidth(0);
            this.tblInfo.getColumn(7).setWidth(0);
            this.tblInfo.redraw();
        } else {
            this.tblInfo.getColumn(3).setWidth(80);
            this.tblInfo.getColumn(4).setWidth(80);
            this.tblInfo.getColumn(5).setWidth(80);
            this.tblInfo.getColumn(6).setWidth(80);
            this.tblInfo.getColumn(7).setWidth(80);
            this.tblInfo.redraw();
        }
    }

    public void setQSpaceInfo(double d, double d2, QSpace qSpace) {
        Vector3d vector3d = qSpace.qFromPixelPosition(d, d2);
        this.item.setText(3, String.format("% 4.4f", vector3d.x));
        this.item.setText(4, String.format("% 4.4f", vector3d.y));
        this.item.setText(5, String.format("% 4.4f", vector3d.z));
        this.item.setText(6, String.format("% 3.3f", Math.toDegrees(qSpace.scatteringAngle(vector3d))));
        this.item.setText(7, String.format("% 4.4f", Math.PI * 2 / vector3d.length()));
    }

    public void setName(String string) {
        this.item.setText(8, string);
    }
}

