/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.PointSetFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import java.util.Iterator;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;

public class DataSetScatterPlot3D
extends DataSet3DPlot3D {
    private static final double MAXRADII = 64.0;
    private double dataMin;
    private double dataMax;
    private boolean uniformSize;

    public DataSetScatterPlot3D(AbstractViewerApp abstractViewerApp, boolean bl, boolean bl2) {
        super(abstractViewerApp, bl, bl2);
        this.xAxis = AxisMode.CUSTOM;
        this.yAxis = AxisMode.CUSTOM;
        this.zAxis = AxisMode.CUSTOM;
    }

    @Override
    protected void buildDisplayDataSet() {
        this.displayData = this.currentData;
    }

    @Override
    protected void setGlobalMinMax() {
        if (!this.useWindow || this.windowEndPosX == 0) {
            this.globalRealXmin = this.xAxisValues.getMinValue();
            this.globalRealXmax = this.xAxisValues.getMaxValue();
            this.globalRealYmin = this.yAxisValues.getMinValue();
            this.globalRealYmax = this.yAxisValues.getMaxValue();
            this.globalZmin = this.zAxisValues.getMinValue();
            this.globalZmax = this.zAxisValues.getMaxValue();
            this.dataMin = this.displayData.min().doubleValue();
            this.dataMax = this.displayData.max().doubleValue();
        }
    }

    @Override
    protected void determineGraphSize(int n, int n2) {
        this.xSpan = 15.0;
        this.ySpan = 15.0;
    }

    private PointSet createGraphGeometry() {
        this.determineGraphSize(1, 1);
        int n = this.xAxisValues.size();
        double[] dArray = new double[n * 3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n * 3];
        PointSetFactory pointSetFactory = new PointSetFactory();
        Iterator<Double> iterator = this.xAxisValues.iterator();
        Iterator<Double> iterator2 = this.yAxisValues.iterator();
        Iterator<Double> iterator3 = this.zAxisValues.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            double d = iterator.next();
            double d2 = iterator2.next();
            double d3 = iterator3.next();
            dArray[n2 * 3] = -this.xSpan * 0.5 + this.xSpan * (d - this.globalRealXmin) / (this.globalRealXmax - this.globalRealXmin);
            dArray[n2 * 3 + 1] = 15.0 * (d3 - this.globalZmin) / (this.globalZmax - this.globalZmin);
            dArray[n2 * 3 + 2] = -this.ySpan + this.ySpan * (d2 - this.globalRealYmin) / (this.globalRealYmax - this.globalRealYmin);
            double d4 = this.displayData.getDouble(new int[]{n2});
            dArray2[n2] = !this.uniformSize ? (this.dataMax > 64.0 ? 64.0 * d4 / this.dataMax : d4) : 3.0;
            if (this.colourTable == null) {
                dArray3[n2 * 3] = (d4 - this.dataMin) / Math.max(1.0, this.dataMax - this.dataMin);
                dArray3[n2 * 3 + 1] = 0.25;
                dArray3[n2 * 3 + 2] = 0.25;
            } else if (this.hasJOGL) {
                int n3 = (int)((double)this.colourTable.getWidth() * ((d4 - this.colourTableMin) / (this.colourTableMax - this.colourTableMin)));
                n3 = Math.min(Math.max(0, n3), this.colourTable.getWidth() - 1);
                int n4 = this.colourTable.get(n3);
                int n5 = n4 >> 16 & 0xFF;
                int n6 = n4 >> 8 & 0xFF;
                int n7 = n4 & 0xFF;
                dArray3[n2 * 3] = (double)n5 / 255.0;
                dArray3[n2 * 3 + 1] = (double)n6 / 255.0;
                dArray3[n2 * 3 + 2] = (double)n7 / 255.0;
            }
            ++n2;
        }
        pointSetFactory.setVertexCount(n);
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexColors(dArray3);
        pointSetFactory.setVertexRelativeRadii(dArray2);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    protected void updateDisplay(int n, int n2) {
        this.setGlobalMinMax();
        this.graph.setGeometry((Geometry)this.createGraphGeometry());
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        if (this.zLabelNode != null) {
            this.zLabelNode.setGeometry((Geometry)this.createZLabelsGeometry());
        }
        if (this.xTicksNode != null && this.xCoordActive) {
            this.xTicksNode.setGeometry((Geometry)this.createXAxisTicksGeometry());
        }
        if (this.yTicksNode != null && this.yCoordActive) {
            this.yTicksNode.setGeometry((Geometry)this.createYAxisTicksGeometry());
        }
        if (this.zTicksNode != null && this.zCoordActive) {
            this.zTicksNode.setGeometry((Geometry)this.createZAxisTicksGeometry());
        }
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            this.graph = sceneGraphComponent;
            this.currentData = list.get(0);
            this.buildDisplayDataSet();
            this.setGlobalMinMax();
            this.graphAppearance = new Appearance();
            sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry());
            sceneGraphComponent.setAppearance(this.graphAppearance);
            this.dgsGraph = ShaderUtility.createDefaultGeometryShader((Appearance)this.graphAppearance, (boolean)true);
            this.graphAppearance.setAttribute("vertexColors", true);
            this.graphAppearance.setAttribute("lightingEnabled", false);
            this.graphAppearance.setAttribute("lineShader.tubeDraw", false);
            this.graphAppearance.setAttribute("pointShader.spheresDraw", false);
            this.graphAppearance.setAttribute("pointShader.pointSize", 8.0);
            this.graphAppearance.setAttribute("attenuatePointSize", false);
            this.graphAppearance.setAttribute("transparencyEnabled", false);
            this.graphAppearance.setAttribute("transparency", 0.5f);
            this.graphAppearance.setAttribute("zBufferEnabled", true);
            this.dgsGraph.setShowFaces(Boolean.valueOf(false));
            this.dgsGraph.setShowLines(Boolean.valueOf(false));
            this.dgsGraph.setShowPoints(Boolean.valueOf(true));
            DefaultPointShader defaultPointShader = (DefaultPointShader)this.dgsGraph.createPointShader("default");
            defaultPointShader.setPointSize(Double.valueOf(1.0));
            this.buildOtherNodes();
        }
        return sceneGraphComponent;
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        if (sceneGraphComponent != null) {
            this.colourTable = colourImageData;
            this.colourTableMin = d;
            this.colourTableMax = d2;
            if (sceneGraphComponent.getGeometry() != null) {
                PointSet pointSet = (PointSet)sceneGraphComponent.getGeometry();
                double[] dArray = new double[this.displayData.getSize() * 3];
                int n = 0;
                while (n < this.displayData.getSize()) {
                    double d3 = this.displayData.getDouble(new int[]{n});
                    int n2 = (int)((double)colourImageData.getWidth() * ((d3 - d) / (d2 - d)));
                    n2 = Math.min(Math.max(0, n2), colourImageData.getWidth() - 1);
                    int n3 = colourImageData.get(n2);
                    int n4 = n3 >> 16 & 0xFF;
                    int n5 = n3 >> 8 & 0xFF;
                    int n6 = n3 & 0xFF;
                    dArray[n * 3] = (double)n4 / 255.0;
                    dArray[n * 3 + 1] = (double)n5 / 255.0;
                    dArray[n * 3 + 2] = (double)n6 / 255.0;
                    ++n;
                }
                pointSet.setVertexAttributes(Attribute.COLORS, (DataList)new DoubleArrayArray.Inlined(dArray, 3));
            }
        }
    }

    public void setTransparency(boolean bl) {
        this.graphAppearance.setAttribute("transparencyEnabled", bl);
        this.graphAppearance.setAttribute("zBufferEnabled", !bl);
    }

    public void setDrawOutlinesOnly(boolean bl) {
        this.graphAppearance.setAttribute("sourceAlphaBlendOnly", bl);
    }

    public void setUniformSize(boolean bl) {
        this.uniformSize = bl;
        this.graph.setGeometry((Geometry)this.createGraphGeometry());
    }
}

