/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.PointSetFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.errors.ErrorHelpers;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SelectedWindow;

public class DataSetScatterPlot2D
extends DataSet3DPlot1D {
    private List<AxisValues> yAxes = Collections.synchronizedList(new LinkedList());
    private LinkedList<DefaultPointShader> graphPointShaders;
    private double dataMin;
    private double dataMax;
    private static final double MAXRADII = 64.0;
    SceneGraphComponent xErrors;
    SceneGraphComponent yErrors;

    public DataSetScatterPlot2D(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, Plot1DGraphTable plot1DGraphTable, boolean bl) {
        super(abstractViewerApp, composite, cursor, plot1DGraphTable, bl);
        this.xAxis = AxisMode.CUSTOM;
        this.yAxis = AxisMode.CUSTOM;
        this.graphPointShaders = new LinkedList();
    }

    @Override
    protected void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        Iterator iterator2 = this.xAxes.iterator();
        Iterator<AxisValues> iterator3 = this.yAxes.iterator();
        this.globalYmin = 3.4028234663852886E38;
        this.globalYmax = -3.4028234663852886E38;
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = -3.4028234663852886E38;
        this.dataMin = 3.4028234663852886E38;
        this.dataMax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            AxisValues axisValues = (AxisValues)iterator2.next();
            AxisValues axisValues2 = iterator3.next();
            this.globalRealXmin = Math.min(this.globalRealXmin, axisValues.getMinValue());
            this.globalXmax = this.globalRealXmax = Math.max(this.globalRealXmax, axisValues.getMaxValue());
            this.globalYmin = Math.min(this.globalYmin, axisValues2.getMinValue());
            this.globalYmax = Math.max(this.globalYmax, axisValues2.getMaxValue());
            this.dataMin = Math.min(iDataset.min().doubleValue(), this.dataMin);
            this.dataMax = Math.max(iDataset.max().doubleValue(), this.dataMax);
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
    }

    private PointSet createGraphGeometry(IDataset iDataset, AxisValues axisValues, AxisValues axisValues2) {
        int n = iDataset.getSize();
        PointSetFactory pointSetFactory = new PointSetFactory();
        double[] dArray = new double[n * 3];
        double[] dArray2 = new double[]{};
        if (this.dataMin != this.dataMax) {
            dArray2 = new double[n];
        }
        Iterator<Double> iterator = axisValues.iterator();
        Iterator<Double> iterator2 = axisValues2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            double d = iterator.next();
            double d2 = iterator2.next();
            dArray[n2 * 3] = (d - this.graphXmin) * (14.75 / (this.graphXmax - this.graphXmin));
            dArray[n2 * 3 + 1] = (d2 - this.graphYmin) * (14.75 / (this.graphYmax - this.graphYmin));
            dArray[n2 * 3 + 2] = 0.0;
            if (this.dataMin != this.dataMax) {
                dArray2[n2] = this.dataMax > 64.0 ? 64.0 * iDataset.getDouble(new int[]{n2}) / this.dataMax : iDataset.getDouble(new int[]{n2});
            }
            ++n2;
        }
        pointSetFactory.setVertexCount(n);
        if (this.dataMin != this.dataMax) {
            pointSetFactory.setVertexRelativeRadii(dArray2);
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            IDataset iDataset;
            this.graphGroupNode = SceneGraphUtility.createFullSceneGraphComponent((String)"groupNode");
            this.sets = list;
            this.graph = sceneGraphComponent;
            this.determineRanges(list);
            Iterator<IDataset> iterator = list.iterator();
            Iterator iterator2 = this.xAxes.iterator();
            Iterator<AxisValues> iterator3 = this.yAxes.iterator();
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.numGraphs = 0;
            while (iterator.hasNext()) {
                iDataset = iterator.next();
                SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
                this.subGraphs.add(sceneGraphComponent2);
                AxisValues axisValues = (AxisValues)iterator2.next();
                AxisValues axisValues2 = iterator3.next();
                sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues, axisValues2));
                Appearance appearance = new Appearance();
                sceneGraphComponent2.setAppearance(appearance);
                DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
                appearance.setAttribute("lineShader.tubeDraw", false);
                appearance.setAttribute("pointShader.spheresDraw", false);
                appearance.setAttribute("attenuatePointSize", false);
                appearance.setAttribute("lightingEnabled", false);
                defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(false));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                this.graphPointShaders.add(defaultPointShader);
                Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(plot1DAppearance.getColour());
                if (this.dataMin == this.dataMax) {
                    defaultPointShader.setPointSize(Double.valueOf(this.dataMin));
                } else {
                    defaultPointShader.setPointSize(Double.valueOf(1.0));
                }
                this.graphShaders.add(defaultGeometryShader);
                this.addErrorBarNodesToPointNode(axisValues, axisValues2, sceneGraphComponent2);
                this.graphGroupNode.addChild(sceneGraphComponent2);
                ++this.numGraphs;
            }
            this.buildClipPlanes(sceneGraphComponent);
            this.resizeAndPositionNodes();
            iDataset = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
            iDataset.setFieldOfView(56.5);
            if (this.background == null) {
                this.buildBackground();
                sceneGraphComponent.addChild(this.background);
                sceneGraphComponent.addTool((Tool)this.tool);
            }
            if (this.areaSelection == null) {
                this.buildAreaSelection();
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks != null) {
                this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            }
        }
        return sceneGraphComponent;
    }

    private void addErrorBarNodesToPointNode(AxisValues axisValues, AxisValues axisValues2, SceneGraphComponent sceneGraphComponent) {
        double[] dArray = ErrorHelpers.extractAndScale((IDataset)axisValues.toDataset(), this.graphXmin, 14.75, this.graphXmax);
        double[] dArray2 = ErrorHelpers.extractAndScale((IDataset)axisValues2.toDataset(), this.graphYmin, 14.75, this.graphYmax);
        double[] dArray3 = ErrorHelpers.constantPoints(0.0, axisValues.size());
        double[] dArray4 = ErrorHelpers.extractAndScaleError((IDataset)axisValues.toDataset(), this.graphXmin, 14.75, this.graphXmax);
        double[] dArray5 = new double[]{1.0, 0.0, 0.0};
        double[] dArray6 = new double[]{0.0, 1.0, 0.0};
        double d = 14.75 / ((double)axisValues.size() * 4.0);
        double[] dArray7 = ErrorHelpers.extractAndScaleError((IDataset)axisValues2.toDataset(), this.graphYmin, 14.75, this.graphYmax);
        double[] dArray8 = new double[]{0.0, 1.0, 0.0};
        double[] dArray9 = new double[]{1.0, 0.0, 0.0};
        this.xErrors = ErrorHelpers.createErrorNode(dArray, dArray2, dArray3, dArray4, d, dArray5, dArray6);
        this.yErrors = ErrorHelpers.createErrorNode(dArray, dArray2, dArray3, dArray7, d, dArray8, dArray9);
        sceneGraphComponent.addChild(this.xErrors);
        sceneGraphComponent.addChild(this.yErrors);
    }

    private void updateErrorBarNodesToPointNode(AxisValues axisValues, AxisValues axisValues2) {
        double[] dArray = ErrorHelpers.extractAndScale((IDataset)axisValues.toDataset(), this.graphXmin, 14.75, this.graphXmax);
        double[] dArray2 = ErrorHelpers.extractAndScale((IDataset)axisValues2.toDataset(), this.graphYmin, 15.0, this.graphYmax);
        double[] dArray3 = ErrorHelpers.constantPoints(0.0, axisValues.size());
        double[] dArray4 = ErrorHelpers.extractAndScaleError((IDataset)axisValues.toDataset(), this.graphXmin, 14.75, this.graphXmax);
        double[] dArray5 = new double[]{1.0, 0.0, 0.0};
        double[] dArray6 = new double[]{0.0, 1.0, 0.0};
        double d = 14.75 / ((double)axisValues.size() * 4.0);
        double[] dArray7 = ErrorHelpers.extractAndScaleError((IDataset)axisValues2.toDataset(), this.graphYmin, 15.0, this.graphYmax);
        double[] dArray8 = new double[]{0.0, 1.0, 0.0};
        double[] dArray9 = new double[]{1.0, 0.0, 0.0};
        ErrorHelpers.updateErrorNode(this.xErrors, dArray, dArray2, dArray3, dArray4, d, dArray5, dArray6);
        ErrorHelpers.updateErrorNode(this.yErrors, dArray, dArray2, dArray3, dArray7, d, dArray8, dArray9);
    }

    public void addAxises(AxisValues axisValues, AxisValues axisValues2) {
        this.xAxes.add(axisValues);
        this.yAxes.add(axisValues2);
    }

    public void replaceAxises(List<AxisValues> list, List<AxisValues> list2) {
        this.xAxes.clear();
        this.yAxes.clear();
        this.xAxes.addAll(list);
        this.yAxes.addAll(list2);
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
        if (this.yAxes.size() > 0) {
            this.yAxes.set(0, axisValues);
        } else {
            this.yAxes.add(axisValues);
        }
    }

    @Override
    public void addGraphNode() {
        if (this.graph != null) {
            this.buildAdditionalGraphNode();
        }
    }

    @Override
    protected SceneGraphComponent buildAdditionalGraphNode() {
        SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
        this.subGraphs.add(sceneGraphComponent);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        appearance.setAttribute("pointShader.spheresDraw", false);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("attenuatePointSize", false);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
        defaultPointShader.setPointSize(Double.valueOf(4.0));
        defaultPointShader.setDiffuseColor(plot1DAppearance.getColour());
        this.graphShaders.add(defaultGeometryShader);
        this.graphPointShaders.add(defaultPointShader);
        this.graphGroupNode.addChild(sceneGraphComponent);
        ++this.numGraphs;
        return sceneGraphComponent;
    }

    @Override
    public void removeLastGraphNode() {
        if (this.graph != null) {
            assert (this.graphPointShaders.size() > 1);
            this.graphPointShaders.remove(this.graphPointShaders.size() - 1);
            this.graphShaders.remove(this.graphShaders.size() - 1);
            SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)this.subGraphs.get(this.subGraphs.size() - 1);
            this.graphGroupNode.removeChild(sceneGraphComponent);
            this.subGraphs.remove(this.subGraphs.size() - 1);
            int n = this.subGraphs.size();
            while (n < this.xAxes.size()) {
                this.xAxes.remove(this.xAxes.size() - 1);
                ++n;
            }
            n = this.subGraphs.size();
            while (n < this.yAxes.size()) {
                this.yAxes.remove(this.yAxes.size() - 1);
                ++n;
            }
            --this.numGraphs;
        }
    }

    @Override
    protected void updateGraphs() {
        if (this.graph != null) {
            IDataset iDataset;
            int n = this.subGraphs.size();
            while (n < this.sets.size()) {
                this.buildAdditionalGraphNode();
                ++n;
            }
            Iterator iterator = this.sets.iterator();
            Iterator iterator2 = this.subGraphs.iterator();
            Iterator iterator3 = this.xAxes.iterator();
            Iterator<AxisValues> iterator4 = this.yAxes.iterator();
            Iterator iterator5 = this.graphPointShaders.iterator();
            while (iterator.hasNext()) {
                iDataset = (IDataset)iterator.next();
                SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)iterator2.next();
                AxisValues axisValues = (AxisValues)iterator3.next();
                AxisValues axisValues2 = iterator4.next();
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues, axisValues2));
                DefaultPointShader defaultPointShader = (DefaultPointShader)iterator5.next();
                if (this.dataMin == this.dataMax) {
                    defaultPointShader.setPointSize(Double.valueOf(this.dataMin));
                } else {
                    defaultPointShader.setPointSize(Double.valueOf(1.0));
                }
                this.updateErrorBarNodesToPointNode(axisValues, axisValues2);
            }
            while (iterator2.hasNext()) {
                iDataset = (SceneGraphComponent)iterator2.next();
                iDataset.setGeometry(null);
            }
        }
    }

    @Override
    protected void updateWindowWithNewRanges(List<IDataset> list, SelectedWindow selectedWindow) {
        Iterator iterator = this.xAxes.iterator();
        Iterator<AxisValues> iterator2 = this.yAxes.iterator();
        double d = 3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            AxisValues axisValues = (AxisValues)iterator.next();
            AxisValues axisValues2 = iterator2.next();
            d3 = Math.min(d3, axisValues.getMinValue());
            d4 = Math.max(d4, axisValues.getMaxValue());
            d = Math.min(d, axisValues2.getMinValue());
            d2 = Math.max(d2, axisValues2.getMaxValue());
        }
        selectedWindow.setStartWindowX(d3);
        selectedWindow.setEndWindowX(d4);
        selectedWindow.setStartWindowY(d);
        selectedWindow.setEndWindowY(d2);
    }

    @Override
    public void updateAllGraphAppearances() {
        int n = 0;
        while (n < this.graphShaders.size()) {
            Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(n);
            DefaultPointShader defaultPointShader = this.graphPointShaders.get(n);
            plot1DAppearance.updateGraph(defaultPointShader);
            SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)this.subGraphs.get(n);
            sceneGraphComponent.setVisible(plot1DAppearance.isVisible());
            ++n;
        }
    }

    @Override
    protected void refreshZoomedGraphsCustom(double d, double d2) {
        AxisValues axisValues;
        AxisValues axisValues2;
        IDataset iDataset;
        this.globalRealXmax = d2;
        this.globalRealXmin = d;
        Iterator iterator = this.sets.iterator();
        Iterator iterator2 = this.subGraphs.iterator();
        Iterator iterator3 = this.xAxes.iterator();
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset2 = (IDataset)iterator.next();
            AxisValues axisValues3 = (AxisValues)iterator3.next();
            if (!(axisValues3.getMaxValue() > this.globalRealXmin) || !(axisValues3.getMinValue() < this.globalRealXmax)) continue;
            int n = 0;
            n = this.rangeZoom ? axisValues3.nearestUpEntry(d) : axisValues3.nearestLowEntry(d);
            int n2 = axisValues3.nearestUpEntry(d2);
            if (n == -1) {
                n = 0;
            }
            if (n2 == -1) {
                n2 = iDataset2.getShape()[0] - 1;
            }
            this.globalXmin = Math.min(this.globalXmin, axisValues3.getValue(n));
            this.globalXmax = Math.max(this.globalXmax, axisValues3.getValue(n2));
        }
        double d3 = this.globalRealXmax;
        double d4 = this.globalRealXmin;
        this.globalRealXmax = this.globalXmax;
        this.globalRealXmin = this.globalXmin;
        iterator = this.sets.iterator();
        iterator2 = this.subGraphs.iterator();
        iterator3 = this.xAxes.iterator();
        Iterator<AxisValues> iterator4 = this.yAxes.iterator();
        LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
        LinkedList<AxisValues> linkedList2 = new LinkedList<AxisValues>();
        LinkedList<AxisValues> linkedList3 = new LinkedList<AxisValues>();
        while (iterator.hasNext()) {
            iDataset = (IDataset)iterator.next();
            axisValues2 = (AxisValues)iterator3.next();
            axisValues = iterator4.next();
            if (axisValues2.getMaxValue() > d4 && axisValues2.getMinValue() < d3) {
                int n = 0;
                n = this.rangeZoom ? axisValues2.nearestUpEntry(d) : axisValues2.nearestLowEntry(d);
                int n3 = axisValues2.nearestUpEntry(d2);
                if (n == -1) {
                    n = 0;
                }
                n3 = n3 == -1 ? iDataset.getShape()[0] : Math.min(n3 + 1, iDataset.getShape()[0]);
                IDataset iDataset3 = null;
                AxisValues axisValues4 = null;
                if (n < n3) {
                    iDataset3 = iDataset.getSlice(new int[]{n}, new int[]{n3}, new int[]{1});
                    axisValues4 = axisValues.subset(n, n3);
                }
                if (this.rangeZoom && iDataset3 != null) {
                    if (iDataset3.getSize() != 1) {
                        this.dataMin = Math.min(this.dataMin, iDataset3.min().doubleValue());
                        this.dataMax = Math.max(this.dataMax, iDataset3.max().doubleValue());
                    } else {
                        this.dataMin = Math.min(this.dataMin, iDataset3.getDouble(new int[]{0}));
                        this.dataMax = Math.max(this.dataMax, iDataset3.getDouble(new int[]{0}) + 1.0E-4);
                    }
                }
                AxisValues axisValues5 = null;
                if (n < n3) {
                    axisValues5 = axisValues2.subset(n, n3);
                }
                linkedList.add(iDataset3);
                linkedList2.add(axisValues5);
                linkedList3.add(axisValues4);
                continue;
            }
            linkedList.add(null);
            linkedList2.add(null);
            linkedList3.add(null);
        }
        this.buildTickLists();
        this.sanityCheckMinMax();
        iterator3 = linkedList2.iterator();
        iterator4 = linkedList3.iterator();
        iterator = linkedList.iterator();
        while (iterator2.hasNext()) {
            iDataset = (SceneGraphComponent)iterator2.next();
            axisValues2 = null;
            axisValues = null;
            AxisValues axisValues6 = null;
            if (iterator.hasNext()) {
                axisValues2 = (IDataset)iterator.next();
                axisValues = (AxisValues)iterator3.next();
                axisValues6 = iterator4.next();
            }
            if (axisValues2 != null) {
                iDataset.setGeometry((Geometry)this.createGraphGeometry((IDataset)axisValues2, axisValues, axisValues6));
                continue;
            }
            iDataset.setGeometry(null);
        }
        linkedList2.clear();
        linkedList3.clear();
        linkedList.clear();
    }

    @Override
    protected void updateGraphInZoom() {
        double d = this.currentSelectWindow.getStartWindowX();
        double d2 = this.currentSelectWindow.getEndWindowX();
        SelectedWindow selectedWindow = (SelectedWindow)this.undoSelectStack.get(this.undoSelectStack.size() - 1);
        this.updateWindowWithNewRanges(this.sets, selectedWindow);
        this.refreshZoomedGraphsCustom(d, d2);
    }

    @Override
    public void toggleErrorBars(boolean bl, boolean bl2, boolean bl3) {
        this.xErrors.setVisible(bl);
        this.yErrors.setVisible(bl2);
    }
}

