/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.Viewer;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.tool.Tool;
import de.jreality.softviewer.SoftViewer;
import de.jreality.tools.ClickWheelCameraZoomTool;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.RotateTool;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.ViewerAppSwt;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import de.jreality.util.Secure;
import de.jreality.util.SystemProperties;
import gda.observable.IObserver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JPanel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;
import uk.ac.diamond.scisoft.analysis.io.IDiffractionMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourLookupTable;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramChartPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1DStack;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot2DMulti;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetScatterPlot2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetScatterPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IMainPlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.InfoBoxComponent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositeEntry;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositingControl;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.CompositeOp;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.SurfPlotStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendComponent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.PlotPrintPreviewDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.PrintSettings;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.CameraRotationTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ClickWheelZoomTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ClickWheelZoomToolWithScrollBar;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanActionListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanningTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SceneDragTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.system.info.JOGLChecker;

public class DataSetPlotter
extends JPanel
implements ComponentListener,
IObserver,
Listener,
PaintListener,
LegendChangeEventListener,
PlotActionEventListener,
IMainPlot,
SelectionListener,
PanActionListener {
    protected IDataSet3DCorePlot plotter = null;
    private SceneGraphComponent root = null;
    private SceneGraphComponent graph = null;
    private SceneGraphComponent coordAxes = null;
    private SceneGraphComponent bbox = null;
    private SceneGraphComponent coordTicks = null;
    private SceneGraphComponent coordXLabels = null;
    private SceneGraphComponent coordYLabels = null;
    private SceneGraphComponent coordZLabels = null;
    private SceneGraphComponent coordGrid = null;
    private SceneGraphComponent toolNode = null;
    private SceneGraphComponent cameraNode = null;
    private int maxDataSingleDim = 256;
    private int maxDataTotalDim = this.maxDataSingleDim * this.maxDataSingleDim;
    private boolean hasJOGL = false;
    private boolean hasJOGLshaders = false;
    private AbstractViewerApp viewerApp = null;
    private PanningTool panTool = null;
    private SceneDragTool dragTool = null;
    private ClickWheelCameraZoomTool cameraZoomTool = null;
    private ClickWheelZoomTool zoomTool = null;
    private CameraRotationTool cameraRotateTool = null;
    private PlottingMode currentMode = PlottingMode.SURF2D;
    private List<IDataset> currentDataSets = Collections.synchronizedList(new LinkedList());
    private Plot1DGraphTable graphColourTable;
    private Cursor defaultCursor = null;
    private LegendComponent legendTable = null;
    private InfoBoxComponent infoBox = null;
    private CompositingControl cmpControl = null;
    private SashForm container = null;
    private Composite plotArea = null;
    private ScrollBar vBar = null;
    private ScrollBar hBar = null;
    IDataset currentDataSet = null;
    private boolean useWindow = false;
    private boolean hasData = false;
    private boolean xGridActive = true;
    private boolean yGridActive = true;
    private boolean zGridActive = true;
    private double perspFOV = 56.5;
    private double orthoFOV = 140.0;
    private int historyCounter = 0;
    private String xAxisLabel = "";
    private String yAxisLabel = "";
    private String zAxisLabel = "";
    private String x2AxisLabel = "";
    private boolean useLegend = true;
    private boolean isInExporting = false;
    private boolean donotProcessEvent = false;
    private QSpace qSpace = null;
    private static final String RENDER_SOFTWARE_PROPERTY_STRING = "uk.ac.diamond.analysis.rcp.plotting.useSoftware";
    private static final String RENDER_HYBRID_PROPERTY_STRING = "uk.ac.diamond.analysis.rcp.plotting.useGL13";
    private static final String ERROR_MESG = "DataSet contains either NaNs or Infs can not plot";
    private static final String ERROR_MESG_NO_SHADERS = "System does not support OpenGL shaders falling back to compatibily mode. Some advanced features might not work";
    private static final Logger logger = LoggerFactory.getLogger(DataSetPlotter.class);
    private AbstractMapFunction cacheRedFunc;
    private AbstractMapFunction cacheGreenFunc;
    private AbstractMapFunction cacheBlueFunc;
    private AbstractMapFunction cacheAlphaFunc;
    private boolean cacheInverseRed;
    private boolean cacheInverseGreen;
    private boolean cacheInverseBlue;
    private boolean cacheInverseAlpha;
    private boolean showScrollBars = true;
    private double cacheMinValue;
    private double cacheMaxValue;
    private PrinterData defaultPrinterData;
    private PrintSettings settings;
    public static final double HANDNESS = 1.0;
    private boolean isZoomEnabled = false;

    private void removeInitialTools() {
        Tool tool2;
        List list = this.viewerApp.getSceneRoot().getChildComponents();
        List list2 = this.viewerApp.getSceneRoot().getTools();
        for (Tool tool2 : list2) {
            if (!(tool2 instanceof ClickWheelCameraZoomTool)) continue;
            this.cameraZoomTool = (ClickWheelCameraZoomTool)tool2;
        }
        tool2 = null;
        Tool tool3 = null;
        for (SceneGraphComponent sceneGraphComponent : list) {
            List list3 = sceneGraphComponent.getTools();
            for (Tool tool4 : list3) {
                if (tool4 instanceof RotateTool) {
                    this.cameraNode = sceneGraphComponent;
                    tool2 = tool4;
                }
                if (!(tool4 instanceof DraggingTool)) continue;
                this.toolNode = sceneGraphComponent;
                tool3 = tool4;
            }
        }
        if (this.toolNode != null && tool3 != null) {
            this.toolNode.removeTool(tool3);
            this.cameraNode.removeTool(tool2);
            this.panTool = new PanningTool(this.toolNode);
            this.panTool.addPanActionListener(this);
            this.cameraRotateTool = new CameraRotationTool();
            this.dragTool = new SceneDragTool();
            this.toolNode.addTool((Tool)this.panTool);
        }
        this.zoomTool = new ClickWheelZoomToolWithScrollBar(this.root, this.toolNode, this.showScrollBars ? this.hBar : null, this.showScrollBars ? this.vBar : null);
    }

    private void init(Composite composite) {
        this.graphColourTable = new Plot1DGraphTable();
        Secure.setProperty((String)"de.jreality.ui.viewerapp.autoRender", (String)"false");
        this.root = SceneGraphUtility.createFullSceneGraphComponent((String)"world");
        this.graph = SceneGraphUtility.createFullSceneGraphComponent((String)"graph");
        this.graph.setOwner((Object)this.root);
        this.coordAxes = SceneGraphUtility.createFullSceneGraphComponent((String)"axis");
        this.coordXLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"xLabels");
        this.coordYLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"yLabels");
        this.coordZLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"zLabels");
        this.root.addChild(this.coordAxes);
        this.root.addChild(this.coordXLabels);
        this.root.addChild(this.coordYLabels);
        this.root.addChild(this.coordZLabels);
        this.root.addChild(this.graph);
        this.hasJOGL = true;
        String string = System.getProperty(RENDER_SOFTWARE_PROPERTY_STRING);
        if (string != null && string.toLowerCase().equals("true")) {
            logger.warn("Force software render");
            this.hasJOGL = false;
        } else {
            String string2 = Secure.getProperty((String)SystemProperties.VIEWER, (String)"de.jreality.jogl.ViewerAwt");
            this.hasJOGL = JOGLChecker.canUseJOGL_OpenGL((String)string2, (Composite)composite);
        }
        this.hasData = false;
        this.defaultPrinterData = Printer.getDefaultPrinterData();
    }

    public void setUseLegend(boolean bl) {
        this.useLegend = bl;
        if (this.useLegend) {
            if (this.legendTable == null) {
                this.buildLegendTable();
            }
            this.legendTable.setVisible(true);
            this.legendTable.updateTable(this.graphColourTable);
        } else if (this.legendTable != null) {
            this.legendTable.setVisible(false);
        }
        this.legendTable.getParent().layout();
    }

    private void buildLegendTable() {
        if (this.legendTable == null || this.legendTable.isDisposed()) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = 75;
            this.legendTable = new LegendTable((Composite)this.container, 0x20000000);
            this.legendTable.setLayoutData(gridData);
        }
        this.container.setWeights(new int[]{90, 10});
        this.legendTable.addIObserver(this);
        this.legendTable.addLegendChangeEventListener(this);
    }

    private void buildInfoBox() {
        if (this.infoBox == null || this.infoBox.isDisposed()) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = 55;
            this.infoBox = new InfoBoxComponent((Composite)this.container, 0x20000000);
            this.infoBox.setLayoutData(gridData);
            this.container.setWeights(new int[]{90, 10});
        }
    }

    private void buildCompositingControl() {
        if (this.cmpControl == null || this.cmpControl.isDisposed()) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = 95;
            this.cmpControl = new CompositingControl((Composite)this.container, 0x20000000);
            this.cmpControl.setLayoutData(gridData);
            this.cmpControl.addSelectionListener(this);
            this.container.setWeights(new int[]{90, 10});
        }
    }

    public Composite getComposite() {
        return this.container;
    }

    private Composite createSWTGUI(Composite composite) {
        this.container = new SashForm(composite, 512);
        this.container.addPaintListener((PaintListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        this.container.setLayout((Layout)gridLayout);
        this.plotArea = this.hasJOGL ? new Composite((Composite)this.container, 0x20000300) : new Composite((Composite)this.container, 0x1000300);
        this.hBar = this.plotArea.getHorizontalBar();
        this.hBar.addSelectionListener((SelectionListener)this);
        this.vBar = this.plotArea.getVerticalBar();
        this.vBar.addSelectionListener((SelectionListener)this);
        if (SWT.getPlatform().equals("gtk")) {
            this.plotArea.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    DataSetPlotter.this.donotProcessEvent = true;
                }
            });
        }
        this.hBar.setVisible(false);
        this.vBar.setVisible(false);
        this.defaultCursor = this.plotArea.getCursor();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.plotArea.setLayoutData((Object)gridData);
        if (this.hasJOGL) {
            this.plotArea.setLayout((Layout)new FillLayout());
            this.plotArea.addListener(11, (Listener)this);
            this.viewerApp = new ViewerAppSwt((SceneGraphNode)this.root, this.plotArea);
            this.hasJOGLshaders = ((ViewerAppSwt)this.viewerApp).supportsShaders();
            String string = System.getProperty(RENDER_HYBRID_PROPERTY_STRING);
            if (string != null && string.toLowerCase().equals("true")) {
                this.hasJOGLshaders = false;
            }
            if (!this.hasJOGLshaders) {
                logger.warn(ERROR_MESG_NO_SHADERS);
            }
        } else {
            this.viewerApp = new ViewerApp((SceneGraphNode)this.root, true);
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            Component component = ((ViewerApp)this.viewerApp).getContent();
            this.add(component);
            component.addComponentListener(this);
            Frame frame = SWT_AWT.new_Frame((Composite)this.plotArea);
            JApplet jApplet = new JApplet();
            frame.add(jApplet);
            jApplet.add(this);
        }
        this.viewerApp.setBackgroundColor(new Color[]{Color.white});
        if (this.useLegend) {
            this.buildLegendTable();
        }
        this.removeInitialTools();
        return this.container;
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite) {
        this(plottingMode, composite, true);
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite, boolean bl) {
        this.useLegend = bl;
        this.currentMode = plottingMode;
        this.init(composite);
        this.createSWTGUI(composite);
        this.setInitPlotMode();
    }

    public DataSetPlotter(PlottingMode plottingMode, Composite composite, LegendComponent legendComponent) {
        this.useLegend = true;
        this.legendTable = legendComponent;
        this.legendTable.addLegendChangeEventListener(this);
        this.currentMode = plottingMode;
        this.init(composite);
        this.createSWTGUI(composite);
        this.setInitPlotMode();
    }

    private void setInitPlotMode() {
        switch (this.currentMode) {
            case ONED: {
                this.plotter = new DataSet3DPlot1D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.toolNode.removeTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                break;
            }
            case ONED_THREED: {
                this.plotter = new DataSet3DPlot1DStack(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                break;
            }
            case SCATTER2D: {
                this.plotter = new DataSetScatterPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.toolNode.removeTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                break;
            }
            case TWOD: {
                this.plotter = new DataSet3DPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL, this.hasJOGLshaders);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                break;
            }
            case MULTI2D: {
                this.plotter = new DataSet3DPlot2DMulti(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL, this.hasJOGLshaders);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                break;
            }
            case SURF2D: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.plotter = new DataSet3DPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                break;
            }
            case SCATTER3D: {
                this.plotter = new DataSetScatterPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                break;
            }
            case BARCHART: {
                this.toolNode.removeTool((Tool)this.panTool);
                this.toolNode.removeTool((Tool)this.dragTool);
                this.cameraNode.removeTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
                this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
                this.plotter = new HistogramChartPlot1D(this.viewerApp, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                break;
            }
        }
    }

    public int getMaximumSingleDimension() {
        return this.maxDataSingleDim;
    }

    public int getMaximumTotalDimension() {
        return this.maxDataTotalDim;
    }

    private void removeOldSceneNodes() {
        if (this.bbox != null) {
            this.root.removeChild(this.bbox);
            this.bbox = null;
        }
        if (this.coordTicks != null) {
            this.root.removeChild(this.coordTicks);
            this.coordTicks = null;
        }
        if (this.coordGrid != null) {
            this.root.removeChild(this.coordGrid);
            this.coordGrid = null;
        }
        if (this.currentMode == PlottingMode.TWOD && this.root != null && this.root.getTransformation() != null) {
            this.root.getTransformation().removeTransformationListener((TransformationListener)((DataSet3DPlot2D)this.plotter));
        }
        if (this.graph != null) {
            this.graph.setGeometry(null);
        }
        if (this.plotter != null) {
            this.plotter.cleanUpGraphNode();
        }
    }

    public void applyColourCast(HistogramUpdate histogramUpdate) {
        this.applyColourCast(histogramUpdate.getRedMapFunction(), histogramUpdate.getGreenMapFunction(), histogramUpdate.getBlueMapFunction(), histogramUpdate.getAlphaMapFunction(), histogramUpdate.inverseRed(), histogramUpdate.inverseGreen(), histogramUpdate.inverseBlue(), histogramUpdate.inverseAlpha(), histogramUpdate.getMinValue(), histogramUpdate.getMaxValue());
    }

    public void applyColourCast(AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, AbstractMapFunction abstractMapFunction4, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, double d2) {
        if (this.currentDataSets.size() > 0 && this.graph != null) {
            ColourImageData colourImageData = null;
            if (this.hasJOGLshaders || this.currentMode == PlottingMode.SCATTER3D) {
                colourImageData = ColourLookupTable.generateColourLookupTable(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4);
            } else {
                this.cacheRedFunc = abstractMapFunction;
                this.cacheGreenFunc = abstractMapFunction2;
                this.cacheBlueFunc = abstractMapFunction3;
                this.cacheAlphaFunc = abstractMapFunction4;
                this.cacheInverseAlpha = bl4;
                this.cacheInverseRed = bl;
                this.cacheInverseGreen = bl2;
                this.cacheInverseBlue = bl3;
                this.cacheMinValue = d;
                this.cacheMaxValue = d2;
                colourImageData = this.currentMode != PlottingMode.BARCHART ? ColourLookupTable.generateColourTable(this.currentDataSets.get(0), abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4, d, d2, this.plotter.getScaling() != ScaleType.LINEAR) : ColourLookupTable.generateColourLookupTable(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4);
            }
            this.plotter.handleColourCast(colourImageData, this.graph, d, d2);
        }
    }

    public void setPlot(IDataset iDataset) {
        if (this.currentDataSet != null) {
            this.currentDataSets.remove(0);
            this.currentDataSets.add(0, iDataset);
            this.plotter.updateGraph(iDataset);
        } else {
            this.currentDataSets.add(iDataset);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            this.plotter.setYAxisLabel(this.yAxisLabel);
        }
    }

    @Deprecated
    public void addPlot(IDataset ... iDatasetArray) {
        if (this.currentMode == PlottingMode.SURF2D) {
            logger.info("Plot3D is currently in 2D mode but 1D plot has been added switching to Multi 1D");
            this.currentDataSets.clear();
            int n = 0;
            while (n < iDatasetArray.length) {
                this.currentDataSets.add(iDatasetArray[n]);
                ++n;
            }
            if (iDatasetArray.length > 1) {
                this.setMode(PlottingMode.ONED_THREED);
            } else {
                this.setMode(PlottingMode.ONED);
                this.currentDataSet = iDatasetArray[0];
            }
        } else {
            int n = 0;
            while (n < iDatasetArray.length) {
                this.currentDataSets.add(iDatasetArray[n]);
                ++n;
            }
            this.checkAndAddLegend(this.currentDataSets);
            if (this.currentDataSet == null) {
                this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
                this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
                this.hasData = true;
                this.plotter.setXAxisLabel(this.xAxisLabel);
                this.plotter.setYAxisLabel(this.yAxisLabel);
                this.currentDataSet = iDatasetArray[0];
            } else {
                this.plotter.updateGraph(this.currentDataSets);
            }
        }
    }

    public void addToCurrentPlot(double[] dArray) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).addDataPoints(dArray);
        }
    }

    public void addToCurrentPlots(List<double[]> list) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).addDataPoints(list);
        }
    }

    public void addToCurrentPlot(double[] dArray, double[] dArray2) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (dArray.length != dArray2.length) {
                throw new PlotException("Length of values doesn't match length of axisValues");
            }
            ((DataSet3DPlot1D)this.plotter).addDataPoints(dArray, dArray2);
        }
    }

    public void addToCurrentPlot(IDataset iDataset, AxisValues axisValues, AxisValues axisValues2) throws PlotException {
        if (this.currentMode == PlottingMode.SCATTER2D) {
            if (this.currentDataSets.size() == 0) {
                throw new PlotException("There is no data in the scatter plot so far");
            }
            this.currentDataSets.add(iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            if (iDataset.getSize() != axisValues.size()) {
                throw new PlotException("Length of values doesn't match length of axisValues");
            }
            ((DataSetScatterPlot2D)this.plotter).addAxises(axisValues, axisValues2);
            this.plotter.updateGraph(this.currentDataSets);
        }
    }

    public void addToCurrentPlots(List<double[]> list, List<double[]> list2) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (list.size() != list2.size()) {
                throw new PlotException("Lenght of value list doesn't match length of axis value list");
            }
            ((DataSet3DPlot1D)this.plotter).addDataPoints(list, list2);
        }
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
        if (this.hasData) {
            this.plotter.setXAxisLabel(this.xAxisLabel);
        }
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public String getZAxisLabel() {
        return this.zAxisLabel;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
        if (this.hasData) {
            this.plotter.setYAxisLabel(this.yAxisLabel);
        }
    }

    public void setZAxisLabel(String string) {
        this.zAxisLabel = string;
        if (this.hasData) {
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
    }

    public void replaceAllPlots(Collection<? extends IDataset> collection, List<AxisValues> list) throws PlotException {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (collection.size() > list.size()) {
                throw new PlotException("Number of DataSets is larger than Axis values");
            }
            ((DataSet3DPlot1D)this.plotter).setXAxisValues(list, this.historyCounter);
            this.replaceAllPlots(collection);
        }
    }

    public void replaceAllPlots(Collection<? extends IDataset> collection, List<AxisValues> list, List<AxisValues> list2) throws PlotException {
        if (this.currentMode == PlottingMode.SCATTER2D) {
            if (collection.size() != list.size() || collection.size() != list2.size()) {
                throw new PlotException("Number of DataSets different to Axis values");
            }
            ((DataSetScatterPlot2D)this.plotter).replaceAxises(list, list2);
            this.replaceAllPlots(collection);
        }
    }

    private void checkAndAddLegend(Collection<? extends IDataset> collection) {
        if ((this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.SCATTER2D) && collection != null && collection.size() > this.graphColourTable.getLegendSize()) {
            logger.info("# graphs > # of entries in the legend will auto add entries");
            int n = this.graphColourTable.getLegendSize();
            while (n < collection.size()) {
                this.graphColourTable.addEntryOnLegend(new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), PlotColorUtility.getDefaultStyle(n), ""));
                ++n;
            }
        }
    }

    private boolean checkForNan(IDataset iDataset) {
        if (iDataset instanceof AbstractDataset) {
            return ((AbstractDataset)iDataset).containsNans();
        }
        int n = 0;
        while (n < iDataset.getShape()[0]) {
            if (!Double.isNaN(iDataset.getDouble(new int[]{n++}))) continue;
            return true;
        }
        return false;
    }

    private boolean checkForInf(IDataset iDataset) {
        if (iDataset instanceof AbstractDataset) {
            return ((AbstractDataset)iDataset).containsInfs();
        }
        int n = 0;
        while (n < iDataset.getShape()[0]) {
            if (!Double.isInfinite(iDataset.getDouble(new int[]{n++}))) continue;
            return true;
        }
        return false;
    }

    private void sanityCheckDataSets(Collection<? extends IDataset> collection) throws PlotException {
        for (IDataset iDataset : collection) {
            if (!this.checkForNan(iDataset) && !this.checkForInf(iDataset)) continue;
            throw new PlotException(ERROR_MESG);
        }
    }

    public void replaceAllPlots(Collection<? extends IDataset> collection) throws PlotException {
        int n;
        this.checkAndAddLegend(collection);
        this.sanityCheckDataSets(collection);
        if (this.currentDataSets.size() > 0) {
            int n2 = this.currentDataSets.size() - this.historyCounter;
            if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.SCATTER2D) {
                if (n2 > collection.size()) {
                    n = 0;
                    while (n < n2 - collection.size()) {
                        ((DataSet3DPlot1D)this.plotter).removeLastGraphNode();
                        ++n;
                    }
                }
                if (n2 < collection.size()) {
                    n = 0;
                    while (n < collection.size() - n2) {
                        ((DataSet3DPlot1D)this.plotter).addGraphNode();
                        ++n;
                    }
                }
            }
            n = this.currentDataSets.size() - (this.historyCounter + 1);
            while (n >= 0) {
                this.currentDataSets.remove(n);
                --n;
            }
            this.currentDataSets.addAll(0, collection);
            this.plotter.updateGraph(this.currentDataSets);
        } else {
            this.currentDataSets.addAll(collection);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            if (this.currentMode == PlottingMode.ONED) {
                ((DataSet3DPlot1D)this.plotter).setSecondaryXAxisLabel(this.x2AxisLabel);
            }
            this.plotter.setYAxisLabel(this.yAxisLabel);
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER3D) {
            this.root.removeChild(this.bbox);
            this.bbox = this.plotter.buildBoundingBox();
            this.root.addChild(this.bbox);
        }
        if (this.currentMode == PlottingMode.MULTI2D) {
            ArrayList<CompositeEntry> arrayList = new ArrayList<CompositeEntry>();
            n = 0;
            while (n < this.currentDataSets.size()) {
                String string = this.currentDataSets.get(n).getName();
                float f = 1.0f / (float)this.currentDataSets.size();
                if (string == null) {
                    string = "";
                }
                CompositeEntry compositeEntry = new CompositeEntry(string, f, CompositeOp.ADD, 7);
                arrayList.add(compositeEntry);
                ++n;
            }
            if (this.cmpControl != null) {
                this.cmpControl.updateTable(arrayList);
            }
            ((DataSet3DPlot2DMulti)this.plotter).updateCompositingSettings(arrayList);
        }
        if (this.currentDataSets.size() > 0) {
            this.currentDataSet = this.currentDataSets.get(0);
            this.checkForDiffractionImage(this.currentDataSet);
        }
    }

    public void replaceCurrentPlot(IDataset iDataset) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentDataSet != null) {
            this.currentDataSets.remove(0);
            this.currentDataSets.add(0, iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            this.plotter.updateGraph(iDataset);
        } else {
            this.currentDataSets.add(iDataset);
            this.checkAndAddLegend(this.currentDataSets);
            this.graph = this.plotter.buildGraph(this.currentDataSets, this.graph);
            this.coordAxes = this.plotter.buildCoordAxis(this.coordAxes);
            this.hasData = true;
            this.plotter.setXAxisLabel(this.xAxisLabel);
            this.plotter.setYAxisLabel(this.yAxisLabel);
            this.plotter.setZAxisLabel(this.zAxisLabel);
        }
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.SCATTER3D) {
            this.root.removeChild(this.bbox);
            this.bbox = this.plotter.buildBoundingBox();
            this.root.addChild(this.bbox);
        }
        this.currentDataSet = iDataset;
        this.checkForDiffractionImage(iDataset);
    }

    public void replaceAPlot(IDataset iDataset, int n) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (n < this.currentDataSets.size()) {
                ((DataSet3DPlot1D)this.plotter).updateAGraph(iDataset, n);
            } else {
                throw new PlotException("This plotNumber doesn't exist");
            }
        }
    }

    public void replaceAPlot(IDataset iDataset, AxisValues axisValues, int n) throws PlotException {
        if (this.checkForNan(iDataset) || this.checkForInf(iDataset)) {
            throw new PlotException(ERROR_MESG);
        }
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            if (n < this.currentDataSets.size()) {
                ((DataSet3DPlot1D)this.plotter).replaceXAxisValue(axisValues, n);
                ((DataSet3DPlot1D)this.plotter).updateAGraph(iDataset, n);
            } else {
                throw new PlotException("This plotNumber doesn't exist");
            }
        }
    }

    private void checkForDiffractionImage(IDataset iDataset) {
        if (this.currentMode == PlottingMode.TWOD || this.currentMode == PlottingMode.SURF2D) {
            AbstractDataset abstractDataset;
            IMetaData iMetaData;
            this.qSpace = null;
            boolean bl = false;
            if (iDataset instanceof AbstractDataset && (iMetaData = (abstractDataset = (AbstractDataset)iDataset).getMetadata()) instanceof IDiffractionMetadata) {
                IDiffractionMetadata iDiffractionMetadata = (IDiffractionMetadata)iMetaData;
                try {
                    this.qSpace = new QSpace(iDiffractionMetadata.getDetector2DProperties(), iDiffractionMetadata.getDiffractionCrystalEnvironment());
                    bl = true;
                }
                catch (Exception exception) {
                    logger.debug("Could not create a detector properties object from metadata");
                }
            }
            final boolean bl2 = bl;
            if (this.infoBox != null) {
                this.infoBox.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataSetPlotter.this.infoBox.isDiffractionImage(bl2);
                    }
                });
            }
        }
    }

    public void setQSpace(QSpace qSpace) {
        this.qSpace = qSpace;
    }

    public void emptyPlot() {
        this.setMode(PlottingMode.EMPTY);
        this.coordXLabels.setVisible(false);
        this.coordYLabels.setVisible(false);
        this.coordZLabels.setVisible(false);
        this.coordAxes.setVisible(false);
    }

    private void clearPlot() {
        this.historyCounter = 0;
        this.currentDataSets.clear();
        this.currentDataSet = null;
        this.removeOldSceneNodes();
        if (this.legendTable != null) {
            this.legendTable.removeAllLegendChangeEventListener();
            this.legendTable.dispose();
            this.legendTable = null;
        }
        if (this.infoBox != null) {
            this.infoBox.dispose();
            this.infoBox = null;
        }
        if (this.cmpControl != null) {
            this.cmpControl.removeSelectionListener(this);
            this.cmpControl.dispose();
            this.cmpControl = null;
        }
    }

    public void setMode(PlottingMode plottingMode) {
        this.clearPlot();
        if (plottingMode != this.currentMode) {
            this.hasData = false;
        }
        this.currentMode = plottingMode;
        if (this.hasJOGL) {
            this.plotArea.setFocus();
        }
        this.toolNode.removeTool((Tool)this.panTool);
        this.toolNode.removeTool((Tool)this.dragTool);
        this.cameraNode.removeTool((Tool)this.cameraRotateTool);
        this.viewerApp.getSceneRoot().removeTool((Tool)this.zoomTool);
        this.viewerApp.getSceneRoot().removeTool((Tool)this.cameraZoomTool);
        switch (this.currentMode) {
            case ONED: {
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSet3DPlot1D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.buildLegendTable();
                this.container.layout();
                this.setPerspectiveCamera(true, false);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case ONED_THREED: {
                this.plotter = new DataSet3DPlot1DStack(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.buildLegendTable();
                this.container.layout();
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case SCATTER2D: {
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSetScatterPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.graphColourTable, this.hasJOGL);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.buildLegendTable();
                this.container.layout();
                this.setPerspectiveCamera(true, false);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case TWOD: {
                this.root.removeChild(this.coordTicks);
                this.plotter = new DataSet3DPlot2D(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL, this.hasJOGLshaders);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.toolNode.addTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.zoomTool);
                if (this.useLegend) {
                    this.buildInfoBox();
                }
                this.container.layout();
                this.root.getTransformation().addTransformationListener((TransformationListener)((DataSet3DPlot2D)this.plotter));
                this.setPerspectiveCamera(true, false);
                break;
            }
            case MULTI2D: {
                this.root.removeChild(this.coordTicks);
                this.plotter = new DataSet3DPlot2DMulti(this.viewerApp, this.plotArea, this.defaultCursor, this.panTool, this.hasJOGL, this.hasJOGLshaders);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.toolNode.addTool((Tool)this.panTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.zoomTool);
                this.buildCompositingControl();
                this.container.layout();
                this.root.getTransformation().addTransformationListener((TransformationListener)((DataSet3DPlot2D)this.plotter));
                this.setPerspectiveCamera(true, false);
                break;
            }
            case SURF2D: {
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSet3DPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildCoordAxis(this.coordAxes);
                this.container.layout();
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                this.setPerspectiveCamera(true, false);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case SCATTER3D: {
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.plotter = new DataSetScatterPlot3D(this.viewerApp, this.hasJOGL, this.useWindow);
                this.plotter.buildXCoordLabeling(this.coordXLabels);
                this.plotter.buildYCoordLabeling(this.coordYLabels);
                this.plotter.buildZCoordLabeling(this.coordZLabels);
                this.coordTicks = this.plotter.buildCoordAxesTicks();
                this.root.addChild(this.coordTicks);
                this.plotter.buildCoordAxis(this.coordAxes);
                this.container.layout();
                this.toolNode.addTool((Tool)this.dragTool);
                this.cameraNode.addTool((Tool)this.cameraRotateTool);
                this.viewerApp.getSceneRoot().addTool((Tool)this.cameraZoomTool);
                this.setPerspectiveCamera(true, false);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case BARCHART: {
                this.plotter = new HistogramChartPlot1D(this.viewerApp, this.graphColourTable, this.hasJOGL);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
                MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
                this.setPerspectiveCamera(true, false);
                this.hBar.setVisible(false);
                this.vBar.setVisible(false);
                break;
            }
            case EMPTY: {
                Camera camera = CameraUtility.getCamera((Viewer)this.viewerApp.getCurrentViewer());
                camera.setPerspective(true);
            }
        }
        this.coordXLabels.setVisible(true);
        this.coordYLabels.setVisible(true);
        this.coordZLabels.setVisible(true);
        this.coordAxes.setVisible(true);
    }

    public PlottingMode getMode() {
        return this.currentMode;
    }

    private void cleanUpViewers() {
        Viewer[] viewerArray = this.viewerApp.getViewerSwitch().getViewers();
        int n = 0;
        while (n < viewerArray.length) {
            if (viewerArray[n] instanceof SoftViewer) {
                ((SoftViewer)viewerArray[n]).dispose();
            }
            ++n;
        }
    }

    public void cleanUp() {
        if (this.plotter != null) {
            this.plotter.cleanUpGraphNode();
        }
        try {
            this.removeOldSceneNodes();
            if (this.graph != null) {
                this.graph.setOwner(null);
            }
            if (this.bbox != null) {
                this.root.removeChild(this.bbox);
            }
            if (this.coordGrid != null) {
                this.root.removeChild(this.coordGrid);
            }
            if (this.coordXLabels != null) {
                this.root.removeChild(this.coordXLabels);
            }
            if (this.coordYLabels != null) {
                this.root.removeChild(this.coordYLabels);
            }
            if (this.coordZLabels != null) {
                this.root.removeChild(this.coordZLabels);
            }
            if (this.coordTicks != null) {
                this.root.removeChild(this.coordTicks);
            }
            if (this.panTool != null) {
                this.panTool.removeAllPanActionListener();
            }
            this.bbox = null;
            this.coordTicks = null;
            this.coordXLabels = null;
            this.coordYLabels = null;
            this.coordZLabels = null;
            this.coordGrid = null;
            this.root = null;
            this.currentDataSets.clear();
            this.currentDataSet = null;
            this.plotter = null;
            if (this.graphColourTable != null) {
                this.graphColourTable.clearLegend();
            }
            this.graphColourTable = null;
            this.cleanUpViewers();
            try {
                this.viewerApp.dispose();
            }
            catch (Exception exception) {
                logger.debug("oh no", (Throwable)exception);
            }
            if (this.plotArea != null) {
                this.plotArea.dispose();
            }
            if (this.container != null) {
                this.container.dispose();
            }
            if (this.legendTable != null) {
                this.legendTable.removeAllLegendChangeEventListener();
                this.legendTable.dispose();
            }
            if (this.infoBox != null && !this.infoBox.isDisposed()) {
                this.infoBox.dispose();
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.isDisposed()) {
                return;
            }
            throw runtimeException;
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.plotter != null) {
            Component component = ((ViewerApp)this.viewerApp).getViewingComponent();
            this.plotter.notifyComponentResize(component.getWidth(), component.getHeight());
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setCurrentGraphColour(int n) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).updateGraphAppearance(n);
            if (this.legendTable != null) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public void updateAllAppearance() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.BARCHART || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).updateAllGraphAppearances();
            if (this.legendTable != null) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public void undoZoom() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).undoZoom();
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).undoZoom();
        }
    }

    public void resetZoom() {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).resetZoom();
        }
    }

    public void pushGraphOntoHistory() {
        if (this.currentMode == PlottingMode.ONED) {
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((ILazyDataset)((ILazyDataset)this.currentDataSets.get(0))).clone();
            this.currentDataSets.add((IDataset)abstractDataset);
            ((DataSet3DPlot1D)this.plotter).addGraphNode();
            ++this.historyCounter;
        }
    }

    public void popGraphFromHistory() {
        if (this.currentMode == PlottingMode.ONED && this.currentDataSets.size() > 1) {
            ((DataSet3DPlot1D)this.plotter).removeLastGraphNode();
            this.currentDataSets.remove(this.currentDataSets.size() - 1);
            --this.historyCounter;
            if (this.useLegend) {
                this.legendTable.updateTable(this.graphColourTable);
            }
        }
    }

    public int getNumHistory() {
        return this.historyCounter;
    }

    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.plotter.setAxisModes(axisMode, axisMode2, axisMode3);
    }

    public void setAxisOffset(double d, double d2, double d3) {
        if (this.plotter != null) {
            this.plotter.setXAxisOffset(d);
            this.plotter.setYAxisOffset(d2);
            this.plotter.setZAxisOffset(d3);
        }
    }

    public void setXAxisValues(AxisValues axisValues, int n) {
        if (this.plotter != null) {
            this.plotter.setXAxisValues(axisValues, n);
        }
    }

    public void setSecondaryXAxisValues(AxisValues axisValues, String string) {
        if (this.plotter != null && this.currentMode == PlottingMode.ONED) {
            ((DataSet3DPlot1D)this.plotter).set2ndXAxisValues(axisValues);
            this.x2AxisLabel = string;
            if (this.hasData) {
                ((DataSet3DPlot1D)this.plotter).setSecondaryXAxisLabel(string);
            }
        }
    }

    public void setYAxisValues(AxisValues axisValues) {
        if (this.plotter != null) {
            this.plotter.setYAxisValues(axisValues);
        }
    }

    public void setZAxisValues(AxisValues axisValues) {
        if (this.plotter != null) {
            this.plotter.setZAxisValues(axisValues);
        }
    }

    public synchronized void refresh(boolean bl) {
        if (!this.isInExporting && this.viewerApp != null) {
            if (!bl) {
                this.viewerApp.getCurrentViewer().render();
            } else {
                this.viewerApp.getCurrentViewer().renderAsync();
            }
        }
        if ((this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) && this.legendTable != null) {
            this.legendTable.updateTable(this.graphColourTable);
        }
    }

    public Plot1DGraphTable getColourTable() {
        return this.graphColourTable;
    }

    public void registerUI(IPlotUI iPlotUI) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).addPlotActionEventListener(iPlotUI);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).addPlotActionEventListener(this);
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).addAreaSelectEventListener(iPlotUI);
        }
    }

    public void unregisterUI(IPlotUI iPlotUI) {
        if (iPlotUI != null) {
            iPlotUI.disposeOverlays();
        }
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).removePlotActionEventListener(iPlotUI);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).removePlotActionEventListener(this);
        } else if (this.currentMode == PlottingMode.BARCHART) {
            ((HistogramChartPlot1D)this.plotter).removeAreaSelectEventListener(iPlotUI);
        }
    }

    public void registerOverlay(OverlayConsumer overlayConsumer) {
        switch (this.currentMode) {
            case ONED: {
                ((DataSet3DPlot1D)this.plotter).registerOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
            case TWOD: {
                ((DataSet3DPlot2D)this.plotter).registerOverlay((Overlay2DConsumer)overlayConsumer);
                break;
            }
            case ONED_THREED: {
                break;
            }
            case SCATTER2D: {
                break;
            }
            case SURF2D: {
                break;
            }
            case SCATTER3D: {
                break;
            }
            case BARCHART: {
                ((DataSet3DPlot1D)this.plotter).registerOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
            case MULTI2D: {
                break;
            }
        }
    }

    public void unRegisterOverlay(OverlayConsumer overlayConsumer) {
        switch (this.currentMode) {
            case ONED: {
                ((DataSet3DPlot1D)this.plotter).unRegisterOverlay((Overlay1DConsumer)overlayConsumer);
                break;
            }
            case TWOD: {
                ((DataSet3DPlot2D)this.plotter).unRegisterOverlay((Overlay2DConsumer)overlayConsumer);
                break;
            }
            case ONED_THREED: {
                break;
            }
            case SCATTER2D: {
                break;
            }
            case SURF2D: {
                break;
            }
            case SCATTER3D: {
                break;
            }
            case BARCHART: {
                break;
            }
            case MULTI2D: {
                break;
            }
        }
    }

    public void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.BARCHART || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).enableZoomTool(bl);
        }
    }

    public boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public void setZoomMode(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.BARCHART || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).setZoomMode(bl);
        }
    }

    public void setPlotActionEnabled(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).enablePlotActionTool(bl);
        } else if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).enablePlotActionTool(bl);
        }
    }

    public void setPlotRightClickActionEnabled(boolean bl) {
        if (this.currentMode == PlottingMode.ONED) {
            ((DataSet3DPlot1D)this.plotter).enableRightClickActionTool(bl);
        }
    }

    public void setXTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setXAxisLabelMode(tickFormatting);
    }

    public void setYTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setYAxisLabelMode(tickFormatting);
    }

    public void setZTickLabelFormat(TickFormatting tickFormatting) {
        this.plotter.setZAxisLabelMode(tickFormatting);
    }

    public void setTitle(final String string) {
        if (this.plotter != null) {
            this.plotter.setTitle(string);
            if (this.infoBox != null) {
                this.infoBox.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataSetPlotter.this.infoBox.setName(string);
                    }
                });
            }
        }
    }

    public void setTickGridLines(boolean bl, boolean bl2, boolean bl3) {
        this.xGridActive = bl;
        this.yGridActive = bl2;
        this.zGridActive = bl3;
        this.plotter.setTickGridLinesActive(bl, bl2, bl3);
    }

    public boolean getXGridActive() {
        return this.xGridActive;
    }

    public boolean getYGridActive() {
        return this.yGridActive;
    }

    public boolean getZGridActive() {
        return this.zGridActive;
    }

    public void useWindow(boolean bl) {
        this.useWindow = bl;
    }

    @Override
    public IDataset getCurrentDataSet() {
        return this.currentDataSet;
    }

    @Override
    public List<IDataset> getCurrentDataSets() {
        if (this.currentDataSets == null) {
            return null;
        }
        return new ArrayList<IDataset>(this.currentDataSets);
    }

    public void enableBoundingBox(boolean bl) {
        if (this.currentMode == PlottingMode.SURF2D || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER3D) {
            if (bl) {
                this.bbox = this.plotter.buildBoundingBox();
                this.root.addChild(this.bbox);
            } else {
                this.root.removeChild(this.bbox);
            }
        }
    }

    public void setPlot2DSurfStyle(SurfPlotStyles surfPlotStyles) {
        if (this.currentMode == PlottingMode.SURF2D) {
            ((DataSet3DPlot3D)this.plotter).setStyle(surfPlotStyles);
        }
    }

    public void resetView() {
        MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.toolNode);
        MatrixBuilder.euclidean().translate(0.0, 0.0, 0.0).assignTo(this.root);
        if (this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SURF2D) {
            Camera camera = CameraUtility.getCamera((Viewer)this.viewerApp.getCurrentViewer());
            if (camera.isPerspective()) {
                camera.setFieldOfView(56.5);
            } else {
                camera.setFieldOfView(140.0);
            }
        }
        if (this.vBar != null) {
            this.vBar.setVisible(false);
            this.vBar.setMaximum(0);
            this.vBar.setMinimum(0);
            this.vBar.setIncrement(0);
        }
        if (this.hBar != null) {
            this.hBar.setVisible(false);
            this.hBar.setMaximum(0);
            this.hBar.setMinimum(0);
            this.hBar.setIncrement(0);
        }
        this.plotArea.redraw();
        this.plotter.resetView();
    }

    public synchronized void saveGraph(String string, String string2) {
        this.isInExporting = true;
        File file = new File(string).getParentFile();
        if (!file.canWrite()) {
            String string3 = "Saving failed: no permission to write in directory: " + file.getAbsolutePath();
            logger.error(string3);
            Status status = new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", string3);
            ErrorDialog.openError((Shell)this.getComposite().getShell(), (String)"Image export error", (String)"Error saving image file", (IStatus)status);
            this.isInExporting = false;
            return;
        }
        try {
            try {
                PlotExportUtil.saveGraph(string, string2, this.viewerApp);
            }
            catch (Exception exception) {
                logger.error(exception.getCause().getMessage(), (Throwable)exception);
                Status status = new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", exception.getMessage(), (Throwable)exception);
                ErrorDialog.openError((Shell)this.getComposite().getShell(), (String)"Image export error", (String)"Error saving image file", (IStatus)status);
                this.isInExporting = false;
            }
        }
        finally {
            this.isInExporting = false;
        }
    }

    public synchronized void printGraph(PrinterData printerData, float f) {
        if (printerData != null) {
            this.isInExporting = true;
            if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
                PlotExportUtil.printGraph(printerData, this.viewerApp, this.container.getDisplay(), this.graphColourTable, f);
            } else {
                PlotExportUtil.printGraph(printerData, this.viewerApp, this.container.getDisplay(), null, f);
            }
            this.isInExporting = false;
        }
    }

    public void printGraph() {
        this.isInExporting = true;
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            if (this.defaultPrinterData == null) {
                this.defaultPrinterData = Printer.getDefaultPrinterData();
            }
            if (this.settings == null) {
                this.settings = new PrintSettings();
            }
            PlotPrintPreviewDialog plotPrintPreviewDialog = new PlotPrintPreviewDialog(this.viewerApp, this.container.getDisplay(), this.graphColourTable, this.settings);
            this.settings = plotPrintPreviewDialog.open();
        } else {
            if (this.defaultPrinterData == null) {
                this.defaultPrinterData = Printer.getDefaultPrinterData();
            }
            if (this.settings == null) {
                this.settings = new PrintSettings();
            }
            PlotPrintPreviewDialog plotPrintPreviewDialog = new PlotPrintPreviewDialog(this.viewerApp, this.container.getDisplay(), null, this.settings);
            this.settings = plotPrintPreviewDialog.open();
        }
        this.isInExporting = false;
    }

    public synchronized void copyGraph() {
        try {
            PlotExportUtil.copyGraph(this.viewerApp);
        }
        catch (Exception exception) {
            logger.error(exception.getCause().getMessage(), (Throwable)exception);
            Status status = new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", exception.getMessage(), (Throwable)exception);
            ErrorDialog.openError((Shell)this.getComposite().getShell(), (String)"Image copy error", (String)"Error copying image to clipboard", (IStatus)status);
        }
    }

    public void update(Object object, Object object2) {
        if (object.equals((Object)this.legendTable) && (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D)) {
            ((DataSet3DPlot1D)this.plotter).updateAllGraphAppearances();
            this.viewerApp.getCurrentViewer().render();
        }
    }

    public void setPerspectiveCamera(boolean bl, boolean bl2) {
        Camera camera = CameraUtility.getCamera((Viewer)this.viewerApp.getCurrentViewer());
        if (camera.isPerspective()) {
            this.perspFOV = camera.getFieldOfView();
        } else {
            this.orthoFOV = camera.getFieldOfView();
        }
        camera.setPerspective(bl);
        if (bl) {
            camera.setFieldOfView(this.perspFOV);
        } else {
            camera.setFieldOfView(this.orthoFOV);
        }
        if (bl2) {
            this.viewerApp.getCurrentViewer().render();
        }
    }

    public void clearZoomHistory() {
        if (this.currentMode == PlottingMode.BARCHART && this.plotter != null) {
            ((HistogramChartPlot1D)this.plotter).clearZoom();
        }
    }

    public void handleEvent(Event event) {
        if (this.plotter != null) {
            Rectangle rectangle = this.plotArea.getBounds();
            this.plotter.notifyComponentResize(rectangle.width, rectangle.height);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        this.viewerApp.getCurrentViewer().render();
    }

    public void setDataWindowPosition(SurfacePlotROI surfacePlotROI) {
        if (this.currentMode == PlottingMode.SURF2D) {
            ((DataSet3DPlot3D)this.plotter).setDataWindow(surfacePlotROI);
        }
    }

    @Override
    public void legendDeleted(LegendChangeEvent legendChangeEvent) {
        int n;
        if (this.currentMode == PlottingMode.ONED && (n = legendChangeEvent.getEntryNr()) < this.currentDataSets.size()) {
            ((DataSet3DPlot1D)this.plotter).removeGraphNode(n);
            this.currentDataSets.remove(n);
            this.graphColourTable.deleteLegendEntry(n);
            --this.historyCounter;
            if (this.useLegend) {
                this.legendTable.updateTable(this.graphColourTable);
            }
            this.refresh(false);
        }
    }

    public void setPlotUpdateOperation(boolean bl) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED) {
            ((DataSet3DPlot1D)this.plotter).setUpdateOperation(bl);
        }
    }

    public void setYAxisScaling(ScaleType scaleType) {
        this.plotter.setScaling(scaleType);
    }

    public void setZAxisScaling(ScaleType scaleType) {
        if (!this.hasJOGL && this.currentMode == PlottingMode.TWOD && scaleType != this.plotter.getScaling()) {
            this.plotter.setScaling(scaleType);
            this.applyColourCast(this.cacheRedFunc, this.cacheGreenFunc, this.cacheBlueFunc, this.cacheAlphaFunc, this.cacheInverseRed, this.cacheInverseGreen, this.cacheInverseBlue, this.cacheInverseAlpha, this.cacheMinValue, this.cacheMaxValue);
        } else {
            this.plotter.setScaling(scaleType);
        }
    }

    public double stackPlotGetZAxisLengthFactor() {
        return 0.0;
    }

    public void stackPlotSetZAxisLengthFactor(double d) {
    }

    public void imagePlotSetCanvasAspectRatio(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).setCanvasAspectRation(bl);
        }
    }

    @Override
    public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
        if (this.currentMode == PlottingMode.TWOD) {
            if (this.infoBox != null) {
                this.container.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = plotActionEvent.getDataPosition()[0];
                        int n2 = plotActionEvent.getDataPosition()[1];
                        n = Math.max(n, 0);
                        n = Math.min(n, DataSetPlotter.this.currentDataSet.getShape()[1] - 1);
                        n2 = Math.max(n2, 0);
                        n2 = Math.min(n2, DataSetPlotter.this.currentDataSet.getShape()[0] - 1);
                        DataSetPlotter.this.infoBox.setPositionInfo(plotActionEvent.getPosition()[0], plotActionEvent.getPosition()[1], DataSetPlotter.this.currentDataSet.getDouble(new int[]{n2, n}));
                        if (DataSetPlotter.this.qSpace != null) {
                            DataSetPlotter.this.infoBox.setQSpaceInfo(n, n2, DataSetPlotter.this.qSpace);
                        }
                    }
                });
            }
        } else {
            logger.warn("This shouldn't be happening there should be no notifications");
        }
    }

    public void restoreDefaultPlotAreaCursor() {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSetPlotter.this.plotArea.setCursor(DataSetPlotter.this.defaultCursor);
            }
        });
    }

    public void setPlotAreaCursor(final int n) {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DataSetPlotter.this.plotArea.getDisplay().getSystemCursor(n);
                if (cursor != null) {
                    DataSetPlotter.this.plotArea.setCursor(cursor);
                }
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.getComposite().isDisposed();
    }

    @Override
    public List<AxisValues> getXAxisValues() {
        if (this.plotter == null) {
            return null;
        }
        return this.plotter.getAxisValues();
    }

    public void setAxisVisibility(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            this.coordXLabels.setVisible(bl);
            this.coordYLabels.setVisible(bl);
            this.coordZLabels.setVisible(bl);
            this.coordAxes.setVisible(bl);
            this.coordTicks.setVisible(bl);
            this.refresh(bl);
        }
    }

    public void useTransparency(boolean bl) {
        if (this.currentMode == PlottingMode.SCATTER3D) {
            ((DataSetScatterPlot3D)this.plotter).setTransparency(bl);
        }
    }

    public void useDrawOutlinesOnly(boolean bl) {
        if (this.currentMode == PlottingMode.SCATTER3D) {
            ((DataSetScatterPlot3D)this.plotter).setDrawOutlinesOnly(bl);
        }
    }

    public void useUniformSize(boolean bl) {
        if (this.currentMode == PlottingMode.SCATTER3D) {
            ((DataSetScatterPlot3D)this.plotter).setUniformSize(bl);
        }
    }

    public void setDiffractionMode(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).setDiffractionImageMode(bl);
            this.refresh(false);
        }
    }

    public void setGradientImageMode(boolean bl) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).setGradientImageMode(bl);
            this.refresh(false);
        }
    }

    public void setOverloadThreshold(double d) {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).changeThreshold(d);
            this.refresh(false);
        }
    }

    public void increaseFeatureSensitivty() {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).changeThreshold(0.9);
            this.refresh(false);
        }
    }

    public void decreaseFeatureSensitivty() {
        if (this.currentMode == PlottingMode.TWOD) {
            ((DataSet3DPlot2D)this.plotter).changeThreshold(1.1);
            this.refresh(false);
        }
    }

    public void setPlotZoomArea(double d, double d2, double d3, double d4) {
        if (this.currentMode == PlottingMode.ONED || this.currentMode == PlottingMode.ONED_THREED || this.currentMode == PlottingMode.SCATTER2D) {
            ((DataSet3DPlot1D)this.plotter).setPlotZoomArea(d, d2, d3, d4);
            this.refresh(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public synchronized void widgetSelected(SelectionEvent selectionEvent) {
        if (!this.donotProcessEvent) {
            if (selectionEvent.getSource().equals(this.hBar)) {
                if (this.currentMode == PlottingMode.TWOD) {
                    double[] dArray = this.toolNode.getTransformation().getMatrix();
                    double d = dArray[3];
                    double d2 = dArray[7];
                    double d3 = dArray[11];
                    double d4 = (double)(-this.hBar.getMaximum()) / 20.0;
                    d = -d4 - (double)((float)this.hBar.getSelection() / 10.0f);
                    MatrixBuilder.euclidean().translate(d, d2, d3).assignTo(this.toolNode);
                    this.refresh(false);
                }
            } else if (selectionEvent.getSource().equals(this.vBar) && (selectionEvent.detail != 0 || SWT.getPlatform().equals("gtk"))) {
                if (this.currentMode == PlottingMode.TWOD) {
                    double[] dArray = this.toolNode.getTransformation().getMatrix();
                    double d = dArray[3];
                    double d5 = dArray[7];
                    double d6 = dArray[11];
                    double d7 = (double)(-this.vBar.getMaximum()) / 20.0;
                    d5 = (d7 + (double)((float)this.vBar.getSelection() / 10.0f)) * (double)1.15f;
                    MatrixBuilder.euclidean().translate(d, d5, d6).assignTo(this.toolNode);
                    this.refresh(false);
                }
            } else if (selectionEvent.data != null && selectionEvent.data instanceof List && this.currentMode == PlottingMode.MULTI2D) {
                List list = (List)selectionEvent.data;
                ((DataSet3DPlot2DMulti)this.plotter).updateCompositingSettings(list);
                this.refresh(false);
            }
        }
        this.donotProcessEvent = false;
    }

    @Override
    public synchronized void panPerformed(final double d, final double d2) {
        this.hBar.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                double d4;
                double d22 = d;
                double d3 = d2;
                if (DataSetPlotter.this.hBar.isVisible()) {
                    d4 = (double)(-DataSetPlotter.this.hBar.getMaximum()) / 20.0;
                    d22 = Math.max(d22, d4 - 0.25);
                    d22 = Math.min(d22, -d4 + 0.25);
                    DataSetPlotter.this.hBar.setSelection(DataSetPlotter.this.hBar.getMaximum() - (int)((d22 - d4) * 10.0));
                }
                if (DataSetPlotter.this.vBar.isVisible()) {
                    d4 = (double)(-DataSetPlotter.this.vBar.getMaximum()) / 20.0;
                    d3 = Math.max(d3, d4 - 1.5);
                    d3 = Math.min(d3, -d4 + 1.5);
                    DataSetPlotter.this.vBar.setSelection((int)((d3 - d4) * 10.0));
                }
                MatrixBuilder.euclidean().translate(d22, d3, 0.0).assignTo(DataSetPlotter.this.toolNode);
                DataSetPlotter.this.refresh(false);
            }
        });
    }

    public Composite getPlotArea() {
        return this.plotArea;
    }

    public void enableImageScrollBars(boolean bl) {
        if (!bl) {
            if (this.hBar != null && this.hBar.isVisible()) {
                this.hBar.setVisible(bl);
            }
            if (this.vBar != null && this.vBar.isVisible()) {
                this.vBar.setVisible(bl);
            }
        }
        if (this.zoomTool != null && this.zoomTool instanceof ClickWheelZoomToolWithScrollBar) {
            ((ClickWheelZoomToolWithScrollBar)this.zoomTool).setScrollBars(bl ? this.vBar : null, bl ? this.hBar : null);
        }
        this.showScrollBars = bl;
    }

    public void hideAllPlots() {
        int n = 0;
        while (n < this.graphColourTable.getLegendSize()) {
            this.graphColourTable.getLegendEntry(n).setVisible(false);
            ++n;
        }
        this.refresh(true);
    }

    public void showAllPlots() {
        int n = 0;
        while (n < this.graphColourTable.getLegendSize()) {
            this.graphColourTable.getLegendEntry(n).setVisible(true);
            ++n;
        }
        this.refresh(true);
    }

    public void toggleErrorBars(boolean bl, boolean bl2, boolean bl3) {
        this.plotter.toggleErrorBars(bl, bl2, bl3);
    }
}

