/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.PointSetFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.compositing.CompositeEntry;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanningTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.JOGLGLSLShaderGenerator;
import uk.ac.diamond.scisoft.system.info.JOGLChecker;

public class DataSet3DPlot2DMulti
extends DataSet3DPlot2D {
    public static final int MAX_IMAGES = 7;
    private Map<Texture2D, Object> imageDatas = new HashMap<Texture2D, Object>();
    private int[] isRGB = new int[7];
    private static final Logger logger = LoggerFactory.getLogger(DataSet3DPlot2DMulti.class);

    public DataSet3DPlot2DMulti(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, PanningTool panningTool, boolean bl, boolean bl2) {
        super(abstractViewerApp, composite, cursor, panningTool, bl, bl2);
    }

    private void loadGLSLProgram(Appearance appearance, double d, double d2) {
        if (this.tableProg == null) {
            this.tableProg = new GlslProgram(appearance, "polygonShader", null, JOGLGLSLShaderGenerator.generateCompositeShader(false, this.numGraphs > 7 ? 7 : this.numGraphs), JOGLGLSLShaderGenerator.generateCompositeShaderName(false, this.numGraphs > 7 ? 7 : this.numGraphs));
        } else {
            this.tableProg.setShaders(null, JOGLGLSLShaderGenerator.generateCompositeShader(false, this.numGraphs > 7 ? 7 : this.numGraphs), JOGLGLSLShaderGenerator.generateCompositeShaderName(false, this.numGraphs > 7 ? 7 : this.numGraphs));
        }
        this.tableProg.setUniform("maxValue", d2);
        this.tableProg.setUniform("minValue", d);
    }

    @Override
    protected void setShaderOnAppearance(Appearance appearance) {
        if (this.hasJOGLshaders) {
            Texture2D texture2D = null;
            if (this.tableProg != null) {
                appearance.setAttribute("useGLSL", true);
                appearance.setAttribute("polygonShader::glsl-source", (Object)this.tableProg.getSource());
                switch (this.numGraphs) {
                    case 1: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 2: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 3: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[3]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 4: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[4]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 5: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[5]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 6: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[6]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    default: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[7]", (Appearance)appearance, (boolean)true);
                    }
                }
                int n = 0;
                while (n < (this.numGraphs < 7 ? this.numGraphs : 7)) {
                    this.tableProg.setUniform("sampler" + n, n);
                    ++n;
                }
                this.tableProg.setUniform("tableSampler", this.numGraphs < 7 ? this.numGraphs : 7);
                float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray2 = new float[21];
                int n2 = 0;
                while (n2 < 21) {
                    fArray2[n2] = 1.0f;
                    ++n2;
                }
                int[] nArray = new int[7];
                this.tableProg.setUniform("weight", fArray);
                this.tableProg.setUniform("ops", nArray);
                this.tableProg.setUniform("isRGB", this.isRGB);
                this.tableProg.setUniform("mask", fArray2);
                texture2D.setImage(this.lookupTableImg);
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
            }
        }
    }

    private void buildMessage(SceneGraphComponent sceneGraphComponent) {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[] dArray = new double[3];
        String[] stringArray = new String[]{"NO GLSL SHADER SUPPORT!\nYOU SHOULD BUY A NEWER\nGRAPHICS CARD IT IS ABOUT\nTIME!!1"};
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        sceneGraphComponent.setGeometry((Geometry)pointSetFactory.getPointSet());
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        DefaultTextShader defaultTextShader = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultTextShader.setDiffuseColor(Color.black);
        defaultTextShader.setTextdirection(Integer.valueOf(0));
        defaultTextShader.setScale(Double.valueOf(0.0075));
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        this.maxHeight = 0;
        this.maxWidth = 0;
        if (sceneGraphComponent != null) {
            this.graphGroupNode = new SceneGraphComponent("Graph Group node");
            this.overlayPrimitiveGroupNode = new SceneGraphComponent("Overlay group node");
            this.graph = sceneGraphComponent;
            if (this.hasJOGLshaders) {
                int n;
                int n2;
                for (IDataset iDataset : list) {
                    n2 = iDataset.getShape()[1];
                    n = iDataset.getShape()[0];
                    this.maxWidth = Math.max(n2, this.maxWidth);
                    this.maxHeight = Math.max(n, this.maxHeight);
                }
                this.numGraphs = 0;
                boolean bl = false;
                n2 = 0;
                n = 0;
                double[] dArray = new double[]{0.0, 0.0};
                for (IDataset object : list) {
                    n2 = object.getShape()[1];
                    n = object.getShape()[0];
                    if (!bl) {
                        dArray = this.determineXYsize();
                    }
                    int n3 = JOGLChecker.getMaxTextureHeight();
                    int n4 = JOGLChecker.getMaxTextureWidth();
                    double d = 0.0;
                    double d2 = (double)n3 / (double)this.maxHeight < 1.0 ? dArray[1] * (double)n3 / (double)this.maxHeight : dArray[1];
                    double d3 = (double)n4 / (double)this.maxWidth < 1.0 ? dArray[0] * (double)n4 / (double)this.maxWidth : dArray[0];
                    float f = (float)(d3 / dArray[0]);
                    float f2 = (float)(d2 / dArray[1]);
                    n3 = (int)((float)n3 * f2);
                    n4 = (int)((float)n4 * f);
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n) {
                        double d4 = 0.0;
                        int n7 = 0;
                        while (n7 < n2) {
                            int n8;
                            if (!bl) {
                                SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs + ".sub" + n7 + "_" + n6));
                                this.subGraphs.add(sceneGraphComponent2);
                                this.graphGroupNode.addChild(sceneGraphComponent2);
                                sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(d4 + d3 > dArray[0] ? dArray[0] - d4 : d3, d + d2 > dArray[1] ? dArray[1] - d : d2, d4, d));
                                if (object instanceof AbstractCompoundDataset) {
                                    this.tableMin = 0.0;
                                    this.tableMax = 0.0;
                                } else {
                                    this.tableMin = object.min().doubleValue();
                                    this.tableMax = object.max().doubleValue();
                                }
                                this.graphAppearance = this.createAppearance();
                                sceneGraphComponent2.setAppearance(this.graphAppearance);
                            } else {
                                this.graphAppearance = (Appearance)this.graphApps.get(n5);
                            }
                            int sceneGraphComponent2 = n2 > n4 ? n4 : n2;
                            int n9 = n8 = n > n3 ? n3 : n;
                            if (n7 + sceneGraphComponent2 > n2) {
                                sceneGraphComponent2 = n2 - n7;
                            }
                            if (n6 + n8 > n) {
                                n8 = n - n6;
                            }
                            Texture2D texture2D = null;
                            switch (this.numGraphs) {
                                case 0: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 1: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 2: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 3: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[3]", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 4: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[4]", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 5: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[5]", (Appearance)this.graphAppearance, (boolean)true);
                                    break;
                                }
                                case 6: {
                                    texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[6]", (Appearance)this.graphAppearance, (boolean)true);
                                }
                            }
                            if (texture2D != null) {
                                boolean bl2 = object instanceof RGBDataset || object instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)object).getElementsPerItem() == 3 || ((AbstractCompoundDataset)object).getElementsPerItem() == 4);
                                this.isRGB[this.numGraphs] = bl2 ? 1 : 0;
                                this.generateTexture(object, texture2D, n7, n6, sceneGraphComponent2, n8, bl2);
                            }
                            n7 += n4;
                            d4 += d3;
                            ++n5;
                        }
                        n6 += n3;
                        d += d2;
                    }
                    bl = true;
                    ++this.numGraphs;
                }
                this.determineRanges(list);
                for (Appearance appearance : this.graphApps) {
                    this.loadGLSLProgram(appearance, this.tableMin, this.tableMax);
                    this.setShaderOnAppearance(appearance);
                }
                this.setupOtherNodes();
            } else {
                this.buildMessage(sceneGraphComponent);
                logger.warn("No shader support! Get a new graphics card or install proper drivers, it's about time!");
            }
        }
        return sceneGraphComponent;
    }

    protected void generateFloatTexture(IDataset iDataset, Texture2D texture2D, int n, int n2, int n3, int n4, boolean bl) {
        float[] fArray;
        if (bl) {
            fArray = new float[n3 * n4];
            this.imageDatas.put(texture2D, fArray);
        }
        fArray = (float[])this.imageDatas.get(texture2D);
        FloatDataset floatDataset = (FloatDataset)DatasetUtils.cast((AbstractDataset)DatasetUtils.convertToAbstractDataset((ILazyDataset)iDataset), (int)5);
        if (n3 == floatDataset.getShape()[1] && n4 == floatDataset.getShape()[0]) {
            fArray = floatDataset.getData();
        } else {
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < n3) {
                    fArray[n6 + n5 * n3] = floatDataset.getFloat(new int[]{floatDataset.getShape()[0] - 1 - (n2 + (n4 - 1 - n5)), n + n6});
                    ++n6;
                }
                ++n5;
            }
        }
        if (bl) {
            texture2D.setImage(new ImageData(fArray, n3, n4));
            texture2D.setRepeatS(Integer.valueOf(33071));
            texture2D.setRepeatT(Integer.valueOf(33071));
            texture2D.setMagFilter(Integer.valueOf(9728));
            texture2D.setMinFilter(Integer.valueOf(9729));
            texture2D.setMipmapMode(Boolean.valueOf(true));
            System.gc();
        } else {
            ImageData imageData = texture2D.getImage();
            imageData.updateData(fArray);
        }
    }

    private void generateRGBTexture(AbstractCompoundDataset abstractCompoundDataset, Texture2D texture2D, int n, int n2, int n3, int n4, boolean bl) {
        RGBDataset rGBDataset;
        byte[] byArray;
        if (bl) {
            byArray = new byte[n3 * n4 * 4];
            this.imageDatas.put(texture2D, byArray);
        }
        byArray = (byte[])this.imageDatas.get(texture2D);
        int n5 = 0;
        int n6 = abstractCompoundDataset.getShape()[0];
        if (abstractCompoundDataset instanceof RGBDataset) {
            rGBDataset = (RGBDataset)abstractCompoundDataset;
            short[] sArray = rGBDataset.getData();
            int n7 = rGBDataset.getShape()[1];
            int n8 = 0;
            while (n8 < n4) {
                int n9 = (n + (n6 - 1 - n2 - (n4 - 1 - n8)) * n7) * 3;
                int n10 = 0;
                while (n10 < n3) {
                    short s = sArray[n9++];
                    short s2 = sArray[n9++];
                    short s3 = sArray[n9++];
                    byArray[n5++] = (byte)s;
                    byArray[n5++] = (byte)s2;
                    byArray[n5++] = (byte)s3;
                    byArray[n5++] = -1;
                    ++n10;
                }
                ++n8;
            }
        } else {
            int n11 = abstractCompoundDataset.getElementsPerItem();
            switch (abstractCompoundDataset.getDtype()) {
                case 100: {
                    CompoundByteDataset compoundByteDataset = (CompoundByteDataset)abstractCompoundDataset;
                    int n12 = 0;
                    while (n12 < n4) {
                        int n13 = n6 - 1 - n2 - (n4 - 1 - n12);
                        int n14 = 0;
                        while (n14 < n3) {
                            byte[] byArray2 = compoundByteDataset.getByteArray(new int[]{n13, n14 + n});
                            byArray[n5++] = byArray2[0];
                            byArray[n5++] = byArray2[1];
                            byArray[n5++] = byArray2[2];
                            byArray[n5++] = n11 > 3 ? byArray2[3] : -1;
                            ++n14;
                        }
                        ++n12;
                    }
                    break;
                }
                case 200: {
                    CompoundShortDataset compoundShortDataset = (CompoundShortDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray2 = abstractCompoundDataset.maxItem();
                    short s = (short)Math.max(1, (short)(dArray2[0] - dArray[0]));
                    short s4 = (short)Math.max(1.0, dArray2[1] - dArray[1]);
                    short s5 = (short)Math.max(1.0, dArray2[2] - dArray[2]);
                    short s6 = n11 > 3 ? (short)(dArray2[3] - dArray[3]) : (short)0;
                    int n15 = 0;
                    while (n15 < n4) {
                        int n16 = n6 - 1 - n2 - (n4 - 1 - n15);
                        int n17 = 0;
                        while (n17 < n3) {
                            short[] sArray = compoundShortDataset.getShortArray(new int[]{n16, n17 + n});
                            short s7 = sArray[0];
                            short s8 = sArray[1];
                            short s9 = sArray[2];
                            int n18 = n11 > 3 ? sArray[3] : 255;
                            double d = ((double)s7 - dArray[0]) / (double)s;
                            s7 = (short)(255.0 * d);
                            d = ((double)s8 - dArray[1]) / (double)s4;
                            s8 = (short)(255.0 * d);
                            d = ((double)s9 - dArray[2]) / (double)s5;
                            s9 = (short)(255.0 * d);
                            if (s6 != 0) {
                                d = ((double)n18 - dArray[3]) / (double)s6;
                                n18 = (short)(255.0 * d);
                            }
                            byArray[n5++] = (byte)s7;
                            byArray[n5++] = (byte)s8;
                            byArray[n5++] = (byte)s9;
                            byArray[n5++] = (byte)n18;
                            ++n17;
                        }
                        ++n15;
                    }
                    break;
                }
                case 300: {
                    CompoundIntegerDataset compoundIntegerDataset = (CompoundIntegerDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray3 = abstractCompoundDataset.maxItem();
                    int n19 = (int)Math.max(1.0, dArray3[0] - dArray[0]);
                    int n20 = (int)Math.max(1.0, dArray3[1] - dArray[1]);
                    int n21 = (int)Math.max(1.0, dArray3[2] - dArray[2]);
                    int n22 = n11 > 3 ? (int)(dArray3[3] - dArray[3]) : 0;
                    int n23 = 0;
                    while (n23 < n4) {
                        int n24 = n6 - 1 - n2 - (n4 - 1 - n23);
                        int n25 = 0;
                        while (n25 < n3) {
                            int[] nArray = compoundIntegerDataset.getIntegerArray(new int[]{n24, n25 + n});
                            int n26 = nArray[0];
                            int n27 = nArray[1];
                            int n28 = nArray[2];
                            int n29 = n11 > 3 ? nArray[3] : 255;
                            double d = ((double)n26 - dArray[0]) / (double)n19;
                            n26 = (int)(255.0 * d);
                            d = ((double)n27 - dArray[1]) / (double)n20;
                            n27 = (int)(255.0 * d);
                            d = ((double)n28 - dArray[2]) / (double)n21;
                            n28 = (int)(255.0 * d);
                            if (n22 != 0) {
                                d = ((double)n28 - dArray[2]) / (double)n22;
                                n29 = (int)(255.0 * d);
                            }
                            byArray[n5++] = (byte)n26;
                            byArray[n5++] = (byte)n27;
                            byArray[n5++] = (byte)n28;
                            byArray[n5++] = (byte)n29;
                            ++n25;
                        }
                        ++n23;
                    }
                    break;
                }
                case 400: {
                    CompoundLongDataset compoundLongDataset = (CompoundLongDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray4 = abstractCompoundDataset.maxItem();
                    long l = (long)Math.max(1.0, dArray4[0] - dArray[0]);
                    long l2 = (long)Math.max(1.0, dArray4[1] - dArray[1]);
                    long l3 = (long)Math.max(1.0, dArray4[2] - dArray[2]);
                    long l4 = n11 > 3 ? (long)(dArray4[3] - dArray[3]) : 0L;
                    int n30 = 0;
                    while (n30 < n4) {
                        int n31 = n6 - 1 - n2 - (n4 - 1 - n30);
                        int n32 = 0;
                        while (n32 < n3) {
                            long[] lArray = compoundLongDataset.getLongArray(new int[]{n31, n32 + n});
                            long l5 = lArray[0];
                            long l6 = lArray[1];
                            long l7 = lArray[2];
                            long l8 = n11 > 3 ? lArray[3] : 255L;
                            double d = ((double)l5 - dArray[0]) / (double)l;
                            l5 = (long)(255.0 * d);
                            d = ((double)l6 - dArray[1]) / (double)l2;
                            l6 = (long)(255.0 * d);
                            d = ((double)l7 - dArray[2]) / (double)l3;
                            l7 = (long)(255.0 * d);
                            if (l4 != 0L) {
                                d = ((double)l7 - dArray[2]) / (double)l4;
                                l8 = (long)(255.0 * d);
                            }
                            byArray[n5++] = (byte)l5;
                            byArray[n5++] = (byte)l6;
                            byArray[n5++] = (byte)l7;
                            byArray[n5++] = (byte)l8;
                            ++n32;
                        }
                        ++n30;
                    }
                    break;
                }
                case 500: 
                case 600: {
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray5 = abstractCompoundDataset.maxItem();
                    double d = dArray5[0] - dArray[0];
                    double d2 = dArray5[1] - dArray[1];
                    double d3 = dArray5[2] - dArray[2];
                    double d4 = n11 > 3 ? dArray5[3] - dArray[3] : 0.0;
                    double[] dArray6 = new double[4];
                    int n33 = 0;
                    while (n33 < n4) {
                        int n34 = n6 - 1 - n2 - (n4 - 1 - n33);
                        int n35 = 0;
                        while (n35 < n3) {
                            abstractCompoundDataset.getDoubleArray(dArray6, new int[]{n34, n35 + n});
                            double d5 = dArray6[0];
                            double d6 = dArray6[1];
                            double d7 = dArray6[2];
                            double d8 = n11 > 3 ? dArray6[3] : 255.0;
                            d5 = 255.0 * ((d5 - dArray[0]) / d);
                            d6 = 255.0 * ((d6 - dArray[1]) / d2);
                            d7 = 255.0 * ((d7 - dArray[2]) / d3);
                            if (d4 != 0.0) {
                                d8 = 255.0 * ((d8 - dArray[3]) / d4);
                            }
                            byArray[n5++] = (byte)d5;
                            byArray[n5++] = (byte)d6;
                            byArray[n5++] = (byte)d7;
                            byArray[n5++] = (byte)d8;
                            ++n35;
                        }
                        ++n33;
                    }
                    break;
                }
            }
        }
        if (bl) {
            texture2D.setImage(new ImageData(byArray, n3, n4));
            texture2D.setRepeatS(Integer.valueOf(33071));
            texture2D.setRepeatT(Integer.valueOf(33071));
            texture2D.setMagFilter(Integer.valueOf(9728));
            texture2D.setMinFilter(Integer.valueOf(9729));
            texture2D.setMipmapMode(Boolean.valueOf(true));
            System.gc();
        } else if (texture2D != null) {
            rGBDataset = texture2D.getImage();
            rGBDataset.updateData(byArray);
        }
    }

    private void generateTexture(IDataset iDataset, Texture2D texture2D, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            Object object = this.imageDatas.get(texture2D);
            if (object == null || !(object instanceof float[]) || ((float[])object).length != n3 * n4) {
                bl2 = true;
            }
            this.generateFloatTexture(iDataset, texture2D, n, n2, n3, n4, bl2);
        } else {
            Object object = this.imageDatas.get(texture2D);
            if (object == null || !(object instanceof byte[]) || ((byte[])object).length != n3 * n4 * 4) {
                bl2 = true;
            }
            this.generateRGBTexture((AbstractCompoundDataset)iDataset, texture2D, n, n2, n3, n4, bl2);
        }
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        if (this.tableProg != null) {
            this.tableMin = d;
            this.tableMax = d2;
            this.tableProg.setUniform("minValue", this.tableMin);
            this.tableProg.setUniform("maxValue", this.tableMax);
            byte[] byArray = new byte[colourImageData.getWidth() * 4];
            int n = 0;
            while (n < colourImageData.getWidth()) {
                int n2 = colourImageData.get(n, 0);
                byte by = (byte)(n2 >> 16 & 0xFF);
                byte by2 = (byte)(n2 >> 8 & 0xFF);
                byte by3 = (byte)(n2 & 0xFF);
                byArray[n * 4] = by;
                byArray[n * 4 + 1] = by2;
                byArray[n * 4 + 2] = by3;
                byArray[n * 4 + 3] = -1;
                ++n;
            }
            this.lookupTableImg = null;
            this.lookupTableImg = new ImageData(byArray, colourImageData.getWidth(), 1);
            for (Appearance appearance : this.graphApps) {
                Texture2D texture2D = null;
                switch (this.numGraphs) {
                    case 1: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 2: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 3: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[3]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 4: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[4]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 5: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[5]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    case 6: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[6]", (Appearance)appearance, (boolean)true);
                        break;
                    }
                    default: {
                        texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[7]", (Appearance)appearance, (boolean)true);
                    }
                }
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
                texture2D.setImage(this.lookupTableImg);
            }
        }
    }

    private void updateGraphNodes(Iterator<SceneGraphComponent> iterator, List<SceneGraphComponent> list, double d, double d2, int n, int n2) {
        int n3 = JOGLChecker.getMaxTextureHeight();
        int n4 = JOGLChecker.getMaxTextureWidth();
        double d3 = 0.0;
        double d4 = (double)n3 / (double)this.maxHeight < 1.0 ? d2 * (double)n3 / (double)this.maxHeight : d2;
        double d5 = (double)n4 / (double)this.maxWidth < 1.0 ? d * (double)n4 / (double)this.maxWidth : d;
        int n5 = 0;
        while (n5 < n) {
            double d6 = 0.0;
            int n6 = 0;
            while (n6 < n2) {
                SceneGraphComponent sceneGraphComponent = null;
                if (iterator.hasNext()) {
                    sceneGraphComponent = iterator.next();
                } else {
                    sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs + ".sub" + n6 + "_" + n5));
                    list.add(sceneGraphComponent);
                    this.graphGroupNode.addChild(sceneGraphComponent);
                    Appearance appearance = this.createAppearance();
                    this.graphApps.add(appearance);
                    sceneGraphComponent.setAppearance(appearance);
                }
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(d6 + d5 > d ? d - d6 : d5, d3 + d4 > d2 ? d2 - d3 : d4, d6, d3));
                n6 += n4;
                d6 += d5;
            }
            n5 += n3;
            d3 += d4;
        }
    }

    private void updateTextures(List<IDataset> list, double d, double d2) {
        Iterator<IDataset> iterator = list.iterator();
        this.numGraphs = 0;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            int n = JOGLChecker.getMaxTextureHeight();
            int n2 = JOGLChecker.getMaxTextureWidth();
            double d3 = (double)n / (double)this.maxHeight < 1.0 ? d2 * (double)n / (double)this.maxHeight : d2;
            double d4 = (double)n2 / (double)this.maxWidth < 1.0 ? d * (double)n2 / (double)this.maxWidth : d;
            float f = (float)(d4 / d);
            float f2 = (float)(d3 / d2);
            n = (int)((float)n * f2);
            n2 = (int)((float)n2 * f);
            int n3 = iDataset.getShape()[1];
            int n4 = iDataset.getShape()[0];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                int n7 = 0;
                while (n7 < n3) {
                    int n8;
                    this.graphAppearance = (Appearance)this.graphApps.get(n5);
                    int n9 = n3 > n2 ? n2 : n3;
                    int n10 = n8 = n4 > n ? n : n4;
                    if (n7 + n9 > n3) {
                        n9 = this.maxWidth - n7;
                    }
                    if (n6 + n8 > n4) {
                        n8 = this.maxHeight - n6;
                    }
                    Texture2D texture2D = null;
                    switch (this.numGraphs) {
                        case 0: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 1: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 2: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 3: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[3]", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 4: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[4]", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 5: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[5]", (Appearance)this.graphAppearance, (boolean)true);
                            break;
                        }
                        case 6: {
                            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[6]", (Appearance)this.graphAppearance, (boolean)true);
                        }
                    }
                    if (texture2D != null) {
                        boolean bl = iDataset instanceof RGBDataset || iDataset instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)iDataset).getElementsPerItem() == 3 || ((AbstractCompoundDataset)iDataset).getElementsPerItem() == 4);
                        this.isRGB[this.numGraphs] = bl ? 1 : 0;
                        this.generateTexture(iDataset, texture2D, n7, n6, n9, n8, bl);
                    }
                    n7 += n2;
                    ++n5;
                }
                n6 += n;
            }
            ++this.numGraphs;
        }
    }

    @Override
    public void updateGraph(IDataset iDataset) {
        logger.warn("This function is not supported!");
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        if (list.size() > 0 && this.subGraphs.size() > 0 && this.hasJOGLshaders) {
            Object object;
            Object object2;
            Iterator<IDataset> iterator = list.iterator();
            ((SceneGraphComponent)this.subGraphs.get(this.subGraphs.size() - 1)).removeChild(this.overlayPrimitiveGroupNode);
            Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
            this.maxWidth = 0;
            this.maxHeight = 0;
            LinkedList<SceneGraphComponent> linkedList = new LinkedList<SceneGraphComponent>();
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                object2 = iterator.next();
                n = object2.getShape()[1];
                n2 = object2.getShape()[0];
                this.maxWidth = Math.max(n, this.maxWidth);
                this.maxHeight = Math.max(n2, this.maxHeight);
            }
            if (this.maxWidth >= this.maxHeight) {
                d = 15.0;
                d2 = 15.0 * (double)this.maxHeight / (double)this.maxWidth;
            } else {
                d2 = 15.0;
                d = 15.0 * (double)this.maxWidth / (double)this.maxHeight;
            }
            d = Math.max(d, 3.0);
            d2 = Math.max(d2, 3.0);
            this.updateGraphNodes(iterator2, linkedList, d, d2, n2, n);
            object2 = new LinkedList();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                ((LinkedList)object2).add(object);
                object.setGeometry(null);
                this.graphGroupNode.removeChild(object);
                this.graphApps.remove(object.getAppearance());
            }
            this.subGraphs.removeAll((Collection<?>)object2);
            this.subGraphs.addAll(linkedList);
            ((SceneGraphComponent)this.subGraphs.get(this.subGraphs.size() - 1)).addChild(this.overlayPrimitiveGroupNode);
            ((LinkedList)object2).clear();
            linkedList.clear();
            this.posTool.setImageHeight(this.maxHeight);
            this.posTool.setImageWidth(this.maxWidth);
            object = this.determineXYsize();
            this.updateClipPlanePositions((double[])object);
            this.posTool.setMaxXY((double)object[0], (double)object[1]);
            this.panTool.setDataDimension((double)object[0], (double)object[1]);
            this.determineRanges(list);
            this.imageDatas.clear();
            this.updateTextures(list, d, d2);
            for (Appearance appearance : this.graphApps) {
                this.loadGLSLProgram(appearance, this.tableMin, this.tableMax);
                this.setShaderOnAppearance(appearance);
            }
            if (this.xTickNode != null) {
                this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTickNode != null) {
                this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
            }
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
            if (this.yLabelNode != null) {
                this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
            }
            if (this.titleLabel != null) {
                this.titleLabel.setGeometry((Geometry)this.createTitleGeometry());
            }
            this.axis.setGeometry((Geometry)this.createAxisGeometry((double)object[0], (double)object[1]));
            this.createYAxisLabelGeom();
            this.createXAxisLabelGeom();
        }
    }

    public void updateCompositingSettings(List<CompositeEntry> list) {
        if (this.tableProg != null) {
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            float[] fArray2 = new float[21];
            int[] nArray = new int[7];
            int n = 0;
            while (n < (list.size() < 7 ? list.size() : 7)) {
                fArray[n] = list.get(n).getWeight();
                fArray2[n * 3] = (list.get(n).getChannelMask() & 1) == 1 ? 1.0f : 0.0f;
                fArray2[n * 3 + 1] = (list.get(n).getChannelMask() & 2) == 2 ? 1.0f : 0.0f;
                fArray2[n * 3 + 2] = (list.get(n).getChannelMask() & 4) == 4 ? 1.0f : 0.0f;
                switch (list.get(n).getOperation()) {
                    case ADD: {
                        nArray[n] = 0;
                        break;
                    }
                    case SUBTRACT: {
                        nArray[n] = 1;
                        break;
                    }
                    case MULTIPLY: {
                        nArray[n] = 2;
                        break;
                    }
                    case DIVIDE: {
                        nArray[n] = 3;
                        break;
                    }
                    case MAX: {
                        nArray[n] = 4;
                        break;
                    }
                    case MIN: {
                        nArray[n] = 5;
                    }
                }
                ++n;
            }
            this.tableProg.setUniform("weight", fArray);
            this.tableProg.setUniform("ops", nArray);
            this.tableProg.setUniform("mask", fArray2);
        }
    }
}

