/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ScalingUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.TickFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider2;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayImage;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.enums.LabelOrientation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.ArrowObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.BoxObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.CircleObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.CircleSectorObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.EllipseObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.LineObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.OverlayObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.PointListObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.PointObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.TextLabelObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.TriangleObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.ArrowPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.BoxPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.CirclePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.CircleSectorPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.EllipsePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.LabelPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.LinePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.OverlayPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.PointListPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.PointPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.RingPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.TrianglePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ImagePositionTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanningTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionTool2D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.JOGLGLSLShaderGenerator;
import uk.ac.diamond.scisoft.system.info.JOGLChecker;

public class DataSet3DPlot2D
implements IDataSet3DCorePlot,
Overlay2DProvider2,
TransformationListener,
PlotActionEventListener {
    protected boolean hasJOGLshaders;
    protected int maxWidth = 0;
    protected int maxHeight = 0;
    protected int numGraphs = 0;
    protected double tableMin = 0.0;
    protected double tableMax = 0.0;
    protected SceneGraphComponent graphGroupNode = null;
    protected SceneGraphComponent overlayPrimitiveGroupNode = null;
    protected SceneGraphComponent graph = null;
    protected List<SceneGraphComponent> subGraphs = Collections.synchronizedList(new LinkedList());
    protected List<Appearance> graphApps = Collections.synchronizedList(new LinkedList());
    protected Appearance graphAppearance;
    protected GlslProgram tableProg = null;
    protected ImageData lookupTableImg = null;
    protected ImagePositionTool posTool;
    protected PanningTool panTool;
    protected SceneGraphComponent xTickNode = null;
    protected SceneGraphComponent yTickNode = null;
    protected SceneGraphComponent xLabelNode = null;
    protected SceneGraphComponent yLabelNode = null;
    protected SceneGraphComponent titleLabel = null;
    protected SceneGraphComponent axis = null;
    private static final Logger logger = LoggerFactory.getLogger(DataSet3DPlot2D.class);
    private AbstractViewerApp app;
    private SceneGraphComponent xAxisLabel = null;
    private SceneGraphComponent yAxisLabel = null;
    private DefaultTextShader dtsXAxisLabel;
    private DefaultTextShader dtsYAxisLabel;
    private DefaultTextShader dtsTitleLabel;
    private DefaultTextShader dtsXTicks;
    private DefaultTextShader dtsYTicks;
    private SceneGraphComponent ticksNode = null;
    private SceneGraphComponent leftClip = null;
    private SceneGraphComponent rightClip = null;
    private SceneGraphComponent topClip = null;
    private SceneGraphComponent bottomClip = null;
    private SceneGraphComponent background = null;
    private String titleLabelStr = null;
    private Map<Integer, OverlayPrimitive> prim2DMap = Collections.synchronizedMap(new HashMap(1000));
    private List<PlotActionEventListener> actionListeners = Collections.synchronizedList(new LinkedList());
    String xAxisLabelStr = null;
    String yAxisLabelStr = null;
    private double globalRealXmin = 0.0;
    private double globalRealXmax = 1.0;
    private double globalRealYmin = 0.0;
    private double globalRealYmax = 1.0;
    private double threshold = 65535.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private boolean hasJOGL;
    private boolean useLogarithmic = false;
    private boolean useCanvasAspect = false;
    private boolean useDiffractionMode = false;
    private boolean useGradientMode = false;
    private TickFactory tickFactory = null;
    private TickFormatting xLabelMode = TickFormatting.plainMode;
    private TickFormatting yLabelMode = TickFormatting.plainMode;
    private AxisMode xAxis = AxisMode.LINEAR;
    private AxisMode yAxis = AxisMode.LINEAR;
    private AxisValues xAxisValues;
    private AxisValues yAxisValues;
    private PlotActionTool2D actionTool;
    private Composite plotArea;
    private Cursor defaultCursor;
    private boolean overlayInOperation = false;
    private int primKeyID = 0;
    private int canvasWidth = 1;
    private int canvasHeight = 1;
    private byte[] softwareImageRGBAdata = null;
    private Overlay2DConsumer consumer;
    private double inverseScaling = 1.0;
    private double labelScaling = 1.0;
    private static double MINX = 6.0;
    private Map<Appearance, Texture2D> overlayTextures;
    private Map<Appearance, float[]> imageDatas;
    private Map<Appearance, Texture2D> textures;
    private Map<Appearance, byte[]> softwareImageRGBAdatas;
    private OverlayImage overlayImage;
    private ScaleType currentScale = ScaleType.LINEAR;
    private int lastImageType = -1;
    private int currentImageType = -1;
    private static /* synthetic */ int[] $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType;

    public DataSet3DPlot2D(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, PanningTool panningTool, boolean bl, boolean bl2) {
        this.app = abstractViewerApp;
        this.panTool = panningTool;
        this.plotArea = composite;
        this.defaultCursor = cursor;
        this.hasJOGL = bl;
        this.hasJOGLshaders = bl2;
        if (this.hasJOGLshaders) {
            byte[] byArray = new byte[1024];
            int n = 0;
            while (n < 256) {
                byArray[n * 4] = (byte)(n >> 2);
                byArray[n * 4 + 1] = (byte)(255 - n);
                byArray[n * 4 + 2] = (byte)(n >> 3);
                byArray[n * 4 + 3] = -1;
                ++n;
            }
            this.lookupTableImg = new ImageData(byArray, 256, 1);
        }
        this.textures = new HashMap<Appearance, Texture2D>();
        this.imageDatas = new HashMap<Appearance, float[]>();
        this.overlayTextures = new HashMap<Appearance, Texture2D>();
        this.softwareImageRGBAdatas = new HashMap<Appearance, byte[]>();
        this.tickFactory = new TickFactory(this.xLabelMode);
        this.posTool = new ImagePositionTool(this.maxWidth, this.maxHeight, 15.0, 15.0);
        this.actionTool = new PlotActionTool2D();
        this.actionTool.addPlotActionEventListener(this);
    }

    @Override
    public SceneGraphComponent buildBoundingBox() {
        return null;
    }

    private void refresh() {
        try {
            this.app.getCurrentViewer().render();
        }
        catch (SWTException sWTException) {}
    }

    protected double[] determineXYsize() {
        double[] dArray = new double[2];
        if (!this.useCanvasAspect) {
            if (this.maxWidth >= this.maxHeight) {
                dArray[0] = 15.0;
                dArray[1] = 15.0 * (double)this.maxHeight / (double)this.maxWidth;
            } else {
                dArray[1] = 15.0;
                dArray[0] = 15.0 * (double)this.maxWidth / (double)this.maxHeight;
            }
            dArray[0] = Math.max(dArray[0], 3.0);
            dArray[1] = Math.max(dArray[1], 3.0);
        } else if (this.canvasWidth >= this.canvasHeight) {
            dArray[0] = 15.0;
            dArray[1] = 15.0 * (double)this.canvasHeight / (double)this.canvasWidth;
        } else {
            dArray[1] = 15.0;
            dArray[0] = 15.0 * (double)this.canvasWidth / (double)this.canvasHeight;
        }
        return dArray;
    }

    protected IndexedLineSet createXTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, d, d2, (short)0, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size() * 2);
        double[] dArray2 = this.determineXYsize();
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        int n2 = 0;
        while (n2 < linkedList.size()) {
            double d3 = this.tickFactory.getTickUnit() * (double)n2;
            dArray[n2 * 2][0] = d3 / (this.globalRealXmax - d) * dArray2[0];
            dArray[n2 * 2][1] = -0.125;
            dArray[n2 * 2][2] = 0.0;
            dArray[n2 * 2 + 1][0] = d3 / (this.globalRealXmax - d) * dArray2[0];
            dArray[n2 * 2 + 1][1] = 0.0;
            dArray[n2 * 2 + 1][2] = 0.0;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createYTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[] dArray = this.determineXYsize();
        double[][] dArray2 = ArrayPoolUtility.getDoubleArray(linkedList.size() * 2);
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        double d = this.globalRealYmax - this.globalRealYmin;
        double d2 = dArray[1] * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        int n2 = 0;
        while (n2 < linkedList.size()) {
            dArray2[n2 * 2][0] = -0.125;
            dArray2[n2 * 2][1] = dArray[1] - (double)n2 * d2;
            dArray2[n2 * 2][2] = 0.0;
            dArray2[n2 * 2 + 1][0] = 0.0;
            dArray2[n2 * 2 + 1][1] = dArray[1] - (double)n2 * d2;
            dArray2[n2 * 2 + 1][2] = 0.0;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray2);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxesTicks() {
        if (this.ticksNode == null) {
            this.ticksNode = SceneGraphUtility.createFullSceneGraphComponent((String)"ticks");
            this.xTickNode = SceneGraphUtility.createFullSceneGraphComponent((String)"xTicks");
            this.yTickNode = SceneGraphUtility.createFullSceneGraphComponent((String)"yTicks");
            this.ticksNode.addChild(this.xTickNode);
            this.ticksNode.addChild(this.yTickNode);
            Appearance appearance = new Appearance();
            this.xTickNode.setAppearance(appearance);
            this.yTickNode.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        return this.ticksNode;
    }

    private IndexedFaceSet createBackground() {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = -5.0;
        dArray[0][0][1] = 20.0;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = 20.0;
        dArray[0][1][1] = 20.0;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = -5.0;
        dArray[1][0][1] = -5.0;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = 20.0;
        dArray[1][1][1] = -5.0;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private void buildBackground(SceneGraphComponent sceneGraphComponent) {
        this.background = SceneGraphUtility.createFullSceneGraphComponent((String)"background");
        sceneGraphComponent.addChild(this.background);
        this.background.setGeometry((Geometry)this.createBackground());
        Appearance appearance = new Appearance();
        this.background.setAppearance(appearance);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("transparencyEnabled", true);
        appearance.setAttribute("additiveBlendingEnabled", false);
        appearance.setAttribute("polygonShader.transparency", 1.0);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(true));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
    }

    protected IndexedLineSet createAxisGeometry(double d, double d2) {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(4);
        indexedLineSetFactory.setEdgeCount(2);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(4);
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = d;
        dArray[1][1] = 0.0;
        dArray[1][2] = 0.0;
        dArray[2][0] = 0.0;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = d2;
        dArray[3][2] = 0.0;
        int[][] nArray = ArrayPoolUtility.getIntArray(2);
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 2;
        nArray[1][1] = 3;
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxis(SceneGraphComponent sceneGraphComponent) {
        this.axis = sceneGraphComponent;
        this.xAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"xAxisLabel");
        this.yAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"yAxisLabel");
        this.titleLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"titleLabel");
        sceneGraphComponent.addChild(this.xAxisLabel);
        sceneGraphComponent.addChild(this.yAxisLabel);
        sceneGraphComponent.addChild(this.titleLabel);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        double[] dArray = this.determineXYsize();
        sceneGraphComponent.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setLineWidth(Double.valueOf(2.0));
        defaultLineShader.setDiffuseColor(Color.black);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        Appearance appearance2 = new Appearance();
        Appearance appearance3 = new Appearance();
        Appearance appearance4 = new Appearance();
        this.xAxisLabel.setAppearance(appearance2);
        this.yAxisLabel.setAppearance(appearance3);
        this.titleLabel.setAppearance(appearance4);
        appearance2.setAttribute("pointShader.spheresDraw", false);
        appearance3.setAttribute("pointShader.spheresDraw", false);
        appearance4.setAttribute("pointShader.spheresDraw", false);
        DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsXAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXAxisLabel.setDiffuseColor(Color.black);
        this.dtsXAxisLabel.setTextdirection(Integer.valueOf(0));
        this.dtsXAxisLabel.setScale(Double.valueOf(0.0075));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance3, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsYAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYAxisLabel.setDiffuseColor(Color.black);
        this.dtsYAxisLabel.setTextdirection(Integer.valueOf(1));
        this.dtsYAxisLabel.setScale(Double.valueOf(0.0075));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance4, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsTitleLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        this.dtsTitleLabel.setDiffuseColor(Color.black);
        this.dtsTitleLabel.setTextdirection(Integer.valueOf(0));
        this.dtsTitleLabel.setScale(Double.valueOf(0.0075));
        Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n == 0) {
            n = 490;
        }
        if (n2 == 0) {
            n2 = 475;
        }
        MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(sceneGraphComponent);
        double d = 1.0;
        if (n < 490) {
            d = 490.0 / (double)dimension.width;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)dimension.height);
        }
        if (d > 1.0) {
            this.dtsXAxisLabel.setScale(Double.valueOf(0.0075 * d));
            this.dtsYAxisLabel.setScale(Double.valueOf(0.0075 * d));
            this.dtsTitleLabel.setScale(Double.valueOf(0.0075 * d));
        }
        return sceneGraphComponent;
    }

    protected IndexedFaceSet createGraphGeometry(double d, double d2, double d3, double d4) {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = d3;
        dArray[0][0][1] = d4 + d2;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = d3 + d;
        dArray[0][1][1] = d4 + d2;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = d3;
        dArray[1][0][1] = d4;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = d3 + d;
        dArray[1][1][1] = d4;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.setGenerateTextureCoordinates(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private Texture2D generateSoftwareTexture(Appearance appearance, ImageData imageData) {
        Texture2D texture2D = null;
        texture2D = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)imageData);
        texture2D.setRepeatS(Integer.valueOf(33071));
        texture2D.setRepeatT(Integer.valueOf(33071));
        texture2D.setMagFilter(Integer.valueOf(9728));
        texture2D.setMinFilter(Integer.valueOf(9728));
        texture2D.setMipmapMode(Boolean.valueOf(true));
        return texture2D;
    }

    private void generateOverlayTexture(Appearance appearance) {
        Texture2D texture2D = this.overlayTextures.get(appearance);
        texture2D.getImage().updateData(this.overlayImage.getImageData());
        this.overlayImage.clean();
    }

    protected void generateFloatTexture(IDataset iDataset, Appearance appearance, int n, int n2, int n3, int n4, boolean bl) {
        float[] fArray;
        if (bl) {
            fArray = new float[n3 * n4];
            this.imageDatas.put(appearance, fArray);
        }
        fArray = this.imageDatas.get(appearance);
        Texture2D texture2D = this.textures.get(appearance);
        FloatDataset floatDataset = (FloatDataset)DatasetUtils.cast((AbstractDataset)DatasetUtils.convertToAbstractDataset((ILazyDataset)iDataset), (int)5);
        if (n3 == floatDataset.getShape()[1] && n4 == floatDataset.getShape()[0]) {
            fArray = floatDataset.getData();
        } else {
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < n3) {
                    fArray[n6 + n5 * n3] = floatDataset.getFloat(new int[]{floatDataset.getShape()[0] - 1 - (n2 + (n4 - 1 - n5)), n + n6});
                    ++n6;
                }
                ++n5;
            }
        }
        if (!bl) {
            boolean bl2 = bl = texture2D == null || texture2D.getImage().getHeight() != n4 || texture2D.getImage().getWidth() != n3;
        }
        if (bl) {
            ImageData imageData = new ImageData(fArray, n3, n4);
            texture2D = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)imageData);
            texture2D.setRepeatS(Integer.valueOf(33071));
            texture2D.setRepeatT(Integer.valueOf(33071));
            texture2D.setMagFilter(Integer.valueOf(9728));
            texture2D.setMinFilter(Integer.valueOf(9729));
            texture2D.setMipmapMode(Boolean.valueOf(true));
            imageData = null;
            this.textures.put(appearance, texture2D);
            System.gc();
        } else if (texture2D != null) {
            ImageData imageData = texture2D.getImage();
            imageData.updateData(fArray);
        } else {
            logger.warn("Upps no texture to update found");
        }
    }

    private void generateRGBTexture(AbstractCompoundDataset abstractCompoundDataset, Appearance appearance, int n, int n2, int n3, int n4, boolean bl) {
        RGBDataset rGBDataset;
        byte[] byArray;
        if (bl) {
            byArray = new byte[n3 * n4 * 4];
            this.softwareImageRGBAdatas.put(appearance, byArray);
        }
        byArray = this.softwareImageRGBAdatas.get(appearance);
        Texture2D texture2D = this.textures.get(appearance);
        int n5 = 0;
        int n6 = abstractCompoundDataset.getShape()[0];
        if (abstractCompoundDataset instanceof RGBDataset) {
            rGBDataset = (RGBDataset)abstractCompoundDataset;
            short[] sArray = rGBDataset.getData();
            int n7 = rGBDataset.getShape()[1];
            int n8 = 0;
            while (n8 < n4) {
                int n9 = (n + (n6 - 1 - n2 - (n4 - 1 - n8)) * n7) * 3;
                int n10 = 0;
                while (n10 < n3) {
                    short s = sArray[n9++];
                    short s2 = sArray[n9++];
                    short s3 = sArray[n9++];
                    byArray[n5++] = (byte)s;
                    byArray[n5++] = (byte)s2;
                    byArray[n5++] = (byte)s3;
                    byArray[n5++] = -1;
                    ++n10;
                }
                ++n8;
            }
        } else {
            int n11 = abstractCompoundDataset.getElementsPerItem();
            switch (abstractCompoundDataset.getDtype()) {
                case 100: {
                    CompoundByteDataset compoundByteDataset = (CompoundByteDataset)abstractCompoundDataset;
                    int n12 = 0;
                    while (n12 < n4) {
                        int n13 = n6 - 1 - n2 - (n4 - 1 - n12);
                        int n14 = 0;
                        while (n14 < n3) {
                            byte[] byArray2 = compoundByteDataset.getByteArray(new int[]{n13, n14 + n});
                            byArray[n5++] = byArray2[0];
                            byArray[n5++] = byArray2[1];
                            byArray[n5++] = byArray2[2];
                            byArray[n5++] = n11 > 3 ? byArray2[3] : -1;
                            ++n14;
                        }
                        ++n12;
                    }
                    break;
                }
                case 200: {
                    CompoundShortDataset compoundShortDataset = (CompoundShortDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray2 = abstractCompoundDataset.maxItem();
                    short s = (short)Math.max(1, (short)(dArray2[0] - dArray[0]));
                    short s4 = (short)Math.max(1.0, dArray2[1] - dArray[1]);
                    short s5 = (short)Math.max(1.0, dArray2[2] - dArray[2]);
                    short s6 = n11 > 3 ? (short)(dArray2[3] - dArray[3]) : (short)0;
                    int n15 = 0;
                    while (n15 < n4) {
                        int n16 = n6 - 1 - n2 - (n4 - 1 - n15);
                        int n17 = 0;
                        while (n17 < n3) {
                            short[] sArray = compoundShortDataset.getShortArray(new int[]{n16, n17 + n});
                            short s7 = sArray[0];
                            short s8 = sArray[1];
                            short s9 = sArray[2];
                            int n18 = n11 > 3 ? sArray[3] : 255;
                            double d = ((double)s7 - dArray[0]) / (double)s;
                            s7 = (short)(255.0 * d);
                            d = ((double)s8 - dArray[1]) / (double)s4;
                            s8 = (short)(255.0 * d);
                            d = ((double)s9 - dArray[2]) / (double)s5;
                            s9 = (short)(255.0 * d);
                            if (s6 != 0) {
                                d = ((double)n18 - dArray[3]) / (double)s6;
                                n18 = (short)(255.0 * d);
                            }
                            byArray[n5++] = (byte)s7;
                            byArray[n5++] = (byte)s8;
                            byArray[n5++] = (byte)s9;
                            byArray[n5++] = (byte)n18;
                            ++n17;
                        }
                        ++n15;
                    }
                    break;
                }
                case 300: {
                    CompoundIntegerDataset compoundIntegerDataset = (CompoundIntegerDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray3 = abstractCompoundDataset.maxItem();
                    int n19 = (int)Math.max(1.0, dArray3[0] - dArray[0]);
                    int n20 = (int)Math.max(1.0, dArray3[1] - dArray[1]);
                    int n21 = (int)Math.max(1.0, dArray3[2] - dArray[2]);
                    int n22 = n11 > 3 ? (int)(dArray3[3] - dArray[3]) : 0;
                    int n23 = 0;
                    while (n23 < n4) {
                        int n24 = n6 - 1 - n2 - (n4 - 1 - n23);
                        int n25 = 0;
                        while (n25 < n3) {
                            int[] nArray = compoundIntegerDataset.getIntegerArray(new int[]{n24, n25 + n});
                            int n26 = nArray[0];
                            int n27 = nArray[1];
                            int n28 = nArray[2];
                            int n29 = n11 > 3 ? nArray[3] : 255;
                            double d = ((double)n26 - dArray[0]) / (double)n19;
                            n26 = (int)(255.0 * d);
                            d = ((double)n27 - dArray[1]) / (double)n20;
                            n27 = (int)(255.0 * d);
                            d = ((double)n28 - dArray[2]) / (double)n21;
                            n28 = (int)(255.0 * d);
                            if (n22 != 0) {
                                d = ((double)n28 - dArray[2]) / (double)n22;
                                n29 = (int)(255.0 * d);
                            }
                            byArray[n5++] = (byte)n26;
                            byArray[n5++] = (byte)n27;
                            byArray[n5++] = (byte)n28;
                            byArray[n5++] = (byte)n29;
                            ++n25;
                        }
                        ++n23;
                    }
                    break;
                }
                case 400: {
                    CompoundLongDataset compoundLongDataset = (CompoundLongDataset)abstractCompoundDataset;
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray4 = abstractCompoundDataset.maxItem();
                    long l = (long)Math.max(1.0, dArray4[0] - dArray[0]);
                    long l2 = (long)Math.max(1.0, dArray4[1] - dArray[1]);
                    long l3 = (long)Math.max(1.0, dArray4[2] - dArray[2]);
                    long l4 = n11 > 3 ? (long)(dArray4[3] - dArray[3]) : 0L;
                    int n30 = 0;
                    while (n30 < n4) {
                        int n31 = n6 - 1 - n2 - (n4 - 1 - n30);
                        int n32 = 0;
                        while (n32 < n3) {
                            long[] lArray = compoundLongDataset.getLongArray(new int[]{n31, n32 + n});
                            long l5 = lArray[0];
                            long l6 = lArray[1];
                            long l7 = lArray[2];
                            long l8 = n11 > 3 ? lArray[3] : 255L;
                            double d = ((double)l5 - dArray[0]) / (double)l;
                            l5 = (long)(255.0 * d);
                            d = ((double)l6 - dArray[1]) / (double)l2;
                            l6 = (long)(255.0 * d);
                            d = ((double)l7 - dArray[2]) / (double)l3;
                            l7 = (long)(255.0 * d);
                            if (l4 != 0L) {
                                d = ((double)l7 - dArray[2]) / (double)l4;
                                l8 = (long)(255.0 * d);
                            }
                            byArray[n5++] = (byte)l5;
                            byArray[n5++] = (byte)l6;
                            byArray[n5++] = (byte)l7;
                            byArray[n5++] = (byte)l8;
                            ++n32;
                        }
                        ++n30;
                    }
                    break;
                }
                case 500: 
                case 600: {
                    double[] dArray = abstractCompoundDataset.minItem();
                    double[] dArray5 = abstractCompoundDataset.maxItem();
                    double d = dArray5[0] - dArray[0];
                    double d2 = dArray5[1] - dArray[1];
                    double d3 = dArray5[2] - dArray[2];
                    double d4 = n11 > 3 ? dArray5[3] - dArray[3] : 0.0;
                    double[] dArray6 = new double[4];
                    int n33 = 0;
                    while (n33 < n4) {
                        int n34 = n6 - 1 - n2 - (n4 - 1 - n33);
                        int n35 = 0;
                        while (n35 < n3) {
                            abstractCompoundDataset.getDoubleArray(dArray6, new int[]{n34, n35 + n});
                            double d5 = dArray6[0];
                            double d6 = dArray6[1];
                            double d7 = dArray6[2];
                            double d8 = n11 > 3 ? dArray6[3] : 255.0;
                            d5 = 255.0 * ((d5 - dArray[0]) / d);
                            d6 = 255.0 * ((d6 - dArray[1]) / d2);
                            d7 = 255.0 * ((d7 - dArray[2]) / d3);
                            if (d4 != 0.0) {
                                d8 = 255.0 * ((d8 - dArray[3]) / d4);
                            }
                            byArray[n5++] = (byte)d5;
                            byArray[n5++] = (byte)d6;
                            byArray[n5++] = (byte)d7;
                            byArray[n5++] = (byte)d8;
                            ++n35;
                        }
                        ++n33;
                    }
                    break;
                }
            }
        }
        if (!bl) {
            boolean bl2 = bl = texture2D == null || texture2D.getImage().getHeight() != n4 || texture2D.getImage().getWidth() != n3;
        }
        if (bl) {
            rGBDataset = new ImageData(byArray, n3, n4);
            texture2D = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)rGBDataset);
            texture2D.setRepeatS(Integer.valueOf(33071));
            texture2D.setRepeatT(Integer.valueOf(33071));
            texture2D.setMagFilter(Integer.valueOf(9728));
            texture2D.setMinFilter(Integer.valueOf(9729));
            texture2D.setMipmapMode(Boolean.valueOf(true));
            this.textures.put(appearance, texture2D);
            rGBDataset = null;
            System.gc();
        } else if (texture2D != null) {
            rGBDataset = texture2D.getImage();
            rGBDataset.updateData(byArray);
        } else {
            logger.warn("Tried to update a texture that does not exist!");
        }
    }

    protected void generateTexture(IDataset iDataset, Appearance appearance, int n, int n2, int n3, int n4) {
        if (this.hasJOGLshaders) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = iDataset instanceof RGBDataset || iDataset instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)iDataset).getElementsPerItem() == 3 || ((AbstractCompoundDataset)iDataset).getElementsPerItem() == 4);
            if (!bl) {
                this.currentImageType = 0;
                float[] fArray = this.imageDatas.get(appearance);
                if (fArray == null || fArray.length != n3 * n4 || this.currentImageType != this.lastImageType) {
                    bl2 = true;
                }
                this.generateFloatTexture(iDataset, appearance, n, n2, n3, n4, bl2);
            } else {
                this.currentImageType = 1;
                byte[] byArray = this.softwareImageRGBAdatas.get(appearance);
                if (byArray == null || byArray.length != n3 * n4 * 4 || this.currentImageType != this.lastImageType) {
                    bl2 = true;
                }
                this.generateRGBTexture((AbstractCompoundDataset)iDataset, appearance, n, n2, n3, n4, bl2);
            }
            if (this.lastImageType != this.currentImageType) {
                this.loadGLSLProgram(this.tableMin, this.tableMax);
            }
            this.lastImageType = this.currentImageType;
        } else {
            double d = iDataset.max().doubleValue();
            double d2 = iDataset.min().doubleValue();
            int n5 = iDataset.getShape()[0];
            int n6 = iDataset.getShape()[1];
            this.softwareImageRGBAdata = new byte[n3 * n4 * 4];
            if (!(iDataset instanceof RGBDataset)) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = 0;
                    while (n8 < n3) {
                        int n9 = n5 - 1 - n2 - (n4 - 1 - n7);
                        double d3 = iDataset.getDouble(new int[]{n9, n8 + n});
                        byte by = (byte)(255.0 * d3 / (d - d2));
                        byte by2 = (byte)(255.0 * d3 / (d - d2));
                        byte by3 = (byte)(255.0 * d3 / (d - d2));
                        int n10 = -1;
                        this.softwareImageRGBAdata[(n8 + n7 * n3) * 4] = by;
                        this.softwareImageRGBAdata[(n8 + n7 * n3) * 4 + 1] = by2;
                        this.softwareImageRGBAdata[(n8 + n7 * n3) * 4 + 2] = by3;
                        this.softwareImageRGBAdata[(n8 + n7 * n3) * 4 + 3] = n10;
                        ++n8;
                    }
                    ++n7;
                }
            } else {
                RGBDataset rGBDataset = (RGBDataset)iDataset;
                short[] sArray = rGBDataset.getData();
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = 0;
                    while (n12 < n4) {
                        int n13 = n5 - 1 - n2 - (n4 - 1 - n12);
                        short s = sArray[(n11 + n + n13 * n6) * 3];
                        short s2 = sArray[(n11 + n + n13 * n6) * 3 + 1];
                        short s3 = sArray[(n11 + n + n13 * n6) * 3 + 2];
                        byte by = (byte)s;
                        byte by4 = (byte)s2;
                        byte by5 = (byte)s3;
                        int n14 = -1;
                        this.softwareImageRGBAdata[(n11 + n12 * n3) * 4] = by;
                        this.softwareImageRGBAdata[(n11 + n12 * n3) * 4 + 1] = by4;
                        this.softwareImageRGBAdata[(n11 + n12 * n3) * 4 + 2] = by5;
                        this.softwareImageRGBAdata[(n11 + n12 * n3) * 4 + 3] = n14;
                        ++n12;
                    }
                    ++n11;
                }
            }
            ImageData imageData = new ImageData(this.softwareImageRGBAdata, n3, n4);
            this.generateSoftwareTexture(appearance, imageData);
            imageData = null;
        }
    }

    protected void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = 1.4E-45f;
        this.globalRealYmin = 3.4028234663852886E38;
        this.globalRealYmax = 1.4E-45f;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            switch (this.xAxis) {
                case LINEAR: {
                    this.globalRealXmin = 0.0;
                    this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.globalRealXmin = this.xOffset;
                    this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                    break;
                }
                case CUSTOM: {
                    this.globalRealXmin = Math.min(this.globalRealXmin, this.xAxisValues.getMinValue());
                    this.globalRealXmax = Math.max(this.globalRealXmax, this.xAxisValues.getMaxValue());
                }
            }
            switch (this.yAxis) {
                case LINEAR: {
                    this.globalRealYmin = 0.0;
                    this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.globalRealYmin = this.yOffset;
                    this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                    break;
                }
                case CUSTOM: {
                    this.globalRealYmin = Math.min(this.globalRealYmin, this.yAxisValues.getMinValue());
                    this.globalRealYmax = Math.max(this.globalRealYmax, this.yAxisValues.getMaxValue());
                }
            }
        }
    }

    private void determineRanges(IDataset iDataset) {
        switch (this.xAxis) {
            case LINEAR: {
                this.globalRealXmin = 0.0;
                this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealXmin = this.xOffset;
                this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1] + this.xOffset);
                break;
            }
            case CUSTOM: {
                this.globalRealXmin = this.xAxisValues.getMinValue();
                this.globalRealXmax = this.xAxisValues.getMaxValue();
            }
        }
        switch (this.yAxis) {
            case LINEAR: {
                this.globalRealYmin = 0.0;
                this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealYmin = this.yOffset;
                this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0] + this.yOffset);
                break;
            }
            case CUSTOM: {
                this.globalRealYmin = this.yAxisValues.getMinValue();
                this.globalRealYmax = this.yAxisValues.getMaxValue();
            }
        }
    }

    protected void updateClipPlanePositions(double[] dArray) {
        MatrixBuilder.euclidean().rotateY(-1.5707963267948966).assignTo(this.leftClip);
        MatrixBuilder.euclidean().rotateY(1.5707963267948966).rotateX(1.5707963267948966).assignTo(this.bottomClip);
        MatrixBuilder.euclidean().rotateX(-1.5707963267948966).translate(0.0, dArray[1], 0.0).rotateX(-1.5707963267948966).assignTo(this.topClip);
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).translate(dArray[0], -dArray[1], 0.0).rotateY(1.5707963267948966).assignTo(this.rightClip);
        MatrixBuilder.euclidean().rotateY(-1.5707963267948966).translate(-dArray[0], 0.0, 0.0).assignTo(this.graphGroupNode);
    }

    private void buildClipPlanes(SceneGraphComponent sceneGraphComponent) {
        Object object;
        if (this.leftClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.leftClip = new SceneGraphComponent("leftClipBorder");
            this.leftClip.setGeometry((Geometry)object);
            sceneGraphComponent.addChild(this.leftClip);
        }
        if (this.bottomClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.bottomClip = new SceneGraphComponent("bottomClipBorder");
            this.bottomClip.setGeometry((Geometry)object);
            this.leftClip.addChild(this.bottomClip);
        }
        if (this.topClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.topClip = new SceneGraphComponent("topClipBorder");
            this.topClip.setGeometry((Geometry)object);
            this.bottomClip.addChild(this.topClip);
        }
        if (this.rightClip == null) {
            this.rightClip = new SceneGraphComponent("rightClipBorder");
            object = new ClippingPlane();
            object.setLocal(true);
            this.rightClip.setGeometry((Geometry)object);
            this.topClip.addChild(this.rightClip);
            this.rightClip.addChild(this.graphGroupNode);
        }
        object = this.determineXYsize();
        this.updateClipPlanePositions((double[])object);
    }

    protected void loadGLSLProgram(double d, double d2) {
        if (this.currentImageType == 0) {
            if (this.tableProg == null) {
                this.tableProg = new GlslProgram(this.graphAppearance, "polygonShader", null, JOGLGLSLShaderGenerator.generateShader(this.useLogarithmic, false, this.useDiffractionMode, this.useGradientMode), JOGLGLSLShaderGenerator.generateShaderName(this.useLogarithmic, false, this.useDiffractionMode, this.useGradientMode));
            } else {
                this.tableProg.setShaders(null, JOGLGLSLShaderGenerator.generateShader(this.useLogarithmic, false, this.useDiffractionMode, this.useGradientMode), JOGLGLSLShaderGenerator.generateShaderName(this.useLogarithmic, false, this.useDiffractionMode, this.useGradientMode));
            }
            if (this.tableProg != null) {
                this.tableProg.setUniform("sampler", 0);
                this.tableProg.setUniform("tableSampler", 1);
                this.tableProg.setUniform("overlaySampler", 2);
                if (this.useLogarithmic) {
                    ScalingUtility.setSmallLogFlag(false);
                    this.tableProg.setUniform("maxValue", ScalingUtility.valueScaler(d2, ScaleType.LN));
                    this.tableProg.setUniform("minValue", ScalingUtility.valueScaler(d, ScaleType.LN));
                } else {
                    this.tableProg.setUniform("maxValue", d2);
                    this.tableProg.setUniform("minValue", d);
                }
            }
        } else {
            if (this.tableProg == null) {
                this.tableProg = new GlslProgram(this.graphAppearance, "polygonShader", null, JOGLGLSLShaderGenerator.generateShader(false, true, false, false), JOGLGLSLShaderGenerator.generateShaderName(false, true, false, false));
            } else {
                this.tableProg.setShaders(null, JOGLGLSLShaderGenerator.generateShader(false, true, false, false), JOGLGLSLShaderGenerator.generateShaderName(false, true, false, false));
            }
            this.tableProg.setUniform("sampler", 0);
            this.tableProg.setUniform("overlaySampler", 2);
        }
        for (Appearance appearance : this.graphApps) {
            appearance.setAttribute("polygonShader::glsl-source", (Object)this.tableProg.getSource());
        }
    }

    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        this.graphApps.add(appearance);
        appearance.setAttribute("lightingEnabled", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        DefaultPolygonShader defaultPolygonShader = (DefaultPolygonShader)defaultGeometryShader.createPolygonShader("default");
        defaultPolygonShader.setDiffuseColor(Color.white);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(true));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        return appearance;
    }

    protected void setShaderOnAppearance(Appearance appearance) {
        if (this.hasJOGLshaders) {
            Texture2D texture2D = null;
            if (this.tableProg != null) {
                appearance.setAttribute("useGLSL", true);
                appearance.setAttribute("polygonShader::glsl-source", (Object)this.tableProg.getSource());
                texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)appearance, (boolean)true);
                texture2D.setImage(this.lookupTableImg);
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
            }
        }
    }

    protected void setupOtherNodes() {
        MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.graph);
        if (this.xTickNode != null) {
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTickNode != null) {
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        if (this.ticksNode != null) {
            MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.ticksNode);
        }
        if (this.xLabelNode != null) {
            MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.xLabelNode);
        }
        if (this.yLabelNode != null) {
            MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.yLabelNode);
        }
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFieldOfView(52.5);
        this.posTool.setImageHeight(this.maxHeight);
        this.posTool.setImageWidth(this.maxWidth);
        double[] dArray = this.determineXYsize();
        if (this.axis != null) {
            this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        }
        this.panTool.setDataDimension(dArray[0], dArray[1]);
        this.posTool.setMaxXY(dArray[0], dArray[1]);
        this.buildBackground(this.graph);
        this.buildClipPlanes(this.graph);
        ((SceneGraphComponent)this.graph.getOwner()).addTool((Tool)this.posTool);
        this.subGraphs.get(this.subGraphs.size() - 1).addChild(this.overlayPrimitiveGroupNode);
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        this.maxHeight = 0;
        this.maxWidth = 0;
        if (sceneGraphComponent != null) {
            this.graphGroupNode = new SceneGraphComponent("Graph Group node");
            this.overlayPrimitiveGroupNode = new SceneGraphComponent("Overlay group node");
            this.graph = sceneGraphComponent;
            Iterator<IDataset> iterator = list.iterator();
            this.numGraphs = 0;
            while (iterator.hasNext()) {
                IDataset iDataset = iterator.next();
                int n = iDataset.getShape()[1];
                int n2 = iDataset.getShape()[0];
                this.maxWidth = Math.max(n, this.maxWidth);
                this.maxHeight = Math.max(n2, this.maxHeight);
                double[] dArray = this.determineXYsize();
                int n3 = JOGLChecker.getMaxTextureHeight();
                int n4 = JOGLChecker.getMaxTextureWidth();
                double d = 0.0;
                double d2 = (double)n3 / (double)this.maxHeight < 1.0 ? dArray[1] * (double)n3 / (double)this.maxHeight : dArray[1];
                double d3 = (double)n4 / (double)this.maxWidth < 1.0 ? dArray[0] * (double)n4 / (double)this.maxWidth : dArray[0];
                int n5 = 0;
                while (n5 < this.maxHeight) {
                    double d4 = 0.0;
                    int n6 = 0;
                    while (n6 < this.maxWidth) {
                        int n7;
                        SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs + ".sub" + n6 + "_" + n5));
                        this.subGraphs.add(sceneGraphComponent2);
                        this.graphGroupNode.addChild(sceneGraphComponent2);
                        sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(d4 + d3 > dArray[0] ? dArray[0] - d4 : d3, d + d2 > dArray[1] ? dArray[1] - d : d2, d4, d));
                        if (iDataset instanceof AbstractCompoundDataset) {
                            this.tableMin = 0.0;
                            this.tableMax = 0.0;
                        } else {
                            this.tableMin = iDataset.min().doubleValue();
                            this.tableMax = iDataset.max().doubleValue();
                        }
                        int n8 = n > n4 ? n4 : n;
                        int n9 = n7 = n2 > n3 ? n3 : n2;
                        if (n6 + n8 > this.maxWidth) {
                            n8 = this.maxWidth - n6;
                        }
                        if (n5 + n7 > this.maxHeight) {
                            n7 = this.maxHeight - n5;
                        }
                        this.graphAppearance = this.createAppearance();
                        sceneGraphComponent2.setAppearance(this.graphAppearance);
                        this.generateTexture(iDataset, this.graphAppearance, n6, n5, n8, n7);
                        this.setShaderOnAppearance(this.graphAppearance);
                        n6 += n4;
                        d4 += d3;
                    }
                    n5 += n3;
                    d += d2;
                }
                ++this.numGraphs;
            }
            this.determineRanges(list);
            this.setupOtherNodes();
        }
        this.registerOverlayImage(1, 1);
        return sceneGraphComponent;
    }

    protected PointSet createYLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        double d = this.globalRealYmax - this.globalRealYmin;
        double[] dArray = this.determineXYsize();
        double d2 = dArray[1] * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray2 = ArrayPoolUtility.getDoubleArray(linkedList.size());
        if (this.yAxis == AxisMode.CUSTOM) {
            boolean bl = this.yAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray2[n2][0] = -0.7;
                dArray2[n2][1] = dArray[1] - (double)n2 * d2;
                dArray2[n2][2] = 0.0;
                stringArray[n2] = tick.getTickName();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                Tick tick = linkedList.get(n3);
                dArray2[n3][0] = -0.7;
                dArray2[n3][1] = dArray[1] - (double)n3 * d2;
                dArray2[n3][2] = 0.0;
                stringArray[n3] = tick.getTickName();
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray2);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected PointSet createXLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks((int)(this.labelScaling * (double)n), d, d2, (short)0, false);
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        double[] dArray2 = this.determineXYsize();
        if (this.xAxis == AxisMode.CUSTOM) {
            boolean bl = this.xAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                double d3 = this.tickFactory.getTickUnit() * (double)n2;
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray[n2][0] = d3 / (this.globalRealXmax - this.globalRealXmin) * dArray2[0];
                dArray[n2][1] = -0.275;
                dArray[n2][2] = 0.0;
                stringArray[n2] = tick.getTickName();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                double d4 = this.tickFactory.getTickUnit() * (double)n3;
                Tick tick = linkedList.get(n3);
                dArray[n3][0] = d4 / (this.globalRealXmax - this.globalRealXmin) * dArray2[0];
                dArray[n3][1] = -0.275;
                dArray[n3][2] = 0.0;
                stringArray[n3] = tick.getTickName();
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public void buildXCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.xLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsXTicks.setOffset(dArray);
        this.dtsXTicks.setScale(Double.valueOf(0.0075));
        this.dtsXTicks.setDiffuseColor(Color.black);
        this.dtsXTicks.setAlignment(Integer.valueOf(0));
        sceneGraphComponent.setGeometry((Geometry)this.createXLabelsGeometry());
    }

    @Override
    public void buildYCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.yLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsYTicks.setOffset(dArray);
        this.dtsYTicks.setScale(Double.valueOf(0.0075));
        this.dtsYTicks.setDiffuseColor(Color.black);
        this.dtsYTicks.setAlignment(Integer.valueOf(0));
        sceneGraphComponent.setGeometry((Geometry)this.createYLabelsGeometry());
    }

    @Override
    public void buildZCoordLabeling(SceneGraphComponent sceneGraphComponent) {
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        if (this.hasJOGLshaders && this.tableProg != null) {
            this.tableMin = d;
            this.tableMax = d2;
            byte[] byArray = new byte[colourImageData.getWidth() * 4];
            int n = 0;
            while (n < colourImageData.getWidth()) {
                int n2 = colourImageData.get(n, 0);
                byte by = (byte)(n2 >> 16 & 0xFF);
                byte by2 = (byte)(n2 >> 8 & 0xFF);
                byte by3 = (byte)(n2 & 0xFF);
                byArray[n * 4] = by;
                byArray[n * 4 + 1] = by2;
                byArray[n * 4 + 2] = by3;
                byArray[n * 4 + 3] = -1;
                ++n;
            }
            this.lookupTableImg = null;
            this.lookupTableImg = new ImageData(byArray, colourImageData.getWidth(), 1);
            for (Appearance appearance : this.graphApps) {
                Texture2D texture2D = (Texture2D)AttributeEntityUtility.getAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)appearance, (boolean)true);
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
                texture2D.setImage(this.lookupTableImg);
            }
            if (this.useLogarithmic) {
                ScalingUtility.setSmallLogFlag(false);
                this.tableProg.setUniform("maxValue", ScalingUtility.valueScaler(d2, ScaleType.LN));
                this.tableProg.setUniform("minValue", ScalingUtility.valueScaler(d, ScaleType.LN));
            } else {
                this.tableProg.setUniform("maxValue", d2);
                this.tableProg.setUniform("minValue", d);
            }
        } else {
            int n = colourImageData.getWidth();
            int n3 = colourImageData.getHeight();
            int n4 = JOGLChecker.getMaxTextureHeight();
            int n5 = JOGLChecker.getMaxTextureWidth();
            Iterator<Appearance> iterator = this.graphApps.iterator();
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n) {
                    int n8;
                    Appearance appearance = iterator.next();
                    int n9 = n > n5 ? n5 : n;
                    int n10 = n8 = n3 > n4 ? n4 : n3;
                    if (n7 + n9 > this.maxWidth) {
                        n9 = this.maxWidth - n7;
                    }
                    if (n6 + n8 > this.maxHeight) {
                        n8 = this.maxHeight - n6;
                    }
                    this.softwareImageRGBAdata = new byte[n9 * n8 * 4];
                    int n11 = 0;
                    while (n11 < n8) {
                        int n12 = 0;
                        while (n12 < n9) {
                            int n13 = n3 - 1 - n6 - (n8 - 1 - n11);
                            int n14 = colourImageData.get(n12 + n7, n13);
                            byte by = (byte)(n14 >> 24 & 0xFF);
                            byte by4 = (byte)(n14 >> 16 & 0xFF);
                            byte by5 = (byte)(n14 >> 8 & 0xFF);
                            byte by6 = (byte)(n14 & 0xFF);
                            this.softwareImageRGBAdata[(n12 + n11 * n9) * 4] = by4;
                            this.softwareImageRGBAdata[(n12 + n11 * n9) * 4 + 1] = by5;
                            this.softwareImageRGBAdata[(n12 + n11 * n9) * 4 + 2] = by6;
                            this.softwareImageRGBAdata[(n12 + n11 * n9) * 4 + 3] = by;
                            ++n12;
                        }
                        ++n11;
                    }
                    ImageData imageData = new ImageData(this.softwareImageRGBAdata, n9, n8);
                    this.generateSoftwareTexture(appearance, imageData);
                    n7 += n5;
                }
                n6 += n4;
            }
        }
    }

    @Override
    public void notifyComponentResize(int n, int n2) {
        double d = 1.0;
        this.canvasWidth = n;
        this.canvasHeight = n2;
        if (n < 490) {
            d = 490.0 / (double)n;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)n2);
        }
        d = Math.max(d, 0.5);
        if (this.dtsXAxisLabel != null) {
            this.dtsXAxisLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsYAxisLabel != null) {
            this.dtsYAxisLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsTitleLabel != null) {
            this.dtsTitleLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsXTicks != null) {
            if (this.hasJOGL) {
                this.dtsXTicks.setScale(Double.valueOf(0.0075 * d * 0.85));
            } else {
                this.dtsXTicks.setScale(Double.valueOf(0.0075 * d));
            }
        }
        if (this.dtsYTicks != null) {
            if (this.hasJOGL) {
                this.dtsYTicks.setScale(Double.valueOf(0.0075 * d * 0.85));
            } else {
                this.dtsYTicks.setScale(Double.valueOf(0.0075 * d));
            }
        }
    }

    @Override
    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.xAxis = axisMode;
        this.yAxis = axisMode2;
    }

    @Override
    public void setScaling(ScaleType scaleType) {
        block10: {
            block9: {
                if (this.graph == null) break block9;
                this.currentScale = scaleType;
                switch (DataSet3DPlot2D.$SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType()[scaleType.ordinal()]) {
                    case 1: {
                        if (this.useLogarithmic) {
                            this.useLogarithmic = false;
                            if (this.hasJOGLshaders) {
                                this.loadGLSLProgram(this.tableMin, this.tableMax);
                                break;
                            }
                        }
                        break block10;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.useLogarithmic) break block10;
                        this.useLogarithmic = true;
                        if (!this.hasJOGLshaders) break block10;
                        this.loadGLSLProgram(this.tableMin, this.tableMax);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            this.useLogarithmic = scaleType != ScaleType.LINEAR;
        }
    }

    protected void createXAxisLabelGeom() {
        if (this.xAxisLabelStr != null) {
            double[] dArray = this.determineXYsize();
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray2 = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{this.xAxisLabelStr};
            dArray2[0][0] = dArray[0] * 0.5;
            dArray2[0][1] = -0.5;
            dArray2[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray2);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.xAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setXAxisLabel(String string) {
        if (this.xAxisLabelStr == null || !string.equals(this.xAxisLabelStr)) {
            this.xAxisLabelStr = string;
            this.createXAxisLabelGeom();
        }
    }

    @Override
    public void setXAxisOffset(double d) {
        this.xOffset = d;
    }

    @Override
    public void setXAxisValues(AxisValues axisValues, int n) {
        this.xAxisValues = axisValues;
    }

    protected void createYAxisLabelGeom() {
        if (this.yAxisLabelStr != null) {
            double[] dArray = this.determineXYsize();
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray2 = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{this.yAxisLabelStr};
            dArray2[0][0] = -0.5;
            dArray2[0][1] = dArray[1] * 0.5;
            dArray2[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray2);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.yAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setYAxisLabel(String string) {
        if (this.yAxisLabelStr == null || !string.equals(this.yAxisLabelStr)) {
            this.yAxisLabelStr = string;
            this.createYAxisLabelGeom();
        }
    }

    @Override
    public void setYAxisOffset(double d) {
        this.yOffset = d;
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
        this.yAxisValues = axisValues;
    }

    @Override
    public void setZAxisLabel(String string) {
    }

    @Override
    public void setZAxisOffset(double d) {
    }

    private void cleanUpOverlay() {
        if (this.consumer != null) {
            this.consumer.removePrimitives();
            this.consumer = null;
        }
        this.overlayInOperation = false;
        Integer[] integerArray = new Integer[this.prim2DMap.keySet().size()];
        this.prim2DMap.keySet().toArray(integerArray);
        int n = 0;
        while (n < integerArray.length) {
            this.unregisterPrimitive(integerArray[n]);
            ++n;
        }
        this.prim2DMap.clear();
    }

    @Override
    public void updateGraph(IDataset iDataset) {
        this.maxHeight = 0;
        this.maxWidth = 0;
        int n = iDataset.getShape()[1];
        int n2 = iDataset.getShape()[0];
        this.maxWidth = Math.max(n, this.maxWidth);
        this.maxHeight = Math.max(n2, this.maxHeight);
        double[] dArray = this.determineXYsize();
        LinkedList<SceneGraphComponent> linkedList = new LinkedList<SceneGraphComponent>();
        this.subGraphs.get(this.subGraphs.size() - 1).removeChild(this.overlayPrimitiveGroupNode);
        Iterator<SceneGraphComponent> iterator = this.subGraphs.iterator();
        this.updateGraphNodes(iDataset, iterator, linkedList, dArray[0], dArray[1], n2, n);
        LinkedList<SceneGraphComponent> linkedList2 = new LinkedList<SceneGraphComponent>();
        while (iterator.hasNext()) {
            SceneGraphComponent sceneGraphComponent = iterator.next();
            linkedList2.add(sceneGraphComponent);
            sceneGraphComponent.setGeometry(null);
            this.graphGroupNode.removeChild(sceneGraphComponent);
            this.textures.remove(sceneGraphComponent.getAppearance());
            this.softwareImageRGBAdatas.remove(sceneGraphComponent.getAppearance());
            this.imageDatas.remove(sceneGraphComponent.getAppearance());
            this.graphApps.remove(sceneGraphComponent.getAppearance());
        }
        this.subGraphs.removeAll(linkedList2);
        this.subGraphs.addAll(linkedList);
        linkedList2.clear();
        linkedList.clear();
        this.subGraphs.get(this.subGraphs.size() - 1).addChild(this.overlayPrimitiveGroupNode);
        this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        this.determineRanges(iDataset);
        this.updateClipPlanePositions(dArray);
        this.posTool.setImageHeight(this.maxHeight);
        this.posTool.setImageWidth(this.maxWidth);
        this.posTool.setMaxXY(dArray[0], dArray[1]);
        this.panTool.setDataDimension(dArray[0], dArray[1]);
        if (this.xTickNode != null) {
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTickNode != null) {
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        if (this.titleLabel != null) {
            this.titleLabel.setGeometry((Geometry)this.createTitleGeometry());
        }
        this.createYAxisLabelGeom();
        this.createXAxisLabelGeom();
    }

    private void updateGraphNodes(IDataset iDataset, Iterator<SceneGraphComponent> iterator, List<SceneGraphComponent> list, double d, double d2, int n, int n2) {
        int n3 = JOGLChecker.getMaxTextureHeight();
        int n4 = JOGLChecker.getMaxTextureWidth();
        double d3 = 0.0;
        double d4 = (double)n3 / (double)this.maxHeight < 1.0 ? d2 * (double)n3 / (double)this.maxHeight : d2;
        double d5 = (double)n4 / (double)this.maxWidth < 1.0 ? d * (double)n4 / (double)this.maxWidth : d;
        int n5 = 0;
        while (n5 < n) {
            double d6 = 0.0;
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                SceneGraphComponent sceneGraphComponent = null;
                if (iterator.hasNext()) {
                    sceneGraphComponent = iterator.next();
                } else {
                    sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs + ".sub" + n6 + "_" + n5));
                    list.add(sceneGraphComponent);
                    this.graphGroupNode.addChild(sceneGraphComponent);
                    this.graphAppearance = this.createAppearance();
                    sceneGraphComponent.setAppearance(this.graphAppearance);
                    this.setShaderOnAppearance(this.graphAppearance);
                }
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(d6 + d5 > d ? d - d6 : d5, d3 + d4 > d2 ? d2 - d3 : d4, d6, d3));
                int n8 = n2 > n4 ? n4 : n2;
                int n9 = n7 = n > n3 ? n3 : n;
                if (n6 + n8 > this.maxWidth) {
                    n8 = this.maxWidth - n6;
                }
                if (n5 + n7 > this.maxHeight) {
                    n7 = this.maxHeight - n5;
                }
                this.generateTexture(iDataset, sceneGraphComponent.getAppearance(), n6, n5, n8, n7);
                n6 += n4;
                d6 += d5;
            }
            n5 += n3;
            d3 += d4;
        }
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        if (list.size() > 0 && this.subGraphs.size() > 0) {
            IDataset iDataset;
            Iterator<IDataset> iterator = list.iterator();
            this.subGraphs.get(this.subGraphs.size() - 1).removeChild(this.overlayPrimitiveGroupNode);
            Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
            this.maxWidth = 0;
            this.maxHeight = 0;
            LinkedList<SceneGraphComponent> linkedList = new LinkedList<SceneGraphComponent>();
            while (iterator.hasNext()) {
                double d;
                double d2;
                iDataset = iterator.next();
                int n = iDataset.getShape()[1];
                int n2 = iDataset.getShape()[0];
                this.maxWidth = Math.max(n, this.maxWidth);
                this.maxHeight = Math.max(n2, this.maxHeight);
                if (!this.useCanvasAspect) {
                    if (n >= n2) {
                        d2 = 15.0;
                        d = 15.0 * (double)n2 / (double)n;
                    } else {
                        d = 15.0;
                        d2 = 15.0 * (double)n / (double)n2;
                    }
                } else if (this.canvasWidth >= this.canvasHeight) {
                    d2 = 15.0;
                    d = 15.0 * (double)this.canvasHeight / (double)this.canvasWidth;
                } else {
                    d2 = 15.0;
                    d = 15.0 * (double)this.canvasWidth / (double)this.canvasHeight;
                }
                d2 = Math.max(d2, 3.0);
                d = Math.max(d, 3.0);
                this.updateGraphNodes(iDataset, iterator2, linkedList, d2, d, n2, n);
            }
            iDataset = new LinkedList();
            while (iterator2.hasNext()) {
                SceneGraphComponent sceneGraphComponent = iterator2.next();
                iDataset.add(sceneGraphComponent);
                sceneGraphComponent.setGeometry(null);
                this.graphGroupNode.removeChild(sceneGraphComponent);
                this.textures.remove(sceneGraphComponent.getAppearance());
                this.overlayTextures.remove(sceneGraphComponent.getAppearance());
                this.softwareImageRGBAdatas.remove(sceneGraphComponent.getAppearance());
                this.imageDatas.remove(sceneGraphComponent.getAppearance());
                this.graphApps.remove(sceneGraphComponent.getAppearance());
            }
            this.subGraphs.removeAll((Collection<?>)iDataset);
            this.subGraphs.addAll(linkedList);
            this.subGraphs.get(this.subGraphs.size() - 1).addChild(this.overlayPrimitiveGroupNode);
            iDataset.clear();
            linkedList.clear();
            this.posTool.setImageHeight(this.maxHeight);
            this.posTool.setImageWidth(this.maxWidth);
            double[] dArray = this.determineXYsize();
            this.updateClipPlanePositions(dArray);
            this.posTool.setMaxXY(dArray[0], dArray[1]);
            this.panTool.setDataDimension(dArray[0], dArray[1]);
            this.determineRanges(list);
            if (this.xTickNode != null) {
                this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTickNode != null) {
                this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
            }
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
            if (this.yLabelNode != null) {
                this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
            }
            if (this.titleLabel != null) {
                this.titleLabel.setGeometry((Geometry)this.createTitleGeometry());
            }
            this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
            this.createYAxisLabelGeom();
            this.createXAxisLabelGeom();
        } else {
            logger.warn("Tried to plot altough there is either no data or no graph nodes");
        }
    }

    @Override
    public void setXAxisLabelMode(TickFormatting tickFormatting) {
        this.xLabelMode = tickFormatting;
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
    }

    @Override
    public void setYAxisLabelMode(TickFormatting tickFormatting) {
        this.yLabelMode = tickFormatting;
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
    }

    @Override
    public void setZAxisLabelMode(TickFormatting tickFormatting) {
    }

    @Override
    public void cleanUpGraphNode() {
        if (this.graph != null) {
            if (this.graphGroupNode != null) {
                Iterator<SceneGraphComponent> iterator = this.subGraphs.iterator();
                while (iterator.hasNext()) {
                    this.graphGroupNode.removeChild(iterator.next());
                }
                this.subGraphs.clear();
            }
            if (this.leftClip != null) {
                this.graph.removeChild(this.leftClip);
            }
            if (this.background != null) {
                this.graph.removeChild(this.background);
            }
            this.cleanUpOverlay();
        }
        if (this.axis != null) {
            this.axis.removeChild(this.xAxisLabel);
            this.axis.removeChild(this.yAxisLabel);
            this.axis.removeChild(this.titleLabel);
        }
        if (this.graph != null) {
            this.graph.removeTool((Tool)this.actionTool);
            ((SceneGraphComponent)this.graph.getOwner()).removeTool((Tool)this.posTool);
        }
        this.softwareImageRGBAdata = null;
        this.actionListeners.clear();
    }

    @Override
    public boolean begin(OverlayType overlayType) {
        if (!this.overlayInOperation) {
            this.overlayInOperation = true;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void end(OverlayType overlayType) {
        this.overlayInOperation = false;
        switch (overlayType) {
            case IMAGE: {
                if (this.overlayImage == null || !this.overlayImage.isDirty()) break;
                for (Appearance appearance : this.graphApps) {
                    this.generateOverlayTexture(appearance);
                }
                break;
            }
            case VECTOR2D: {
                Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
                while (iterator.hasNext()) {
                    OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
                    overlayPrimitive.updateNode();
                    if (!overlayPrimitive.isFixedSize()) continue;
                    this.updateScaledPrimitive(overlayPrimitive, 1.0 / this.inverseScaling);
                }
                break;
            }
        }
        this.refresh();
    }

    public void registerOverlay(Overlay2DConsumer overlay2DConsumer) {
        this.consumer = overlay2DConsumer;
        this.posTool.addImagePositionListener(overlay2DConsumer);
        overlay2DConsumer.registerProvider(this);
    }

    public void unRegisterOverlay(Overlay2DConsumer overlay2DConsumer) {
        this.posTool.removeImagePositionListener(overlay2DConsumer);
        overlay2DConsumer.unregisterProvider();
        Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
            if (overlayPrimitive == null || this.overlayPrimitiveGroupNode == null) continue;
            this.overlayPrimitiveGroupNode.removeChild(overlayPrimitive.getNode());
        }
        this.prim2DMap.clear();
        this.overlayInOperation = false;
    }

    @Override
    public void drawLine(int n, double d, double d2, double d3, double d4) {
        LinePrimitive linePrimitive;
        if (this.overlayInOperation && (linePrimitive = (LinePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = dArray[0] / ((double)this.maxWidth * 2.0);
            double d6 = dArray[1] / ((double)this.maxHeight * 2.0);
            double d7 = d / (double)this.maxWidth * dArray[0] + d5;
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1] - d6;
            double d9 = d3 / (double)this.maxWidth * dArray[0] + d5;
            double d10 = dArray[1] - d4 / (double)this.maxHeight * dArray[1] - d6;
            linePrimitive.setLinePoints(d7, d8, d9, d10);
        }
    }

    @Override
    public void drawArrow(int n, double d, double d2, double d3, double d4) {
        ArrowPrimitive arrowPrimitive;
        if (this.overlayInOperation && (arrowPrimitive = (ArrowPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = dArray[0] / ((double)this.maxWidth * 2.0);
            double d6 = dArray[1] / ((double)this.maxHeight * 2.0);
            double d7 = d / (double)this.maxWidth * dArray[0] + d5;
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1] - d6;
            double d9 = d3 / (double)this.maxWidth * dArray[0] + d5;
            double d10 = dArray[1] - d4 / (double)this.maxHeight * dArray[1] - d6;
            arrowPrimitive.setArrowPoints(d7, d8, d9, d10, 1.0);
        }
    }

    @Override
    public void drawArrow(int n, double d, double d2, double d3, double d4, double d5) {
        ArrowPrimitive arrowPrimitive;
        if (this.overlayInOperation && (arrowPrimitive = (ArrowPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d6 = dArray[0] / ((double)this.maxWidth * 2.0);
            double d7 = dArray[1] / ((double)this.maxHeight * 2.0);
            double d8 = d / (double)this.maxWidth * dArray[0] + d6;
            double d9 = dArray[1] - d2 / (double)this.maxHeight * dArray[1] - d7;
            double d10 = d3 / (double)this.maxWidth * dArray[0] + d6;
            double d11 = dArray[1] - d4 / (double)this.maxHeight * dArray[1] - d7;
            arrowPrimitive.setArrowPoints(d8, d9, d10, d11, d5);
        }
    }

    @Override
    public void drawBox(int n, double d, double d2, double d3, double d4) {
        BoxPrimitive boxPrimitive;
        if (this.overlayInOperation && (boxPrimitive = (BoxPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = dArray[0] / ((double)this.maxWidth * 2.0);
            double d6 = dArray[1] / ((double)this.maxHeight * 2.0);
            double d7 = d / (double)this.maxWidth * dArray[0] + d5;
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1] - d6;
            double d9 = d3 / (double)this.maxWidth * dArray[0] + d5;
            double d10 = dArray[1] - d4 / (double)this.maxHeight * dArray[1] - d6;
            boxPrimitive.setBoxPoints(d7, d8, d9, d10);
        }
    }

    @Override
    public void drawCircle(int n, double d, double d2, double d3) {
        CirclePrimitive circlePrimitive;
        if (this.overlayInOperation && (circlePrimitive = (CirclePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d4 = d / (double)this.maxWidth * dArray[0];
            double d5 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d6 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            circlePrimitive.setCircleParameters(d4, d5, d6);
        }
    }

    @Override
    public void drawSector(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        CircleSectorPrimitive circleSectorPrimitive;
        if (this.overlayInOperation && (circleSectorPrimitive = (CircleSectorPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d7 = d / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d9 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d10 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            circleSectorPrimitive.setSectorParameters(d7, d8, d10, d9, d5, d6);
        }
    }

    @Override
    public void drawTriangle(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        TrianglePrimitive trianglePrimitive;
        if (this.overlayInOperation && (trianglePrimitive = (TrianglePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d7 = d / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d9 = d3 / (double)this.maxWidth * dArray[0];
            double d10 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            double d11 = d5 / (double)this.maxWidth * dArray[0];
            double d12 = dArray[1] - d6 / (double)this.maxHeight * dArray[1];
            trianglePrimitive.setTriangleCoords(d7, d8, d9, d10, d11, d12);
        }
    }

    @Override
    public synchronized int registerPrimitive(PrimitiveType primitiveType) {
        return this.registerPrimitive(primitiveType, false);
    }

    @Override
    public void setColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setColour(color);
        }
    }

    @Override
    public synchronized void unregisterPrimitive(int n) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.remove(n);
        if (overlayPrimitive != null && this.overlayPrimitiveGroupNode != null) {
            this.overlayPrimitiveGroupNode.removeChild(overlayPrimitive.getNode());
        }
        if (!this.overlayInOperation) {
            this.refresh();
        }
    }

    @Override
    public synchronized void unregisterPrimitive(List<Integer> list) {
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.remove(iterator.next());
            if (overlayPrimitive == null || this.overlayPrimitiveGroupNode == null) continue;
            this.overlayPrimitiveGroupNode.removeChild(overlayPrimitive.getNode());
        }
        if (!this.overlayInOperation) {
            this.refresh();
        }
    }

    @Override
    public void setStyle(int n, VectorOverlayStyles vectorOverlayStyles) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setStyle(vectorOverlayStyles);
        }
    }

    @Override
    public void setOutlineColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setOutlineColour(color);
        }
    }

    @Override
    public void translatePrimitive(int n, double d, double d2) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            double[] dArray = new double[2];
            double[] dArray2 = this.determineXYsize();
            dArray[0] = d / (double)this.maxWidth * dArray2[0];
            dArray[1] = -(d2 / (double)this.maxHeight) * dArray2[1];
            overlayPrimitive.translate(dArray);
        }
    }

    @Override
    public void rotatePrimitive(int n, double d, double d2, double d3) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            double[] dArray = new double[2];
            double[] dArray2 = this.determineXYsize();
            dArray[0] = d2 / (double)this.maxWidth * dArray2[0];
            dArray[1] = dArray2[1] - d3 / (double)this.maxHeight * dArray2[1];
            overlayPrimitive.rotate(d, dArray);
        }
    }

    @Override
    public boolean setTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setTransparency(d);
            bl = true;
        }
        return bl;
    }

    protected PointSet createTitleGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[] dArray = new double[3];
        String[] stringArray = new String[]{this.titleLabelStr != null ? this.titleLabelStr : ""};
        dArray[0] = 0.5;
        dArray[1] = this.determineXYsize()[1];
        dArray[2] = 0.0;
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public void setTitle(String string) {
        if (this.titleLabelStr == null || !string.equals(this.titleLabelStr)) {
            this.titleLabelStr = string;
            this.titleLabel.setGeometry((Geometry)this.createTitleGeometry());
        }
    }

    @Override
    public void setTickGridLinesActive(boolean bl, boolean bl2, boolean bl3) {
    }

    @Override
    public void setZAxisValues(AxisValues axisValues) {
    }

    @Override
    public void setLineThickness(int n, double d) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setLineThickness(d);
        }
    }

    @Override
    public boolean setOutlineTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setOutlineTransparency(d);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setPrimitiveVisible(int n, boolean bl) {
        boolean bl2 = false;
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            if (bl) {
                if (overlayPrimitive.isHidden() && this.overlayPrimitiveGroupNode != null) {
                    this.overlayPrimitiveGroupNode.addChild(overlayPrimitive.getNode());
                    bl2 = true;
                    overlayPrimitive.unhide();
                }
            } else if (!overlayPrimitive.isHidden() && this.overlayPrimitiveGroupNode != null) {
                this.overlayPrimitiveGroupNode.removeChild(overlayPrimitive.getNode());
                overlayPrimitive.hide();
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public void resetView() {
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFieldOfView(52.5);
        this.labelScaling = 1.0;
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
    }

    private void updateScaledPrimitive(OverlayPrimitive overlayPrimitive, double d) {
        double[] dArray = overlayPrimitive.getAnchorPoint();
        double d2 = dArray[0] * d - dArray[0];
        double d3 = dArray[1] * d - dArray[1];
        if (overlayPrimitive.getTransformationMatrix() != null) {
            MatrixBuilder.euclidean().scale(this.inverseScaling).translate(d2, d3, 0.0).times(overlayPrimitive.getTransformationMatrix()).assignTo(overlayPrimitive.getNode());
        } else {
            MatrixBuilder.euclidean().scale(this.inverseScaling).translate(d2, d3, 0.0).assignTo(overlayPrimitive.getNode());
        }
    }

    public void transformationMatrixChanged(TransformationEvent transformationEvent) {
        double[] dArray = transformationEvent.getTransformationMatrix();
        double[] dArray2 = this.determineXYsize();
        if (dArray2[0] * dArray[0] < MINX) {
            this.labelScaling = dArray2[0] * dArray[0] / MINX;
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
        }
        this.inverseScaling = 1.0 / dArray[0];
        double d = dArray[0];
        Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
            if (overlayPrimitive == null || !overlayPrimitive.isFixedSize()) continue;
            this.updateScaledPrimitive(overlayPrimitive, d);
        }
    }

    @Override
    public synchronized int registerPrimitive(PrimitiveType primitiveType, boolean bl) {
        if (this.subGraphs.size() != 0) {
            ++this.primKeyID;
            while (this.prim2DMap.containsKey(this.primKeyID)) {
                this.primKeyID = (this.primKeyID + 1) % Integer.MAX_VALUE;
            }
            OverlayPrimitive overlayPrimitive = null;
            SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)("overlayPrim" + this.primKeyID));
            this.overlayPrimitiveGroupNode.addChild(sceneGraphComponent);
            switch (primitiveType) {
                case LINE: {
                    overlayPrimitive = new LinePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case BOX: {
                    overlayPrimitive = new BoxPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case ARROW: {
                    overlayPrimitive = new ArrowPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case CIRCLE: {
                    overlayPrimitive = new CirclePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case TRIANGLE: {
                    overlayPrimitive = new TrianglePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case SECTOR: {
                    overlayPrimitive = new CircleSectorPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case LABEL: {
                    overlayPrimitive = new LabelPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case POINT: {
                    overlayPrimitive = new PointPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case POINTLIST: {
                    overlayPrimitive = new PointListPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case RING: {
                    overlayPrimitive = new RingPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case ELLIPSE: {
                    overlayPrimitive = new EllipsePrimitive(sceneGraphComponent, bl);
                }
            }
            this.prim2DMap.put(this.primKeyID, overlayPrimitive);
            return this.primKeyID;
        }
        return -1;
    }

    @Override
    public void setAnchorPoints(int n, double d, double d2) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null && overlayPrimitive.isFixedSize()) {
            double[] dArray = this.determineXYsize();
            double d3 = d / (double)this.maxWidth * dArray[0];
            double d4 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            overlayPrimitive.setAnchorPoint(d3, d4);
        }
    }

    public void addPlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.add(plotActionEventListener);
    }

    public void removePlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.remove(plotActionEventListener);
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
        int n;
        double[] dArray = this.determineXYsize();
        double d = plotActionEvent.getPosition()[0] / dArray[0];
        double d2 = 1.0 - plotActionEvent.getPosition()[1] / dArray[1];
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.xAxis) {
            case LINEAR: {
                d3 = d * (double)this.maxWidth;
                n2 = (int)d3;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                d3 = (double)this.maxWidth * d;
                n2 = (int)d3;
                d3 += this.xOffset;
                break;
            }
            case CUSTOM: {
                n2 = n = (int)((double)this.maxWidth * d);
                d3 = this.xAxisValues.getValue(n);
            }
        }
        switch (this.yAxis) {
            case LINEAR: {
                d4 = (double)this.maxHeight * d2;
                n3 = (int)d4;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                d4 = (double)this.maxHeight * d2;
                n3 = (int)d4;
                d4 += this.yOffset;
                break;
            }
            case CUSTOM: {
                n3 = n = (int)((double)this.maxHeight * d2);
                d4 = this.yAxisValues.getValue(n);
            }
        }
        Iterator<PlotActionEventListener> iterator = this.actionListeners.iterator();
        double[] dArray2 = new double[]{d3, d4};
        int[] nArray = new int[]{n2, n3};
        PlotActionEvent plotActionEvent2 = new PlotActionEvent(this.actionTool, dArray2);
        plotActionEvent2.setDataPosition(nArray);
        while (iterator.hasNext()) {
            PlotActionEventListener plotActionEventListener = iterator.next();
            plotActionEventListener.plotActionPerformed(plotActionEvent2);
        }
    }

    public void enablePlotActionTool(boolean bl) {
        if (this.graph != null) {
            if (bl) {
                this.graph.addTool((Tool)this.actionTool);
            } else {
                this.graph.removeTool((Tool)this.actionTool);
            }
        }
    }

    @Override
    public void drawLabel(int n, double d, double d2) {
        LabelPrimitive labelPrimitive;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d3 = d / (double)this.maxWidth * dArray[0];
            double d4 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            labelPrimitive.setLabelPosition(d3, d4);
        }
    }

    @Override
    public boolean setLabelFont(int n, Font font) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelFont(font);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelOrientation(int n, LabelOrientation labelOrientation) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelDirection(labelOrientation);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelText(int n, String string, int n2) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelString(string);
            labelPrimitive.setLabelAlignment(n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public void drawPoint(int n, double d, double d2) {
        PointPrimitive pointPrimitive;
        if (this.overlayInOperation && (pointPrimitive = (PointPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d3 = dArray[0] / ((double)this.maxWidth * 2.0);
            double d4 = dArray[1] / ((double)this.maxHeight * 2.0);
            double d5 = d / (double)this.maxWidth * dArray[0] + d3;
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1] - d4;
            pointPrimitive.setPoint(d5, d6);
        }
    }

    @Override
    public void setThickPoints(int n, boolean bl) {
        PointPrimitive pointPrimitive;
        if (this.overlayInOperation && (pointPrimitive = (PointPrimitive)this.prim2DMap.get(n)) != null) {
            pointPrimitive.setPhat(bl);
        }
    }

    @Override
    public void drawPoints(int n, double[] dArray, double[] dArray2) {
        PointListPrimitive pointListPrimitive;
        if (this.overlayInOperation && dArray.length == dArray2.length && (pointListPrimitive = (PointListPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray3 = this.determineXYsize();
            double d = dArray3[0] / ((double)this.maxWidth * 2.0);
            double d2 = dArray3[1] / ((double)this.maxHeight * 2.0);
            double[] dArray4 = new double[dArray.length];
            double[] dArray5 = new double[dArray2.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray4[n2] = dArray[n2] / (double)this.maxWidth * dArray3[0] + d;
                dArray5[n2] = dArray3[1] - dArray2[n2] / (double)this.maxHeight * dArray3[1] - d2;
                ++n2;
            }
            pointListPrimitive.setPoints(dArray4, dArray5);
        }
    }

    @Override
    public void drawRing(int n, double d, double d2, double d3, double d4) {
        RingPrimitive ringPrimitive;
        if (this.overlayInOperation && (ringPrimitive = (RingPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = d / (double)this.maxWidth * dArray[0];
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d7 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d8 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            ringPrimitive.setRingParameters(d5, d6, d7, d8);
        }
    }

    @Override
    public void drawEllipse(int n, double d, double d2, double d3, double d4, double d5) {
        EllipsePrimitive ellipsePrimitive;
        if (this.overlayInOperation && (ellipsePrimitive = (EllipsePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d6 = d / (double)this.maxWidth * dArray[0];
            double d7 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d8 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d9 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            ellipsePrimitive.setEllipseParameters(d6, d7, d8, d9, d5);
        }
    }

    @Override
    public ScaleType getScaling() {
        return this.currentScale;
    }

    public void setCanvasAspectRation(boolean bl) {
        this.useCanvasAspect = bl;
        double[] dArray = this.determineXYsize();
        for (SceneGraphComponent sceneGraphComponent : this.subGraphs) {
            sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(dArray[0], dArray[1], 0.0, 0.0));
        }
        this.updateClipPlanePositions(dArray);
        this.posTool.setMaxXY(dArray[0], dArray[1]);
        this.panTool.setDataDimension(dArray[0], dArray[1]);
        if (this.xTickNode != null) {
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTickNode != null) {
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        if (this.titleLabel != null) {
            this.titleLabel.setGeometry((Geometry)this.createTitleGeometry());
        }
        this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        this.createYAxisLabelGeom();
        this.createXAxisLabelGeom();
    }

    @Override
    public List<AxisValues> getAxisValues() {
        return null;
    }

    @Override
    public void restoreDefaultPlotAreaCursor() {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSet3DPlot2D.this.plotArea.setCursor(DataSet3DPlot2D.this.defaultCursor);
            }
        });
    }

    @Override
    public void setPlotAreaCursor(final int n) {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DataSet3DPlot2D.this.plotArea.getDisplay().getSystemCursor(n);
                if (cursor != null) {
                    DataSet3DPlot2D.this.plotArea.setCursor(cursor);
                }
            }
        });
    }

    public void setGradientImageMode(boolean bl) {
        if (this.currentImageType == 0 && this.graph != null) {
            this.useGradientMode = bl;
            this.loadGLSLProgram(this.tableMin, this.tableMax);
            if (bl && this.tableProg != null) {
                float[] fArray = new float[]{1.0f / (float)this.maxWidth, 1.0f / (float)this.maxHeight};
                float f = 1.0f;
                f = this.tableMax < 100.0 ? 0.5f : 0.1f;
                this.tableProg.setUniform("sampler", 0);
                this.tableProg.setUniform("tableSampler", 1);
                this.tableProg.setUniform("overlaySampler", 2);
                this.tableProg.setUniform("maxValue", this.tableMax);
                this.tableProg.setUniform("minValue", this.tableMin);
                this.tableProg.setUniform("delta", fArray);
                this.tableProg.setUniform("threshold", f);
            }
        }
    }

    public void setDiffractionImageMode(boolean bl) {
        if (this.currentImageType == 0 && this.graph != null) {
            this.useDiffractionMode = bl;
            this.loadGLSLProgram(this.tableMin, this.tableMax);
            if (bl && this.tableProg != null) {
                this.tableProg.setUniform("sampler", 0);
                this.tableProg.setUniform("tableSampler", 1);
                this.tableProg.setUniform("overlaySampler", 2);
                this.tableProg.setUniform("threshold", this.threshold);
            }
        }
    }

    public void changeThreshold(double d) {
        if (this.useDiffractionMode && this.tableProg != null) {
            this.threshold = d;
            this.tableProg.setUniform("threshold", this.threshold);
        }
    }

    @Override
    public OverlayObject registerObject(PrimitiveType primitiveType) {
        int n = this.registerPrimitive(primitiveType, false);
        if (n != -1) {
            switch (primitiveType) {
                case LINE: {
                    return new LineObject(n, this);
                }
                case ARROW: {
                    return new ArrowObject(n, this);
                }
                case BOX: {
                    return new BoxObject(n, this);
                }
                case CIRCLE: {
                    return new CircleObject(n, this);
                }
                case SECTOR: {
                    return new CircleSectorObject(n, this);
                }
                case ELLIPSE: {
                    return new EllipseObject(n, this);
                }
                case LABEL: {
                    return new TextLabelObject(n, this);
                }
                case TRIANGLE: {
                    return new TriangleObject(n, this);
                }
                case POINT: {
                    return new PointObject(n, this);
                }
                case POINTLIST: {
                    return new PointListObject(n, this);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public OverlayImage registerOverlayImage(int n, int n2) {
        this.overlayImage = new OverlayImage(n, n2);
        this.overlayImage.clear((short)0, (short)0, (short)0, (short)0);
        if (this.hasJOGLshaders) {
            for (Appearance appearance : this.graphApps) {
                Texture2D texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)appearance, (boolean)true);
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setImage(new ImageData(this.overlayImage.getImageData(), this.overlayImage.getWidth(), this.overlayImage.getHeight()));
                this.overlayTextures.put(appearance, texture2D);
            }
            if (this.tableProg != null) {
                this.tableProg.setUniform("overlaySampler", 2);
            }
        } else {
            for (Appearance appearance : this.graphApps) {
                ImageData imageData = new ImageData(this.overlayImage.getImageData(), this.overlayImage.getWidth(), this.overlayImage.getHeight());
                Texture2D texture2D = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)imageData);
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
                texture2D.setMagFilter(Integer.valueOf(9728));
                texture2D.setMinFilter(Integer.valueOf(9728));
                this.overlayTextures.put(appearance, texture2D);
            }
            if (this.tableProg != null) {
                this.tableProg.setUniform("overlaySampler", 2);
            }
        }
        this.overlayImage.clean();
        return this.overlayImage;
    }

    @Override
    public void toggleErrorBars(boolean bl, boolean bl2, boolean bl3) {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType() {
        if ($SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType != null) {
            return $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType;
        }
        int[] nArray = new int[ScaleType.values().length];
        try {
            nArray[ScaleType.LINEAR.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LOG10.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LOG2.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType = nArray;
        return nArray;
    }
}

