/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;

public class DataSet3DPlot1DStack
extends DataSet3DPlot1D {
    private IndexedLineSetFactory areaSelectFactory;
    private SceneGraphComponent zTicks = null;
    private SceneGraphComponent zAxisLabel = null;
    private SceneGraphComponent zLabels = null;
    private SceneGraphComponent bBox = null;
    private DefaultTextShader dtsZAxisLabel;
    private DefaultTextShader dtsZTicks;
    private String zAxisLabelStr = null;
    private TickFormatting zLabelMode = TickFormatting.roundAndChopMode;
    private static final double TICKWIDTH = 0.25;
    private static final double INITROTATION = -0.7853981633974483;
    private double zOffset;
    private double zAxisLength;
    private double zGapBetweenGraphs = -0.0;
    private AxisValues zAxisValues = null;

    public DataSet3DPlot1DStack(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, Plot1DGraphTable plot1DGraphTable, boolean bl) {
        super(abstractViewerApp, composite, cursor, plot1DGraphTable, bl);
        this.showXTicks = true;
        this.showYTicks = true;
        this.areaSelectFactory = new IndexedLineSetFactory();
    }

    @Override
    protected void repositionAndScaleAxis(float f) {
        MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.axis);
    }

    @Override
    protected void resizeAndPositionNodes() {
        MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.graph);
        if (this.xTicks != null) {
            MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.xTicks);
        }
        if (this.yTicks != null) {
            MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.yTicks);
        }
    }

    private void updateGraphsZPosition() {
        Iterator iterator = this.subGraphs.iterator();
        Iterator<Double> iterator2 = this.zAxisValues.iterator();
        double d = this.zAxisValues.getMinValue();
        double d2 = this.zAxisValues.getMaxValue();
        while (iterator.hasNext()) {
            SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)iterator.next();
            if (!iterator2.hasNext()) break;
            double d3 = iterator2.next();
            double d4 = this.zAxisLength * (d3 - d) / (d2 - d);
            MatrixBuilder.euclidean().translate(0.0, 0.0, d4).assignTo(sceneGraphComponent);
        }
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        this.zGapBetweenGraphs = 15.0 / (double)list.size();
        if (this.zGapBetweenGraphs > 1.0) {
            this.zGapBetweenGraphs = 1.0;
        }
        this.zAxisLength = this.zGapBetweenGraphs * (double)list.size();
        SceneGraphComponent sceneGraphComponent2 = super.buildGraph(list, sceneGraphComponent);
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFar(500.0);
        camera.setNear(0.5);
        sceneGraphComponent.removeTool((Tool)this.tool);
        if (this.zAxisValues == null) {
            this.zAxisValues = new AxisValues(AbstractDataset.arange((double)((double)(1 + list.size()) + this.zOffset), (int)6));
        }
        if (this.zTicks != null) {
            this.zTicks.setGeometry((Geometry)this.createZTicksGeometry());
        }
        if (this.zLabels != null) {
            this.zLabels.setGeometry((Geometry)this.createZLabelsGeometry());
        }
        this.updateGraphsZPosition();
        return sceneGraphComponent2;
    }

    @Override
    public void enableZoomTool(boolean bl) {
        if (bl && !this.zoomToolEnabled) {
            this.graph.addTool((Tool)this.tool);
        } else if (!bl) {
            this.graph.removeTool((Tool)this.tool);
        }
        this.zoomToolEnabled = bl;
    }

    @Override
    protected void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        Iterator iterator2 = this.offsets.iterator();
        Iterator iterator3 = this.xAxes.iterator();
        this.globalYmin = 3.4028234663852886E38;
        this.globalYmax = -3.4028234663852886E38;
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            this.globalYmin = Math.min(this.globalYmin, iDataset.min().doubleValue());
            this.globalYmax = Math.max(this.globalYmax, iDataset.max().doubleValue());
            this.globalXmax = Math.max(this.globalXmax, (double)iDataset.getShape()[0]);
            switch (this.xAxis) {
                case LINEAR: {
                    this.globalRealXmin = 0.0;
                    this.globalRealXmax = this.globalXmax - 1.0;
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    double d = (Double)iterator2.next();
                    this.globalRealXmin = Math.min(d, this.globalRealXmin);
                    this.globalRealXmax = Math.max(this.globalXmax + d, this.globalRealXmax) - 1.0;
                    break;
                }
                case CUSTOM: {
                    AxisValues axisValues = (AxisValues)iterator3.next();
                    this.globalRealXmin = Math.min(this.globalRealXmin, axisValues.getMinValue());
                    this.globalRealXmax = Math.max(this.globalRealXmax, axisValues.getMaxValue());
                }
            }
        }
        if (this.yAxis == AxisMode.LINEAR_WITH_OFFSET) {
            this.globalYmin += this.yOffset;
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
    }

    @Override
    protected Geometry createAreaSelection() {
        double[][] dArray = ArrayPoolUtility.getDoubleArray(8);
        int[][] nArray = ArrayPoolUtility.getIntArray(12);
        dArray[0][0] = this.areaSelectStart[0];
        dArray[0][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[0][2] = 0.0;
        dArray[1][0] = this.areaSelectEnd[0];
        dArray[1][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[1][2] = 0.0;
        dArray[2][0] = this.areaSelectStart[0];
        dArray[2][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[2][2] = 0.0;
        dArray[3][0] = this.areaSelectEnd[0];
        dArray[3][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[3][2] = 0.0;
        dArray[4][0] = this.areaSelectStart[0];
        dArray[4][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[4][2] = this.zAxisLength;
        dArray[5][0] = this.areaSelectEnd[0];
        dArray[5][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[5][2] = this.zAxisLength;
        dArray[6][0] = this.areaSelectStart[0];
        dArray[6][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[6][2] = this.zAxisLength;
        dArray[7][0] = this.areaSelectEnd[0];
        dArray[7][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[7][2] = this.zAxisLength;
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 0;
        nArray[1][1] = 2;
        nArray[2][0] = 2;
        nArray[2][1] = 3;
        nArray[3][0] = 1;
        nArray[3][1] = 3;
        nArray[4][0] = 4;
        nArray[4][1] = 5;
        nArray[5][0] = 4;
        nArray[5][1] = 6;
        nArray[6][0] = 6;
        nArray[6][1] = 7;
        nArray[7][0] = 5;
        nArray[7][1] = 7;
        nArray[8][0] = 0;
        nArray[8][1] = 4;
        nArray[9][0] = 1;
        nArray[9][1] = 5;
        nArray[10][0] = 2;
        nArray[10][1] = 6;
        nArray[11][0] = 3;
        nArray[11][1] = 7;
        this.areaSelectFactory.setVertexCount(8);
        this.areaSelectFactory.setEdgeCount(12);
        this.areaSelectFactory.setVertexCoordinates(dArray);
        this.areaSelectFactory.setEdgeIndices(nArray);
        this.areaSelectFactory.update();
        return this.areaSelectFactory.getIndexedLineSet();
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        this.zGapBetweenGraphs = 15.0 / (double)list.size();
        if (this.zGapBetweenGraphs > 1.0) {
            this.zGapBetweenGraphs = 1.0;
        }
        this.zAxisLength = this.zGapBetweenGraphs * (double)list.size();
        super.updateGraph(list);
        if (this.zAxisValues != null) {
            if (this.zAxisValues.size() < list.size()) {
                int n = this.zAxisValues.size();
                int n2 = list.size();
                while (n < n2) {
                    this.zAxisValues.addValue((double)(n + 1) + this.zOffset);
                    ++n;
                }
            }
        } else {
            this.zAxisValues = new AxisValues(AbstractDataset.arange((double)((double)(1 + list.size()) + this.zOffset), (int)6));
        }
        this.updateGraphsZPosition();
        this.axis.setGeometry((Geometry)this.createAxisGeometry());
        if (this.zAxisLabelStr != null) {
            this.generateZLabelGeom();
        }
        if (this.zLabels != null) {
            this.zLabels.setGeometry((Geometry)this.createZLabelsGeometry());
        }
        if (this.zTicks != null) {
            this.zTicks.setGeometry((Geometry)this.createZTicksGeometry());
        }
    }

    @Override
    protected IndexedLineSet createAxisGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(6);
        indexedLineSetFactory.setEdgeCount(3);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(6);
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 14.75;
        dArray[1][1] = 0.0;
        dArray[1][2] = 0.0;
        dArray[2][0] = 0.0;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = 15.0;
        dArray[3][2] = 0.0;
        dArray[4][0] = 0.0;
        dArray[4][1] = 0.0;
        dArray[4][2] = 0.0;
        dArray[5][0] = 0.0;
        dArray[5][1] = 0.0;
        dArray[5][2] = this.zAxisLength;
        int[][] nArray = ArrayPoolUtility.getIntArray(2);
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 2;
        nArray[1][1] = 3;
        nArray[2][0] = 4;
        nArray[2][1] = 5;
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    protected IndexedLineSet createXTicksGeometry() {
        double d = this.graphXmin;
        if (this.xLabels != null) {
            this.xLabels.setGeometry((Geometry)this.createXLabelsGeometry(this.xTicksLabels));
        }
        if (this.showXTicks) {
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(this.xTicksLabels.size() * 3);
            indexedLineSetFactory.setEdgeCount(this.xTicksLabels.size() * 2);
            double[][] dArray = ArrayPoolUtility.getDoubleArray(this.xTicksLabels.size() * 3);
            int[][] nArray = ArrayPoolUtility.getIntArray(this.xTicksLabels.size() * 2);
            int n = 0;
            while (n < this.xTicksLabels.size()) {
                double d2 = this.xTicksUnitSize * (double)n;
                dArray[n * 3][0] = d2 / (this.graphXmax - d) * 14.75;
                dArray[n * 3][1] = -0.125;
                dArray[n * 3][2] = -1.0E-4;
                dArray[n * 3 + 1][0] = d2 / (this.graphXmax - d) * 14.75;
                dArray[n * 3 + 1][1] = 15.0;
                dArray[n * 3 + 1][2] = -1.0E-4;
                dArray[n * 3 + 2][0] = d2 / (this.graphXmax - d) * 14.75;
                dArray[n * 3 + 2][1] = -1.0E-4;
                dArray[n * 3 + 2][2] = this.zAxisLength;
                nArray[n * 2][0] = n * 3;
                nArray[n * 2][1] = n * 3 + 1;
                nArray[n * 2 + 1][0] = n * 3;
                nArray[n * 2 + 1][1] = n * 3 + 2;
                ++n;
            }
            indexedLineSetFactory.setVertexCoordinates(dArray);
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    private PointSet createZLabelsGeometry() {
        this.tickFactory.setTickMode(this.zLabelMode);
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(Math.min(15, this.zAxisValues.size()), this.zAxisValues.getMinValue(), this.zAxisValues.getMaxValue(), (short)2, false);
        PointSetFactory pointSetFactory = new PointSetFactory();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        double d = this.zAxisValues.getMaxValue() - this.zAxisValues.getMinValue();
        int n = 0;
        while (n < linkedList.size()) {
            dArray[n][0] = -0.5;
            dArray[n][1] = -0.25;
            if (n != 0 && n != linkedList.size() - 1) {
                Tick tick = linkedList.get(n);
                dArray[n][2] = this.zAxisLength * (tick.getTickValue() - this.zAxisValues.getMinValue()) / d;
                stringArray[n] = Double.toString(tick.getTickValue());
            } else if (n == 0) {
                dArray[n][2] = 0.0;
                stringArray[n] = Double.toString(this.zAxisValues.getMinValue());
            } else if (n == linkedList.size() - 1) {
                dArray[n][2] = this.zAxisLength * (this.zAxisValues.getMaxValue() - this.zAxisValues.getMinValue()) / d;
                stringArray[n] = Double.toString(this.zAxisValues.getMaxValue());
            }
            ++n;
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    private IndexedLineSet createZTicksGeometry() {
        this.tickFactory.setTickMode(this.zLabelMode);
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(Math.min(15, this.zAxisValues.size()), this.zAxisValues.getMinValue(), this.zAxisValues.getMaxValue(), (short)2, false);
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size() * 2);
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        double d = this.zAxisValues.getMaxValue() - this.zAxisValues.getMinValue();
        int n = 0;
        while (n < linkedList.size()) {
            double d2 = this.zAxisLength * (linkedList.get(n).getTickValue() - this.zAxisValues.getMinValue()) / d;
            if (n == 0) {
                d2 = 0.0;
            } else if (n == linkedList.size() - 1) {
                d2 = this.zAxisLength * (this.zAxisValues.getMaxValue() - this.zAxisValues.getMinValue()) / d;
            }
            dArray[n * 2][0] = -0.25;
            dArray[n * 2][1] = 1.0E-4;
            dArray[n * 2][2] = d2;
            dArray[n * 2 + 1][0] = 15.0;
            dArray[n * 2 + 1][1] = 1.0E-4;
            dArray[n * 2 + 1][2] = d2;
            nArray[n][0] = n * 2;
            nArray[n][1] = n * 2 + 1;
            ++n;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public void buildZCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.zTicks = sceneGraphComponent;
        if (sceneGraphComponent != null) {
            this.zLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"zLabels");
            sceneGraphComponent.addChild(this.zLabels);
            Appearance appearance = new Appearance();
            sceneGraphComponent.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            appearance.setAttribute("lineShader.tubeDraw", false);
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setLineStipple(Boolean.valueOf(true));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            Appearance appearance2 = new Appearance();
            this.zLabels.setAppearance(appearance2);
            DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
            appearance2.setAttribute("pointShader.spheresDraw", false);
            appearance2.setAttribute("attenuatePointSize", false);
            appearance2.setAttribute("lightingEnabled", false);
            DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
            defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
            defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
            defaultPointShader.setPointSize(Double.valueOf(1.0));
            defaultPointShader.setDiffuseColor(Color.WHITE);
            this.dtsZTicks = (DefaultTextShader)defaultPointShader.getTextShader();
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            this.dtsZTicks.setOffset(dArray);
            this.dtsZTicks.setAlignment(Integer.valueOf(0));
            this.dtsZTicks.setScale(Double.valueOf(0.0075));
            this.dtsZTicks.setDiffuseColor(Color.black);
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setLineStipple(Boolean.valueOf(true));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n == 0) {
                n = 490;
            }
            if (n2 == 0) {
                n2 = 475;
            }
            MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(sceneGraphComponent);
        }
    }

    @Override
    public SceneGraphComponent buildCoordAxis(SceneGraphComponent sceneGraphComponent) {
        super.buildCoordAxis(sceneGraphComponent);
        this.zAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"zAxisLabel");
        sceneGraphComponent.addChild(this.zAxisLabel);
        Appearance appearance = new Appearance();
        this.zAxisLabel.setAppearance(appearance);
        appearance.setAttribute("pointShader.spheresDraw", false);
        appearance.setAttribute("attenuatePointSize", false);
        appearance.setAttribute("lightingEnabled", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        this.dtsZAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsZAxisLabel.setDiffuseColor(Color.black);
        this.dtsZAxisLabel.setTextdirection(Integer.valueOf(0));
        this.dtsZAxisLabel.setScale(Double.valueOf(0.0075));
        return sceneGraphComponent;
    }

    @Override
    public void cleanUpGraphNode() {
        super.cleanUpGraphNode();
        if (this.axis != null) {
            this.axis.removeChild(this.zAxisLabel);
        }
        if (this.zTicks != null) {
            this.zTicks.removeChild(this.zLabels);
            this.zTicks.setGeometry(null);
        }
    }

    private void generateZLabelGeom() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
        String[] stringArray = new String[]{this.zAxisLabelStr};
        dArray[0][0] = -0.75;
        dArray[0][1] = -0.75;
        dArray[0][2] = this.zAxisLength * 0.5;
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        this.zAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
    }

    @Override
    public void setZAxisLabel(String string) {
        if (this.zAxisLabelStr == null || !string.equals(this.zAxisLabelStr)) {
            this.zAxisLabelStr = string;
            this.generateZLabelGeom();
        }
    }

    @Override
    public void setZAxisLabelMode(TickFormatting tickFormatting) {
        this.zLabelMode = tickFormatting;
    }

    @Override
    public void notifyComponentResize(int n, int n2) {
        if (this.graph != null) {
            MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.graph);
            if (this.axis != null) {
                MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.axis);
            }
            if (this.xTicks != null) {
                MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.xTicks);
            }
            if (this.yTicks != null) {
                MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.yTicks);
            }
        }
        if (this.bBox != null) {
            MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.bBox);
        }
        MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.zTicks);
    }

    public double getZAxisLengthFactor() {
        return this.zAxisLength / 15.0;
    }

    public void setZAxisLengthFactor(double d) {
        this.zAxisLength = 15.0 * d;
        this.updateGraphsZPosition();
        if (this.bBox != null) {
            this.bBox.setGeometry((Geometry)this.createBBoxGeometry());
        }
        if (this.xTicks != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.zTicks != null) {
            this.zTicks.setGeometry((Geometry)this.createZTicksGeometry());
        }
        if (this.zLabels != null) {
            this.zLabels.setGeometry((Geometry)this.createZLabelsGeometry());
        }
        if (this.axis != null) {
            this.axis.setGeometry((Geometry)this.createAxisGeometry());
        }
        if (this.zAxisLabelStr != null) {
            this.generateZLabelGeom();
        }
    }

    @Override
    public void setZAxisOffset(double d) {
        this.zOffset = d;
    }

    @Override
    public void setZAxisValues(AxisValues axisValues) {
        this.zAxisValues = axisValues;
    }

    private IndexedLineSet createBBoxGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double[][] dArray = new double[8][3];
        int[][] nArray = new int[12][2];
        dArray[0][0] = 0.0;
        dArray[0][1] = 15.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 15.0;
        dArray[1][1] = 15.0;
        dArray[1][2] = 0.0;
        dArray[2][0] = 15.0;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = 0.0;
        dArray[3][2] = 0.0;
        dArray[4][0] = 0.0;
        dArray[4][1] = 15.0;
        dArray[4][2] = this.zAxisLength;
        dArray[5][0] = 15.0;
        dArray[5][1] = 15.0;
        dArray[5][2] = this.zAxisLength;
        dArray[6][0] = 15.0;
        dArray[6][1] = 0.0;
        dArray[6][2] = this.zAxisLength;
        dArray[7][0] = 0.0;
        dArray[7][1] = 0.0;
        dArray[7][2] = this.zAxisLength;
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 1;
        nArray[1][1] = 2;
        nArray[2][0] = 2;
        nArray[2][1] = 3;
        nArray[3][0] = 3;
        nArray[3][1] = 0;
        nArray[4][0] = 4;
        nArray[4][1] = 5;
        nArray[5][0] = 5;
        nArray[5][1] = 6;
        nArray[6][0] = 6;
        nArray[6][1] = 7;
        nArray[7][0] = 7;
        nArray[7][1] = 4;
        nArray[8][0] = 0;
        nArray[8][1] = 4;
        nArray[9][0] = 1;
        nArray[9][1] = 5;
        nArray[10][0] = 2;
        nArray[10][1] = 6;
        nArray[11][0] = 3;
        nArray[11][1] = 7;
        indexedLineSetFactory.setEdgeCount(12);
        indexedLineSetFactory.setVertexCount(8);
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildBoundingBox() {
        this.bBox = SceneGraphUtility.createFullSceneGraphComponent((String)"BBox");
        Appearance appearance = new Appearance();
        this.bBox.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setDiffuseColor(Color.GRAY);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        this.bBox.setGeometry((Geometry)this.createBBoxGeometry());
        MatrixBuilder.euclidean().rotate(-0.7853981633974483, -1.0, 1.0, 0.0).translate(-6.75, -7.5, -4.95).scale(0.85).assignTo(this.bBox);
        return this.bBox;
    }
}

