/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ScalingUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.TickFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.enums.LabelOrientation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.BoxPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.LabelPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.LinePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.OverlayPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotRightClickActionTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SelectedWindow;

public class DataSet3DPlot1D
implements IDataSet3DCorePlot,
AreaSelectListener,
PlotActionEventListener,
Overlay1DProvider {
    public static String GRAPHNAMEPREFIX = "graph.subGraph";
    protected static final Logger logger = LoggerFactory.getLogger(DataSet3DPlot1D.class);
    protected List<IDataset> sets;
    protected SelectedWindow currentSelectWindow = null;
    protected SceneGraphComponent xTicks = null;
    protected SceneGraphComponent yTicks = null;
    protected AbstractViewerApp app;
    protected SceneGraphComponent graph = null;
    protected SceneGraphComponent areaSelection = null;
    protected SceneGraphComponent background = null;
    protected SceneGraphComponent axis = null;
    protected SceneGraphComponent graphGroupNode = null;
    protected SceneGraphComponent xLabels = null;
    protected double globalYmin = 3.4028234663852886E38;
    protected double globalYmax = 1.4E-45f;
    protected double globalXmin = 0.0;
    protected double globalXmax = -1.0;
    protected double globalRealXmax = 1.4E-45f;
    protected double globalRealXmin = 3.4028234663852886E38;
    protected double graphXmax = -3.4028234663852886E38;
    protected double graphXmin = 3.4028234663852886E38;
    protected double graphYmax = -3.4028234663852886E38;
    protected double graphYmin = 3.4028234663852886E38;
    protected int numGraphs = 0;
    protected List<SceneGraphComponent> subGraphs = Collections.synchronizedList(new LinkedList());
    protected LinkedList<DefaultLineShader> graphLineShaders;
    protected LinkedList<DefaultGeometryShader> graphShaders;
    protected Plot1DGraphTable graphColours;
    protected List<SelectedWindow> undoSelectStack = Collections.synchronizedList(new LinkedList());
    protected AreaSelectTool tool = null;
    protected TickFactory tickFactory = null;
    protected double font_scale;
    protected double font_scale_axis;
    protected double yOffset = 0.0;
    protected static final double xInset = 0.25;
    protected static final double yInset = 0.25;
    protected boolean zoomToolEnabled = false;
    protected boolean rangeZoom = true;
    protected boolean showXTicks = true;
    protected boolean showYTicks = true;
    protected boolean isUpdateOperation = false;
    protected double[] areaSelectStart = new double[2];
    protected double[] areaSelectEnd = new double[2];
    protected AxisMode zAxis = AxisMode.LINEAR;
    protected TickFormatting xLabelMode = TickFormatting.plainMode;
    protected LinkedList<Tick> xTicksLabels = null;
    protected LinkedList<Tick> yTicksLabels = null;
    protected double xTicksUnitSize = 0.0;
    protected double yTicksUnitSize = 0.0;
    protected AxisMode xAxis = AxisMode.LINEAR;
    protected AxisMode yAxis = AxisMode.LINEAR;
    protected List<AxisValues> xAxes = Collections.synchronizedList(new LinkedList());
    protected List<Double> offsets = Collections.synchronizedList(new LinkedList());
    private LinkedList<Tick> x2ndTicksLabels = null;
    private AxisValues secondaryXAxes;
    private AxisValues displaySecondaryXAxes;
    private DefaultTextShader dtsXTicks;
    private DefaultTextShader dtsX2Ticks;
    private DefaultTextShader dtsYTicks;
    private DefaultTextShader dtsXAxisLabel;
    private DefaultTextShader dtsX2AxisLabel;
    private DefaultTextShader dtsYAxisLabel;
    private DefaultTextShader dtsTitleLabel;
    private IDataset currentDataSet;
    private SceneGraphComponent yLabels = null;
    private SceneGraphComponent xAxisLabel = null;
    private SceneGraphComponent secondXAxisLabel = null;
    private SceneGraphComponent yAxisLabel = null;
    private SceneGraphComponent titleLabel = null;
    private SceneGraphComponent secondaryAxes = null;
    private SceneGraphComponent secondaryXAxisTicks = null;
    private SceneGraphComponent secondaryXAxisLabel = null;
    private SceneGraphComponent topClip = null;
    private SceneGraphComponent bottomClip = null;
    private ArrayPoolUtility pool = null;
    private QuadMeshFactory areaSelectFactory = null;
    private String xAxisLabelStr = null;
    private String x2AxisLabelStr = null;
    private String yAxisLabelStr = null;
    private String titleLabelStr = null;
    private PlotActionTool actionTool = null;
    private PlotRightClickActionTool rightClickActionTool = null;
    private List<PlotActionEventListener> actionListeners = Collections.synchronizedList(new LinkedList());
    private Map<Integer, OverlayPrimitive> prim1DMap = Collections.synchronizedMap(new HashMap(1000));
    private List<Overlay1DConsumer> overlayConsumer = new LinkedList<Overlay1DConsumer>();
    private TickFormatting yLabelMode = TickFormatting.plainMode;
    private ScaleType yScaling = ScaleType.LINEAR;
    private Composite plotArea;
    private Cursor defaultCursor;
    private double xOffset = 0.0;
    private boolean actionToolEnabled = false;
    private boolean rightClickActionToolEnabled = false;
    private boolean allowZoomMouseGesture = true;
    private boolean overlayInOperation = false;
    private int primKeyID = 0;
    private static final int DEFAULTMAXGRAPHSIZE = 50000;
    private static int MAXGRAPHSIZE = 50000;
    private static String ERRORMSG_WRONG_NUM_ENTRIES = "The number of entries in the value list does not match the number of graphs";
    private static String ERRORMSG_NO_GRAPH = "There is no graph data can be added to ";
    private static String ERRORMSG_NOT_LINEAR = "Can not add DataPoints to CUSTOM mode with this function";
    private static String ERRORMSG_NOT_CUSTOM = "Can not add DataPoints to NON CUSTOM mode with this function";
    private static final String LODSIZE_PROPERTY_STRING = "uk.ac.diamond.analysis.rcp.plotting.LODsize";
    private static final String USEUNZOOM_MOUSEGESTURE = "uk.ac.diamond.analysis.rcp.plotting.UnzoomGesture";
    private int crosshairID_x = -1;
    private int crosshairID_y = -1;

    public DataSet3DPlot1D(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, Plot1DGraphTable plot1DGraphTable, boolean bl) {
        String string = System.getProperty(LODSIZE_PROPERTY_STRING);
        this.plotArea = composite;
        this.defaultCursor = cursor;
        if (string != null) {
            try {
                MAXGRAPHSIZE = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                MAXGRAPHSIZE = 50000;
            }
        } else {
            MAXGRAPHSIZE = 50000;
        }
        if ((string = System.getProperty(USEUNZOOM_MOUSEGESTURE)) != null) {
            this.allowZoomMouseGesture = (string = string.toUpperCase()).equals("TRUE");
        }
        if (bl) {
            this.font_scale = 0.0075;
            this.font_scale_axis = 0.0075;
        } else {
            this.font_scale = 0.0085;
            this.font_scale_axis = 0.0085;
        }
        this.app = abstractViewerApp;
        this.pool = new ArrayPoolUtility();
        this.tickFactory = new TickFactory(TickFormatting.plainMode);
        this.tool = new AreaSelectTool();
        this.actionTool = new PlotActionTool();
        this.actionTool.addPlotActionEventListener(this);
        this.rightClickActionTool = new PlotRightClickActionTool();
        this.rightClickActionTool.addPlotActionEventListener(this);
        this.tool.addAreaSelectListener(this);
        this.graphLineShaders = new LinkedList();
        this.graphShaders = new LinkedList();
        this.graphColours = plot1DGraphTable;
    }

    @Override
    public SceneGraphComponent buildBoundingBox() {
        return null;
    }

    protected void refresh() {
        this.app.getCurrentViewer().render();
    }

    @Override
    public SceneGraphComponent buildCoordAxesTicks() {
        return null;
    }

    private void setScalingSmallFlag(double d) {
        switch (this.yScaling) {
            case LINEAR: {
                ScalingUtility.setSmallLogFlag(false);
                break;
            }
            case LN: {
                ScalingUtility.setSmallLogFlag(d < Math.E && d > 0.0);
                break;
            }
            case LOG10: {
                ScalingUtility.setSmallLogFlag(d < 10.0 && d > 0.0);
                break;
            }
            case LOG2: {
                ScalingUtility.setSmallLogFlag(d < 2.0 && d > 0.0);
            }
        }
    }

    private IndexedLineSet createSecondaryAxis() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(4);
        indexedLineSetFactory.setEdgeCount(2);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(2);
        dArray[0][0] = 0.0;
        dArray[0][1] = 14.75;
        dArray[0][2] = 0.0;
        dArray[1][0] = 14.75;
        dArray[1][1] = 14.75;
        dArray[1][2] = 0.0;
        int[][] nArray = ArrayPoolUtility.getIntArray(1);
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createAxisGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(4);
        indexedLineSetFactory.setEdgeCount(2);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(4);
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 14.75;
        dArray[1][1] = 0.0;
        dArray[1][2] = 0.0;
        dArray[2][0] = 0.0;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = 14.75;
        dArray[3][2] = 0.0;
        int[][] nArray = ArrayPoolUtility.getIntArray(2);
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 2;
        nArray[1][1] = 3;
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected void repositionAndScaleAxis(float f) {
        if (f > 1.0f) {
            MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.axis);
        } else {
            MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.axis);
        }
    }

    @Override
    public SceneGraphComponent buildCoordAxis(SceneGraphComponent sceneGraphComponent) {
        this.axis = sceneGraphComponent;
        this.xAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"xAxisLabel");
        this.yAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"yAxisLabel");
        this.titleLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"titleLabel");
        this.secondXAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"x2AxisLabel");
        this.secondaryAxes = SceneGraphUtility.createFullSceneGraphComponent((String)"SecondXAxis");
        this.secondaryXAxisTicks = SceneGraphUtility.createFullSceneGraphComponent((String)"SecondXAxisTicks");
        this.secondaryXAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"SecondaryAxisLabels");
        sceneGraphComponent.addChild(this.xAxisLabel);
        sceneGraphComponent.addChild(this.secondXAxisLabel);
        sceneGraphComponent.addChild(this.yAxisLabel);
        sceneGraphComponent.addChild(this.titleLabel);
        sceneGraphComponent.addChild(this.secondaryAxes);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        this.secondaryAxes.setAppearance(appearance);
        sceneGraphComponent.setGeometry((Geometry)this.createAxisGeometry());
        this.secondaryAxes.setGeometry((Geometry)this.createSecondaryAxis());
        this.secondaryAxes.addChild(this.secondaryXAxisTicks);
        this.secondaryAxes.addChild(this.secondaryXAxisLabel);
        Appearance appearance2 = new Appearance();
        this.secondaryXAxisTicks.setAppearance(appearance2);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
        appearance2.setAttribute("lineShader.tubeDraw", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setLineWidth(Double.valueOf(1.0));
        defaultLineShader.setLineStipple(Boolean.valueOf(false));
        defaultLineShader.setDiffuseColor(Color.lightGray);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        appearance2 = new Appearance();
        this.secondaryXAxisLabel.setAppearance(appearance2);
        defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
        appearance2.setAttribute("pointShader.spheresDraw", false);
        appearance2.setAttribute("lightingEnabled", false);
        appearance2.setAttribute("attenuatePointSize", false);
        defaultLineShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultLineShader.setPointSize(Double.valueOf(1.0));
        defaultLineShader.setDiffuseColor(Color.white);
        this.dtsX2Ticks = (DefaultTextShader)defaultLineShader.getTextShader();
        Object object = new double[]{0.0, 0.0, 0.0};
        this.dtsX2Ticks.setOffset(object);
        this.dtsX2Ticks.setScale(Double.valueOf(this.font_scale));
        this.dtsX2Ticks.setDiffuseColor(Color.lightGray);
        this.dtsX2Ticks.setAlignment(Integer.valueOf(0));
        appearance2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        defaultGeometryShader = (DefaultLineShader)appearance2.createLineShader("default");
        defaultGeometryShader.setLineWidth(Double.valueOf(1.0));
        defaultGeometryShader.setDiffuseColor(Color.black);
        appearance2.setShowFaces(Boolean.valueOf(false));
        appearance2.setShowLines(Boolean.valueOf(true));
        appearance2.setShowPoints(Boolean.valueOf(false));
        defaultLineShader = new Appearance();
        object = new Appearance();
        Appearance appearance3 = new Appearance();
        Appearance appearance4 = new Appearance();
        this.xAxisLabel.setAppearance((Appearance)defaultLineShader);
        this.secondXAxisLabel.setAppearance((Appearance)object);
        this.yAxisLabel.setAppearance(appearance3);
        this.titleLabel.setAppearance(appearance4);
        defaultLineShader.setAttribute("pointShader.spheresDraw", false);
        defaultLineShader.setAttribute("attenuatePointSize", false);
        defaultLineShader.setAttribute("lightingEnabled", false);
        object.setAttribute("pointShader.spheresDraw", false);
        object.setAttribute("attenuatePointSize", false);
        object.setAttribute("lightingEnabled", false);
        appearance3.setAttribute("pointShader.spheresDraw", false);
        appearance3.setAttribute("attenuatePointSize", false);
        appearance3.setAttribute("lightingEnabled", false);
        appearance4.setAttribute("pointShader.spheresDraw", false);
        appearance4.setAttribute("attenuatePointSize", false);
        appearance4.setAttribute("lightingEnabled", false);
        DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)defaultLineShader, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsXAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXAxisLabel.setDiffuseColor(Color.black);
        this.dtsXAxisLabel.setTextdirection(Integer.valueOf(0));
        this.dtsXAxisLabel.setScale(Double.valueOf(this.font_scale_axis));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)object, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsX2AxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        this.dtsX2AxisLabel.setDiffuseColor(Color.lightGray);
        this.dtsX2AxisLabel.setTextdirection(Integer.valueOf(0));
        this.dtsX2AxisLabel.setScale(Double.valueOf(this.font_scale_axis));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance3, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsYAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYAxisLabel.setDiffuseColor(Color.black);
        this.dtsYAxisLabel.setTextdirection(Integer.valueOf(1));
        this.dtsYAxisLabel.setScale(Double.valueOf(this.font_scale_axis));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance4, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsTitleLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        this.dtsTitleLabel.setDiffuseColor(Color.black);
        this.dtsTitleLabel.setAlignment(Integer.valueOf(0));
        this.dtsTitleLabel.setTextdirection(Integer.valueOf(0));
        this.dtsTitleLabel.setScale(Double.valueOf(this.font_scale_axis));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n == 0) {
            n = 490;
        }
        if (n2 == 0) {
            n2 = 475;
        }
        float f = (float)dimension.width / (float)dimension.height;
        this.repositionAndScaleAxis(f);
        double d = 1.0;
        if (n < 490) {
            d = 490.0 / (double)dimension.width;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)dimension.height);
        }
        if (d > 1.0) {
            this.dtsXAxisLabel.setScale(Double.valueOf(this.font_scale_axis * d));
            this.dtsYAxisLabel.setScale(Double.valueOf(this.font_scale_axis * d));
            this.dtsTitleLabel.setScale(Double.valueOf(this.font_scale_axis * d));
        }
        return sceneGraphComponent;
    }

    private IndexedLineSet createGraphGeometry(IDataset iDataset, double d) {
        int n = iDataset.getShape()[0];
        float f = 1.0f;
        if (n > MAXGRAPHSIZE) {
            f = (float)n / (float)MAXGRAPHSIZE;
            n = MAXGRAPHSIZE;
        }
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(n);
        indexedLineSetFactory.setEdgeCount(n - 1);
        double[] dArray = new double[n * 3];
        this.setScalingSmallFlag(this.graphYmin);
        double d2 = 14.75 / (this.globalRealXmax - this.globalRealXmin);
        double d3 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d4 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d5 = 14.75 / (d4 - d3);
        double d6 = d;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2 * 3] = ((double)n2 + Math.max(0.0, d6 - this.globalRealXmin)) * d2;
            dArray[n2 * 3 + 1] = (ScalingUtility.valueScaler(iDataset.getDouble(new int[]{(int)((float)n2 * f)}), this.yScaling) - d3) * d5;
            dArray[n2 * 3 + 2] = 0.0;
            ++n2;
        }
        int[][] nArray = ArrayPoolUtility.getIntArray(n - 1);
        int n3 = 0;
        while (n3 < n - 1) {
            nArray[n3][0] = n3;
            nArray[n3][1] = n3 + 1;
            ++n3;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createGraphGeometry(IDataset iDataset, AxisValues axisValues) {
        int n;
        int n2 = iDataset.getShape()[0];
        double d = 1.0;
        if (n2 > MAXGRAPHSIZE) {
            d = (double)MAXGRAPHSIZE / (double)n2;
            n2 = MAXGRAPHSIZE;
        }
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double[] dArray = new double[n2 * 3];
        this.setScalingSmallFlag(this.graphYmin);
        double d2 = 14.75 / (this.graphXmax - this.graphXmin);
        double d3 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d4 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d5 = 14.75 / (d4 - d3);
        int n3 = 0;
        while (n3 < n2) {
            n = (int)((double)n3 / d);
            double d6 = axisValues.getValue(n);
            dArray[n3 * 3] = (d6 - this.graphXmin) * d2;
            dArray[n3 * 3 + 1] = (ScalingUtility.valueScaler(iDataset.getDouble(new int[]{n}), this.yScaling) - d3) * d5;
            dArray[n3 * 3 + 2] = 0.0;
            ++n3;
        }
        indexedLineSetFactory.setVertexCount(n2);
        indexedLineSetFactory.setEdgeCount(n2 - 1);
        int[][] nArray = ArrayPoolUtility.getIntArray(n2 - 1);
        n = 0;
        while (n < n2 - 1) {
            nArray[n][0] = n;
            nArray[n][1] = n + 1;
            ++n;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createGraphGeometry(IDataset iDataset) {
        int n = iDataset.getShape()[0];
        float f = 1.0f;
        if (n > MAXGRAPHSIZE) {
            f = (float)n / (float)MAXGRAPHSIZE;
            n = MAXGRAPHSIZE;
        }
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(n);
        indexedLineSetFactory.setEdgeCount(n - 1);
        double[] dArray = new double[n * 3];
        this.setScalingSmallFlag(this.graphYmin);
        double d = 14.75 / (double)(n - 1);
        double d2 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d3 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d4 = 14.75 / (d3 - d2);
        int n2 = 0;
        while (n2 < n) {
            dArray[n2 * 3] = (double)n2 * d;
            dArray[n2 * 3 + 1] = (ScalingUtility.valueScaler(iDataset.getDouble(new int[]{(int)((float)n2 * f)}), this.yScaling) - d2) * d4;
            dArray[n2 * 3 + 2] = 0.0;
            ++n2;
        }
        int[][] nArray = ArrayPoolUtility.getIntArray(n - 1);
        int n3 = 0;
        while (n3 < n - 1) {
            nArray[n3][0] = n3;
            nArray[n3][1] = n3 + 1;
            ++n3;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public void setXAxisLabel(String string) {
        if (this.xAxisLabelStr == null || !string.equals(this.xAxisLabelStr)) {
            this.xAxisLabelStr = string;
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{string};
            dArray[0][0] = 7.5;
            dArray[0][1] = -0.5;
            dArray[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.xAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    public void setSecondaryXAxisLabel(String string) {
        if (this.x2AxisLabelStr == null || !string.equals(this.x2AxisLabelStr)) {
            this.x2AxisLabelStr = string;
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{string};
            dArray[0][0] = 7.5;
            dArray[0][1] = 15.0;
            dArray[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            if (this.secondaryAxes != null) {
                this.secondXAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
            } else {
                this.secondXAxisLabel.setGeometry(null);
            }
        }
    }

    @Override
    public void setYAxisLabel(String string) {
        if (this.yAxisLabelStr == null || !string.equals(this.yAxisLabelStr)) {
            this.yAxisLabelStr = string;
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{string};
            dArray[0][0] = -0.75;
            dArray[0][1] = 7.375;
            dArray[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.yAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setZAxisLabel(String string) {
    }

    private ArrayList<Tick> createLabelTicks(LinkedList<Tick> linkedList) {
        double d = 0.0;
        this.setScalingSmallFlag(this.graphYmin);
        double d2 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d3 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d4 = 14.75 / (d3 - d2);
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (Tick tick : linkedList) {
            double d5 = ScalingUtility.valueScaler(tick.getTickValue(), this.yScaling);
            if (arrayList.size() == 0) {
                d = (d5 - d2) * d4;
                Tick tick2 = new Tick();
                tick2.setTickName(tick.getTickName());
                tick2.setYCoord(d);
                arrayList.add(tick2);
                continue;
            }
            double d6 = (d5 - d2) * d4;
            if (!(d6 > d + 0.48)) continue;
            Tick tick3 = new Tick();
            tick3.setTickName(tick.getTickName());
            tick3.setYCoord(d6);
            arrayList.add(tick3);
            d = d6;
        }
        return arrayList;
    }

    private PointSet createYLabelsGeometry(LinkedList<Tick> linkedList) {
        PointSetFactory pointSetFactory = new PointSetFactory();
        ArrayList<Tick> arrayList = this.createLabelTicks(linkedList);
        String[] stringArray = new String[arrayList.size()];
        pointSetFactory.setVertexCount(arrayList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(arrayList.size());
        Iterator<Tick> iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Tick tick = iterator.next();
            dArray[n][0] = -0.7;
            dArray[n][1] = tick.getYCoord();
            dArray[n][2] = 0.0;
            stringArray[n] = tick.getTickName();
            ++n;
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected IndexedLineSet createYTicksGeometry() {
        this.setScalingSmallFlag(this.graphYmin);
        double d = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d2 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        if (this.yLabels != null) {
            this.yLabels.setGeometry((Geometry)this.createYLabelsGeometry(this.yTicksLabels));
        }
        if (this.showYTicks) {
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(this.yTicksLabels.size() * 2);
            indexedLineSetFactory.setEdgeCount(this.yTicksLabels.size());
            double[][] dArray = ArrayPoolUtility.getDoubleArray(this.yTicksLabels.size() * 2);
            int[][] nArray = ArrayPoolUtility.getIntArray(this.yTicksLabels.size());
            double d3 = 14.75 / (d2 - d);
            Iterator iterator = this.yTicksLabels.iterator();
            int n = 0;
            int n2 = this.yTicksLabels.size();
            while (n < n2) {
                double d4;
                dArray[n * 2][0] = -0.125;
                double d5 = ((Tick)iterator.next()).getTickValue();
                d5 = ScalingUtility.valueScaler(d5, this.yScaling);
                dArray[n * 2][1] = d4 = (d5 - d) * d3;
                dArray[n * 2][2] = -1.0E-4;
                dArray[n * 2 + 1][0] = 15.0;
                dArray[n * 2 + 1][1] = d4;
                dArray[n * 2 + 1][2] = -1.0E-4;
                nArray[n][0] = n * 2;
                nArray[n][1] = n * 2 + 1;
                ++n;
            }
            indexedLineSetFactory.setVertexCoordinates(dArray);
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    private PointSet create2ndXLabelsGeometry(LinkedList<Tick> linkedList) {
        PointSetFactory pointSetFactory = new PointSetFactory();
        String[] stringArray = new String[linkedList.size()];
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        pointSetFactory.setVertexCount(linkedList.size());
        double d = this.globalRealXmin - this.graphXmin;
        double d2 = this.graphXmax - this.graphXmin;
        double d3 = this.globalRealXmax - this.globalRealXmin;
        double d4 = 14.75 * (d / d2);
        double d5 = 14.75 * d3 / d2;
        double d6 = this.displaySecondaryXAxes.getMinValue();
        double d7 = this.displaySecondaryXAxes.getMaxValue();
        double d8 = d5 / (d7 - d6);
        int n = 0;
        int n2 = linkedList.size();
        while (n < n2) {
            Tick tick = linkedList.get(n);
            double d9 = tick.getTickValue();
            dArray[n][0] = d4 + (d9 - d6) * d8;
            dArray[n][1] = 15.025;
            dArray[n][2] = 0.0;
            stringArray[n] = tick.getTickName();
            ++n;
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected PointSet createXLabelsGeometry(LinkedList<Tick> linkedList) {
        PointSetFactory pointSetFactory = new PointSetFactory();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        double d = 14.75 / (this.graphXmax - this.graphXmin);
        if (this.xAxis == AxisMode.CUSTOM && this.xAxes.size() > 0) {
            int n = 0;
            int n2 = linkedList.size();
            while (n < n2) {
                double d2 = this.xTicksUnitSize * (double)n;
                Tick tick = null;
                tick = linkedList.get(n);
                dArray[n][0] = d2 * d;
                dArray[n][1] = -0.275;
                dArray[n][2] = 0.0;
                stringArray[n] = tick.getTickName();
                ++n;
            }
        } else {
            int n = 0;
            int n3 = linkedList.size();
            while (n < n3) {
                double d3 = this.xTicksUnitSize * (double)n;
                Tick tick = linkedList.get(n);
                dArray[n][0] = d3 * d;
                dArray[n][1] = -0.275;
                dArray[n][2] = 0.0;
                stringArray[n] = tick.getTickName();
                ++n;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected IndexedLineSet createXTicksGeometry() {
        double d = this.graphXmin;
        if (this.xLabels != null) {
            this.xLabels.setGeometry((Geometry)this.createXLabelsGeometry(this.xTicksLabels));
        }
        if (this.showXTicks) {
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(this.xTicksLabels.size() * 2);
            indexedLineSetFactory.setEdgeCount(this.xTicksLabels.size());
            double[][] dArray = ArrayPoolUtility.getDoubleArray(this.xTicksLabels.size() * 2);
            int[][] nArray = ArrayPoolUtility.getIntArray(this.xTicksLabels.size());
            double d2 = 14.75 / (this.graphXmax - d);
            int n = 0;
            int n2 = this.xTicksLabels.size();
            while (n < n2) {
                double d3 = this.xTicksUnitSize * (double)n;
                dArray[n * 2][0] = d3 * d2;
                dArray[n * 2][1] = -0.125;
                dArray[n * 2][2] = -1.0E-4;
                dArray[n * 2 + 1][0] = d3 * d2;
                dArray[n * 2 + 1][1] = 14.75;
                dArray[n * 2 + 1][2] = -1.0E-4;
                nArray[n][0] = n * 2;
                nArray[n][1] = n * 2 + 1;
                ++n;
            }
            indexedLineSetFactory.setVertexCoordinates(dArray);
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    private IndexedLineSet create2ndXTicksGeometry() {
        if (this.secondaryXAxisLabel != null) {
            this.secondaryXAxisLabel.setGeometry((Geometry)this.create2ndXLabelsGeometry(this.x2ndTicksLabels));
        }
        if (this.showXTicks) {
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(this.x2ndTicksLabels.size() * 2);
            indexedLineSetFactory.setEdgeCount(this.x2ndTicksLabels.size());
            double[][] dArray = ArrayPoolUtility.getDoubleArray(this.x2ndTicksLabels.size() * 2);
            int[][] nArray = ArrayPoolUtility.getIntArray(this.x2ndTicksLabels.size());
            double d = 14.75 / (this.graphXmax - this.graphXmin);
            double d2 = d * (this.globalRealXmin - this.graphXmin);
            double d3 = this.displaySecondaryXAxes.getMinValue();
            double d4 = this.displaySecondaryXAxes.getMaxValue();
            double d5 = d * (this.globalRealXmax - this.globalRealXmin) / (d4 - d3);
            int n = 0;
            int n2 = this.x2ndTicksLabels.size();
            while (n < n2) {
                double d6 = this.x2ndTicksLabels.get(n).getTickValue();
                dArray[n * 2][0] = d2 + (d6 - d3) * d5;
                dArray[n * 2][1] = 0.0;
                dArray[n * 2][2] = -1.0E-4;
                dArray[n * 2 + 1][0] = dArray[n * 2][0];
                dArray[n * 2 + 1][1] = 14.875;
                dArray[n * 2 + 1][2] = -1.0E-4;
                nArray[n][0] = n * 2;
                nArray[n][1] = n * 2 + 1;
                ++n;
            }
            indexedLineSetFactory.setVertexCoordinates(dArray);
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    protected Geometry createAreaSelection() {
        double[][] dArray = ArrayPoolUtility.getDoubleArray(4);
        double d = this.areaSelectStart[0];
        dArray[0][0] = d;
        dArray[0][0] = d;
        dArray[0][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[0][2] = 0.0;
        dArray[1][0] = this.areaSelectEnd[0];
        dArray[1][1] = this.rangeZoom ? 0.0 : this.areaSelectEnd[1];
        dArray[1][2] = 0.0;
        dArray[2][0] = this.areaSelectStart[0];
        dArray[2][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[2][2] = 0.0;
        dArray[3][0] = this.areaSelectEnd[0];
        dArray[3][1] = this.rangeZoom ? 14.75 : this.areaSelectStart[1];
        dArray[3][2] = 0.0;
        this.areaSelectFactory.setVLineCount(2);
        this.areaSelectFactory.setULineCount(2);
        this.areaSelectFactory.setClosedInUDirection(false);
        this.areaSelectFactory.setClosedInVDirection(false);
        this.areaSelectFactory.setVertexCoordinates(dArray);
        this.areaSelectFactory.setGenerateFaceNormals(true);
        this.areaSelectFactory.setGenerateEdgesFromFaces(true);
        this.areaSelectFactory.update();
        return this.areaSelectFactory.getIndexedFaceSet();
    }

    protected IndexedFaceSet createBackground() {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = -1.5;
        dArray[0][0][1] = 16.25;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = 16.5;
        dArray[0][1][1] = 16.25;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = -1.5;
        dArray[1][0][1] = -1.5;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = 16.5;
        dArray[1][1][1] = -1.5;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    protected void buildAreaSelection() {
        if (this.areaSelectFactory == null) {
            this.areaSelectFactory = new QuadMeshFactory();
        }
        this.areaSelection = SceneGraphUtility.createFullSceneGraphComponent((String)"areaSelect");
        Appearance appearance = new Appearance();
        this.areaSelection.setAppearance(appearance);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setLineWidth(Double.valueOf(2.0));
        defaultLineShader.setDiffuseColor(Color.gray);
    }

    protected void buildBackground() {
        this.background = SceneGraphUtility.createFullSceneGraphComponent((String)"background");
        this.background.setGeometry((Geometry)this.createBackground());
        Appearance appearance = new Appearance();
        this.background.setAppearance(appearance);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("transparencyEnabled", true);
        appearance.setAttribute("additiveBlendingEnabled", false);
        appearance.setAttribute("polygonShader.transparency", 1.0);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(true));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
    }

    protected void sanityCheckMinMax() {
        if (Math.abs(this.globalYmax - this.globalYmax) < 1.0E-10) {
            this.globalYmin -= 1.0E-5;
            this.globalYmax += 1.0E-5;
        }
        if (this.globalYmin == 3.4028234663852886E38 && this.globalYmax == -3.4028234663852886E38) {
            this.globalYmin = 0.0;
            this.globalYmax = 0.1;
        }
        if (this.globalRealXmin == 3.4028234663852886E38 && this.globalRealXmax == -3.4028234663852886E38) {
            this.globalRealXmin = 0.0;
            this.globalRealXmax = 0.1;
        }
        if (this.globalXmin == 3.4028234663852886E38 && this.globalXmax == -3.4028234663852886E38) {
            this.globalXmin = 0.0;
            this.globalXmax = 0.1;
        }
    }

    protected void updateWindowWithNewRanges(List<IDataset> list, SelectedWindow selectedWindow) {
        Iterator<IDataset> iterator = list.iterator();
        Iterator<Double> iterator2 = this.offsets.iterator();
        Iterator<AxisValues> iterator3 = this.xAxes.iterator();
        double d = 3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            d = Math.min(d, iDataset.min().doubleValue());
            d2 = Math.max(d2, iDataset.max().doubleValue());
            switch (this.xAxis) {
                case LINEAR: {
                    d3 = 0.0;
                    d4 = Math.max(d4, (double)iDataset.getShape()[0]) - 1.0;
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    double d5 = iterator2.next();
                    d3 = Math.min(d5, d3);
                    d4 = Math.max(d4, (double)iDataset.getShape()[0] + d5) - 1.0;
                    break;
                }
                case CUSTOM: {
                    AxisValues axisValues = iterator3.next();
                    d3 = Math.min(d3, axisValues.getMinValue());
                    d4 = Math.max(d4, axisValues.getMaxValue());
                }
            }
        }
        selectedWindow.setStartWindowX(d3);
        selectedWindow.setEndWindowX(d4);
        selectedWindow.setStartWindowY(d);
        selectedWindow.setEndWindowY(d2);
    }

    private boolean determineRangeChange(IDataset iDataset, int n) {
        boolean bl = false;
        double d = 3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = -3.4028234663852886E38;
        double d5 = 3.4028234663852886E38;
        double d6 = -3.4028234663852886E38;
        d = Math.min(d, iDataset.min().doubleValue());
        d2 = Math.max(d2, iDataset.max().doubleValue());
        d4 = Math.max(d4, (double)iDataset.getShape()[0]);
        switch (this.xAxis) {
            case LINEAR: {
                d5 = 0.0;
                d6 = d4 - 1.0;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                double d7 = this.offsets.get(n);
                d5 = Math.min(d7, d5);
                d6 = Math.max(d4 + d7, d6) - 1.0;
                break;
            }
            case CUSTOM: {
                AxisValues axisValues = this.xAxes.get(n);
                d5 = Math.min(d5, axisValues.getMinValue());
                d6 = Math.max(d6, axisValues.getMaxValue());
            }
        }
        this.buildTickLists();
        if (d < this.globalYmin) {
            this.globalYmin = d;
            bl = true;
        }
        if (d2 > this.globalYmax) {
            this.globalYmax = d2;
            bl = true;
        }
        if (d3 < this.globalXmin) {
            this.globalXmin = d3;
            bl = true;
        }
        if (d4 > this.globalXmax) {
            this.globalXmax = d4;
            bl = true;
        }
        if (d5 < this.globalRealXmin) {
            this.globalRealXmin = d5;
            bl = true;
        }
        if (d6 > this.globalRealXmax) {
            this.globalRealXmax = d6;
            bl = true;
        }
        return bl;
    }

    protected void buildTickLists() {
        int n;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n2 = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n2 == 0) {
            n2 = 237;
        }
        if ((n = this.app.getCurrentViewer().getViewingComponentSize().width) == 0) {
            n = 490;
        }
        this.graphXmax = this.globalRealXmax;
        this.graphXmin = this.globalRealXmin;
        if (this.xAxis == AxisMode.CUSTOM) {
            this.tickFactory.setTickMode(this.xLabelMode);
            this.xTicksLabels = this.tickFactory.generateTicks(n, this.globalRealXmin, this.globalRealXmax, (short)0, true);
            this.graphXmin = this.tickFactory.getLabelMin();
            this.graphXmax = this.tickFactory.getLabelMax();
        } else {
            this.xTicksLabels = this.tickFactory.generateTicks(n, this.globalRealXmin, this.globalRealXmax, (short)0, false);
        }
        this.xTicksUnitSize = this.tickFactory.getTickUnit();
        this.tickFactory.setTickMode(this.yLabelMode);
        this.yTicksLabels = this.tickFactory.generateTicks(n2, this.globalYmin, this.globalYmax, (short)1, true);
        this.yTicksUnitSize = this.tickFactory.getTickUnit();
        this.graphYmin = this.tickFactory.getLabelMin();
        this.graphYmax = this.tickFactory.getLabelMax();
        if (this.secondaryXAxes != null) {
            this.x2ndTicksLabels = this.tickFactory.generateTicks(n, this.displaySecondaryXAxes.getMinValue(), this.displaySecondaryXAxes.getMaxValue(), (short)0, false);
            double d = this.displaySecondaryXAxes.getMinValue();
            this.x2ndTicksLabels.get(0).setTickValue(d);
            int n3 = d == 0.0 ? 0 : (int)Math.max(-Math.floor(Math.log10(Math.abs(d))), 3.0);
            String string = String.format("%%.%df", n3 + 1);
            this.x2ndTicksLabels.get(0).setTickName(String.format(string, d));
        }
    }

    protected void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        Iterator<Double> iterator2 = this.offsets.iterator();
        Iterator<AxisValues> iterator3 = this.xAxes.iterator();
        this.globalYmin = 3.4028234663852886E38;
        this.globalYmax = -3.4028234663852886E38;
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            this.globalYmin = Math.min(this.globalYmin, iDataset.min().doubleValue());
            this.globalYmax = Math.max(this.globalYmax, iDataset.max().doubleValue());
            this.globalXmax = Math.max(this.globalXmax, (double)iDataset.getShape()[0]);
            switch (this.xAxis) {
                case LINEAR: {
                    this.globalRealXmin = 0.0;
                    this.globalRealXmax = this.globalXmax - 1.0;
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    double d = iterator2.next();
                    this.globalRealXmin = Math.min(d, this.globalRealXmin);
                    this.globalRealXmax = Math.max(this.globalXmax + d, this.globalRealXmax) - 1.0;
                    break;
                }
                case CUSTOM: {
                    AxisValues axisValues = iterator3.next();
                    this.globalRealXmin = Math.min(this.globalRealXmin, axisValues.getMinValue());
                    this.globalRealXmax = Math.max(this.globalRealXmax, axisValues.getMaxValue());
                }
            }
        }
        if (this.yAxis == AxisMode.LINEAR_WITH_OFFSET) {
            this.globalYmin += this.yOffset;
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
    }

    protected void buildClipPlanes(SceneGraphComponent sceneGraphComponent) {
        ClippingPlane clippingPlane;
        if (this.bottomClip == null) {
            clippingPlane = new ClippingPlane();
            clippingPlane.setLocal(true);
            this.bottomClip = SceneGraphUtility.createFullSceneGraphComponent((String)"bottomClipBorder");
            this.bottomClip.setGeometry((Geometry)clippingPlane);
            sceneGraphComponent.addChild(this.bottomClip);
        }
        if (this.topClip == null) {
            clippingPlane = new ClippingPlane();
            clippingPlane.setLocal(true);
            this.topClip = SceneGraphUtility.createFullSceneGraphComponent((String)"topClipBorder");
            this.topClip.setGeometry((Geometry)clippingPlane);
            this.bottomClip.addChild(this.topClip);
        }
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).assignTo(this.bottomClip);
        MatrixBuilder.euclidean().rotateX(-1.5707963267948966).translate(0.0, 14.75, 0.0).rotateX(-1.5707963267948966).assignTo(this.topClip);
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).translate(0.0, -14.75, 0.0).assignTo(this.graphGroupNode);
        this.topClip.addChild(this.graphGroupNode);
    }

    protected SceneGraphComponent buildAdditionalGraphNode() {
        SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
        this.subGraphs.add(sceneGraphComponent);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        appearance.setAttribute("pointShader.spheresDraw", false);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("attenuatePointSize", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
        plot1DAppearance.updateGraph(defaultLineShader, defaultGeometryShader);
        this.graphLineShaders.add(defaultLineShader);
        this.graphShaders.add(defaultGeometryShader);
        this.graphGroupNode.addChild(sceneGraphComponent);
        ++this.numGraphs;
        return sceneGraphComponent;
    }

    protected void resizeAndPositionNodes() {
        Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
        float f = (float)dimension.width / (float)dimension.height;
        if (f > 1.0f) {
            MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.graph);
            if (this.xTicks != null) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
            }
            if (this.yTicks != null) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
            }
        } else {
            MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.graph);
            if (this.xTicks != null) {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
            }
            if (this.yTicks != null) {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
            }
        }
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            IDataset iDataset;
            this.graphGroupNode = SceneGraphUtility.createFullSceneGraphComponent((String)"groupNode");
            this.sets = list;
            this.graph = sceneGraphComponent;
            this.determineRanges(list);
            Iterator<IDataset> iterator = list.iterator();
            Iterator<Double> iterator2 = this.offsets.iterator();
            Iterator<AxisValues> iterator3 = this.xAxes.iterator();
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.numGraphs = 0;
            while (iterator.hasNext()) {
                AxisValues axisValues;
                iDataset = iterator.next();
                SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
                this.subGraphs.add(sceneGraphComponent2);
                switch (this.xAxis) {
                    case LINEAR: {
                        sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset));
                        break;
                    }
                    case LINEAR_WITH_OFFSET: {
                        double d = iterator2.next();
                        sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset, d));
                        break;
                    }
                    case CUSTOM: {
                        axisValues = iterator3.next();
                        sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues));
                    }
                }
                axisValues = new Appearance();
                sceneGraphComponent2.setAppearance((Appearance)axisValues);
                DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)axisValues, (boolean)true);
                axisValues.setAttribute("lineShader.tubeDraw", false);
                axisValues.setAttribute("pointShader.spheresDraw", false);
                axisValues.setAttribute("attenuatePointSize", false);
                axisValues.setAttribute("lightingEnabled", false);
                DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
                Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
                plot1DAppearance.updateGraph(defaultLineShader, defaultGeometryShader);
                this.graphLineShaders.add(defaultLineShader);
                this.graphShaders.add(defaultGeometryShader);
                this.graphGroupNode.addChild(sceneGraphComponent2);
                ++this.numGraphs;
            }
            this.buildClipPlanes(sceneGraphComponent);
            this.resizeAndPositionNodes();
            iDataset = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
            iDataset.setFieldOfView(56.5);
            if (this.background == null) {
                this.buildBackground();
                sceneGraphComponent.addChild(this.background);
                sceneGraphComponent.addTool((Tool)this.tool);
                if (this.actionToolEnabled) {
                    sceneGraphComponent.addTool((Tool)this.actionTool);
                }
                if (this.rightClickActionToolEnabled) {
                    sceneGraphComponent.addTool((Tool)this.rightClickActionTool);
                }
            }
            if (this.areaSelection == null) {
                this.buildAreaSelection();
            }
            if (this.secondaryXAxes != null) {
                this.secondaryAxes.setVisible(true);
                this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
            } else if (this.secondaryAxes != null) {
                this.secondaryAxes.setVisible(false);
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks != null) {
                this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            }
        }
        return sceneGraphComponent;
    }

    @Override
    public void buildXCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        if (sceneGraphComponent != null) {
            float f;
            this.xTicks = sceneGraphComponent;
            this.xLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"xLabels");
            sceneGraphComponent.addChild(this.xLabels);
            Appearance appearance = new Appearance();
            sceneGraphComponent.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setLineStipple(Boolean.valueOf(true));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            Appearance appearance2 = new Appearance();
            this.xLabels.setAppearance(appearance2);
            DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
            appearance2.setAttribute("pointShader.spheresDraw", false);
            appearance2.setAttribute("lightingEnabled", false);
            appearance2.setAttribute("attenuatePointSize", false);
            DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
            defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
            defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
            defaultPointShader.setPointSize(Double.valueOf(1.0));
            defaultPointShader.setDiffuseColor(Color.white);
            this.dtsXTicks = (DefaultTextShader)defaultPointShader.getTextShader();
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            this.dtsXTicks.setOffset(dArray);
            this.dtsXTicks.setScale(Double.valueOf(this.font_scale));
            this.dtsXTicks.setDiffuseColor(Color.black);
            this.dtsXTicks.setAlignment(Integer.valueOf(0));
            Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n == 0) {
                n = 490;
            }
            if (n2 == 0) {
                n2 = 475;
            }
            if ((f = (float)n / (float)n2) > 1.0f) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
            } else {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
            }
        }
    }

    @Override
    public void buildYCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        if (sceneGraphComponent != null) {
            float f;
            this.yTicks = sceneGraphComponent;
            this.yLabels = SceneGraphUtility.createFullSceneGraphComponent((String)"yLabels");
            sceneGraphComponent.addChild(this.yLabels);
            Appearance appearance = new Appearance();
            sceneGraphComponent.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            Appearance appearance2 = new Appearance();
            this.yLabels.setAppearance(appearance2);
            DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
            appearance2.setAttribute("pointShader.spheresDraw", false);
            appearance2.setAttribute("lightingEnabled", false);
            appearance2.setAttribute("attenuatePointSize", false);
            DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
            defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
            defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
            defaultPointShader.setPointSize(Double.valueOf(1.0));
            defaultPointShader.setDiffuseColor(Color.WHITE);
            this.dtsYTicks = (DefaultTextShader)defaultPointShader.getTextShader();
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            this.dtsYTicks.setOffset(dArray);
            this.dtsYTicks.setAlignment(Integer.valueOf(0));
            this.dtsYTicks.setScale(Double.valueOf(this.font_scale));
            this.dtsYTicks.setDiffuseColor(Color.black);
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setLineStipple(Boolean.valueOf(true));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n == 0) {
                n = 490;
            }
            if (n2 == 0) {
                n2 = 475;
            }
            if ((f = (float)n / (float)n2) > 1.0f) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
            } else {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(sceneGraphComponent);
            }
        }
    }

    @Override
    public void buildZCoordLabeling(SceneGraphComponent sceneGraphComponent) {
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
    }

    @Override
    public void setScaling(ScaleType scaleType) {
        this.yScaling = scaleType;
        if (this.graph != null) {
            switch (this.xAxis) {
                case LINEAR: {
                    this.refreshZoomedGraphsLinear((int)this.graphXmin, (int)this.graphXmax);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.refreshZoomedGraphsOffset(this.graphXmin, this.graphXmax);
                    break;
                }
                case CUSTOM: {
                    this.refreshZoomedGraphsCustom(this.graphXmin, this.graphXmax);
                }
            }
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            if (this.secondaryXAxes != null && this.secondaryXAxisTicks != null) {
                this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
            }
            this.repositionOverlaysAfterZoom();
        }
    }

    protected void updateGraphs() {
        if (this.graph != null) {
            IDataset iDataset;
            int n = this.subGraphs.size();
            while (n < this.sets.size()) {
                this.buildAdditionalGraphNode();
                ++n;
            }
            Iterator<IDataset> iterator = this.sets.iterator();
            Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
            Iterator<Double> iterator3 = this.offsets.iterator();
            Iterator<AxisValues> iterator4 = this.xAxes.iterator();
            while (iterator.hasNext()) {
                iDataset = iterator.next();
                SceneGraphComponent sceneGraphComponent = iterator2.next();
                switch (this.xAxis) {
                    case LINEAR: {
                        sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset));
                        break;
                    }
                    case LINEAR_WITH_OFFSET: {
                        double d = iterator3.next();
                        sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, d));
                        break;
                    }
                    case CUSTOM: {
                        AxisValues axisValues = iterator4.next();
                        sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues));
                    }
                }
            }
            while (iterator2.hasNext()) {
                iDataset = iterator2.next();
                iDataset.setGeometry(null);
            }
        }
    }

    private void updateGraph(IDataset iDataset, int n) {
        if (this.graph != null) {
            SceneGraphComponent sceneGraphComponent = this.subGraphs.get(n);
            switch (this.xAxis) {
                case LINEAR: {
                    sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset));
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    double d = this.offsets.get(n);
                    sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, d));
                    break;
                }
                case CUSTOM: {
                    AxisValues axisValues = this.xAxes.get(n);
                    sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues));
                }
            }
        }
    }

    protected void updateGraphInZoom() {
        double d = this.currentSelectWindow.getStartWindowX();
        double d2 = this.currentSelectWindow.getEndWindowX();
        SelectedWindow selectedWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
        this.updateWindowWithNewRanges(this.sets, selectedWindow);
        switch (this.xAxis) {
            case LINEAR: {
                this.refreshZoomedGraphsLinear((int)d, (int)d2);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.refreshZoomedGraphsOffset(d, d2);
                break;
            }
            case CUSTOM: {
                this.refreshZoomedGraphsCustom(d, d2);
            }
        }
    }

    @Override
    public void updateGraph(IDataset iDataset) {
        this.currentDataSet = iDataset;
        if (!this.isUpdateOperation || this.undoSelectStack.size() == 0) {
            this.undoSelectStack.clear();
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.updateGraphs();
        } else {
            this.updateGraphInZoom();
        }
        if (this.xTicks != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTicks != null) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.secondaryXAxes != null) {
            if (this.secondaryXAxisTicks != null) {
                this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
            }
            this.secondaryAxes.setVisible(true);
        } else {
            this.secondaryAxes.setVisible(false);
            this.secondXAxisLabel.setGeometry(null);
        }
    }

    public void updateAGraph(IDataset iDataset, int n) {
        this.sets.set(n, iDataset);
        if (!this.isUpdateOperation || this.undoSelectStack.size() == 0) {
            this.undoSelectStack.clear();
            boolean bl = this.determineRangeChange(iDataset, n);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.updateGraph(iDataset, n);
            if (bl) {
                if (this.xTicks != null) {
                    this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
                }
                if (this.yTicks != null) {
                    this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
                }
            }
            if (this.secondaryXAxes != null) {
                if (this.secondaryXAxisTicks != null) {
                    this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
                }
                this.secondaryAxes.setVisible(true);
            } else {
                this.secondaryAxes.setVisible(false);
                this.secondXAxisLabel.setGeometry(null);
            }
        } else {
            this.updateGraphInZoom();
        }
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        this.sets = list;
        if (!this.isUpdateOperation || this.undoSelectStack.size() == 0) {
            this.undoSelectStack.clear();
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.updateGraphs();
        } else {
            this.updateGraphInZoom();
        }
        if (this.xTicks != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTicks != null) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.secondaryXAxes != null) {
            if (this.secondaryXAxisTicks != null) {
                this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
            }
            this.secondaryAxes.setVisible(true);
        } else {
            this.secondaryAxes.setVisible(false);
            this.secondXAxisLabel.setGeometry(null);
        }
    }

    @Override
    public void notifyComponentResize(int n, int n2) {
        if (this.graph != null) {
            float f = (float)n / (float)n2;
            if ((double)f > 1.0) {
                MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.graph);
                if (this.axis != null) {
                    MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.axis);
                }
                if (this.xTicks != null) {
                    MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
                }
                if (this.yTicks != null) {
                    MatrixBuilder.euclidean().scale((double)f, 1.0, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
                }
            } else {
                MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.graph);
                if (this.axis != null) {
                    MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.axis);
                }
                if (this.xTicks != null) {
                    MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.xTicks);
                }
                if (this.yTicks != null) {
                    MatrixBuilder.euclidean().scale(1.0, 1.0 / (double)f, 1.0).translate(-6.75, -7.5, 0.0).assignTo(this.yTicks);
                }
            }
        }
        double d = 1.0;
        if (n < 490) {
            d = 490.0 / (double)n;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)n2);
        }
        this.buildTickLists();
        d = Math.max(d, 0.5);
        if (this.dtsXTicks != null) {
            this.dtsXTicks.setScale(Double.valueOf(this.font_scale * d));
        }
        if (this.dtsX2Ticks != null) {
            this.dtsX2Ticks.setScale(Double.valueOf(this.font_scale * d));
        }
        if (this.dtsYTicks != null) {
            this.dtsYTicks.setScale(Double.valueOf(this.font_scale * d));
        }
        if (this.dtsXAxisLabel != null) {
            this.dtsXAxisLabel.setScale(Double.valueOf(this.font_scale_axis * d));
        }
        if (this.dtsX2AxisLabel != null) {
            this.dtsX2AxisLabel.setScale(Double.valueOf(this.font_scale_axis * d));
        }
        if (this.dtsYAxisLabel != null) {
            this.dtsYAxisLabel.setScale(Double.valueOf(this.font_scale_axis * d));
        }
        if (this.dtsTitleLabel != null) {
            this.dtsTitleLabel.setScale(Double.valueOf(this.font_scale_axis * d));
        }
        if (this.xTicks != null && this.currentDataSet != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTicks != null && this.currentDataSet != null) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.secondaryXAxes != null && this.secondaryXAxisTicks != null) {
            this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
        }
    }

    private void refreshZoomedGraphsLinear(int n, int n2) {
        IDataset iDataset;
        Iterator<Object> iterator = this.sets.iterator();
        Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
        this.globalXmin = 0.0;
        this.globalRealXmin = n;
        this.globalRealXmax = (double)n + this.globalXmax;
        if (n == 0) {
            this.globalRealXmax -= 1.0;
        }
        if (this.rangeZoom) {
            this.globalYmin = 3.4028234663852886E38;
            this.globalYmax = -3.4028234663852886E38;
        }
        LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
        while (iterator.hasNext()) {
            iDataset = iterator.next();
            int n3 = Math.min(iDataset.getShape()[0], n2 + 1);
            if (n < iDataset.getShape()[0]) {
                IDataset iDataset2 = iDataset.getSlice(new int[]{n}, new int[]{n3}, new int[]{1});
                if (this.rangeZoom) {
                    if (iDataset2.getSize() != 1) {
                        this.globalYmin = Math.min(this.globalYmin, iDataset2.min().doubleValue());
                        this.globalYmax = Math.max(this.globalYmax, iDataset2.max().doubleValue());
                    } else {
                        this.globalYmin = iDataset2.getDouble(new int[]{0});
                        this.globalYmax = iDataset2.getDouble(new int[]{0}) + 1.0E-4;
                    }
                }
                linkedList.add(iDataset2);
                continue;
            }
            linkedList.add(null);
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iDataset = null;
            SceneGraphComponent sceneGraphComponent = iterator2.next();
            if (iterator.hasNext()) {
                iDataset = (IDataset)iterator.next();
            }
            if (iDataset != null) {
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset));
                continue;
            }
            sceneGraphComponent.setGeometry(null);
        }
        linkedList.clear();
    }

    private void refreshZoomedGraphsOffset(double d, double d2) {
        IDataset iDataset;
        this.globalRealXmax = Math.round(d2);
        this.globalRealXmin = Math.round(d);
        Iterator<Object> iterator = this.sets.iterator();
        Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
        Iterator<Double> iterator3 = this.offsets.iterator();
        if (this.rangeZoom) {
            this.globalYmin = 3.4028234663852886E38;
            this.globalYmax = -3.4028234663852886E38;
        }
        LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
        LinkedList<Double> linkedList2 = new LinkedList<Double>();
        while (iterator.hasNext()) {
            iDataset = iterator.next();
            double d3 = iterator3.next();
            int n = Math.max(0, (int)Math.round(d - d3));
            int n2 = Math.max(0, (int)Math.round(d2 - d3));
            n2 = Math.min(iDataset.getShape()[0], n2 + 1);
            if (n2 > 0) {
                IDataset iDataset2 = iDataset.getSlice(new int[]{n}, new int[]{n2}, new int[]{1});
                if (this.rangeZoom) {
                    if (iDataset2.getSize() != 1) {
                        this.globalYmin = Math.min(this.globalYmin, iDataset2.min().doubleValue());
                        this.globalYmax = Math.max(this.globalYmax, iDataset2.max().doubleValue());
                    } else {
                        this.globalYmin = iDataset2.getDouble(new int[]{0});
                        this.globalYmax = iDataset2.getDouble(new int[]{0}) + 1.0E-4;
                    }
                }
                linkedList.add(iDataset2);
                linkedList2.add(d3);
                continue;
            }
            linkedList.add(null);
            linkedList2.add(null);
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
        iterator3 = linkedList2.iterator();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iDataset = iterator2.next();
            IDataset iDataset3 = null;
            double d4 = 0.0;
            if (iterator.hasNext()) {
                iDataset3 = (IDataset)iterator.next();
                d4 = iterator3.next();
            }
            if (iDataset3 != null) {
                iDataset.setGeometry((Geometry)this.createGraphGeometry(iDataset3, d4));
                continue;
            }
            iDataset.setGeometry(null);
        }
        linkedList.clear();
        linkedList2.clear();
    }

    private void refreshZoomSecondaryAxis(double d, double d2) {
        this.displaySecondaryXAxes = null;
        if (this.secondaryXAxes.getMaxValue() > d && this.secondaryXAxes.getMinValue() < d2) {
            int n = 0;
            n = this.rangeZoom ? this.secondaryXAxes.nearestUpEntry(d) : this.secondaryXAxes.nearestLowEntry(d);
            int n2 = this.secondaryXAxes.nearestUpEntry(d2);
            if (n == -1) {
                n = 0;
            }
            if (n < (n2 = n2 == -1 ? this.secondaryXAxes.size() - 1 : Math.min(n2 + 1, this.secondaryXAxes.size()))) {
                this.displaySecondaryXAxes = this.secondaryXAxes.subset(n, n2);
            }
        }
    }

    protected void refreshZoomedGraphsCustom(double d, double d2) {
        AxisValues axisValues;
        IDataset iDataset;
        this.globalRealXmax = d2;
        this.globalRealXmin = d;
        Iterator<Object> iterator = this.sets.iterator();
        Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
        Iterator<AxisValues> iterator3 = this.xAxes.iterator();
        if (this.rangeZoom) {
            this.globalYmin = 3.4028234663852886E38;
            this.globalYmax = -3.4028234663852886E38;
        }
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset2 = iterator.next();
            AxisValues axisValues2 = iterator3.next();
            if (!(axisValues2.getMaxValue() > this.globalRealXmin) || !(axisValues2.getMinValue() < this.globalRealXmax)) continue;
            int n = 0;
            n = this.rangeZoom ? axisValues2.nearestUpEntry(d) : axisValues2.nearestLowEntry(d);
            int n2 = axisValues2.nearestUpEntry(d2);
            if (n == -1) {
                n = 0;
            }
            if (n2 == -1) {
                n2 = iDataset2.getShape()[0] - 1;
            }
            this.globalXmin = Math.min(this.globalXmin, axisValues2.getValue(n));
            this.globalXmax = Math.max(this.globalXmax, axisValues2.getValue(n2));
        }
        double d3 = this.globalRealXmax;
        double d4 = this.globalRealXmin;
        this.globalRealXmax = this.globalXmax;
        this.globalRealXmin = this.globalXmin;
        iterator = this.sets.iterator();
        iterator2 = this.subGraphs.iterator();
        iterator3 = this.xAxes.iterator();
        LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
        LinkedList<AxisValues> linkedList2 = new LinkedList<AxisValues>();
        while (iterator.hasNext()) {
            iDataset = iterator.next();
            axisValues = iterator3.next();
            if (axisValues.getMaxValue() > d4 && axisValues.getMinValue() < d3) {
                int n = 0;
                n = this.rangeZoom ? axisValues.nearestUpEntry(d) : axisValues.nearestLowEntry(d);
                int n3 = axisValues.nearestUpEntry(d2);
                if (n == -1) {
                    n = 0;
                }
                n3 = n3 == -1 ? iDataset.getShape()[0] : Math.min(n3 + 1, iDataset.getShape()[0]);
                IDataset iDataset3 = null;
                if (n < n3) {
                    iDataset3 = iDataset.getSlice(new int[]{n}, new int[]{n3}, new int[]{1});
                }
                if (this.rangeZoom && iDataset3 != null) {
                    if (iDataset3.getSize() != 1) {
                        this.globalYmin = Math.min(this.globalYmin, iDataset3.min().doubleValue());
                        this.globalYmax = Math.max(this.globalYmax, iDataset3.max().doubleValue());
                    } else {
                        this.globalYmin = Math.min(this.globalYmin, iDataset3.getDouble(new int[]{0}));
                        this.globalYmax = Math.max(this.globalYmax, iDataset3.getDouble(new int[]{0}) + 1.0E-4);
                    }
                }
                AxisValues axisValues3 = null;
                if (n < n3) {
                    axisValues3 = axisValues.subset(n, n3);
                }
                linkedList.add(iDataset3);
                linkedList2.add(axisValues3);
                continue;
            }
            linkedList.add(null);
            linkedList2.add(null);
        }
        if (this.rangeZoom && this.yAxis == AxisMode.LINEAR_WITH_OFFSET) {
            this.globalYmin += this.yOffset;
        }
        this.buildTickLists();
        this.sanityCheckMinMax();
        iterator3 = linkedList2.iterator();
        iterator = linkedList.iterator();
        while (iterator2.hasNext()) {
            iDataset = iterator2.next();
            axisValues = null;
            AxisValues axisValues4 = null;
            if (iterator.hasNext()) {
                axisValues = (IDataset)iterator.next();
                axisValues4 = iterator3.next();
            }
            if (axisValues != null) {
                iDataset.setGeometry((Geometry)this.createGraphGeometry((IDataset)axisValues, axisValues4));
                continue;
            }
            iDataset.setGeometry(null);
        }
        linkedList2.clear();
        linkedList.clear();
    }

    private void goToZoomLevel(SelectedWindow selectedWindow) {
        this.globalXmax = selectedWindow.getEndWindowX() - selectedWindow.getStartWindowX();
        this.globalYmax = selectedWindow.getEndWindowY();
        this.globalYmin = selectedWindow.getStartWindowY();
        if (this.secondaryXAxes != null) {
            this.refreshZoomSecondaryAxis(selectedWindow.getStartWindowX2(), selectedWindow.getEndWindowX2());
        }
        switch (this.xAxis) {
            case LINEAR: {
                this.refreshZoomedGraphsLinear((int)selectedWindow.getStartWindowX(), (int)selectedWindow.getEndWindowX());
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.refreshZoomedGraphsOffset(selectedWindow.getStartWindowX(), selectedWindow.getEndWindowX());
                break;
            }
            case CUSTOM: {
                this.refreshZoomedGraphsCustom(selectedWindow.getStartWindowX(), selectedWindow.getEndWindowX());
            }
        }
        this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        if (this.secondaryXAxes != null) {
            this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
        }
        this.repositionOverlaysAfterZoom();
    }

    public void resetZoom() {
        if (this.undoSelectStack.size() > 0) {
            this.currentSelectWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
            this.undoSelectStack.clear();
            this.goToZoomLevel(this.currentSelectWindow);
            this.refresh();
        }
    }

    public void undoZoom() {
        if (this.undoSelectStack.size() > 0) {
            this.currentSelectWindow = this.undoSelectStack.get(0);
            this.undoSelectStack.remove(0);
            this.goToZoomLevel(this.currentSelectWindow);
            this.refresh();
        }
    }

    @Override
    public void areaSelectDragged(AreaSelectEvent areaSelectEvent) {
        this.areaSelectEnd[0] = areaSelectEvent.getPosition()[0];
        this.areaSelectEnd[1] = areaSelectEvent.getPosition()[1];
        if (this.areaSelectEnd[0] < 0.0) {
            this.areaSelectEnd[0] = 0.0;
        }
        if (this.areaSelectEnd[1] < 0.0) {
            this.areaSelectEnd[1] = 0.0;
        }
        if (this.areaSelectEnd[0] > 15.0) {
            this.areaSelectEnd[0] = 15.0;
        }
        if (this.areaSelectEnd[1] > 14.75) {
            this.areaSelectEnd[1] = 14.75;
        }
        if (this.zoomToolEnabled) {
            this.areaSelection.setGeometry(this.createAreaSelection());
        }
        if (this.overlayConsumer.size() > 0) {
            double[] dArray = new double[]{this.graphXmin + this.areaSelectEnd[0] * (this.graphXmax - this.graphXmin) / 14.75, this.areaSelectEnd[1] * (this.graphYmax - this.graphYmin) / 14.75};
            AreaSelectEvent areaSelectEvent2 = new AreaSelectEvent((AreaSelectTool)((Object)areaSelectEvent.getSource()), dArray, '\u0001', areaSelectEvent.getPrimitiveID());
            for (Overlay1DConsumer overlay1DConsumer : this.overlayConsumer) {
                overlay1DConsumer.areaSelected(areaSelectEvent2);
            }
        }
        this.refresh();
    }

    private void determineRangeZoomYBounds(double d, double d2) {
        this.setScalingSmallFlag(this.graphYmin);
        double d3 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d4 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d5 = d4 - d3;
        double d6 = d / (14.75 / d5) + d3;
        d6 = ScalingUtility.inverseScaler(d6, this.yScaling);
        double d7 = d2 / (14.75 / d5) + d3;
        d7 = ScalingUtility.inverseScaler(d7, this.yScaling);
        this.globalYmin = d6;
        this.globalYmax = d7;
    }

    private void zoomLinear(double d, double d2, double d3, double d4) {
        int n = (int)this.globalXmax;
        int n2 = (int)((double)n * d / 14.75);
        int n3 = (int)((double)n * d2 / 14.75);
        this.currentSelectWindow.setStartWindowY(this.globalYmin);
        this.currentSelectWindow.setEndWindowY(this.globalYmax);
        if (!this.rangeZoom) {
            this.determineRangeZoomYBounds(d3, d4);
        }
        this.globalXmax = n3 - n2;
        if (this.undoSelectStack.size() > 0) {
            int n4 = (int)this.currentSelectWindow.getStartWindowX();
            int n5 = (int)this.currentSelectWindow.getEndWindowX();
            n2 += n4;
            n3 = n5 - (n - n3);
        }
        this.undoSelectStack.add(0, this.currentSelectWindow);
        this.currentSelectWindow = new SelectedWindow(n2, n3, this.globalYmin, this.globalYmax);
        this.refreshZoomedGraphsLinear(n2, n3);
    }

    private void zoomLinearOffset(double d, double d2, double d3, double d4) {
        double d5 = this.globalRealXmax - this.globalRealXmin;
        double d6 = d5 * d / 14.75 + this.globalRealXmin;
        double d7 = d5 * d2 / 14.75 + this.globalRealXmin;
        this.currentSelectWindow.setStartWindowY(this.globalYmin);
        this.currentSelectWindow.setEndWindowY(this.globalYmax);
        if (!this.rangeZoom) {
            this.determineRangeZoomYBounds(d3, d4);
        }
        if (this.undoSelectStack.size() == 0) {
            this.currentSelectWindow.setStartWindowX(this.globalRealXmin);
            this.currentSelectWindow.setEndWindowX(this.globalRealXmax);
        }
        this.undoSelectStack.add(0, this.currentSelectWindow);
        this.currentSelectWindow = new SelectedWindow(d6, d7, this.globalYmin, this.globalYmax);
        this.refreshZoomedGraphsOffset(d6, d7);
    }

    protected void zoomCustom(double d, double d2, double d3, double d4) {
        double d5 = this.graphXmax - this.graphXmin;
        double d6 = d5 * d / 14.75 + this.graphXmin;
        double d7 = d5 * d2 / 14.75 + this.graphXmin;
        this.currentSelectWindow.setStartWindowY(this.globalYmin);
        this.currentSelectWindow.setEndWindowY(this.globalYmax);
        if (!this.rangeZoom) {
            this.determineRangeZoomYBounds(d3, d4);
        }
        if (this.undoSelectStack.size() == 0) {
            this.currentSelectWindow.setStartWindowX(this.graphXmin);
            this.currentSelectWindow.setEndWindowX(this.graphXmax);
        }
        this.undoSelectStack.add(0, this.currentSelectWindow);
        this.currentSelectWindow = new SelectedWindow(d6, d7, this.globalYmin, this.globalYmax);
        this.refreshZoomedGraphsCustom(d6, d7);
    }

    private void zoomSecondaryAxis(double d, double d2) {
        if (this.undoSelectStack.size() == 0) {
            this.currentSelectWindow.setStartWindowX2(this.displaySecondaryXAxes.getMinValue());
            this.currentSelectWindow.setEndWindowX2(this.displaySecondaryXAxes.getMaxValue());
        }
        double d3 = this.globalRealXmin - this.graphXmin;
        double d4 = this.graphXmax - this.graphXmin;
        double d5 = this.globalRealXmax - this.globalRealXmin;
        double d6 = 14.75 * (d3 / d4);
        double d7 = 14.75 * d5 / d4;
        double d8 = this.displaySecondaryXAxes.getMinValue();
        double d9 = this.displaySecondaryXAxes.getMaxValue();
        double d10 = d9 - d8;
        double d11 = d - d6;
        double d12 = d2 - d6;
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        if (d12 < 0.0) {
            d12 = 0.0;
        }
        double d13 = d11 * d10 / d7 + d8;
        double d14 = d12 * d10 / d7 + d8;
        this.refreshZoomSecondaryAxis(d13, d14);
    }

    private void repositionOverlaysAfterZoom() {
        this.overlayInOperation = true;
        Iterator<Integer> iterator = this.prim1DMap.keySet().iterator();
        while (iterator.hasNext()) {
            double d;
            double d2;
            double d3;
            double d4;
            double[][] dArray;
            OverlayPrimitive overlayPrimitive;
            OverlayPrimitive overlayPrimitive2 = this.prim1DMap.get(iterator.next());
            this.setScalingSmallFlag(this.graphYmin);
            double d5 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
            double d6 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
            if (overlayPrimitive2 instanceof BoxPrimitive) {
                overlayPrimitive = (BoxPrimitive)overlayPrimitive2;
                dArray = ((BoxPrimitive)overlayPrimitive).getDataPoints();
                d4 = 14.75 * (dArray[0][0] - this.graphXmin) / (this.graphXmax - this.graphXmin);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d4 > 14.75) {
                    d4 = 14.75;
                }
                if ((d3 = 14.75 * (ScalingUtility.valueScaler(dArray[0][1], this.yScaling) - d5) / (d6 - d5)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 14.75) {
                    d3 = 14.75;
                }
                if ((d2 = 14.75 * (dArray[1][0] - this.graphXmin) / (this.graphXmax - this.graphXmin)) < 0.0) {
                    d2 = 0.0;
                }
                if (d2 > 14.75) {
                    d2 = 14.75;
                }
                if ((d = 14.75 * (ScalingUtility.valueScaler(dArray[1][1], this.yScaling) - d5) / (d6 - d5)) < 0.0) {
                    d = 0.0;
                }
                if (d > 14.75) {
                    d = 14.75;
                }
                ((BoxPrimitive)overlayPrimitive).setBoxPoints(d4, d3, d2, d);
            } else if (overlayPrimitive2 instanceof LinePrimitive) {
                overlayPrimitive = (LinePrimitive)overlayPrimitive2;
                dArray = ((LinePrimitive)overlayPrimitive).getDataPoints();
                d4 = 14.75 * (dArray[0][0] - this.graphXmin) / (this.graphXmax - this.graphXmin);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d4 > 14.75) {
                    d4 = 14.75;
                }
                if ((d3 = 14.75 * (ScalingUtility.valueScaler(dArray[0][1], this.yScaling) - d5) / (d6 - d5)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 14.75) {
                    d3 = 14.75;
                }
                if ((d2 = 14.75 * (dArray[1][0] - this.graphXmin) / (this.graphXmax - this.graphXmin)) < 0.0) {
                    d2 = 0.0;
                }
                if (d2 > 14.75) {
                    d2 = 14.75;
                }
                if ((d = 14.75 * (ScalingUtility.valueScaler(dArray[1][1], this.yScaling) - d5) / (d6 - d5)) < 0.0) {
                    d = 0.0;
                }
                if (d > 14.75) {
                    d = 14.75;
                }
                ((LinePrimitive)overlayPrimitive).setLinePoints(d4, d3, d2, d);
            } else if (overlayPrimitive2 instanceof LabelPrimitive) {
                overlayPrimitive = (LabelPrimitive)overlayPrimitive2;
                dArray = ((LabelPrimitive)overlayPrimitive).getDataPoints();
                d4 = 14.75 * (dArray[0][0] - this.graphXmin) / (this.graphXmax - this.graphXmin);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d4 > 14.75) {
                    d4 = 14.75;
                }
                if ((d3 = 14.75 * (ScalingUtility.valueScaler(dArray[0][1], this.yScaling) - d5) / (d6 - d5)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 14.75) {
                    d3 = 14.75;
                }
                ((LabelPrimitive)overlayPrimitive).setLabelPosition(d4, d3);
            }
            overlayPrimitive2.updateNode();
        }
        this.overlayInOperation = false;
    }

    public void setPlotZoomArea(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = 0.0;
        double d7 = 0.0;
        switch (this.xAxis) {
            case LINEAR: {
                d6 = d * 14.75 / this.globalXmax;
                d7 = d3 * 14.75 / this.globalXmax;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                d5 = this.globalRealXmax - this.globalRealXmin;
                d6 = (d - this.globalRealXmin) * 14.75 / d5;
                d7 = (d - this.globalRealXmin) * 14.75 / d5;
                break;
            }
            case CUSTOM: {
                d5 = this.graphXmax - this.graphXmin;
                d6 = (d - this.graphXmin) * 14.75 / d5;
                d7 = (d3 - this.graphXmin) * 14.75 / d5;
            }
        }
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (d6 > 14.75) {
            d6 = 14.75;
        }
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        if (d7 > 14.75) {
            d7 = 14.75;
        }
        this.setScalingSmallFlag(this.graphYmin);
        d5 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d8 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d9 = d8 - d5;
        double d10 = (d2 - d5) * (14.75 / d9);
        d10 = ScalingUtility.inverseScaler(d10, this.yScaling);
        double d11 = (d4 - d5) * (14.75 / d9);
        d11 = ScalingUtility.inverseScaler(d11, this.yScaling);
        if (d10 < 0.0) {
            d10 = 0.0;
        }
        if (d10 > 14.75) {
            d10 = 14.75;
        }
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        if (d11 > 14.75) {
            d11 = 14.75;
        }
        boolean bl = this.rangeZoom;
        this.rangeZoom = false;
        this.setZoomArea(d6, d10, d7, d11);
        this.rangeZoom = bl;
    }

    protected void setZoomArea(double d, double d2, double d3, double d4) {
        if (this.graph != null) {
            if (this.secondaryXAxes != null) {
                this.zoomSecondaryAxis(d, d3);
            }
            switch (this.xAxis) {
                case LINEAR: {
                    this.zoomLinear(d, d3, d2, d4);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.zoomLinearOffset(d, d3, d2, d4);
                    break;
                }
                case CUSTOM: {
                    this.zoomCustom(d, d3, d2, d4);
                }
            }
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            if (this.secondaryXAxes != null) {
                if (this.undoSelectStack.size() != 0) {
                    this.currentSelectWindow.setStartWindowX2(this.displaySecondaryXAxes.getMinValue());
                    this.currentSelectWindow.setEndWindowX2(this.displaySecondaryXAxes.getMaxValue());
                }
                if (this.secondaryXAxisTicks != null) {
                    this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
                }
            }
            this.repositionOverlaysAfterZoom();
        }
    }

    @Override
    public void areaSelectEnd(AreaSelectEvent areaSelectEvent) {
        if (this.zoomToolEnabled) {
            boolean bl = true;
            if (this.undoSelectStack.size() > 0 && this.areaSelectStart[0] > this.areaSelectEnd[0] && this.areaSelectStart[1] <= this.areaSelectEnd[1] && this.allowZoomMouseGesture) {
                bl = false;
            }
            if (bl) {
                double d = Math.min(this.areaSelectStart[0], this.areaSelectEnd[0]);
                double d2 = Math.max(this.areaSelectStart[0], this.areaSelectEnd[0]);
                double d3 = Math.min(this.areaSelectStart[1], this.areaSelectEnd[1]);
                double d4 = Math.max(this.areaSelectStart[1], this.areaSelectEnd[1]);
                this.setZoomArea(d, d3, d2, d4);
                this.areaSelectEnd[1] = 0.0;
                this.areaSelectEnd[0] = 0.0;
                this.areaSelectStart[1] = 0.0;
                this.areaSelectStart[0] = 0.0;
                this.areaSelection.setGeometry(this.createAreaSelection());
            } else {
                this.undoZoom();
            }
            this.graph.removeChild(this.areaSelection);
        }
        if (this.overlayConsumer.size() > 0) {
            double[] dArray = new double[]{this.graphXmin + this.areaSelectEnd[0] * (this.graphXmax - this.graphXmin) / 14.75, this.areaSelectEnd[1] * (this.graphYmax - this.graphYmin) / 14.75};
            AreaSelectEvent areaSelectEvent2 = new AreaSelectEvent((AreaSelectTool)((Object)areaSelectEvent.getSource()), dArray, '\u0002', areaSelectEvent.getPrimitiveID());
            for (Overlay1DConsumer overlay1DConsumer : this.overlayConsumer) {
                overlay1DConsumer.areaSelected(areaSelectEvent2);
            }
        }
        this.refresh();
    }

    @Override
    public void areaSelectStart(AreaSelectEvent areaSelectEvent) {
        this.areaSelectStart[0] = areaSelectEvent.getPosition()[0];
        this.areaSelectStart[1] = areaSelectEvent.getPosition()[1];
        if (this.areaSelectStart[0] < 0.0) {
            this.areaSelectStart[0] = 0.0;
        }
        if (this.areaSelectStart[1] < 0.0) {
            this.areaSelectStart[1] = 0.0;
        }
        if (this.areaSelectStart[0] > 15.0) {
            this.areaSelectStart[0] = 15.0;
        }
        if (this.areaSelectStart[1] > 14.75) {
            this.areaSelectStart[1] = 14.75;
        }
        if (this.zoomToolEnabled) {
            this.graph.addChild(this.areaSelection);
        }
        if (this.overlayConsumer.size() > 0) {
            double[] dArray = new double[]{this.graphXmin + this.areaSelectStart[0] * (this.graphXmax - this.graphXmin) / 14.75, this.areaSelectStart[1] * (this.graphYmax - this.graphYmin) / 14.75};
            AreaSelectEvent areaSelectEvent2 = new AreaSelectEvent((AreaSelectTool)((Object)areaSelectEvent.getSource()), dArray, '\u0000', areaSelectEvent.getPrimitiveID());
            for (Overlay1DConsumer overlay1DConsumer : this.overlayConsumer) {
                overlay1DConsumer.areaSelected(areaSelectEvent2);
            }
        }
    }

    public void updateGraphAppearance(int n) {
        if (this.graphLineShaders.size() > 0) {
            DefaultLineShader defaultLineShader = this.graphLineShaders.get(n);
            DefaultGeometryShader defaultGeometryShader = this.graphShaders.get(n);
            Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(n);
            plot1DAppearance.updateGraph(defaultLineShader, defaultGeometryShader);
        }
    }

    public void updateAllGraphAppearances() {
        int n = 0;
        int n2 = this.graphLineShaders.size();
        while (n < n2) {
            DefaultLineShader defaultLineShader = this.graphLineShaders.get(n);
            DefaultGeometryShader defaultGeometryShader = this.graphShaders.get(n);
            Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(n);
            plot1DAppearance.updateGraph(defaultLineShader, defaultGeometryShader);
            SceneGraphComponent sceneGraphComponent = this.subGraphs.get(n);
            sceneGraphComponent.setVisible(plot1DAppearance.isVisible());
            ++n;
        }
    }

    public void addGraphNode() {
        if (this.graph != null) {
            SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
            this.subGraphs.add(sceneGraphComponent);
            Appearance appearance = new Appearance();
            sceneGraphComponent.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            appearance.setAttribute("pointShader.spheresDraw", false);
            appearance.setAttribute("attenuatePointSize", false);
            appearance.setAttribute("lightingEnabled", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
            plot1DAppearance.updateGraph(defaultLineShader, defaultGeometryShader);
            this.graphLineShaders.add(defaultLineShader);
            this.graphShaders.add(defaultGeometryShader);
            this.graphGroupNode.addChild(sceneGraphComponent);
            ++this.numGraphs;
            if (this.xAxis == AxisMode.LINEAR_WITH_OFFSET) {
                this.offsets.add(0, this.xOffset);
            } else if (this.xAxis == AxisMode.CUSTOM) {
                this.xAxes.add(this.xAxes.get(0).clone());
            }
        }
    }

    public void removeGraphNode(int n) {
        if (this.graph != null) {
            assert (this.graphLineShaders.size() > 1);
            if (n < this.graphLineShaders.size()) {
                this.graphLineShaders.remove(n);
            }
            if (n < this.graphShaders.size()) {
                this.graphShaders.remove(n);
            }
            if (n < this.subGraphs.size()) {
                SceneGraphComponent sceneGraphComponent = this.subGraphs.get(n);
                this.graphGroupNode.removeChild(sceneGraphComponent);
                this.subGraphs.remove(n);
            }
            if (n < this.xAxes.size()) {
                this.xAxes.remove(n);
            }
            if (n < this.offsets.size()) {
                this.offsets.remove(n);
            }
            --this.numGraphs;
        }
    }

    public void removeLastGraphNode() {
        if (this.graph != null) {
            assert (this.graphLineShaders.size() > 1);
            this.graphLineShaders.remove(this.graphLineShaders.size() - 1);
            this.graphShaders.remove(this.graphShaders.size() - 1);
            int n = this.subGraphs.size();
            SceneGraphComponent sceneGraphComponent = this.subGraphs.remove(n - 1);
            this.graphGroupNode.removeChild(sceneGraphComponent);
            while (this.xAxes.size() > n - 1) {
                this.xAxes.remove(this.xAxes.size() - 1);
            }
            while (this.offsets.size() > n - 1) {
                this.offsets.remove(this.offsets.size() - 1);
            }
            --this.numGraphs;
        }
    }

    @Override
    public void setXAxisOffset(double d) {
        if (this.xAxis == AxisMode.LINEAR_WITH_OFFSET) {
            this.globalXmin = d;
            this.xOffset = d;
            if (this.offsets.size() > 0) {
                this.offsets.set(0, this.xOffset);
            } else {
                this.offsets.add(0, this.xOffset);
            }
        }
    }

    @Override
    public void setYAxisOffset(double d) {
        this.yOffset = d;
    }

    @Override
    public void setZAxisOffset(double d) {
    }

    @Override
    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.xAxis = axisMode;
        this.yAxis = axisMode2;
        this.zAxis = axisMode3;
    }

    public void setXAxisValues(List<AxisValues> list, int n) {
        int n2;
        if (n == 0) {
            this.xAxes.clear();
        } else {
            n2 = list.size() - 1;
            while (n2 >= n) {
                this.xAxes.remove(n2);
                --n2;
            }
        }
        n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            this.xAxes.add(list.get(n2));
            ++n2;
        }
    }

    public void set2ndXAxisValues(AxisValues axisValues) {
        this.secondaryXAxes = axisValues;
        this.displaySecondaryXAxes = axisValues != null ? axisValues.clone() : null;
    }

    @Override
    public void setXAxisValues(AxisValues axisValues, int n) {
        if (this.xAxes.size() > 0) {
            int n2 = 0;
            int n3 = Math.min(n, this.xAxes.size());
            while (n2 < n3) {
                this.xAxes.set(n2, axisValues);
                ++n2;
            }
            n2 = this.xAxes.size();
            while (n2 < n) {
                this.xAxes.add(n2, axisValues);
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                this.xAxes.add(n4, axisValues);
                ++n4;
            }
        }
    }

    public void replaceXAxisValue(AxisValues axisValues, int n) {
        if (this.xAxes.size() > n) {
            this.xAxes.set(n, axisValues);
        }
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
    }

    private void notifyAllPlotActionListener(PlotActionEvent plotActionEvent) {
        for (PlotActionEventListener plotActionEventListener : this.actionListeners) {
            plotActionEventListener.plotActionPerformed(plotActionEvent);
        }
    }

    private double[] determineDataPos(double d, double d2) {
        double d3 = this.graphXmax - this.graphXmin;
        this.setScalingSmallFlag(this.graphYmin);
        double d4 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
        double d5 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
        double d6 = d5 - d4;
        double d7 = d3 * d / 14.75 + this.graphXmin;
        double d8 = d6 * d2 / 14.75 + d4;
        double[] dArray = new double[2];
        if (this.displaySecondaryXAxes != null) {
            dArray = new double[3];
            double d9 = this.globalRealXmin - this.graphXmin;
            double d10 = this.graphXmax - this.graphXmin;
            double d11 = this.globalRealXmax - this.globalRealXmin;
            double d12 = 14.75 * (d9 / d10);
            double d13 = 14.75 * d11 / d10;
            double d14 = this.displaySecondaryXAxes.getMinValue();
            double d15 = this.displaySecondaryXAxes.getMaxValue();
            double d16 = d15 - d14;
            double d17 = d - d12;
            dArray[2] = d17 = d17 * d16 / d13 + d14;
        }
        d8 = ScalingUtility.inverseScaler(d8, this.yScaling);
        dArray[0] = d7;
        dArray[1] = d8;
        return dArray;
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
        double d = plotActionEvent.getPosition()[0];
        double d2 = plotActionEvent.getPosition()[1];
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 15.0) {
            d = 15.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 14.75) {
            d2 = 14.75;
        }
        double[] dArray = this.determineDataPos(d, d2);
        this.drawActionCrosshair(dArray[0], dArray[1]);
        if (plotActionEvent.getSource().equals((Object)this.rightClickActionTool)) {
            int n = plotActionEvent.getSelectedGraphNr();
            IDataset iDataset = null;
            AxisValues axisValues = null;
            if (n >= 0 && n < this.sets.size()) {
                iDataset = this.sets.get(n);
                if (this.xAxes != null && this.xAxes.size() > n) {
                    axisValues = this.xAxes.get(n);
                }
            }
            PlotActionComplexEvent plotActionComplexEvent = new PlotActionComplexEvent(this.rightClickActionTool, dArray, iDataset, axisValues, this.currentSelectWindow);
            this.notifyAllPlotActionListener(plotActionComplexEvent);
        } else {
            PlotActionEvent plotActionEvent2 = new PlotActionEvent(this.actionTool, dArray);
            this.notifyAllPlotActionListener(plotActionEvent2);
        }
    }

    public void addPlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.add(plotActionEventListener);
    }

    public void removePlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.remove(plotActionEventListener);
    }

    public void enableZoomTool(boolean bl) {
        this.zoomToolEnabled = bl;
    }

    public void enablePlotActionTool(boolean bl) {
        this.actionToolEnabled = bl;
        if (this.graph != null) {
            if (bl) {
                if (this.crosshairID_x == -1) {
                    this.crosshairID_x = this.registerPrimitive(PrimitiveType.LINE);
                } else {
                    this.setPrimitiveVisible(this.crosshairID_x, true);
                }
                if (this.crosshairID_y == -1) {
                    this.crosshairID_y = this.registerPrimitive(PrimitiveType.LINE);
                } else {
                    this.setPrimitiveVisible(this.crosshairID_y, true);
                }
                this.graph.addTool((Tool)this.actionTool);
            } else {
                this.setPrimitiveVisible(this.crosshairID_x, false);
                this.setPrimitiveVisible(this.crosshairID_y, false);
                this.graph.removeTool((Tool)this.actionTool);
                this.app.getCurrentViewer().render();
            }
        }
    }

    public void enableRightClickActionTool(boolean bl) {
        this.rightClickActionToolEnabled = bl;
        if (this.graph != null) {
            if (bl) {
                this.graph.addTool((Tool)this.rightClickActionTool);
            } else {
                this.graph.removeTool((Tool)this.rightClickActionTool);
            }
        }
    }

    @Override
    public void setXAxisLabelMode(TickFormatting tickFormatting) {
        this.xLabelMode = tickFormatting;
        this.buildTickLists();
        if (this.xTicks != null && this.numGraphs > 0) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.secondaryXAxes != null && this.secondaryXAxisTicks != null) {
            this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
        }
    }

    @Override
    public void setYAxisLabelMode(TickFormatting tickFormatting) {
        this.yLabelMode = tickFormatting;
        this.buildTickLists();
        if (this.yTicks != null && this.numGraphs > 0) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
    }

    @Override
    public void setZAxisLabelMode(TickFormatting tickFormatting) {
    }

    private void cleanUpOverlay() {
        Integer[] integerArray;
        if (this.overlayConsumer.size() > 0) {
            for (Overlay1DConsumer object2 : this.overlayConsumer) {
                object2.removePrimitives();
            }
            this.overlayConsumer.clear();
        }
        this.overlayInOperation = false;
        Integer[] integerArray2 = integerArray = this.prim1DMap.keySet().toArray(new Integer[0]);
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer object4 = integerArray2[n2];
            this.unregisterPrimitive(object4);
            ++n2;
        }
        this.prim1DMap.clear();
    }

    @Override
    public void cleanUpGraphNode() {
        if (this.crosshairID_x != -1) {
            this.unregisterPrimitive(this.crosshairID_x);
        }
        if (this.crosshairID_y != -1) {
            this.unregisterPrimitive(this.crosshairID_y);
        }
        this.cleanUpOverlay();
        if (this.graph != null) {
            this.graph.removeChild(this.background);
            Iterator<SceneGraphComponent> iterator = this.subGraphs.iterator();
            while (iterator.hasNext()) {
                this.graphGroupNode.removeChild(iterator.next());
            }
            this.graph.removeChild(this.graphGroupNode);
            if (this.tool != null) {
                this.graph.removeTool((Tool)this.tool);
            }
            if (this.actionTool != null && this.actionToolEnabled) {
                this.graph.removeTool((Tool)this.actionTool);
            }
            if (this.rightClickActionTool != null && this.rightClickActionToolEnabled) {
                this.graph.removeTool((Tool)this.rightClickActionTool);
            }
            this.subGraphs.clear();
        }
        if (this.axis != null) {
            this.axis.removeChild(this.xAxisLabel);
            this.axis.removeChild(this.secondXAxisLabel);
            this.axis.removeChild(this.yAxisLabel);
            this.axis.removeChild(this.titleLabel);
            this.axis.removeChild(this.secondaryAxes);
        }
        if (this.xTicks != null) {
            this.xTicks.removeChild(this.xLabels);
        }
        if (this.yTicks != null) {
            this.yTicks.removeChild(this.yLabels);
        }
    }

    @Override
    public void setTitle(String string) {
        if (!(string == null || this.titleLabelStr != null && string.equals(this.titleLabelStr))) {
            this.titleLabelStr = string;
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{string};
            dArray[0][0] = 7.5;
            dArray[0][1] = 14.85;
            dArray[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.titleLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    public void setZoomMode(boolean bl) {
        this.rangeZoom = !bl;
    }

    public void registerOverlay(Overlay1DConsumer overlay1DConsumer) {
        overlay1DConsumer.registerProvider(this);
        this.overlayConsumer.add(overlay1DConsumer);
    }

    public void unRegisterOverlay(Overlay1DConsumer overlay1DConsumer) {
        this.overlayInOperation = false;
        overlay1DConsumer.unregisterProvider();
        this.overlayConsumer.remove(overlay1DConsumer);
        Iterator<Integer> iterator = this.prim1DMap.keySet().iterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            Object object;
            int n = iterator.next();
            if (n == this.crosshairID_x || n == this.crosshairID_y || (object = this.prim1DMap.get(n)) == null) continue;
            if (this.graphGroupNode != null) {
                this.graphGroupNode.removeChild(((OverlayPrimitive)object).getNode());
            }
            arrayList.add(n);
        }
        for (Integer n : arrayList) {
            this.prim1DMap.remove(n);
        }
        this.refresh();
    }

    @Override
    public boolean begin(OverlayType overlayType) {
        if (!this.overlayInOperation) {
            this.overlayInOperation = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean drawBox(int n, double d, double d2, double d3, double d4) {
        BoxPrimitive boxPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (boxPrimitive = (BoxPrimitive)this.prim1DMap.get(n)) != null) {
            this.setScalingSmallFlag(this.graphYmin);
            double d5 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
            double d6 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
            double d7 = 14.75 * (d - this.graphXmin) / (this.graphXmax - this.graphXmin);
            double d8 = 14.75 * (ScalingUtility.valueScaler(d2, this.yScaling) - d5) / (d6 - d5);
            double d9 = 14.75 * (d3 - this.graphXmin) / (this.graphXmax - this.graphXmin);
            double d10 = 14.75 * (ScalingUtility.valueScaler(d4, this.yScaling) - d5) / (d6 - d5);
            boxPrimitive.setDataPoints(d, d2, d3, d4);
            boxPrimitive.setBoxPoints(d7, d8, d9, d10);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean drawLine(int n, double d, double d2, double d3, double d4) {
        LinePrimitive linePrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (linePrimitive = (LinePrimitive)this.prim1DMap.get(n)) != null) {
            this.setScalingSmallFlag(this.graphYmin);
            double d5 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
            double d6 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
            double d7 = 14.75 * (d - this.graphXmin) / (this.graphXmax - this.graphXmin);
            double d8 = 14.75 * (ScalingUtility.valueScaler(d2, this.yScaling) - d5) / (d6 - d5);
            double d9 = 14.75 * (d3 - this.graphXmin) / (this.graphXmax - this.graphXmin);
            double d10 = 14.75 * (ScalingUtility.valueScaler(d4, this.yScaling) - d5) / (d6 - d5);
            linePrimitive.setDataPoints(d, d2, d3, d4);
            linePrimitive.setLinePoints(d7, d8, d9, d10);
            bl = true;
        }
        return bl;
    }

    @Override
    public void end(OverlayType overlayType) {
        this.overlayInOperation = false;
        switch (overlayType) {
            case IMAGE: {
                logger.warn("Unsupported operation in 1D overlay");
                break;
            }
            case VECTOR2D: {
                Iterator<Integer> iterator = this.prim1DMap.keySet().iterator();
                while (iterator.hasNext()) {
                    OverlayPrimitive overlayPrimitive = this.prim1DMap.get(iterator.next());
                    overlayPrimitive.updateNode();
                }
                break;
            }
            case THREED: {
                logger.warn("Unsupported operation in 1D overlay");
            }
        }
        this.refresh();
    }

    @Override
    public int registerPrimitive(PrimitiveType primitiveType) {
        if (this.graphGroupNode != null && (primitiveType == PrimitiveType.LINE || primitiveType == PrimitiveType.BOX || primitiveType == PrimitiveType.LABEL)) {
            ++this.primKeyID;
            while (this.prim1DMap.containsKey(this.primKeyID)) {
                this.primKeyID = (this.primKeyID + 1) % Integer.MAX_VALUE;
            }
            OverlayPrimitive overlayPrimitive = null;
            SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)("overlayPrim" + this.primKeyID));
            this.graphGroupNode.addChild(sceneGraphComponent);
            switch (primitiveType) {
                case LINE: {
                    overlayPrimitive = new LinePrimitive(sceneGraphComponent);
                    break;
                }
                case BOX: {
                    overlayPrimitive = new BoxPrimitive(sceneGraphComponent);
                    break;
                }
                case LABEL: {
                    overlayPrimitive = new LabelPrimitive(sceneGraphComponent);
                }
            }
            this.prim1DMap.put(this.primKeyID, overlayPrimitive);
            return this.primKeyID;
        }
        return -1;
    }

    @Override
    public void setColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim1DMap.get(n)) != null) {
            overlayPrimitive.setColour(color);
        }
    }

    @Override
    public void setOutlineColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive = this.prim1DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setOutlineColour(color);
        }
    }

    @Override
    public void setStyle(int n, VectorOverlayStyles vectorOverlayStyles) {
        OverlayPrimitive overlayPrimitive = this.prim1DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setStyle(vectorOverlayStyles);
        }
    }

    @Override
    public boolean setTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim1DMap.get(n)) != null) {
            overlayPrimitive.setTransparency(d);
            bl = true;
        }
        return bl;
    }

    @Override
    public void translatePrimitive(int n, double d, double d2) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim1DMap.get(n)) != null) {
            double[] dArray = new double[2];
            this.setScalingSmallFlag(this.graphYmin);
            double d3 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
            double d4 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
            dArray[0] = d / (this.graphXmax - this.graphXmin) * 14.75;
            dArray[1] = ScalingUtility.valueScaler(d2, this.yScaling) / (d4 - d3) * 14.75;
            overlayPrimitive.translate(dArray);
        }
    }

    @Override
    public void unregisterPrimitive(int n) {
        OverlayPrimitive overlayPrimitive = this.prim1DMap.remove(n);
        if (overlayPrimitive != null && this.graphGroupNode != null) {
            this.graphGroupNode.removeChild(overlayPrimitive.getNode());
        }
        this.refresh();
    }

    @Override
    public void unregisterPrimitive(List<Integer> list) {
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim1DMap.remove(iterator.next());
            if (overlayPrimitive == null || this.graphGroupNode == null) continue;
            this.graphGroupNode.removeChild(overlayPrimitive.getNode());
        }
        this.refresh();
    }

    @Override
    public void setTickGridLinesActive(boolean bl, boolean bl2, boolean bl3) {
        this.showXTicks = bl;
        this.showYTicks = bl2;
        if (this.xTicks != null && this.graph != null) {
            this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTicks != null && this.graph != null) {
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.secondaryXAxes != null && this.secondaryXAxisTicks != null) {
            this.secondaryXAxisTicks.setGeometry((Geometry)this.create2ndXTicksGeometry());
        }
    }

    @Override
    public void setZAxisValues(AxisValues axisValues) {
    }

    @Override
    public void setLineThickness(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim1DMap.get(n)) != null) {
            overlayPrimitive.setLineThickness(d);
        }
    }

    @Override
    public boolean setOutlineTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim1DMap.get(n)) != null) {
            overlayPrimitive.setOutlineTransparency(d);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setPrimitiveVisible(int n, boolean bl) {
        boolean bl2 = false;
        OverlayPrimitive overlayPrimitive = this.prim1DMap.get(n);
        if (overlayPrimitive != null) {
            if (bl) {
                if (overlayPrimitive.isHidden() && this.graphGroupNode != null) {
                    this.graphGroupNode.addChild(overlayPrimitive.getNode());
                    overlayPrimitive.unhide();
                    bl2 = true;
                }
            } else if (!overlayPrimitive.isHidden() && this.graphGroupNode != null) {
                this.graphGroupNode.removeChild(overlayPrimitive.getNode());
                overlayPrimitive.hide();
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public void resetView() {
    }

    @Override
    public int registerPrimitive(PrimitiveType primitiveType, boolean bl) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataPoints(double[] dArray) throws PlotException {
        if (this.xAxis != AxisMode.LINEAR && this.xAxis != AxisMode.LINEAR_WITH_OFFSET) throw new PlotException(ERRORMSG_NOT_LINEAR);
        if (this.sets.size() <= 0) throw new PlotException(ERRORMSG_NO_GRAPH);
        IDataset iDataset = this.sets.get(0);
        SceneGraphComponent sceneGraphComponent = this.subGraphs.get(0);
        int n = iDataset.getShape()[0];
        int n2 = 0;
        while (n2 < dArray.length) {
            iDataset.set((Object)dArray[n2], new int[]{n + n2});
            ++n2;
        }
        if (this.undoSelectStack.size() == 0) {
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            if (this.xAxis == AxisMode.LINEAR) {
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset));
            } else {
                double d = this.offsets.get(0);
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, d));
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks == null) return;
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            return;
        } else {
            SelectedWindow selectedWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
            this.updateWindowWithNewRanges(this.sets, selectedWindow);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataPoints(double[] dArray, double[] dArray2) throws PlotException {
        if (this.xAxis != AxisMode.CUSTOM) throw new PlotException(ERRORMSG_NOT_CUSTOM);
        if (this.sets.size() <= 0) throw new PlotException(ERRORMSG_NO_GRAPH);
        IDataset iDataset = this.sets.get(0);
        SceneGraphComponent sceneGraphComponent = this.subGraphs.get(0);
        AxisValues axisValues = this.xAxes.get(0);
        int n = iDataset.getShape()[0];
        int n2 = 0;
        while (n2 < dArray.length) {
            iDataset.set((Object)dArray[n2], new int[]{n + n2});
            ++n2;
        }
        n2 = 0;
        while (n2 < dArray2.length) {
            axisValues.addValue(dArray2[n2]);
            ++n2;
        }
        if (this.undoSelectStack.size() == 0) {
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues));
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks == null) return;
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            return;
        } else {
            SelectedWindow selectedWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
            this.updateWindowWithNewRanges(this.sets, selectedWindow);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataPoints(List<double[]> list) throws PlotException {
        IDataset iDataset;
        if (this.xAxis != AxisMode.LINEAR && this.xAxis != AxisMode.LINEAR_WITH_OFFSET) throw new PlotException(ERRORMSG_NOT_LINEAR);
        if (list.size() != this.sets.size()) throw new PlotException(ERRORMSG_WRONG_NUM_ENTRIES);
        Iterator<double[]> iterator = list.iterator();
        Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
        Iterator<IDataset> iterator3 = this.sets.iterator();
        Iterator<Double> iterator4 = null;
        if (this.xAxis == AxisMode.LINEAR_WITH_OFFSET) {
            iterator4 = this.offsets.iterator();
        }
        while (iterator.hasNext()) {
            double[] dArray = iterator.next();
            iDataset = iterator3.next();
            int n = iDataset.getShape()[0];
            int n2 = 0;
            while (n2 < dArray.length) {
                iDataset.set((Object)dArray[n2], new int[]{n + n2});
                ++n2;
            }
        }
        if (this.undoSelectStack.size() == 0) {
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            iterator3 = this.sets.iterator();
            while (iterator2.hasNext()) {
                SceneGraphComponent sceneGraphComponent = iterator2.next();
                iDataset = iterator3.next();
                if (this.xAxis == AxisMode.LINEAR) {
                    sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset));
                    continue;
                }
                double d = iterator4.next();
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, d));
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks == null) return;
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            return;
        } else {
            SelectedWindow selectedWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
            this.updateWindowWithNewRanges(this.sets, selectedWindow);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataPoints(List<double[]> list, List<double[]> list2) throws PlotException {
        if (this.xAxis != AxisMode.CUSTOM) throw new PlotException(ERRORMSG_NOT_CUSTOM);
        if (list.size() != this.sets.size()) throw new PlotException(ERRORMSG_WRONG_NUM_ENTRIES);
        Iterator<double[]> iterator = list.iterator();
        Iterator<double[]> iterator2 = list2.iterator();
        Iterator<SceneGraphComponent> iterator3 = this.subGraphs.iterator();
        Iterator<IDataset> iterator4 = this.sets.iterator();
        Iterator<AxisValues> iterator5 = this.xAxes.iterator();
        while (iterator.hasNext()) {
            double[] dArray = iterator.next();
            double[] dArray2 = iterator2.next();
            IDataset iDataset = iterator4.next();
            AxisValues axisValues = iterator5.next();
            int n = iDataset.getShape()[0];
            int n2 = 0;
            while (n2 < dArray.length) {
                iDataset.set((Object)dArray[n2], new int[]{n + n2});
                ++n2;
            }
            n2 = 0;
            while (n2 < dArray2.length) {
                axisValues.addValue(dArray2[n2]);
                ++n2;
            }
        }
        if (this.undoSelectStack.size() == 0) {
            this.determineRanges(this.sets);
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            iterator4 = this.sets.iterator();
            iterator5 = this.xAxes.iterator();
            while (iterator3.hasNext()) {
                SceneGraphComponent sceneGraphComponent = iterator3.next();
                IDataset iDataset = iterator4.next();
                AxisValues axisValues = iterator5.next();
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues));
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks == null) return;
            this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            return;
        } else {
            SelectedWindow selectedWindow = this.undoSelectStack.get(this.undoSelectStack.size() - 1);
            this.updateWindowWithNewRanges(this.sets, selectedWindow);
        }
    }

    @Override
    public boolean drawLabel(int n, double d, double d2) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim1DMap.get(n)) != null) {
            this.setScalingSmallFlag(this.graphYmin);
            double d3 = ScalingUtility.valueScaler(this.graphYmin, this.yScaling);
            double d4 = ScalingUtility.valueScaler(this.graphYmax, this.yScaling);
            double d5 = 14.75 * (d - this.graphXmin) / (this.graphXmax - this.graphXmin);
            double d6 = 14.75 * (ScalingUtility.valueScaler(d2, this.yScaling) - d3) / (d4 - d3);
            labelPrimitive.setLabelPosition(d5, d6);
            labelPrimitive.setDataPoints(d, d2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelFont(int n, Font font) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim1DMap.get(n)) != null) {
            labelPrimitive.setLabelFont(font);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelOrientation(int n, LabelOrientation labelOrientation) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim1DMap.get(n)) != null) {
            labelPrimitive.setLabelDirection(labelOrientation);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelText(int n, String string, int n2) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim1DMap.get(n)) != null) {
            labelPrimitive.setLabelString(string);
            labelPrimitive.setLabelAlignment(n2);
            bl = true;
        }
        return bl;
    }

    private void drawActionCrosshair(double d, double d2) {
        if (this.crosshairID_x != -1 && this.crosshairID_y != -1) {
            this.begin(OverlayType.VECTOR2D);
            this.setColour(this.crosshairID_x, Color.RED);
            this.setColour(this.crosshairID_y, Color.RED);
            this.drawLine(this.crosshairID_x, this.graphXmin, d2, this.graphXmax, d2);
            this.drawLine(this.crosshairID_y, d, this.graphYmin, d, this.graphYmax);
            this.end(OverlayType.VECTOR2D);
        }
    }

    public void setUpdateOperation(boolean bl) {
        this.isUpdateOperation = bl;
    }

    @Override
    public ScaleType getScaling() {
        return this.yScaling;
    }

    @Override
    public List<AxisValues> getAxisValues() {
        return this.xAxes;
    }

    @Override
    public void restoreDefaultPlotAreaCursor() {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSet3DPlot1D.this.plotArea.setCursor(DataSet3DPlot1D.this.defaultCursor);
            }
        });
    }

    @Override
    public void setPlotAreaCursor(final int n) {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DataSet3DPlot1D.this.plotArea.getDisplay().getSystemCursor(n);
                if (cursor != null) {
                    DataSet3DPlot1D.this.plotArea.setCursor(cursor);
                }
            }
        });
    }

    @Override
    public void rotatePrimitive(int n, double d, double d2, double d3) {
    }

    @Override
    public void setAnchorPoints(int n, double d, double d2) {
    }

    @Override
    public void toggleErrorBars(boolean bl, boolean bl2, boolean bl3) {
    }
}

