/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class AxisValues
implements Iterable<Double>,
Serializable {
    private DoubleDataset values = null;
    private double minValue;
    private double maxValue;
    private boolean isDirty;
    private static Iterator<Double> NULL_ITERATOR = new Iterator<Double>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Double next() {
            throw new NoSuchElementException("No elements left as no values defined");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    };

    public List<Double> getValues() {
        if (this.values == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < this.values.getShape()[0]) {
            arrayList.add(this.values.get(new int[]{n++}));
        }
        return arrayList;
    }

    public DoubleDataset toDataset() {
        return this.values;
    }

    public AxisValues() {
        this.values = null;
        this.minValue = 3.4028234663852886E38;
        this.maxValue = -3.4028234663852886E38;
        this.isDirty = false;
    }

    public AxisValues(List<Double> list) {
        this.setValues(list);
    }

    public AxisValues(double[] dArray) {
        this.setValues(dArray);
    }

    public AxisValues(AbstractDataset abstractDataset) {
        this.setValues(abstractDataset);
    }

    public void addValue(double d) {
        if (this.values == null) {
            this.values = new DoubleDataset(new double[]{d}, new int[0]);
        } else {
            this.values.set((Object)d, new int[]{this.values.getShape()[0]});
        }
        this.isDirty = true;
    }

    public void setValues(List<Double> list) {
        this.values = (DoubleDataset)AbstractDataset.createFromList(list);
        this.isDirty = true;
    }

    public void setValues(double[] dArray) {
        this.values = new DoubleDataset(dArray, new int[0]);
        this.isDirty = true;
    }

    public void setValues(AbstractDataset abstractDataset) {
        this.values = (DoubleDataset)DatasetUtils.cast((AbstractDataset)abstractDataset, (int)6);
        this.isDirty = true;
    }

    public void setLowEntry(double d) {
        boolean bl = this.values.get(new int[]{0}) == this.minValue;
        this.values.set((Object)d, new int[]{0});
        if (bl) {
            this.minValue = d;
        }
    }

    public void setTopEntry(double d) {
        boolean bl = this.values.get(new int[]{this.values.getShape()[0] - 1}) == this.maxValue;
        this.values.set((Object)d, new int[]{this.values.getShape()[0] - 1});
        if (bl) {
            this.maxValue = d;
        }
    }

    public double getValue(int n) {
        if (this.values.getSize() > 0) {
            if (n < this.values.getShape()[0]) {
                return this.values.get(new int[]{n});
            }
            return this.values.get(new int[]{n - 1});
        }
        return Double.NaN;
    }

    public double distBetween(int n, int n2) {
        return this.values.get(new int[]{n2}) - this.values.get(new int[]{n});
    }

    public void clear() {
        this.values = null;
        this.maxValue = -3.4028234663852886E38;
        this.minValue = 3.4028234663852886E38;
        this.isDirty = false;
    }

    public int nearestUpEntry(double d) {
        if (this.isDirty) {
            this.sanityCheckMinMax();
        }
        if (d > this.maxValue || d < this.minValue) {
            return -1;
        }
        IndexIterator indexIterator = this.values.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d2 = this.values.getAbs(indexIterator.index);
            if (d2 >= d) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int nearestLowEntry(double d) {
        if (this.isDirty) {
            this.sanityCheckMinMax();
        }
        if (d > this.maxValue || d < this.minValue) {
            return -1;
        }
        IndexIterator indexIterator = this.values.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d2 = this.values.getAbs(indexIterator.index);
            if (d2 == d) {
                return n;
            }
            if (d2 > d) {
                return n - 1;
            }
            ++n;
        }
        return -1;
    }

    public AxisValues subset(int n, int n2) {
        return this.subset(n, n2, 1);
    }

    public AxisValues subset(int n, int n2, int n3) {
        return new AxisValues((AbstractDataset)this.values.getSlice(new int[]{n}, new int[]{n2}, new int[]{n3}));
    }

    public int size() {
        if (this.values == null) {
            return 0;
        }
        return this.values.getSize();
    }

    public AxisValues clone() {
        AxisValues axisValues = new AxisValues((AbstractDataset)this.values);
        axisValues.maxValue = this.maxValue;
        axisValues.minValue = this.minValue;
        return axisValues;
    }

    public double getMinValue() {
        this.sanityCheckMinMax();
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
        this.isDirty = false;
    }

    public double getMaxValue() {
        this.sanityCheckMinMax();
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        this.isDirty = false;
    }

    private void sanityCheckMinMax() {
        if (this.isDirty) {
            this.minValue = this.values.min().doubleValue();
            this.maxValue = this.values.max().doubleValue();
            this.isDirty = false;
        }
        if (this.minValue > this.maxValue) {
            double d = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = d;
        }
    }

    public boolean isAscending() {
        if (this.values.getShape()[0] > 0) {
            return this.values.get(new int[]{0}) < this.values.get(new int[]{this.values.getShape()[0] - 1});
        }
        return true;
    }

    public String toString() {
        return this.values != null ? this.values.toString() : "Empty";
    }

    @Override
    public Iterator<Double> iterator() {
        Iterator<Double> iterator = this.values == null ? NULL_ITERATOR : new Iterator<Double>(){
            IndexIterator it;
            boolean read;
            {
                this.it = AxisValues.this.values.getIterator();
                this.read = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }

            @Override
            public Double next() {
                if (this.read) {
                    if (this.it.hasNext()) {
                        this.read = false;
                        return this.next();
                    }
                    throw new NoSuchElementException("No elements left");
                }
                this.read = true;
                return AxisValues.this.values.getAbs(this.it.index);
            }

            @Override
            public boolean hasNext() {
                if (this.read) {
                    this.read = false;
                    return this.it.hasNext();
                }
                return true;
            }
        };
        return iterator;
    }
}

