/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPartSite;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotAxisProperty;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.SliceProperty;
import uk.ac.gda.monitor.IMonitor;

class ScatterTab
extends PlotTab {
    private static final int POINTSIZE = 4;
    private static final String CONSTANT = "constant";
    private static final String DATA = "data";
    private boolean useData;

    public ScatterTab(IWorkbenchPartSite iWorkbenchPartSite, DatasetSelection.InspectorType inspectorType, String string, String[] stringArray) {
        super(iWorkbenchPartSite, inspectorType, string, stringArray);
        this.comboOffset = 1;
    }

    @Override
    protected void createCombos(Composite composite, SelectionListener selectionListener) {
        new Label(composite, 0).setText("size");
        Combo combo = new Combo(composite, 8);
        combo.add("               ");
        combo.addSelectionListener(selectionListener);
        this.combos.add(combo);
        super.createCombos(composite, selectionListener);
    }

    @Override
    public boolean checkCompatible(ILazyDataset iLazyDataset) {
        boolean bl = false;
        int n = iLazyDataset.getRank();
        if (n == 1) {
            bl = true;
        } else {
            boolean bl2 = bl = n >= this.axes.length - 1;
        }
        if (this.composite != null) {
            this.composite.setEnabled(bl);
        }
        return bl;
    }

    @Override
    public boolean canPlotConstant() {
        return true;
    }

    @Override
    public boolean[] getUsedDims() {
        boolean[] blArray = super.getUsedDims();
        if (this.daxes != null && this.daxes.size() == 1) {
            blArray[0] = true;
        }
        return blArray;
    }

    @Override
    protected List<AxisChoice> getChosenAxes() {
        if (this.daxes != null && this.daxes.size() != 1) {
            return super.getChosenAxes();
        }
        LinkedList<String> linkedList = this.getChosenAxisNames();
        ArrayList<AxisChoice> arrayList = new ArrayList<AxisChoice>();
        for (String string : linkedList) {
            AxisChoice axisChoice = null;
            for (AxisSelection axisSelection : this.daxes) {
                axisChoice = axisSelection.getAxis(string);
                if (axisChoice != null) break;
            }
            if (axisChoice != null) {
                arrayList.add(axisChoice);
                continue;
            }
            logger.warn("No axis of names {} found in selections {}", linkedList, (Object)this.daxes);
        }
        return arrayList;
    }

    protected LinkedList<String> getAllAxisNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.daxes != null) {
            for (AxisSelection axisSelection : this.daxes) {
                if (axisSelection.getLength() <= 0) continue;
                int n = 0;
                int n2 = axisSelection.size();
                while (n < n2) {
                    linkedList.add(axisSelection.getName(n));
                    ++n;
                }
            }
        }
        return linkedList;
    }

    @Override
    protected void populateCombos() {
        String string;
        Combo combo = (Combo)this.combos.get(0);
        combo.removeAll();
        combo.add(CONSTANT);
        String string2 = string = this.dataset == null ? null : this.dataset.getName();
        if (string == null || string.length() == 0) {
            combo.add(DATA);
        } else {
            combo.add(string);
        }
        combo.setText(CONSTANT);
        if (this.paxes != null) {
            PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(0);
            plotAxisProperty.setName(CONSTANT, false);
        }
        if (this.daxes != null && this.daxes.size() != 1) {
            super.populateCombos();
            return;
        }
        int n = this.combos.size() - this.comboOffset;
        LinkedList<String> linkedList = this.getAllAxisNames();
        int n2 = this.daxes.size();
        int n3 = 0;
        while (n3 < n) {
            String string3;
            combo = (Combo)this.combos.get(n3 + this.comboOffset);
            combo.removeAll();
            PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(n3 + this.comboOffset);
            if (n3 < n2) {
                string3 = ((AxisSelection)this.daxes.get(n3)).getSelectedName();
                if (!linkedList.contains(string3)) {
                    string3 = linkedList.getLast();
                }
            } else {
                string3 = linkedList.getLast();
            }
            plotAxisProperty.clear();
            int n4 = linkedList.size();
            int n5 = 0;
            while (n5 < n4) {
                String string4 = linkedList.get(n5);
                plotAxisProperty.put(n5, string4);
                combo.add(string4);
                ++n5;
            }
            combo.setText(string3);
            linkedList.remove(string3);
            plotAxisProperty.setName(string3, false);
            plotAxisProperty.setInSet(true);
            ++n3;
        }
    }

    @Override
    protected void repopulateCombos(String string, String string2) {
        if (this.combos == null) {
            return;
        }
        if (this.daxes != null && this.daxes.size() != 1) {
            super.repopulateCombos(string, string2);
            return;
        }
        int n = this.combos.size() - this.comboOffset;
        LinkedList<String> linkedList = this.getAllAxisNames();
        int n2 = this.daxes.size();
        if (n2 == 0) {
            return;
        }
        boolean bl = string != null && string2 != null;
        String string3 = null;
        int n3 = 0;
        while (n3 < n) {
            PlotAxisProperty plotAxisProperty;
            Combo combo = (Combo)this.combos.get(n3 + this.comboOffset);
            string3 = bl && n3 < n2 ? ((AxisSelection)this.daxes.get(n3)).getSelectedName() : combo.getItem(combo.getSelectionIndex());
            combo.removeAll();
            if (!linkedList.contains(string3)) {
                string3 = linkedList.get(0);
            }
            if (!bl && n3 < n2) {
                ((AxisSelection)this.daxes.get(n3)).selectAxis(string3, false);
            }
            for (String string4 : linkedList) {
                combo.add(string4);
            }
            combo.setText(string3);
            linkedList.remove(string3);
            if (this.paxes != null && (plotAxisProperty = (PlotAxisProperty)this.paxes.get(n3 + this.comboOffset)).isInSet()) {
                plotAxisProperty.setName(string3, false);
            }
            ++n3;
        }
        if (string3 != null && this.paxes != null && ((PlotAxisProperty)this.paxes.get(n - 1 + this.comboOffset)).isInSet()) {
            ((PlotAxisProperty)this.paxes.get(n - 1 + this.comboOffset)).setName(string3);
        }
    }

    @Override
    protected List<AbstractDataset> sliceAxes(List<AxisChoice> list, Slice[] sliceArray, int[] nArray) {
        if (this.daxes.size() != 1) {
            return super.sliceAxes(list, sliceArray, nArray);
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        if (sliceArray.length != 1) {
            logger.error("No slices defined");
            return null;
        }
        Slice slice = sliceArray[0];
        if (slice != null && !slice.isSliceComplete()) {
            for (AxisChoice axisChoice : list) {
                arrayList.add(DatasetUtils.convertToAbstractDataset((ILazyDataset)axisChoice.getValues().getSlice(new Slice[]{slice})));
            }
        } else {
            for (AxisChoice axisChoice : list) {
                arrayList.add(DatasetUtils.convertToAbstractDataset((ILazyDataset)axisChoice.getValues()));
            }
        }
        return arrayList;
    }

    @Override
    public void pushToView(IMonitor iMonitor, List<SliceProperty> list) {
        int n;
        int[] nArray;
        if (this.dataset == null) {
            return;
        }
        this.useData = !CONSTANT.equals(((PlotAxisProperty)this.paxes.get(0)).getName());
        Slice[] sliceArray = new Slice[list.size()];
        int n2 = 0;
        while (n2 < sliceArray.length) {
            sliceArray[n2] = list.get(n2).getValue();
            ++n2;
        }
        List<AxisChoice> list2 = this.getChosenAxes();
        List<AbstractDataset> list3 = this.sliceAxes(list2, sliceArray, nArray = this.getOrder(n = this.daxes.size()));
        if (list3 == null) {
            return;
        }
        AbstractDataset abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray);
        if (abstractDataset == null) {
            return;
        }
        switch (this.itype) {
            case POINTS1D: {
                AbstractDataset abstractDataset2 = list3.get(0);
                AbstractDataset abstractDataset3 = abstractDataset.flatten();
                if (!abstractDataset2.isCompatibleWith((ILazyDataset)abstractDataset3)) {
                    logger.error("Could not match axis to data for scatter plot");
                    return;
                }
                AbstractDataset abstractDataset4 = this.useData ? abstractDataset3 : new IntegerDataset(new int[]{abstractDataset2.getSize()}).fill((Object)4);
                try {
                    SDAPlotter.scatter2DPlot((String)"Dataset Plot", (IDataset)abstractDataset2.flatten(), (IDataset)abstractDataset3, (IDataset)abstractDataset4);
                    break;
                }
                catch (Exception exception) {
                    logger.error("Could not plot 1d points");
                    return;
                }
            }
            case POINTS2D: {
                IDataset iDataset;
                AbstractDataset abstractDataset5;
                if (!this.useData) {
                    AbstractDataset abstractDataset6 = list3.get(0).flatten();
                    AbstractDataset abstractDataset7 = list3.get(1).flatten();
                    int n3 = Math.min(abstractDataset6.getSize(), abstractDataset7.getSize());
                    Slice slice = new Slice(Integer.valueOf(n3));
                    abstractDataset = new IntegerDataset(new int[]{n3}).fill((Object)4);
                    try {
                        SDAPlotter.scatter2DPlot((String)"Dataset Plot", (IDataset)abstractDataset6.getSlice(new Slice[]{slice}), (IDataset)abstractDataset7.getSlice(new Slice[]{slice}), (IDataset)abstractDataset);
                        break;
                    }
                    catch (Exception exception) {
                        logger.error("Could not plot 2d points");
                        return;
                    }
                }
                if (abstractDataset.getRank() == 1) {
                    abstractDataset5 = list3.get(0);
                    iDataset = (IDataset)list3.get(1);
                } else {
                    List list4 = DatasetUtils.meshGrid((AbstractDataset[])new AbstractDataset[]{list3.get(0), list3.get(1)});
                    abstractDataset5 = (AbstractDataset)list4.get(0);
                    iDataset = (IDataset)list4.get(1);
                }
                if (!abstractDataset.isCompatibleWith((ILazyDataset)abstractDataset5) || !abstractDataset.isCompatibleWith((ILazyDataset)iDataset)) {
                    logger.error("Could not match axes to data for scatter plot");
                    return;
                }
                try {
                    SDAPlotter.scatter2DPlot((String)"Dataset Plot", (IDataset)abstractDataset5.flatten(), (IDataset)((AbstractDataset)iDataset).flatten(), (IDataset)abstractDataset.flatten());
                    break;
                }
                catch (Exception exception) {
                    logger.error("Could not plot 2d points");
                    return;
                }
            }
            case POINTS3D: {
                if (!this.useData) {
                    AbstractDataset abstractDataset8 = list3.get(0).flatten();
                    AbstractDataset abstractDataset9 = list3.get(1).flatten();
                    AbstractDataset abstractDataset10 = list3.get(2).flatten();
                    int n4 = Math.min(abstractDataset8.getSize(), abstractDataset9.getSize());
                    n4 = Math.min(n4, abstractDataset10.getSize());
                    Slice slice = new Slice(Integer.valueOf(n4));
                    abstractDataset = new IntegerDataset(new int[]{n4}).fill((Object)4);
                    try {
                        SDAPlotter.scatter3DPlot((String)"Dataset Plot", (IDataset)abstractDataset8.getSlice(new Slice[]{slice}), (IDataset)abstractDataset9.getSlice(new Slice[]{slice}), (IDataset)abstractDataset10.getSlice(new Slice[]{slice}), (IDataset)abstractDataset);
                        break;
                    }
                    catch (Exception exception) {
                        logger.error("Could not plot 3d points");
                        return;
                    }
                }
                AbstractDataset abstractDataset11 = DatasetUtils.convertToAbstractDataset((ILazyDataset)list2.get(0).getValues());
                AbstractDataset abstractDataset12 = DatasetUtils.convertToAbstractDataset((ILazyDataset)list2.get(1).getValues());
                AbstractDataset abstractDataset13 = DatasetUtils.convertToAbstractDataset((ILazyDataset)list2.get(2).getValues());
                if (abstractDataset.getRank() != 1) {
                    List list5 = DatasetUtils.meshGrid((AbstractDataset[])new AbstractDataset[]{abstractDataset11, abstractDataset12, abstractDataset13});
                    abstractDataset11 = (AbstractDataset)list5.get(0);
                    abstractDataset12 = (IDataset)list5.get(1);
                    abstractDataset13 = (IDataset)list5.get(2);
                }
                if (!(abstractDataset.isCompatibleWith((ILazyDataset)abstractDataset11) && abstractDataset.isCompatibleWith((ILazyDataset)abstractDataset12) && abstractDataset.isCompatibleWith((ILazyDataset)abstractDataset13))) {
                    logger.error("Could not match axes to data for scatter plot");
                    return;
                }
                try {
                    SDAPlotter.scatter3DPlot((String)"Dataset Plot", (IDataset)abstractDataset11.flatten(), (IDataset)abstractDataset12.flatten(), (IDataset)abstractDataset13.flatten(), (IDataset)abstractDataset.flatten());
                    break;
                }
                catch (Exception exception) {
                    logger.error("Could not plot 3d points");
                    return;
                }
            }
        }
    }
}

