/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.ATab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotAxisProperty;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.SliceProperty;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;
import uk.ac.gda.monitor.IMonitor;

class PlotTab
extends ATab {
    private static final String VOLVIEWNAME = "Remote Volume Viewer";
    private String explorerName;
    private static final int STACKPLOTLIMIT = 100;
    private static final int MULTIIMAGESLIMIT = 7;
    private PropertyChangeListener axesListener = null;
    private ImageExplorerView explorer = null;
    protected boolean runLongJob = false;
    private boolean plotStackIn3D = false;

    public PlotTab(IWorkbenchPartSite iWorkbenchPartSite, DatasetSelection.InspectorType inspectorType, String string, String[] stringArray) {
        super(iWorkbenchPartSite, inspectorType, string, stringArray);
    }

    @Override
    public Composite createTabComposite(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.combos = new ArrayList();
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                int n = PlotTab.this.combos.indexOf(combo);
                if (n >= 0 && PlotTab.this.paxes != null) {
                    PlotAxisProperty plotAxisProperty = (PlotAxisProperty)PlotTab.this.paxes.get(n);
                    String string = combo.getItem(combo.getSelectionIndex());
                    if (string.equals(plotAxisProperty.getName())) {
                        return;
                    }
                    plotAxisProperty.setName(string, false);
                    PlotTab.this.repopulateCombos(null, null);
                }
            }
        };
        this.createCombos(composite2, (SelectionListener)selectionAdapter);
        if (this.daxes != null) {
            this.populateCombos();
        }
        if (this.itype == DatasetSelection.InspectorType.LINESTACK) {
            final Button button = new Button(composite2, 32);
            button.setText("In 3D");
            button.setToolTipText("Check to plot stack of lines in 3D");
            button.setSelection(this.plotStackIn3D);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PlotTab.this.plotStackIn3D = button.getSelection();
                    if (PlotTab.this.paxes != null) {
                        PlotAxisProperty plotAxisProperty = (PlotAxisProperty)PlotTab.this.paxes.get(0);
                        plotAxisProperty.fire(new PropertyChangeEvent(plotAxisProperty, "plotupdate", plotAxisProperty.getName(), plotAxisProperty.getName()));
                    }
                }
            });
        }
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        scrolledComposite.setContent((Control)composite2);
        composite2.setSize(composite2.computeSize(-1, -1));
        this.composite = scrolledComposite;
        return this.composite;
    }

    protected void createCombos(Composite composite, SelectionListener selectionListener) {
        int n = 0;
        while (n < this.axes.length) {
            new Label(composite, 0).setText(this.axes[n]);
            Combo combo = new Combo(composite, 8);
            combo.add("               ");
            combo.addSelectionListener(selectionListener);
            this.combos.add(combo);
            ++n;
        }
    }

    @Override
    public void drawTab() {
        this.repopulateCombos(null, null);
    }

    @Override
    public synchronized void stopInspection() {
        this.runLongJob = false;
    }

    private synchronized void setInspectionRunning() {
        this.runLongJob = true;
    }

    private synchronized boolean canContinueInspection() {
        return this.runLongJob;
    }

    @Override
    public void setParameters(ILazyDataset iLazyDataset, List<AxisSelection> list, List<PlotAxisProperty> list2) {
        if (this.axesListener != null && this.daxes != null) {
            for (AxisSelection axisSelection : this.daxes) {
                axisSelection.removePropertyChangeListener(this.axesListener);
            }
        }
        super.setParameters(iLazyDataset, list, list2);
        if (this.daxes != null) {
            if (this.axesListener == null) {
                this.axesListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        PlotTab.this.repopulateCombos(propertyChangeEvent.getOldValue().toString(), propertyChangeEvent.getNewValue().toString());
                    }
                };
            }
            for (AxisSelection axisSelection : this.daxes) {
                axisSelection.addPropertyChangeListener(this.axesListener);
            }
        }
        if (this.combos != null) {
            this.populateCombos();
        }
    }

    protected List<AxisChoice> getChosenAxes() {
        LinkedList<String> linkedList = this.getChosenAxisNames();
        ArrayList<AxisChoice> arrayList = new ArrayList<AxisChoice>();
        for (AxisSelection axisSelection : this.daxes) {
            AxisChoice axisChoice = null;
            String string = axisSelection.getSelectedName();
            if (linkedList.indexOf(string) != -1) {
                axisChoice = axisSelection.getAxis(string);
                linkedList.remove(string);
            }
            if (axisChoice != null) {
                arrayList.add(axisChoice);
                continue;
            }
            arrayList.add(axisSelection.getSelectedAxis());
        }
        return arrayList;
    }

    protected final LinkedList<String> getChosenAxisNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.paxes != null) {
            for (PlotAxisProperty plotAxisProperty : this.paxes) {
                if (!plotAxisProperty.isInSet()) continue;
                String string = plotAxisProperty.getName();
                if (string != null) {
                    linkedList.add(string);
                    continue;
                }
                logger.error("No axis selected in {}", (Object)plotAxisProperty);
            }
        }
        return linkedList;
    }

    protected final LinkedList<String> getSelectedAxisNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.daxes != null) {
            for (AxisSelection axisSelection : this.daxes) {
                String string = axisSelection.getSelectedName();
                if (string != null) {
                    linkedList.add(string);
                    continue;
                }
                logger.error("No axis selected in {}", (Object)axisSelection);
            }
        }
        return linkedList;
    }

    protected final HashMap<Integer, String> getSelectedComboAxisNames() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (this.daxes != null) {
            int n = 0;
            int n2 = this.daxes.size();
            while (n < n2) {
                AxisSelection axisSelection = (AxisSelection)this.daxes.get(n);
                String string = axisSelection.getSelectedName();
                if (string != null) {
                    hashMap.put(n, string);
                } else {
                    logger.warn("No axis selection available in {}", (Object)axisSelection);
                }
                ++n;
            }
        }
        return hashMap;
    }

    @Override
    public boolean[] getUsedDims() {
        LinkedList<String> linkedList = this.getSelectedAxisNames();
        LinkedList<String> linkedList2 = this.getChosenAxisNames();
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.combos.size() - this.comboOffset;
        int n2 = 0;
        while (n2 < n) {
            PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(n2 + this.comboOffset);
            hashSet.add(plotAxisProperty.getName());
            ++n2;
        }
        if (hashSet.size() != linkedList2.size()) {
            logger.debug("Chosen sets are unequal in size!");
        }
        for (String string : linkedList2) {
            if (hashSet.contains(string)) continue;
            logger.debug("Chosen set does not contain " + string);
        }
        boolean[] blArray = new boolean[linkedList.size()];
        int n3 = 0;
        int n4 = linkedList.size();
        while (n3 < n4) {
            ILazyDataset iLazyDataset = ((AxisSelection)this.daxes.get(n3)).getSelectedAxis().getValues();
            if (iLazyDataset != null) {
                blArray[n3] = hashSet.contains(linkedList.get(n3));
            }
            ++n3;
        }
        return blArray;
    }

    public final int[] getOrder(int n) {
        if (n == 1) {
            return new int[1];
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n2 = 0;
        while (n2 < n) {
            linkedList.add(n2);
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        for (PlotAxisProperty plotAxisProperty : this.paxes) {
            if (!plotAxisProperty.isInSet()) continue;
            int n4 = plotAxisProperty.getDimension();
            nArray[n3++] = n4;
            linkedList.remove((Object)n4);
        }
        while (n3 < n) {
            int n5;
            nArray[n3] = n5 = ((Integer)linkedList.removeFirst()).intValue();
            ++n3;
        }
        return nArray;
    }

    protected void populateCombos() {
        int n = this.combos.size() - this.comboOffset;
        HashMap<Integer, String> hashMap = this.getSelectedComboAxisNames();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Combo combo = (Combo)this.combos.get(n2 + this.comboOffset);
            combo.removeAll();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(hashMap.keySet());
            Collections.sort(arrayList);
            Integer n3 = arrayList.get(arrayList.size() - 1);
            String string = hashMap.get(n3);
            PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(n2 + this.comboOffset);
            plotAxisProperty.clear();
            if (this.axes.length == 1) {
                int[] nArray = this.dataset.getShape();
                while (nArray[n3] == 1) {
                    n3 = n3 - 1;
                }
                string = hashMap.get(n3);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    int n4 = (Integer)object.next();
                    String string2 = hashMap.get(n4);
                    plotAxisProperty.put(n4, string2);
                    if (nArray[n4] == 1) continue;
                    combo.add(string2);
                }
            } else {
                for (int n5 : arrayList) {
                    object = hashMap.get(n5);
                    plotAxisProperty.put(n5, (String)object);
                    combo.add((String)object);
                }
            }
            combo.setText(string);
            hashMap.remove(n3);
            plotAxisProperty.setName(string, false);
            plotAxisProperty.setInSet(true);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void repopulateCombos(String string, String string2) {
        if (this.combos == null) {
            return;
        }
        HashMap<Integer, String> hashMap = this.getSelectedComboAxisNames();
        if (hashMap.size() == 0) {
            return;
        }
        int n = this.combos.size() - this.comboOffset;
        int n2 = this.daxes.size();
        String string3 = null;
        if (string != null && string2 != null) {
            void var11_20;
            LinkedList<String> linkedList = ((PlotAxisProperty)this.paxes.get(this.comboOffset)).getNames();
            if (n2 != linkedList.size()) {
                logger.error("First axis combo has less choice than rank of dataset");
                return;
            }
            LinkedList<String> linkedList2 = this.getChosenAxisNames();
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
            Map<String, Integer> map = ((PlotAxisProperty)this.paxes.get(this.comboOffset)).getValue().getMap();
            for (String object2 : map.keySet()) {
                linkedHashMap.put(object2.equals(string) ? string2 : object2, map.get(object2));
            }
            Object object = null;
            int n3 = 0;
            while (n3 < n) {
                Object object2;
                Combo combo = (Combo)this.combos.get(n3 + this.comboOffset);
                combo.removeAll();
                PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(n3 + this.comboOffset);
                plotAxisProperty.clear();
                String string4 = linkedList2.get(n3);
                String string5 = string3 = string.equals(string4) ? string2 : string4;
                if (this.axes.length == 1) {
                    object2 = this.dataset.getShape();
                    for (Object object3 : linkedHashMap.keySet()) {
                        Integer n4 = (Integer)linkedHashMap.get(object3);
                        plotAxisProperty.put(n4, (String)object3);
                        if (object2[n4] == 1) continue;
                        combo.add((String)object3);
                    }
                } else {
                    Object object3;
                    object3 = linkedHashMap.keySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        Integer n5 = (Integer)linkedHashMap.get(object2);
                        plotAxisProperty.put(n5, (String)object2);
                        combo.add((String)object2);
                    }
                }
                combo.setText(string3);
                linkedHashMap.remove(string3);
                plotAxisProperty.setName(string3, false);
                plotAxisProperty.setInSet(true);
                ++n3;
            }
            if (string3 != null && var11_20 != null && var11_20.isInSet()) {
                var11_20.setName(string3);
            }
            return;
        }
        PlotAxisProperty plotAxisProperty = (PlotAxisProperty)this.paxes.get(this.comboOffset);
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(plotAxisProperty.getValue().getMap());
        string3 = plotAxisProperty.getName();
        linkedHashMap.remove(string3);
        int n6 = 1;
        while (n6 < n) {
            Combo combo = (Combo)this.combos.get(n6 + this.comboOffset);
            plotAxisProperty = (PlotAxisProperty)this.paxes.get(n6 + this.comboOffset);
            string3 = plotAxisProperty.getName();
            combo.removeAll();
            if (!linkedHashMap.containsKey(string3)) {
                string3 = (String)linkedHashMap.keySet().iterator().next();
            }
            plotAxisProperty.clear();
            if (this.axes.length == 1) {
                int[] nArray = this.dataset.getShape();
                for (Object object5 : linkedHashMap.keySet()) {
                    Integer n7 = (Integer)linkedHashMap.get(object5);
                    plotAxisProperty.put(n7, (String)object5);
                    if (nArray[n7] == 1) continue;
                    combo.add((String)object5);
                }
            } else {
                Object object5;
                object5 = linkedHashMap.keySet().iterator();
                while (object5.hasNext()) {
                    String string6 = (String)object5.next();
                    Integer n8 = (Integer)linkedHashMap.get(string6);
                    plotAxisProperty.put(n8, string6);
                    combo.add(string6);
                }
            }
            combo.setText(string3);
            linkedHashMap.remove(string3);
            plotAxisProperty.setName(string3, false);
            ++n6;
        }
        if (string3 != null && plotAxisProperty.isInSet()) {
            plotAxisProperty.setName(string3);
        }
    }

    protected List<AbstractDataset> sliceAxes(List<AxisChoice> list, Slice[] sliceArray, int[] nArray) {
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        boolean[] blArray = this.getUsedDims();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (blArray[n3]) {
                AxisChoice axisChoice = list.get(n3);
                int[] nArray3 = axisChoice.getIndexMapping();
                int[] nArray4 = new int[nArray3.length];
                int n4 = 0;
                int n5 = 0;
                while (n5 < nArray.length) {
                    int n6 = ArrayUtils.indexOf((int[])nArray3, (int)nArray[n5]);
                    if (n6 != -1) {
                        nArray4[n4++] = n6;
                    }
                    ++n5;
                }
                assert (n4 == nArray3.length) : n4;
                ILazyDataset iLazyDataset = axisChoice.getValues();
                Slice[] sliceArray2 = new Slice[nArray3.length];
                int n7 = 0;
                while (n7 < sliceArray2.length) {
                    sliceArray2[n7] = sliceArray[nArray3[n7]];
                    ++n7;
                }
                AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((ILazyDataset)iLazyDataset.getSlice(sliceArray2));
                AbstractDataset abstractDataset2 = DatasetUtils.transpose((IDataset)abstractDataset, (int[])nArray4);
                abstractDataset2.setName(axisChoice.getLongName());
                arrayList.add(abstractDataset2.squeeze());
            }
            ++n2;
        }
        return arrayList;
    }

    protected AbstractDataset sliceData(IMonitor iMonitor, Slice[] sliceArray) {
        AbstractDataset abstractDataset = null;
        try {
            abstractDataset = DatasetUtils.convertToAbstractDataset((ILazyDataset)this.dataset.getSlice(iMonitor, sliceArray));
        }
        catch (Exception exception) {
            logger.error("Problem getting slice of data: {}", (Throwable)exception);
            logger.error("Tried to get slices: {}", (Object)Arrays.toString(sliceArray));
        }
        return abstractDataset;
    }

    protected AbstractDataset slicedAndReorderData(IMonitor iMonitor, Slice[] sliceArray, int[] nArray) {
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = this.sliceData(iMonitor, sliceArray);
        if (abstractDataset2 == null) {
            return null;
        }
        abstractDataset = DatasetUtils.transpose((IDataset)abstractDataset2, (int[])nArray);
        abstractDataset.setName(abstractDataset2.getName());
        abstractDataset.squeeze();
        if (abstractDataset.getSize() < 1) {
            return null;
        }
        return abstractDataset;
    }

    protected void swapFirstTwoInOrder(int[] nArray) {
        if (nArray.length > 1) {
            int n = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n;
        }
    }

    private AbstractDataset make1DAxisSlice(List<AbstractDataset> list, int n) {
        AbstractDataset abstractDataset = list.get(n);
        if (abstractDataset.getRank() > 1) {
            int n2 = abstractDataset.getRank();
            Slice[] sliceArray = new Slice[n2];
            int n3 = 0;
            while (n3 < n2) {
                sliceArray[n3] = n3 != n ? new Slice(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(1)) : new Slice();
                ++n3;
            }
            logger.warn("2D plots can only handle 1D axis. Taking first slice from {} dataset", (Object)abstractDataset.getName());
            AbstractDataset abstractDataset2 = abstractDataset.getSlice(sliceArray).squeeze();
            if (abstractDataset2.getRank() == 0) {
                abstractDataset2.setShape(new int[]{1});
            }
            return abstractDataset2;
        }
        if (abstractDataset.getRank() == 0) {
            abstractDataset.setShape(new int[]{1});
        }
        return abstractDataset;
    }

    private boolean isRankBad(AbstractDataset abstractDataset, int n) {
        if (abstractDataset == null) {
            return true;
        }
        int n2 = abstractDataset.getRank();
        if (n2 > n) {
            return true;
        }
        if (n2 == n) {
            return false;
        }
        int[] nArray = Arrays.copyOf(abstractDataset.getShape(), n);
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        abstractDataset.setShape(nArray);
        return false;
    }

    @Override
    public void pushToView(IMonitor iMonitor, List<SliceProperty> list) {
        if (this.dataset == null) {
            return;
        }
        Slice[] sliceArray = new Slice[list.size()];
        int n = 0;
        while (n < sliceArray.length) {
            sliceArray[n] = list.get(n).getValue();
            ++n;
        }
        int[] nArray = this.getOrder(this.daxes.size());
        List<AbstractDataset> list2 = this.sliceAxes(this.getChosenAxes(), sliceArray, nArray);
        if (this.itype == DatasetSelection.InspectorType.IMAGE || this.itype == DatasetSelection.InspectorType.SURFACE || this.itype == DatasetSelection.InspectorType.IMAGEXP || this.itype == DatasetSelection.InspectorType.MULTIIMAGES) {
            this.swapFirstTwoInOrder(nArray);
        }
        IMetaData iMetaData = null;
        try {
            iMetaData = this.dataset.getMetadata();
        }
        catch (Exception exception) {
            logger.error("Metadata cannot be retrieved from " + this.dataset.getName(), (Throwable)exception);
        }
        switch (this.itype) {
            case LINE: {
                AbstractDataset abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray);
                if (this.isRankBad(abstractDataset, 1)) {
                    try {
                        SDAPlotter.clearPlot((String)"Dataset Plot");
                    }
                    catch (Exception exception) {
                        logger.error("Could not clear plot", (Throwable)exception);
                    }
                    return;
                }
                try {
                    SDAPlotter.updatePlot((String)"Dataset Plot", (IDataset)((IDataset)list2.get(0)), (IDataset)abstractDataset);
                    break;
                }
                catch (Exception exception) {
                    logger.error("Could not plot 1d line");
                    return;
                }
            }
            case LINESTACK: {
                int n2;
                AbstractDataset abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray);
                if (this.isRankBad(abstractDataset, 2)) {
                    try {
                        SDAPlotter.clearPlot((String)"Dataset Plot");
                    }
                    catch (Exception exception) {
                        logger.error("Could not clear plot", (Throwable)exception);
                    }
                    return;
                }
                int[] nArray2 = abstractDataset.getShape();
                int n3 = nArray2[1];
                if (n3 > 100) {
                    logger.warn("Try plot too many lines in stack plot: reduced from {} lines to {}", (Object)n3, (Object)100);
                    int n4 = nArray[1];
                    SliceProperty sliceProperty = list.get(n4);
                    Slice slice = sliceProperty.getValue();
                    Integer n5 = slice.getStart();
                    sliceProperty.setStop((n5 == null ? 0 : n5) + 100 * slice.getStep(), true);
                    return;
                }
                AbstractDataset abstractDataset2 = list2.get(1);
                AbstractDataset abstractDataset3 = list2.get(0);
                AbstractDataset[] abstractDatasetArray = new AbstractDataset[n3];
                if (abstractDataset3.getRank() == 1) {
                    n2 = 0;
                    while (n2 < n3) {
                        abstractDatasetArray[n2] = abstractDataset3;
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n3) {
                        int[] nArray3 = new int[2];
                        nArray3[1] = n2;
                        abstractDatasetArray[n2] = abstractDataset3.getSlice(nArray3, new int[]{nArray2[0], n2 + 1}, null).squeeze();
                        ++n2;
                    }
                }
                AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[n3];
                boolean bl = list2.get(1).getName().startsWith("dim:");
                int n6 = 0;
                while (n6 < n3) {
                    int[] nArray4 = new int[2];
                    nArray4[1] = n6;
                    AbstractDataset abstractDataset4 = abstractDataset.getSlice(nArray4, new int[]{nArray2[0], n6 + 1}, null);
                    abstractDataset4.squeeze();
                    if (bl) {
                        abstractDataset4.setName(String.format("%s[%d]", this.dataset.getName(), n6));
                    } else {
                        String string = n3 == 1 && abstractDataset2.getRank() == 0 ? abstractDataset2.getString(new int[0]) : abstractDataset2.getString(new int[]{n6});
                        abstractDataset4.setName(String.format("%s[%d=%s]", this.dataset.getName(), n6, string));
                    }
                    abstractDatasetArray2[n6] = abstractDataset4;
                    ++n6;
                }
                try {
                    if (this.plotStackIn3D) {
                        SDAPlotter.updateStackPlot((String)"Dataset Plot", (IDataset[])abstractDatasetArray, (IDataset[])abstractDatasetArray2, (IDataset)abstractDataset2);
                        break;
                    }
                    SDAPlotter.updatePlot((String)"Dataset Plot", (IDataset[])abstractDatasetArray, (IDataset[])abstractDatasetArray2);
                }
                catch (Exception exception) {
                    logger.error("Could not plot 1d stack");
                }
                break;
            }
            case IMAGE: 
            case SURFACE: {
                AbstractDataset abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray);
                if (this.isRankBad(abstractDataset, 2)) {
                    try {
                        SDAPlotter.clearPlot((String)"Dataset Plot");
                    }
                    catch (Exception exception) {
                        logger.error("Could not clear plot", (Throwable)exception);
                    }
                    return;
                }
                abstractDataset.setName(this.dataset.getName());
                if (iMetaData != null) {
                    abstractDataset.setMetadata(iMetaData);
                }
                try {
                    AbstractDataset abstractDataset5 = this.make1DAxisSlice(list2, 0);
                    AbstractDataset abstractDataset6 = this.make1DAxisSlice(list2, 1);
                    if (this.itype == DatasetSelection.InspectorType.IMAGE) {
                        SDAPlotter.imagePlot((String)"Dataset Plot", (IDataset)abstractDataset5, (IDataset)abstractDataset6, (IDataset)abstractDataset);
                        break;
                    }
                    SDAPlotter.surfacePlot((String)"Dataset Plot", (IDataset)abstractDataset5, (IDataset)abstractDataset6, (IDataset)abstractDataset);
                }
                catch (Exception exception) {
                    logger.error("Could not plot image or surface");
                }
                break;
            }
            case IMAGEXP: {
                if (this.isExplorerNull()) {
                    return;
                }
                this.pushImages(iMonitor, sliceArray, nArray);
                break;
            }
            case MULTIIMAGES: {
                this.pushMultipleImages(iMonitor, list, sliceArray, list2, nArray);
                break;
            }
            case VOLUME: {
                AbstractDataset abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray);
                if (this.isRankBad(abstractDataset, 3)) {
                    return;
                }
                try {
                    SDAPlotter.volumePlot((String)VOLVIEWNAME, (IDataset)abstractDataset);
                }
                catch (Exception exception) {
                    logger.error("Could not plot volume");
                }
                break;
            }
        }
    }

    private boolean isExplorerNull() {
        if (this.explorerName == null || this.explorer == null) {
            this.site.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlotTab.this.explorer = (ImageExplorerView)PlotTab.this.site.getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView", null, 3);
                        if (PlotTab.this.explorer != null) {
                            PlotTab.this.explorerName = PlotTab.this.explorer.getPlotViewName();
                        } else {
                            PlotTab.this.explorerName = null;
                        }
                    }
                    catch (PartInitException partInitException) {
                        logger.error("Cannot find image explorer view");
                        partInitException.printStackTrace();
                    }
                }
            });
        }
        return this.explorerName == null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushImages(IMonitor var1_1, Slice[] var2_2, int[] var3_3) {
        var4_4 = this.dataset.getShape();
        var5_5 = var2_2.length;
        if (var5_5 < 2) {
            var5_5 = 2;
        }
        var6_6 = var3_3[2];
        var7_7 = new Slice[var5_5];
        var8_8 = 0;
        while (true) {
            if (var8_8 >= var5_5) {
                var8_8 = var4_4[var6_6];
                ** try [egrp 0[TRYBLOCK] [0 : 127->139)] { 
lbl12:
                // 1 sources

                break;
            }
            var7_7[var8_8] = var8_8 < var2_2.length ? (var8_8 == var6_6 ? var2_2[var8_8].clone() : var2_2[var8_8]) : new Slice(Integer.valueOf(var4_4[var8_8]));
            var4_4[var8_8] = var2_2[var8_8].getNumSteps();
            ++var8_8;
        }
        {
            SDAPlotter.setupNewImageGrid((String)this.explorerName, (int)var8_8);
        }
lbl19:
        // 1 sources

        catch (Exception var9_9) {
            PlotTab.logger.warn("Problem with setting up image explorer", (Throwable)var9_9);
        }
        try {
            var9_10 = var7_7[var6_6];
            var10_12 = var9_10.getStart() == null ? 0 : var9_10.getStart();
            var7_7[var6_6].setStop(Integer.valueOf(var10_12 + 1));
            this.setInspectionRunning();
            var11_13 = true;
            var12_14 = 0;
            if (true) ** GOTO lbl38
        }
        catch (Exception var9_11) {
            PlotTab.logger.warn("Problem with sending data to image explorer", (Throwable)var9_11);
            this.stopInspection();
            return;
        }
        catch (Throwable var15_18) {
            this.stopInspection();
            throw var15_18;
        }
        {
            while (true) {
                ++var12_14;
lbl38:
                // 2 sources

                if (var12_14 >= var8_8) break;
                try {
                    var7_7[var6_6].setPosition(var10_12 + var12_14);
                    var13_15 = this.sliceData(var1_1, var7_7);
                    if (var13_15 == null) {
                        this.stopInspection();
                        return;
                    }
                }
                catch (OutOfMemoryError var13_16) {
                    if (!var11_13) {
                        throw var13_16;
                    }
                    var11_13 = false;
                    PlotTab.logger.warn("Ran out of memory: attempting to reduce memory used...");
                    System.gc();
                    --var12_14;
                    continue;
                }
                var14_17 = DatasetUtils.transpose((IDataset)var13_15, (int[])var3_3);
                var14_17.setName(var13_15.getName());
                var14_17.squeeze();
                if (var14_17.getSize() >= 1) ** GOTO lbl-1000
                this.stopInspection();
                return;
lbl-1000:
                // 1 sources

                {
                    var14_17.setName(String.valueOf(this.dataset.getName()) + "." + var12_14);
                    if (this.canContinueInspection()) ** GOTO lbl-1000
                    this.stopInspection();
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    if (!this.explorer.isStopped()) ** GOTO lbl-1000
                    this.stopInspection();
                    this.stopInspection();
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    SDAPlotter.plotImageToGrid((String)this.explorerName, (IDataset)var14_17, (boolean)true);
                    if (!var11_13) {
                        PlotTab.logger.warn("... memory reduction successful");
                    }
                    var11_13 = true;
                    continue;
                }
                break;
            }
        }
        this.stopInspection();
    }

    /*
     * Exception decompiling
     */
    private void pushMultipleImages(IMonitor var1_1, List<SliceProperty> var2_2, Slice[] var3_3, List<AbstractDataset> var4_4, int[] var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

