/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;

public class DatasetSelection
implements IStructuredSelection {
    private final List<AxisSelection> axes;
    private final ILazyDataset[] datasets;
    private InspectorType view;

    public DatasetSelection() {
        this.axes = new ArrayList<AxisSelection>();
        this.datasets = new ILazyDataset[0];
        this.view = InspectorType.EMPTY;
    }

    public DatasetSelection(List<AxisSelection> list, ILazyDataset ... iLazyDatasetArray) {
        this.axes = list;
        this.datasets = iLazyDatasetArray;
        this.view = InspectorType.LINE;
    }

    public DatasetSelection(InspectorType inspectorType, List<AxisSelection> list, ILazyDataset ... iLazyDatasetArray) {
        this.axes = list;
        this.datasets = iLazyDatasetArray;
        this.view = inspectorType;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Null selection";
        }
        return Arrays.toString(this.datasets);
    }

    public boolean isEmpty() {
        return this.datasets == null || this.datasets.length == 0;
    }

    public ILazyDataset getFirstElement() {
        return this.isEmpty() ? null : this.datasets[0];
    }

    public Iterator<ILazyDataset> iterator() {
        return this.toList().iterator();
    }

    public int size() {
        return this.isEmpty() ? 0 : this.datasets.length;
    }

    public ILazyDataset[] toArray() {
        return this.datasets;
    }

    public List<ILazyDataset> toList() {
        ArrayList<ILazyDataset> arrayList = new ArrayList<ILazyDataset>();
        if (!this.isEmpty()) {
            Collections.addAll(arrayList, this.datasets);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        return this.almostEquals(object);
    }

    public final boolean almostEquals(Object object) {
        if (object instanceof DatasetSelection) {
            DatasetSelection datasetSelection = (DatasetSelection)object;
            if (!this.areAxesAllEqual(this.axes, datasetSelection.axes)) {
                return false;
            }
            if (this.areDatasetsAllEqual(this.datasets, datasetSelection.datasets)) {
                return true;
            }
        }
        return false;
    }

    private boolean areDatasetsAllEqual(ILazyDataset[] iLazyDatasetArray, ILazyDataset[] iLazyDatasetArray2) {
        if (iLazyDatasetArray == iLazyDatasetArray2) {
            return true;
        }
        if (iLazyDatasetArray == null || iLazyDatasetArray2 == null) {
            return false;
        }
        int n = iLazyDatasetArray.length;
        if (iLazyDatasetArray2.length != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            ILazyDataset iLazyDataset = iLazyDatasetArray[n2];
            ILazyDataset iLazyDataset2 = iLazyDatasetArray2[n2];
            if (iLazyDataset != iLazyDataset2) {
                if (!Arrays.equals(iLazyDataset.getShape(), iLazyDataset2.getShape())) {
                    return false;
                }
                if (!iLazyDataset.getName().equals(iLazyDataset2.getName())) {
                    return false;
                }
                if (iLazyDataset.hashCode() != iLazyDataset2.hashCode()) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean areAxesAllEqual(List<AxisSelection> list, List<AxisSelection> list2) {
        if (list == list2) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        if (list2.size() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            AxisSelection axisSelection;
            AxisSelection axisSelection2 = list.get(n2);
            if (!axisSelection2.equals(axisSelection = list2.get(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = this.view.getValue();
        int n2 = 0;
        int n3 = this.datasets.length;
        while (n2 < n3) {
            n = n * 31 + this.datasets[n2].hashCode();
            ++n2;
        }
        n2 = 0;
        n3 = this.axes == null ? 0 : this.axes.size();
        while (n2 < n3) {
            n = n * 31 + this.axes.get(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public List<AxisSelection> getAxes() {
        return this.axes;
    }

    public InspectorType getType() {
        return this.view;
    }

    public void setType(InspectorType inspectorType) {
        this.view = inspectorType;
    }

    public static enum InspectorType {
        LINE,
        POINTS1D,
        LINESTACK,
        DATA1D,
        POINTS2D,
        IMAGE,
        SURFACE,
        DATA2D,
        IMAGEXP,
        MULTIIMAGES,
        POINTS3D,
        VOLUME,
        EMPTY;

        private static int index;
        private int value = InspectorType.getIndex();

        static {
            index = 0;
        }

        private static int getIndex() {
            return index++;
        }

        public int getValue() {
            return this.value;
        }

        public static InspectorType getType(int n) {
            InspectorType[] inspectorTypeArray = InspectorType.values();
            int n2 = inspectorTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                InspectorType inspectorType = inspectorTypeArray[n3];
                if (inspectorType.getValue() == n) {
                    return inspectorType;
                }
                ++n3;
            }
            return EMPTY;
        }
    }
}

