/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelectionTable;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSlicer;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DataTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.InspectionTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotAxisProperty;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.ScatterTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.SliceProperty;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveJobAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveQueue;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class DatasetInspector
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(DatasetInspector.class);
    private Display display = null;
    private IWorkbenchPartSite site;
    private static final String PLOTNAME = "Dataset Plot";
    private ILazyDataset cData;
    Label dsDetails;
    private AxisSelectionTable axisSelector;
    CTabFolder plotTabFolder;
    InspectionTab cInspectionTab;
    private ISelectionListener selListener;
    private Inspection inspection;
    private Map<DatasetSelection, Inspection> storedInspections;
    private Map<DatasetSelection.InspectorType, InspectionTab> inspectionTabs;
    private ArrayList<AxisSlicer> slicers;
    private PropertyChangeListener slicerListener;
    private PropertyChangeListener plotTabListener;
    private PropertyChangeListener datasetAxesListener;
    private InteractiveQueue sliceQueue;
    private Group axesSelGroup;
    private Composite iComp;

    public DatasetInspector(Composite composite, int n, IWorkbenchPartSite iWorkbenchPartSite) {
        super(composite, n);
        DatasetSelection.InspectorType inspectorType;
        this.setLayout((Layout)new FillLayout());
        this.sliceQueue = new InteractiveQueue();
        this.site = iWorkbenchPartSite;
        this.display = composite.getDisplay();
        Composite composite2 = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        this.axesSelGroup = new Group(composite2, 0);
        this.axesSelGroup.setText("Data axes selection");
        this.axesSelGroup.setToolTipText("Select which axis dataset to use in each dimension of the dataset array");
        GridData gridData = new GridData(4, 4, true, false);
        this.axesSelGroup.setLayoutData((Object)gridData);
        this.axesSelGroup.setLayout((Layout)new GridLayout(1, false));
        this.dsDetails = new Label((Composite)this.axesSelGroup, 0);
        this.dsDetails.setText("");
        gridData = new GridData(4, 0x1000000, true, true);
        this.dsDetails.setLayoutData((Object)gridData);
        this.axisSelector = new AxisSelectionTable((Composite)this.axesSelGroup);
        gridData = new GridData(4, 4, true, true, 1, 5);
        gridData.heightHint = 150;
        this.axisSelector.setLayoutData(gridData);
        this.plotTabFolder = new CTabFolder(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 250;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.minimumWidth = 200;
        this.plotTabFolder.setLayoutData((Object)gridData);
        this.plotTabFolder.setLayout((Layout)new FillLayout());
        this.inspectionTabs = new LinkedHashMap<DatasetSelection.InspectorType, InspectionTab>();
        this.inspectionTabs.put(DatasetSelection.InspectorType.LINE, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.LINE, "1D plot", new String[]{"x-axis"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.LINESTACK, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.LINESTACK, "1D stack plot", new String[]{"x-axis", "z-axis"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.IMAGE, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.IMAGE, "2D image", new String[]{"x-axis", "y-axis"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.SURFACE, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.SURFACE, "2D surface", new String[]{"x-axis", "y-axis"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.IMAGEXP, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.IMAGEXP, "2D image explorer", new String[]{"x-axis", "y-axis", "image"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.MULTIIMAGES, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.MULTIIMAGES, "2D multiple images", new String[]{"x-axis", "y-axis", "images"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.VOLUME, new PlotTab(iWorkbenchPartSite, DatasetSelection.InspectorType.VOLUME, "3D volume", new String[]{"x-axis", "y-axis", "z-axis"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.POINTS1D, new ScatterTab(iWorkbenchPartSite, DatasetSelection.InspectorType.POINTS1D, "1D scatter plot", new String[]{"x-coord"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.POINTS2D, new ScatterTab(iWorkbenchPartSite, DatasetSelection.InspectorType.POINTS2D, "2D scatter plot", new String[]{"x-coord", "y-coord"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.POINTS3D, new ScatterTab(iWorkbenchPartSite, DatasetSelection.InspectorType.POINTS3D, "3D scatter plot", new String[]{"x-coord", "y-coord", "z-coord"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.DATA1D, new DataTab(iWorkbenchPartSite, DatasetSelection.InspectorType.DATA1D, "1D data", new String[]{"row"}));
        this.inspectionTabs.put(DatasetSelection.InspectorType.DATA2D, new DataTab(iWorkbenchPartSite, DatasetSelection.InspectorType.DATA2D, "2D data", new String[]{"column", "row"}));
        DatasetSelection.InspectorType[] inspectorTypeArray = DatasetSelection.InspectorType.values();
        int n2 = inspectorTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            inspectorType = inspectorTypeArray[n3];
            InspectionTab inspectionTab = this.inspectionTabs.get((Object)inspectorType);
            if (inspectionTab != null) {
                CTabItem cTabItem = new CTabItem(this.plotTabFolder, 0);
                cTabItem.setText(inspectionTab.getTabTitle());
            }
            ++n3;
        }
        this.plotTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DatasetInspector.this.cData == null) {
                    return;
                }
                if (DatasetInspector.this.cInspectionTab != null) {
                    DatasetInspector.this.cInspectionTab.stopInspection();
                }
                CTabItem cTabItem = DatasetInspector.this.plotTabFolder.getSelection();
                int n = DatasetInspector.this.plotTabFolder.getSelectionIndex();
                DatasetSelection.InspectorType inspectorType = DatasetSelection.InspectorType.getType(n);
                InspectionTab inspectionTab = (InspectionTab)DatasetInspector.this.inspectionTabs.get((Object)inspectorType);
                if (!inspectionTab.checkCompatible(DatasetInspector.this.cData)) {
                    for (InspectionTab inspectionTab2 : DatasetInspector.this.inspectionTabs.values()) {
                        if (!inspectionTab2.checkCompatible(DatasetInspector.this.cData)) continue;
                        inspectionTab = inspectionTab2;
                        break;
                    }
                    inspectorType = inspectionTab.getType();
                    n = inspectorType.getValue();
                    cTabItem = DatasetInspector.this.plotTabFolder.getItem(n);
                    DatasetInspector.this.plotTabFolder.setSelection(n);
                    inspectionTab = (InspectionTab)DatasetInspector.this.inspectionTabs.get((Object)inspectorType);
                }
                DatasetInspector.this.cInspectionTab = inspectionTab;
                DatasetInspector.this.inspection.initSlice(inspectorType);
                DatasetInspector.this.inspection.initPlotAxes(inspectionTab);
                if (cTabItem.getControl() == null) {
                    DatasetInspector.this.createPlotTab(cTabItem);
                } else {
                    DatasetInspector.this.cInspectionTab.setParameters(DatasetInspector.this.cData, DatasetInspector.this.inspection.datasetAxes, (List)DatasetInspector.this.inspection.allPlotAxes.get((Object)inspectorType));
                    DatasetInspector.this.cInspectionTab.drawTab();
                }
                DatasetInspector.this.inspection.switchType(inspectorType);
                DatasetInspector.this.updateSlicers(true);
                DatasetInspector.this.sliceDataAndView();
            }
        });
        inspectorType = new Group(composite2, 0);
        inspectorType.setLayout((Layout)new FillLayout());
        inspectorType.setText("Dataset slicing");
        inspectorType.setToolTipText("Configure the slicing of the dataset array. Each dimension can be sliced. A slice is a selection of items specified by a starting position, the number of items selected and the size of the step over which items are skipped");
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        inspectorType.setLayoutData(gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)inspectorType, 768);
        this.iComp = new Composite((Composite)scrolledComposite, 0);
        this.iComp.setLayout((Layout)new GridLayout(6, false));
        Label label = new Label(this.iComp, 0);
        label.setText("Dim");
        label.setToolTipText("Dimension of dataset array");
        label = new Label(this.iComp, 0);
        label.setText("Start position");
        label.setToolTipText("Position of start in array");
        label = new Label(this.iComp, 0);
        label.setText("Start value");
        label.setToolTipText("Value at starting position");
        label = new Label(this.iComp, 0);
        label.setText("Items");
        label.setToolTipText("Number of items in slice");
        label = new Label(this.iComp, 0);
        label.setText("Step size");
        label.setToolTipText("Number of items in each step");
        new Label(this.iComp, 0).setText("");
        scrolledComposite.setContent((Control)this.iComp);
        this.layout();
        this.slicerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if (DatasetInspector.this.cData != null && DatasetInspector.this.display != null) {
                    DatasetInspector.this.cInspectionTab.stopInspection();
                }
                DatasetInspector.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (propertyChangeEvent.getPropertyName() == "sliceupdate") {
                            DatasetInspector.this.updateSlicers(false);
                        }
                        DatasetInspector.this.sliceDataAndView();
                    }
                });
            }
        };
        this.plotTabListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DatasetInspector.this.cInspectionTab.stopInspection();
                if (propertyChangeEvent.getPropertyName() != "plotupdate") {
                    DatasetInspector.this.axisSelector.refresh();
                    DatasetInspector.this.updateSlicers(true);
                }
                DatasetInspector.this.sliceDataAndView();
            }
        };
        this.datasetAxesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (DatasetInspector.this.cData != null && DatasetInspector.this.display != null) {
                    DatasetInspector.this.cInspectionTab.stopInspection();
                }
                DatasetInspector.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DatasetInspector.this.updateSlicers(true);
                        DatasetInspector.this.sliceDataAndView();
                    }
                });
            }
        };
        this.selListener = new ISelectionListener(){
            DatasetSelection oldSelection = null;

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                DatasetSelection datasetSelection;
                if (iSelection instanceof DatasetSelection && (datasetSelection = DatasetInspector.this.processSelection(this.oldSelection, (DatasetSelection)iSelection)) != null) {
                    this.oldSelection = datasetSelection;
                }
            }
        };
        iWorkbenchPartSite.getWorkbenchWindow().getSelectionService().addSelectionListener(this.selListener);
        this.storedInspections = new HashMap<DatasetSelection, Inspection>();
    }

    private DatasetSelection processSelection(DatasetSelection datasetSelection, DatasetSelection datasetSelection2) {
        boolean bl;
        if (datasetSelection2.equals(datasetSelection)) {
            return null;
        }
        this.cData = datasetSelection2.getFirstElement();
        if (this.cData == null) {
            try {
                SDAPlotter.clearPlot((String)PLOTNAME);
            }
            catch (Exception exception) {}
            datasetSelection = datasetSelection2;
            return null;
        }
        if (this.storedInspections.containsKey(datasetSelection2)) {
            this.inspection = this.storedInspections.get(datasetSelection2);
            bl = false;
        } else if (datasetSelection2.almostEquals(datasetSelection)) {
            this.inspection = this.inspection.clone(datasetSelection);
            this.storedInspections.put(datasetSelection2, this.inspection);
            bl = true;
        } else {
            this.inspection = null;
            boolean bl2 = false;
            for (Map.Entry<DatasetSelection, Inspection> entry : this.storedInspections.entrySet()) {
                DatasetSelection datasetSelection3 = entry.getKey();
                if (!datasetSelection2.almostEquals(datasetSelection3)) continue;
                this.inspection = entry.getValue().clone(datasetSelection3);
                this.storedInspections.put(datasetSelection2, this.inspection);
                bl2 = true;
                break;
            }
            bl = bl2;
        }
        if (this.inspection == null) {
            this.inspection = new Inspection(datasetSelection2);
            this.storedInspections.put(datasetSelection2, this.inspection);
            int[] nArray = this.cData.getShape();
            int n = nArray.length;
            int n2 = this.inspection.getNumAxes();
            if (n2 < n) {
                int n3 = n2;
                while (n3 < n) {
                    AxisSelection axisSelection = new AxisSelection(n3, nArray[n3]);
                    AbstractDataset abstractDataset = AbstractDataset.arange((double)nArray[n3], (int)3);
                    abstractDataset.setName("dim:" + (n3 + 1));
                    AxisChoice axisChoice = new AxisChoice((ILazyDataset)abstractDataset);
                    axisChoice.setAxisNumber(n3);
                    axisSelection.addChoice(axisChoice, axisSelection.getMaxOrder() + 1);
                    this.inspection.addDatasetAxis(axisSelection);
                    ++n3;
                }
            }
            this.inspection.initSlice(this.inspection.itype);
            this.inspection.setSliceListener(this.slicerListener);
            this.inspection.setDatasetAxisListener(this.datasetAxesListener);
        }
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StringBuilder stringBuilder = new StringBuilder(String.format("Name: %s; Rank: %d; Dims: ", DatasetInspector.this.cData.getName(), DatasetInspector.this.cData.getRank()));
                    stringBuilder.append(Arrays.toString(DatasetInspector.this.cData.getShape()));
                    DatasetInspector.this.dsDetails.setText(stringBuilder.toString());
                    DatasetInspector.this.axisSelector.setInput(DatasetInspector.this.inspection.datasetAxes);
                    DatasetInspector.this.createSlicers(DatasetInspector.this.iComp);
                    if (DatasetInspector.this.inspection.itype == DatasetSelection.InspectorType.EMPTY) {
                        return;
                    }
                    if (!bl) {
                        DatasetInspector.this.cInspectionTab = (InspectionTab)DatasetInspector.this.inspectionTabs.get((Object)DatasetInspector.this.inspection.itype);
                        DatasetInspector.this.inspection.initPlotAxes(DatasetInspector.this.cInspectionTab);
                        DatasetInspector.this.inspection.setPlotAxisListener(DatasetInspector.this.plotTabListener);
                        int n = DatasetInspector.this.inspection.itype.getValue();
                        DatasetInspector.this.plotTabFolder.setSelection(n);
                        CTabItem cTabItem = DatasetInspector.this.plotTabFolder.getItem(n);
                        if (cTabItem.getControl() == null) {
                            DatasetInspector.this.createPlotTab(cTabItem);
                            DatasetInspector.this.updateSlicers(true);
                            DatasetInspector.this.sliceDataAndView();
                        } else {
                            DatasetInspector.this.cInspectionTab.setParameters(DatasetInspector.this.cData, DatasetInspector.this.inspection.datasetAxes, DatasetInspector.this.inspection.getPlotAxes());
                            DatasetInspector.this.cInspectionTab.drawTab();
                        }
                    } else {
                        DatasetInspector.this.cInspectionTab = (InspectionTab)DatasetInspector.this.inspectionTabs.get((Object)DatasetInspector.this.inspection.itype);
                        DatasetInspector.this.cInspectionTab.setParameters(DatasetInspector.this.cData, DatasetInspector.this.inspection.datasetAxes, DatasetInspector.this.inspection.getPlotAxes());
                        DatasetInspector.this.cInspectionTab.drawTab();
                    }
                }
            });
        }
        return datasetSelection2;
    }

    public void dispose() {
        this.sliceQueue.dispose();
        if (this.selListener != null) {
            this.site.getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selListener);
        }
        this.selListener = null;
        if (!this.isDisposed()) {
            super.dispose();
        }
    }

    private void createPlotTab(CTabItem cTabItem) {
        if (this.cInspectionTab == null) {
            return;
        }
        Composite composite = this.cInspectionTab.createTabComposite((Composite)this.plotTabFolder);
        if (this.inspection != null) {
            this.cInspectionTab.setParameters(this.cData, this.inspection.datasetAxes, (List)this.inspection.allPlotAxes.get((Object)this.cInspectionTab.getType()));
        }
        cTabItem.setControl((Control)composite);
        this.layout();
    }

    private void createSlicers(Composite composite) {
        int n;
        int n2;
        int n3;
        if (this.cData == null) {
            return;
        }
        if (this.slicers == null) {
            this.slicers = new ArrayList();
        }
        if ((n3 = this.cData.getRank()) > this.inspection.datasetAxes.size()) {
            logger.error("Axis selection wrong!");
        }
        if (n3 > (n2 = this.slicers.size())) {
            n = n2;
            while (n < n3) {
                this.slicers.add(new AxisSlicer(composite));
                ++n;
            }
        } else {
            n = n3;
            while (n < n2) {
                this.slicers.get(n).setVisible(false);
                ++n;
            }
        }
        List<SliceProperty> list = this.inspection.getSlices();
        int n4 = 0;
        while (n4 < n3) {
            SliceProperty sliceProperty = list.get(n4);
            AxisChoice axisChoice = ((AxisSelection)this.inspection.datasetAxes.get(n4)).getSelectedAxis();
            String string = ((AxisSelection)this.inspection.datasetAxes.get(n4)).getSelectedName();
            int[] nArray = axisChoice.getIndexMapping();
            ILazyDataset iLazyDataset = axisChoice.getValues();
            SliceProperty[] slicePropertyArray = new SliceProperty[nArray.length];
            int n5 = 0;
            while (n5 < nArray.length) {
                slicePropertyArray[n5] = list.get(nArray[n5]);
                ++n5;
            }
            this.slicers.get(n4).createAxisSlicer();
            this.slicers.get(n4).setParameters(string, sliceProperty, iLazyDataset, slicePropertyArray, true);
            ++n4;
        }
        composite.pack();
        composite.setSize(composite.computeSize(-1, -1));
    }

    private void updateSlicers(boolean bl) {
        List<SliceProperty> list = this.inspection.getSlices();
        boolean[] blArray = this.cInspectionTab.getUsedDims();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Object object2;
            SliceProperty sliceProperty = list.get(n2);
            if (bl) {
                object2 = sliceProperty.getValue();
                if (blArray[n2]) {
                    object2.setStop(null);
                } else {
                    object = object2.getStart();
                    if (object == null) {
                        object2.setStop(Integer.valueOf(1));
                    } else {
                        object2.setStop(Integer.valueOf((Integer)object + 1));
                    }
                }
            }
            object2 = (AxisSelection)this.inspection.datasetAxes.get(n2);
            object = ((AxisSelection)object2).getSelectedAxis();
            String string = ((AxisSelection)object2).getSelectedName();
            ILazyDataset iLazyDataset = ((AxisChoice)object).getValues();
            int[] nArray = ((AxisChoice)object).getIndexMapping();
            SliceProperty[] slicePropertyArray = new SliceProperty[nArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                slicePropertyArray[n3] = list.get(nArray[n3]);
                ++n3;
            }
            this.slicers.get(n2).setParameters(string, sliceProperty, iLazyDataset, slicePropertyArray, blArray[n2]);
            ++n2;
        }
        Composite composite = this.slicers.get(0).getParent();
        composite.pack();
        composite.setSize(composite.computeSize(-1, -1));
    }

    public void sliceDataAndView() {
        DatasetSelection.InspectorType inspectorType;
        DatasetSelection.InspectorType inspectorType2 = inspectorType = this.cInspectionTab == null ? DatasetSelection.InspectorType.EMPTY : this.cInspectionTab.getType();
        if (this.cData == null || inspectorType == DatasetSelection.InspectorType.EMPTY) {
            try {
                SDAPlotter.clearPlot((String)PLOTNAME);
            }
            catch (Exception exception) {
                logger.error("Problem clearing plot");
            }
            return;
        }
        try {
            IJob iJob = new IJob(this.cInspectionTab, this.inspection.getSlices());
            this.sliceQueue.addJob(iJob);
        }
        catch (Exception exception) {
            logger.error("Cannot generate slices", (Throwable)exception);
        }
    }

    class IJob
    extends InteractiveJobAdapter {
        private InspectionTab tab;
        private List<SliceProperty> slices;

        public IJob(InspectionTab inspectionTab, List<SliceProperty> list) {
            this.tab = inspectionTab;
            this.slices = list;
        }

        @Override
        public void run(IProgressMonitor iProgressMonitor) {
            if (!this.isNull()) {
                this.tab.stopInspection();
                this.tab.pushToView((IMonitor)new ProgressMonitorWrapper(iProgressMonitor), this.slices);
            }
        }

        @Override
        public boolean isNull() {
            return this.tab == null && this.slices == null;
        }
    }

    class Inspection {
        private DatasetSelection.InspectorType itype;
        private Map<DatasetSelection.InspectorType, List<SliceProperty>> allSlices;
        private Map<DatasetSelection.InspectorType, List<PlotAxisProperty>> allPlotAxes;
        private List<AxisSelection> datasetAxes;
        private PropertyChangeListener sliceListener;
        private PropertyChangeListener plotAxisListener;
        private PropertyChangeListener datasetAxisListener;

        public Inspection(DatasetSelection datasetSelection) {
            this.datasetAxes = datasetSelection.getAxes() == null ? new ArrayList<AxisSelection>() : new ArrayList<AxisSelection>(datasetSelection.getAxes());
            this.allSlices = new HashMap<DatasetSelection.InspectorType, List<SliceProperty>>();
            this.allPlotAxes = new HashMap<DatasetSelection.InspectorType, List<PlotAxisProperty>>();
            this.itype = datasetSelection.getType();
        }

        public Inspection clone(DatasetSelection datasetSelection) {
            Inspection inspection = new Inspection(datasetSelection);
            if (inspection.datasetAxes.size() > 0) {
                int n = 0;
                int n2 = this.datasetAxes.size();
                while (n < n2) {
                    AxisSelection object = inspection.datasetAxes.get(n);
                    object.selectAxis(this.datasetAxes.get(n).getSelectedIndex(), false);
                    ++n;
                }
            }
            inspection.itype = this.itype;
            ArrayList<SliceProperty> arrayList = new ArrayList<SliceProperty>();
            inspection.allSlices.put(this.itype, arrayList);
            for (SliceProperty sliceProperty : this.allSlices.get((Object)this.itype)) {
                arrayList.add(sliceProperty.clone());
            }
            ArrayList<PlotAxisProperty> arrayList2 = new ArrayList<PlotAxisProperty>();
            inspection.allPlotAxes.put(this.itype, arrayList2);
            for (PlotAxisProperty plotAxisProperty : this.allPlotAxes.get((Object)this.itype)) {
                arrayList2.add(plotAxisProperty.clone());
            }
            inspection.setDatasetAxisListener(this.datasetAxisListener);
            inspection.setSliceListener(DatasetInspector.this.slicerListener);
            inspection.setPlotAxisListener(this.plotAxisListener);
            return inspection;
        }

        public int getNumAxes() {
            if (this.datasetAxes == null) {
                return 0;
            }
            return this.datasetAxes.size();
        }

        public List<SliceProperty> getSlices() {
            return this.allSlices.get((Object)this.itype);
        }

        public List<PlotAxisProperty> getPlotAxes() {
            return this.allPlotAxes.get((Object)this.itype);
        }

        public void addDatasetAxis(AxisSelection axisSelection) {
            if (this.datasetAxes == null) {
                this.datasetAxes = new ArrayList<AxisSelection>();
            }
            this.datasetAxes.add(axisSelection);
        }

        public void addSlice(SliceProperty sliceProperty) {
            this.allSlices.get((Object)this.itype).add(sliceProperty);
        }

        public void addPlotAxis(PlotAxisProperty plotAxisProperty) {
            this.allPlotAxes.get((Object)this.itype).add(plotAxisProperty);
        }

        public void switchType(DatasetSelection.InspectorType inspectorType) {
            if (this.itype == inspectorType) {
                return;
            }
            this.removePropertyChangeListener();
            this.initSlice(inspectorType);
            this.initPlotAxes((InspectionTab)DatasetInspector.this.inspectionTabs.get((Object)inspectorType));
            this.itype = inspectorType;
            this.setSliceListener(this.sliceListener);
            this.setPlotAxisListener(this.plotAxisListener);
        }

        public void setSliceListener(PropertyChangeListener propertyChangeListener) {
            this.sliceListener = propertyChangeListener;
            List<SliceProperty> list = this.getSlices();
            if (list != null) {
                for (SliceProperty sliceProperty : list) {
                    sliceProperty.addPropertyChangeListener(propertyChangeListener);
                }
            }
        }

        public void setPlotAxisListener(PropertyChangeListener propertyChangeListener) {
            this.plotAxisListener = propertyChangeListener;
            List<PlotAxisProperty> list = this.getPlotAxes();
            if (list != null) {
                for (PlotAxisProperty plotAxisProperty : list) {
                    plotAxisProperty.addPropertyChangeListener(propertyChangeListener);
                }
            }
        }

        public void setDatasetAxisListener(PropertyChangeListener propertyChangeListener) {
            this.datasetAxisListener = propertyChangeListener;
            if (this.datasetAxes != null) {
                for (AxisSelection axisSelection : this.datasetAxes) {
                    axisSelection.addPropertyChangeListener(propertyChangeListener);
                }
            }
        }

        private void removePropertyChangeListener() {
            List<PlotAxisProperty> list;
            List<SliceProperty> list2 = this.getSlices();
            if (list2 != null) {
                for (SliceProperty sliceProperty : list2) {
                    sliceProperty.removePropertyChangeListener(this.sliceListener);
                }
            }
            if ((list = this.getPlotAxes()) != null) {
                for (PlotAxisProperty plotAxisProperty : list) {
                    plotAxisProperty.removePropertyChangeListener(this.plotAxisListener);
                }
            }
            if (this.datasetAxes != null) {
                for (AxisSelection axisSelection : this.datasetAxes) {
                    axisSelection.removePropertyChangeListener(this.datasetAxisListener);
                }
            }
        }

        public void initSlice(DatasetSelection.InspectorType inspectorType) {
            if (inspectorType == DatasetSelection.InspectorType.EMPTY || this.allSlices.get((Object)inspectorType) != null) {
                return;
            }
            ArrayList<SliceProperty> arrayList = new ArrayList<SliceProperty>();
            this.allSlices.put(inspectorType, arrayList);
            int[] nArray = DatasetInspector.this.cData.getShape();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                SliceProperty sliceProperty = new SliceProperty();
                sliceProperty.setLength(nArray[n2]);
                arrayList.add(sliceProperty);
                ++n2;
            }
        }

        public void initPlotAxes(InspectionTab inspectionTab) {
            DatasetSelection.InspectorType inspectorType = inspectionTab.getType();
            if (inspectorType == DatasetSelection.InspectorType.EMPTY || this.allPlotAxes.get((Object)inspectorType) != null) {
                return;
            }
            ArrayList<PlotAxisProperty> arrayList = new ArrayList<PlotAxisProperty>();
            this.allPlotAxes.put(inspectorType, arrayList);
            if (inspectionTab.canPlotConstant()) {
                arrayList.add(new PlotAxisProperty());
            }
            int n = inspectionTab.getNumAxes();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(new PlotAxisProperty());
                ++n2;
            }
        }
    }
}

