/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.List;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.SliceProperty;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetTableView;
import uk.ac.gda.monitor.IMonitor;

class DataTab
extends PlotTab {
    public DataTab(IWorkbenchPartSite iWorkbenchPartSite, DatasetSelection.InspectorType inspectorType, String string, String[] stringArray) {
        super(iWorkbenchPartSite, inspectorType, string, stringArray);
    }

    @Override
    public void pushToView(IMonitor iMonitor, List<SliceProperty> list) {
        AbstractDataset abstractDataset;
        if (this.dataset == null) {
            return;
        }
        Slice[] sliceArray = new Slice[list.size()];
        int n = 0;
        while (n < sliceArray.length) {
            sliceArray[n] = list.get(n).getValue();
            ++n;
        }
        int[] nArray = this.getOrder(this.daxes.size());
        final List<AbstractDataset> list2 = this.sliceAxes(this.getChosenAxes(), sliceArray, nArray);
        if (this.itype == DatasetSelection.InspectorType.DATA2D) {
            this.swapFirstTwoInOrder(nArray);
        }
        if ((abstractDataset = this.slicedAndReorderData(iMonitor, sliceArray, nArray)) == null) {
            return;
        }
        abstractDataset.setName(this.dataset.getName());
        abstractDataset.squeeze();
        if (abstractDataset.getSize() < 1) {
            return;
        }
        switch (this.itype) {
            case DATA1D: {
                if (abstractDataset.getRank() != 1) {
                    return;
                }
                this.composite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DatasetTableView datasetTableView = DataTab.this.getDatasetTableView();
                        if (datasetTableView == null) {
                            return;
                        }
                        datasetTableView.setData(abstractDataset.reshape(new int[]{abstractDataset.getShape()[0], 1}), (AbstractDataset)list2.get(0), null);
                    }
                });
                break;
            }
            case DATA2D: {
                if (abstractDataset.getRank() != 2) {
                    return;
                }
                this.composite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DatasetTableView datasetTableView = DataTab.this.getDatasetTableView();
                        if (datasetTableView == null) {
                            return;
                        }
                        datasetTableView.setData(abstractDataset, (AbstractDataset)list2.get(1), (AbstractDataset)list2.get(0));
                    }
                });
                break;
            }
        }
    }

    private DatasetTableView getDatasetTableView() {
        DatasetTableView datasetTableView = null;
        try {
            datasetTableView = (DatasetTableView)this.site.getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.views.DatasetTableView", null, 3);
        }
        catch (PartInitException partInitException) {
            logger.error("All over now! Cannot find dataset table view: {} ", (Throwable)partInitException);
        }
        return datasetTableView;
    }
}

