/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.LabelledSlider;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.SliceProperty;

public class AxisSlicer {
    private Composite composite;
    private Label label = null;
    private LabelledSlider slider;
    private Text value;
    private Spinner size;
    private Spinner step;
    private Button reset;
    private int length;
    private SliceProperty slice;
    private SliceProperty[] axisSlices;
    private boolean mode;
    private AbstractDataset adata;
    private ILazyDataset axisData;
    private PropertyChangeListener listener;
    private String name;
    public static final int COLUMNS = 6;
    private static final Image undo = AnalysisRCPActivator.getImageDescriptor("icons/arrow_undo.png").createImage();

    public AxisSlicer(Composite composite) {
        this.composite = composite;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AxisSlicer.this.createAxisDataset();
                AxisSlicer.this.composite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AxisSlicer.this.init(false);
                    }
                });
            }
        };
    }

    public Composite getParent() {
        return this.composite;
    }

    public void clear() {
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.slider != null) {
            this.slider.dispose();
        }
        if (this.value != null) {
            this.value.dispose();
        }
        if (this.size != null) {
            this.size.dispose();
        }
        if (this.step != null) {
            this.step.dispose();
        }
        if (this.reset != null) {
            this.reset.dispose();
        }
    }

    public void createAxisSlicer() {
        if (this.label != null) {
            return;
        }
        this.label = new Label(this.composite, 0);
        this.slider = new LabelledSlider(this.composite, 256);
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AxisSlicer.this.slice == null) {
                    return;
                }
                int n = AxisSlicer.this.slider.getValue();
                Slice slice = AxisSlicer.this.slice.getValue();
                if (slice.setPosition(n) && AxisSlicer.this.size != null) {
                    AxisSlicer.this.size.setSelection(slice.getNumSteps());
                }
                AxisSlicer.this.slice.setStart(n);
                if (AxisSlicer.this.value != null) {
                    AxisSlicer.this.value.setText(AxisSlicer.this.adata.getString(new int[]{n}));
                }
                AxisSlicer.this.reset.setEnabled(true);
            }
        });
        this.slider.setIncrements(1, 5);
        this.slider.setToolTipText("Starting position");
        this.value = new Text(this.composite, 2056);
        this.value.setToolTipText("Value at starting position");
        this.size = new Spinner(this.composite, 2048);
        this.size.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AxisSlicer.this.slice == null) {
                    return;
                }
                Slice slice = AxisSlicer.this.slice.getValue();
                Integer n = slice.getStart();
                int n2 = n == null ? 0 : n;
                int n3 = slice.getStep();
                int n4 = AxisSlicer.this.size.getSelection();
                int n5 = n2 + (n4 - 1) * n3 + 1;
                if (n5 > AxisSlicer.this.length) {
                    n5 = AxisSlicer.this.length;
                    n2 = n5 - 1 - (n4 - 1) * n3;
                    slice.setStart(Integer.valueOf(n2));
                    if (AxisSlicer.this.slider != null) {
                        AxisSlicer.this.slider.setValue(n2);
                    }
                    if (AxisSlicer.this.value != null) {
                        AxisSlicer.this.value.setText(String.format("%-20s", AxisSlicer.this.adata.getString(new int[]{n2})));
                    }
                }
                AxisSlicer.this.slice.setStop(n5);
                if (AxisSlicer.this.slider != null) {
                    AxisSlicer.this.slider.setThumb(n5 - n2);
                }
                AxisSlicer.this.reset.setEnabled(true);
            }
        });
        this.size.setToolTipText("Adjust number of items in slice");
        this.step = new Spinner(this.composite, 2048);
        this.step.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                if (AxisSlicer.this.slice == null) {
                    return;
                }
                int n2 = AxisSlicer.this.step.getSelection();
                Slice slice = AxisSlicer.this.slice.getValue();
                Integer n3 = slice.getStart();
                int n4 = n3 == null ? 0 : n3;
                int n5 = n4 + ((n = slice.getNumSteps()) - 1) * n2;
                if (n5 > AxisSlicer.this.length) {
                    n = (AxisSlicer.this.length - n4 - 1) / n2 + 1;
                    n5 = n4 + (n - 1) * n2;
                }
                if (AxisSlicer.this.size != null) {
                    AxisSlicer.this.size.setSelection(n);
                }
                slice.setStop(Integer.valueOf(n5 + 1));
                AxisSlicer.this.slice.setStep(n2);
                if (AxisSlicer.this.slider != null) {
                    AxisSlicer.this.slider.setThumb(n5 + 1 - n4);
                }
                int n6 = slice.getNumSteps(0, AxisSlicer.this.length);
                AxisSlicer.this.size.setMaximum(n6);
                AxisSlicer.this.reset.setEnabled(true);
            }
        });
        this.step.setToolTipText("Adjust step size in slice");
        this.reset = new Button(this.composite, 8);
        this.reset.setImage(undo);
        this.reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AxisSlicer.this.init(true);
                AxisSlicer.this.reset.setEnabled(false);
            }
        });
        this.reset.setToolTipText("Reset slice");
    }

    public void setParameters(String string, SliceProperty sliceProperty, ILazyDataset iLazyDataset, SliceProperty[] slicePropertyArray, boolean bl) {
        this.name = string;
        this.slice = sliceProperty;
        if (this.axisSlices != null) {
            int n = 0;
            while (n < this.axisSlices.length) {
                this.axisSlices[n].removePropertyChangeListener(this.listener);
                ++n;
            }
        }
        this.axisSlices = slicePropertyArray;
        this.mode = bl;
        this.axisData = iLazyDataset;
        this.createAxisDataset();
        this.init(false);
    }

    private void createAxisDataset() {
        int n = 0;
        while (n < this.axisSlices.length) {
            this.axisSlices[n].removePropertyChangeListener(this.listener);
            ++n;
        }
        if (this.axisData.getRank() > 1) {
            Slice[] sliceArray = new Slice[this.axisSlices.length];
            int n2 = 0;
            while (n2 < sliceArray.length) {
                SliceProperty sliceProperty = this.axisSlices[n2];
                if (sliceProperty != this.slice) {
                    sliceArray[n2] = sliceProperty.getValue();
                    if (sliceArray[n2].getNumSteps() > 1) {
                        sliceArray[n2] = new Slice(Integer.valueOf(0), Integer.valueOf(1));
                    }
                    sliceProperty.addPropertyChangeListener(this.listener);
                }
                ++n2;
            }
            this.adata = DatasetUtils.convertToAbstractDataset((ILazyDataset)this.axisData.getSlice(sliceArray).squeeze());
        } else {
            this.adata = DatasetUtils.convertToAbstractDataset((ILazyDataset)this.axisData.getSlice(new Slice[0]));
        }
        if (this.adata.getRank() == 0) {
            this.adata.setShape(new int[]{1});
        }
        assert (this.adata.getRank() == 1) : Arrays.toString(this.adata.getShape());
    }

    private void init(boolean bl) {
        int n;
        String string;
        Slice slice = this.slice.getValue();
        if (bl) {
            slice.setStart(null);
            if (this.mode) {
                slice.setStop(null);
            } else {
                slice.setStop(Integer.valueOf(1));
            }
            this.slice.setStep(1);
        } else {
            this.length = slice != null ? slice.getLength() : -1;
        }
        int n2 = this.slice.getMax();
        if (this.length < 0) {
            this.length = this.adata.getSize();
            this.slice.setLength(this.length);
        }
        if (n2 < 0) {
            n2 = this.length;
        }
        this.label.setText(this.name);
        this.slider.setMinMax(0, this.length, this.adata.getString(new int[]{0}), this.adata.getString(new int[]{this.length - 1}));
        this.slider.setIncrements(1, 5);
        boolean bl2 = false;
        if (slice == null) {
            this.slider.setValue(0);
            string = this.adata.getString(new int[]{0});
        } else {
            Integer n3 = slice.getStart();
            if (n3 == null || n3 == 0) {
                this.slider.setValue(0);
                string = this.adata.getString(new int[]{0});
            } else {
                this.slider.setValue(n3);
                string = this.adata.getString(new int[]{n3});
                bl2 = true;
            }
        }
        this.value.setText(String.format("%-20s", string));
        int n4 = n = slice != null ? slice.getNumSteps() : this.length;
        if (this.mode) {
            this.slider.setThumb(n);
        } else {
            int n5 = slice == null ? n2 : slice.getStep();
            this.slider.setThumb(n5);
        }
        this.size.setValues(n, 1, n2, 0, 1, 5 > n2 ? n2 : 5);
        this.step.setValues(1, 1, this.length, 0, 1, 1);
        this.step.setEnabled(this.mode);
        this.size.setEnabled(this.mode);
        this.reset.setEnabled(bl2);
        this.setVisible(true);
        this.composite.layout();
    }

    public void setVisible(boolean bl) {
        this.label.setVisible(bl);
        this.slider.setVisible(bl);
        this.value.setVisible(bl);
        this.size.setVisible(bl);
        this.step.setVisible(bl);
        this.reset.setVisible(bl);
    }
}

