/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelectionContentProvider;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelectionEditing;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelectionLabelProvider;

public class AxisSelectionTable
extends Composite {
    private List<AxisSelection> axes = null;
    private TableViewer axesSelector;
    private ArrayList<TableColumn> asColumns;
    private ICellEditorListener cListener;
    private static final int asWidth = 60;
    private AxisSelectionLabelProvider lProvider = null;

    public AxisSelectionTable(Composite composite) {
        this(composite, null);
    }

    public AxisSelectionTable(Composite composite, ICellEditorListener iCellEditorListener) {
        super(composite, 0);
        this.cListener = iCellEditorListener;
        this.axesSelector = new TableViewer((Composite)this, 101124);
        this.setLayout((Layout)new FillLayout());
        this.asColumns = new ArrayList();
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.axesSelector, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        this.asColumns.add(tableColumn);
        tableColumn.setText("Dim");
        tableColumn.setToolTipText("Dimension of dataset array");
        tableColumn.setWidth(40);
        tableColumn.setResizable(false);
        int n = 5;
        int n2 = 1;
        while (n2 < n) {
            tableViewerColumn = new TableViewerColumn(this.axesSelector, 0);
            tableColumn = tableViewerColumn.getColumn();
            this.asColumns.add(tableColumn);
            tableColumn.setText(String.valueOf(n2));
            tableColumn.setWidth(60);
            tableColumn.setMoveable(false);
            tableViewerColumn.setEditingSupport((EditingSupport)new AxisSelectionEditing((ColumnViewer)this.axesSelector, n2, this.cListener));
            ++n2;
        }
        Table table = this.axesSelector.getTable();
        table.setHeaderVisible(true);
        this.axesSelector.setContentProvider((IContentProvider)new AxisSelectionContentProvider());
        this.lProvider = new AxisSelectionLabelProvider(this.axes);
        this.axesSelector.setLabelProvider((IBaseLabelProvider)this.lProvider);
    }

    public void setInput(List<AxisSelection> list) {
        TableColumn tableColumn;
        this.axes = list;
        this.lProvider.setAxes(list);
        this.axesSelector.setInput(list);
        int n = 0;
        for (AxisSelection axisSelection : list) {
            if (n >= axisSelection.size()) continue;
            n = axisSelection.size();
        }
        int n2 = this.asColumns.size();
        int n3 = ++n - n2;
        int n4 = 1;
        while (n4 < n2) {
            tableColumn = this.asColumns.get(n4);
            tableColumn.setText(String.valueOf(n4));
            if (tableColumn.getWidth() == 0) {
                tableColumn.setWidth(60);
            }
            ++n4;
        }
        if (n3 > 0) {
            n4 = n2;
            while (n4 < n) {
                tableColumn = new TableViewerColumn(this.axesSelector, 0, n4);
                TableColumn tableColumn2 = tableColumn.getColumn();
                this.asColumns.add(tableColumn2);
                tableColumn2.setText(String.valueOf(n4));
                tableColumn2.setWidth(60);
                tableColumn2.setMoveable(false);
                tableColumn.setEditingSupport((EditingSupport)new AxisSelectionEditing((ColumnViewer)this.axesSelector, n4, this.cListener));
                tableColumn.setLabelProvider(this.axesSelector.getLabelProvider(0));
                ++n4;
            }
        } else {
            n4 = n2 - 1;
            while (n4 >= n) {
                tableColumn = this.asColumns.get(n4);
                tableColumn.setText("");
                tableColumn.setWidth(0);
                --n4;
            }
        }
        this.axesSelector.refresh();
        this.getParent().layout();
    }

    public void refresh() {
        this.axesSelector.refresh();
    }
}

