/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.InspectorProperty;

public class AxisSelection
extends InspectorProperty
implements Iterable<String> {
    private static final String propName = "axisselection";
    private int dim;
    private int length;
    private List<AxisSelData> asData;
    private List<String> names;
    private final String suffix;
    Transformer orderTransformer = new Transformer(){

        public Object transform(Object object) {
            if (object instanceof AxisSelData) {
                return ((AxisSelData)object).getOrder();
            }
            return null;
        }
    };
    Predicate axisSelectionPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (object instanceof AxisSelData) {
                return ((AxisSelData)object).isSelected();
            }
            return false;
        }
    };
    OrderPredicate orderPredicate = new OrderPredicate();

    public AxisSelection(int n, int n2) {
        this.dim = n2;
        this.length = n;
        this.asData = new ArrayList<AxisSelData>();
        this.names = new ArrayList<String>();
        this.suffix = ":" + (this.dim + 1);
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (AxisSelData axisSelData : this.asData) {
            stringBuilder.append(axisSelData.getData().getName());
            if (axisSelData.isSelected()) {
                stringBuilder.append('*');
            }
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void addChoice(AxisChoice axisChoice, int n) {
        String string = axisChoice.getName();
        if (axisChoice.getRank() > 1) {
            string = String.valueOf(string) + this.suffix;
        }
        this.addChoice(string, axisChoice, n);
    }

    public void addChoice(String string, AxisChoice axisChoice, int n) {
        int n2;
        AxisSelData axisSelData;
        int n3 = this.names.indexOf(string);
        if (n3 >= 0) {
            axisSelData = this.asData.get(n3);
            if (axisChoice != axisSelData.getData()) {
                axisSelData.setData(axisChoice);
            }
            if ((n2 = axisSelData.getOrder()) == n) {
                return;
            }
            this.names.remove(n3);
            this.asData.remove(n3);
        } else {
            axisSelData = new AxisSelData(axisChoice, false);
        }
        axisSelData.setOrder(n);
        if (n == 0) {
            this.names.add(string);
            this.asData.add(axisSelData);
        } else {
            this.orderPredicate.setOrder(n);
            n2 = this.asData.indexOf(CollectionUtils.find(this.asData, (Predicate)this.orderPredicate));
            if (n2 < 0) {
                this.names.add(string);
                this.asData.add(axisSelData);
            } else {
                this.names.add(n2, string);
                this.asData.add(n2, axisSelData);
            }
        }
        this.selectAxis(0);
    }

    public boolean containsAxis(String string) {
        return this.names.contains(string);
    }

    public void selectAxis(String string, boolean bl) {
        AxisSelData axisSelData2;
        int n = this.names.indexOf(string);
        if (n < 0) {
            return;
        }
        String string2 = this.getSelectedName();
        for (AxisSelData axisSelData2 : this.asData) {
            axisSelData2.setSelected(false);
        }
        axisSelData2 = this.asData.get(n);
        axisSelData2.setSelected(true);
        if (bl) {
            this.fire(new PropertyChangeEvent(this, propName, string2, string));
        }
    }

    public void selectAxis(int n) {
        this.selectAxis(n, false);
    }

    public void selectAxis(int n, boolean bl) {
        AxisSelData axisSelData = (AxisSelData)CollectionUtils.find(this.asData, (Predicate)this.axisSelectionPredicate);
        String string = null;
        if (axisSelData != null) {
            axisSelData.setSelected(false);
            string = this.names.get(this.asData.indexOf(axisSelData));
        }
        axisSelData = this.asData.get(n);
        axisSelData.setSelected(true);
        if (bl) {
            this.fire(new PropertyChangeEvent(this, propName, string, this.names.get(n)));
        }
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public List<String> getNames() {
        return this.names;
    }

    public int getOrder(int n) {
        AxisSelData axisSelData = this.asData.get(n);
        return axisSelData == null ? -1 : axisSelData.getOrder();
    }

    public AxisChoice getAxis(int n) {
        AxisSelData axisSelData = this.asData.get(n);
        return axisSelData == null ? null : axisSelData.getData();
    }

    public AxisChoice getAxis(String string) {
        int n = this.names.indexOf(string);
        return n < 0 ? null : this.asData.get(n).getData();
    }

    public void removeChoice(int n) {
        this.names.remove(n);
        this.asData.remove(n);
    }

    public void removeChoice(String string) {
        int n = this.names.indexOf(string);
        if (n < 0) {
            return;
        }
        this.removeChoice(n);
    }

    public int size() {
        return this.names.size();
    }

    public boolean isSelected(int n) {
        AxisSelData axisSelData = this.asData.get(n);
        return axisSelData == null ? false : axisSelData.isSelected();
    }

    public String getSelectedName() {
        int n = this.getSelectedIndex();
        return n < 0 ? null : this.names.get(n);
    }

    public int getSelectedIndex() {
        AxisSelData axisSelData = (AxisSelData)CollectionUtils.find(this.asData, (Predicate)this.axisSelectionPredicate);
        return this.asData.indexOf(axisSelData);
    }

    public int[] getSelectedIndexMapping() {
        AxisChoice axisChoice = this.getSelectedAxis();
        if (axisChoice != null) {
            return axisChoice.getIndexMapping();
        }
        return null;
    }

    public AxisChoice getSelectedAxis() {
        AxisSelData axisSelData = (AxisSelData)CollectionUtils.find(this.asData, (Predicate)this.axisSelectionPredicate);
        return axisSelData == null ? null : axisSelData.getData();
    }

    public void reorderChoices() {
    }

    public int getMaxOrder() {
        List list = (List)CollectionUtils.collect(this.asData, (Transformer)this.orderTransformer);
        return list.size() > 0 ? (Integer)Collections.max(list) : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AxisSelection) {
            AxisSelection axisSelection = (AxisSelection)object;
            if (!axisSelection.names.equals(this.names)) {
                return false;
            }
            return CollectionUtils.isEqualCollection(this.asData, axisSelection.asData);
        }
        return false;
    }

    public int hashCode() {
        int n = this.length;
        for (String object : this.names) {
            n = n * 17 + object.hashCode();
        }
        for (AxisSelData axisSelData : this.asData) {
            n = n * 17 + axisSelData.hashCode();
        }
        return n;
    }

    public AxisSelection clone() {
        AxisSelection axisSelection = new AxisSelection(this.length, this.dim);
        int n = 0;
        int n2 = this.asData.size();
        while (n < n2) {
            AxisSelData axisSelData = this.asData.get(n);
            axisSelection.addChoice(this.names.get(n), axisSelData.getData().clone(), axisSelData.getOrder());
            if (axisSelData.isSelected()) {
                axisSelection.selectAxis(n);
            }
            ++n;
        }
        return axisSelection;
    }

    @Override
    public Iterator<String> iterator() {
        return this.names.iterator();
    }

    class AxisSelData
    implements Comparable<AxisSelData> {
        private boolean selected;
        private int order;
        private AxisChoice data;

        public AxisSelData(AxisChoice axisChoice, boolean bl) {
            this.setData(axisChoice);
            this.setSelected(bl);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setOrder(int n) {
            this.order = n;
        }

        public int getOrder() {
            return this.order;
        }

        public void setData(AxisChoice axisChoice) {
            this.data = axisChoice;
        }

        public AxisChoice getData() {
            return this.data;
        }

        @Override
        public int compareTo(AxisSelData axisSelData) {
            int n = axisSelData.getOrder();
            if (this.order == 0) {
                return n == 0 ? 0 : 1;
            }
            if (n == 0) {
                return -1;
            }
            return this.order - n;
        }
    }

    class OrderPredicate
    implements Predicate {
        int order;

        OrderPredicate() {
        }

        public void setOrder(int n) {
            this.order = n;
        }

        public boolean evaluate(Object object) {
            AxisSelData axisSelData = (AxisSelData)object;
            int n = axisSelData.getOrder();
            return n == 0 || this.order < n;
        }
    }
}

