/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;

public class AxisChoice {
    private ILazyDataset values = null;
    private int primary;
    private int number;
    private int[] indexMapping = null;
    private String name;

    public AxisChoice(ILazyDataset iLazyDataset) {
        this(iLazyDataset, 0);
    }

    public AxisChoice(ILazyDataset iLazyDataset, int n) {
        this.setValues(iLazyDataset);
        this.setPrimary(n);
    }

    public String getName() {
        return this.values != null ? this.values.getName() : null;
    }

    public void setLongName(String string) {
        this.name = string;
    }

    public String getLongName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getName();
    }

    public void setValues(ILazyDataset iLazyDataset) {
        if (this.values != null && iLazyDataset != null && this.values.getRank() != iLazyDataset.getRank()) {
            throw new IllegalArgumentException("Replacement axis values dataset must have the same rank");
        }
        this.values = iLazyDataset;
    }

    public ILazyDataset getValues() {
        return this.values;
    }

    public void setPrimary(int n) {
        this.primary = n;
    }

    public int getPrimary() {
        return this.primary;
    }

    public void setIndexMapping(int ... nArray) {
        if (nArray.length != this.values.getRank()) {
            throw new IllegalArgumentException("Index mapping array must have a length that matches axis rank");
        }
        this.indexMapping = nArray;
    }

    public int[] getIndexMapping() {
        return this.indexMapping;
    }

    public boolean isDimensionUsed(int n) {
        return ArrayUtils.contains((int[])this.indexMapping, (int)n);
    }

    public void setAxisNumber(int n) {
        this.number = n;
        if (this.indexMapping == null) {
            this.indexMapping = new int[]{this.number};
        }
    }

    public int getAxisNumber() {
        return this.number;
    }

    public int getRank() {
        return this.values.getRank();
    }

    public int getSize() {
        return this.values.getSize();
    }

    public String toString() {
        return String.format("Choice %s: %s #%d = %s", this.getName(), Arrays.toString(this.values.getShape()), this.number, Arrays.toString(this.indexMapping));
    }

    public boolean equals(Object object) {
        if (this.values == null) {
            return false;
        }
        if (object instanceof String) {
            return this.values.getName().equals(object);
        }
        if (object instanceof AxisChoice) {
            if (!this.values.getName().equals(((AxisChoice)object).getValues().getName())) {
                return false;
            }
            if (!Arrays.equals(this.getIndexMapping(), ((AxisChoice)object).getIndexMapping())) {
                return false;
            }
            return this.values.equals(((AxisChoice)object).getValues());
        }
        return false;
    }

    public int hashCode() {
        int n = this.values.getSize();
        int[] nArray = this.indexMapping;
        int n2 = this.indexMapping.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            n = n * 17 + n4;
            ++n3;
        }
        String string = this.values.getName();
        n = string != null ? n * 17 + string.hashCode() : (n *= 17);
        n = n * 17 + this.values.hashCode();
        return n;
    }

    protected AxisChoice clone() {
        AxisChoice axisChoice = new AxisChoice(this.values, this.primary);
        axisChoice.setIndexMapping(this.indexMapping);
        axisChoice.setAxisNumber(this.number);
        return axisChoice;
    }
}

