/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.inspector;

import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.InspectionTab;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.PlotAxisProperty;

abstract class ATab
implements InspectionTab {
    protected static final Logger logger = LoggerFactory.getLogger(ATab.class);
    protected static final String PLOTNAME = "Dataset Plot";
    protected String text;
    protected String[] axes;
    protected List<Combo> combos;
    protected List<AxisSelection> daxes = null;
    protected List<PlotAxisProperty> paxes = null;
    protected Composite composite;
    protected DatasetSelection.InspectorType itype;
    protected IWorkbenchPartSite site;
    protected ILazyDataset dataset;
    protected int comboOffset = 0;

    public ATab(IWorkbenchPartSite iWorkbenchPartSite, DatasetSelection.InspectorType inspectorType, String string, String[] stringArray) {
        this.site = iWorkbenchPartSite;
        this.itype = inspectorType;
        this.text = string;
        this.axes = stringArray;
    }

    @Override
    public void setParameters(ILazyDataset iLazyDataset, List<AxisSelection> list, List<PlotAxisProperty> list2) {
        this.dataset = iLazyDataset;
        this.daxes = list;
        this.paxes = list2;
    }

    @Override
    public final String getTabTitle() {
        return this.text;
    }

    @Override
    public final DatasetSelection.InspectorType getType() {
        return this.itype;
    }

    @Override
    public boolean checkCompatible(ILazyDataset iLazyDataset) {
        boolean bl;
        boolean bl2 = bl = iLazyDataset.getRank() >= this.axes.length;
        if (this.composite != null) {
            this.composite.setEnabled(bl);
        }
        return bl;
    }

    @Override
    public final int getNumAxes() {
        if (this.axes == null) {
            return 0;
        }
        return this.axes.length;
    }

    @Override
    public boolean canPlotConstant() {
        return false;
    }
}

