/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import gda.observable.IObserver;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTGridEntry;
import uk.ac.diamond.scisoft.analysis.utils.ImageThumbnailLoader;

public class ThumbnailLoadService
implements Runnable,
IObserver {
    private static final transient Logger logger = LoggerFactory.getLogger(ThumbnailLoadService.class);
    private boolean terminate = false;
    private boolean localProcessing;
    private ArrayDeque<AbstractGridEntry> highPriorityQueue;
    private ArrayDeque<AbstractGridEntry> lowPriorityQueue;
    private PlotServer plotServer;
    private ArrayList<String> files = new ArrayList();
    private AbstractGridEntry currentProcessEntry = null;
    private final Semaphore locker = new Semaphore(1);
    private String viewName;

    public ThumbnailLoadService(String string) {
        this.highPriorityQueue = new ArrayDeque();
        this.lowPriorityQueue = new ArrayDeque();
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        try {
            this.localProcessing = this.plotServer.isServerLocal();
        }
        catch (Exception exception) {}
        this.viewName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminate) {
            AbstractGridEntry abstractGridEntry = null;
            Object object = this.highPriorityQueue;
            synchronized (object) {
                if (this.highPriorityQueue.size() > 0) {
                    abstractGridEntry = this.highPriorityQueue.pop();
                }
            }
            if (abstractGridEntry != null) {
                this.processJob(abstractGridEntry);
                continue;
            }
            object = this.lowPriorityQueue;
            synchronized (object) {
                if (this.lowPriorityQueue.size() > 0) {
                    abstractGridEntry = this.lowPriorityQueue.pop();
                }
            }
            if (abstractGridEntry != null) {
                this.processJob(abstractGridEntry);
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void undoBlock() {
        this.locker.release();
    }

    private void requestImageFromServer(AbstractGridEntry abstractGridEntry) {
        GuiBean guiBean = new GuiBean();
        this.files.clear();
        FileOperationBean fileOperationBean = new FileOperationBean(3);
        this.files.add(abstractGridEntry.getFilename());
        fileOperationBean.setFiles(this.files);
        guiBean.put(GuiParameters.FILEOPERATION, (Serializable)fileOperationBean);
        try {
            this.plotServer.updateGui(this.viewName, guiBean);
        }
        catch (Exception exception) {
            this.locker.release();
            exception.printStackTrace();
        }
    }

    private void loadAndCreateThumbnailImage(AbstractGridEntry abstractGridEntry) {
        AbstractDataset abstractDataset = ImageThumbnailLoader.loadImage((String)abstractGridEntry.getFilename(), (boolean)true);
        abstractGridEntry.createImage(abstractDataset);
        this.locker.release();
    }

    private void processJob(AbstractGridEntry abstractGridEntry) {
        try {
            this.locker.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.currentProcessEntry = abstractGridEntry;
        if (abstractGridEntry instanceof SWTGridEntry) {
            if (!((SWTGridEntry)abstractGridEntry).hasThumbnailImage()) {
                if (!this.localProcessing) {
                    this.requestImageFromServer(abstractGridEntry);
                } else {
                    this.loadAndCreateThumbnailImage(abstractGridEntry);
                }
            } else {
                ((SWTGridEntry)abstractGridEntry).loadThumbImage();
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
                this.locker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addLoadJob(AbstractGridEntry abstractGridEntry, boolean bl) {
        this.notify();
        if (bl) {
            ArrayDeque<AbstractGridEntry> arrayDeque = this.highPriorityQueue;
            synchronized (arrayDeque) {
                this.highPriorityQueue.add(abstractGridEntry);
            }
        }
        ArrayDeque<AbstractGridEntry> arrayDeque = this.lowPriorityQueue;
        synchronized (arrayDeque) {
            this.lowPriorityQueue.add(abstractGridEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearLowPriorityQueue() {
        ArrayDeque<AbstractGridEntry> arrayDeque = this.lowPriorityQueue;
        synchronized (arrayDeque) {
            this.lowPriorityQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearHighPriorityQueue() {
        ArrayDeque<AbstractGridEntry> arrayDeque = this.highPriorityQueue;
        synchronized (arrayDeque) {
            this.highPriorityQueue.clear();
        }
    }

    public void update(Object object, Object object2) {
        if (object2 instanceof String && object2.equals(this.viewName)) {
            try {
                try {
                    DataBean dataBean = this.plotServer.getData(this.viewName);
                    List list = dataBean.getData();
                    for (DataSetWithAxisInformation dataSetWithAxisInformation : list) {
                        AbstractDataset abstractDataset = dataSetWithAxisInformation.getData();
                        if (abstractDataset.getName().equals(this.currentProcessEntry.getFilename())) {
                            this.currentProcessEntry.createImage(abstractDataset);
                            continue;
                        }
                        logger.error("Oops, no match between dataset {} and current entry {}", (Object)abstractDataset.getName(), (Object)this.currentProcessEntry.getFilename());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.undoBlock();
                }
            }
            finally {
                this.undoBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.notify();
        ArrayDeque<AbstractGridEntry> arrayDeque = this.highPriorityQueue;
        synchronized (arrayDeque) {
            this.highPriorityQueue.clear();
        }
        arrayDeque = this.lowPriorityQueue;
        synchronized (arrayDeque) {
            this.lowPriorityQueue.clear();
        }
        this.plotServer.deleteIObserver((IObserver)this);
        this.terminate = true;
    }
}

