/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractImageGrid;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.GridEntryMonitor;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class SWTImageGrid
extends AbstractImageGrid
implements PaintListener,
Listener,
SelectionListener,
KeyListener,
MouseListener,
MouseMoveListener {
    private static final Logger logger = LoggerFactory.getLogger(SWTImageGrid.class);
    private static final int GRIDXGAPINPIXELS = 5;
    private static final int GRIDYGAPINPIXELS = 5;
    private static final int CTRL_MASK = 4;
    private static final int SHIFT_MASK = 8;
    private static final String DEFAULTPLOTVIEW = "Dataset Plot";
    private List<String> plotViews;
    private Canvas canvas;
    private ScrollBar vBar;
    private ScrollBar hBar;
    private Color background = null;
    private Color white = null;
    private Color green = null;
    private Color red = null;
    private Color blue = null;
    private int scrollX = 0;
    private int scrollY = 0;
    private int mouseX = 0;
    private int mouseY = 0;
    private int currentTileWidth = 0;
    private int currentTileHeight = 0;
    private int mouseButtonMode = 0;
    private boolean visualizeCache = false;
    private boolean overviewWindow = false;
    private SWTGridEntry toolTipEntry = null;
    private String viewName = null;
    private String imageFileToLoad = null;
    private Menu popupMenu = null;
    private boolean usePlotServer = true;

    public SWTImageGrid(Canvas canvas, String string) {
        this.canvas = canvas;
        this.viewName = string;
        this.setupGrid();
    }

    public SWTImageGrid(int n, int n2, Canvas canvas, String string) {
        super(n, n2);
        this.canvas = canvas;
        this.viewName = string;
        this.setupGrid();
    }

    private void setupGrid() {
        if (System.getProperty("uk.ac.diamond.scisoft.analysis.rcp.imagegrid.plotServer") != null) {
            this.usePlotServer = false;
        }
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addListener(11, (Listener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.vBar = this.canvas.getVerticalBar();
        this.hBar = this.canvas.getHorizontalBar();
        this.vBar.addSelectionListener((SelectionListener)this);
        this.hBar.addSelectionListener((SelectionListener)this);
        this.popupMenu = new Menu((Decorations)this.canvas.getShell(), 8);
        org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
        int n = MAXMEMORYUSAGE / (MAXTHUMBWIDTH * MAXTHUMBHEIGHT * 4);
        int n2 = rectangle.width / MINTHUMBWIDTH;
        int n3 = rectangle.height / MINTHUMBHEIGHT;
        this.monitor = new GridEntryMonitor(this, n2, n3, n, this.viewName);
        this.plotViews = ImageExplorerView.getRegisteredViews();
        if (this.plotViews.size() == 0) {
            this.plotViews.add(DEFAULTPLOTVIEW);
        }
        for (String string : this.plotViews) {
            MenuItem menuItem = new MenuItem(this.popupMenu, 8);
            menuItem.setText(string);
            menuItem.addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void displayGrid() {
    }

    private void displayWindowOverview(GC gC) {
        org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
        float f = (float)(rectangle.width - this.vBar.getSize().x) / (float)this.gridWidth;
        float f2 = (float)(rectangle.height - this.hBar.getSize().y) / (float)this.gridHeight;
        gC.setBackground(this.white);
        int n = 0;
        while (n < this.gridHeight) {
            int n2 = 0;
            while (n2 < this.gridWidth) {
                if (this.table[n2 + n * this.gridWidth] != null) {
                    gC.drawRectangle((int)((float)n2 * f) - 1, (int)((float)n * f2) - 1, 3, 3);
                }
                ++n2;
            }
            ++n;
        }
        float f3 = (float)rectangle.width / (float)(this.currentTileWidth + 5);
        float f4 = (float)rectangle.height / (float)(this.currentTileHeight + 5);
        if (this.green == null) {
            this.green = new Color((Device)this.canvas.getDisplay(), new RGB(0, 255, 0));
        }
        gC.setBackground(this.green);
        gC.setAlpha(128);
        gC.fillRectangle((int)((float)(-this.scrollX / this.currentTileWidth) * f), (int)((float)(-this.scrollY / this.currentTileHeight) * f2), (int)(f3 * f), (int)((f4 - 1.0f) * f2));
    }

    private void displayCaches(GC gC) {
        org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
        Rectangle rectangle2 = this.monitor.getPrimaryCacheArea();
        Rectangle rectangle3 = this.monitor.getSecondaryCacheArea();
        float f = (float)rectangle.width / (float)this.gridWidth;
        float f2 = (float)rectangle.height / (float)this.gridHeight;
        if (this.green == null) {
            this.green = new Color((Device)this.canvas.getDisplay(), new RGB(0, 255, 0));
        }
        if (this.red == null) {
            this.red = new Color((Device)this.canvas.getDisplay(), new RGB(255, 0, 0));
        }
        gC.setAlpha(255);
        gC.setBackground(this.white);
        int n = 0;
        while (n < this.gridHeight) {
            int n2 = 0;
            while (n2 < this.gridWidth) {
                if (this.table[n2 + n * this.gridWidth] != null) {
                    if (((SWTGridEntry)this.table[n2 + n * this.gridWidth]).hasImage()) {
                        gC.fillOval((int)((float)n2 * f), (int)((float)n * f2), 2, 2);
                    } else {
                        gC.drawOval((int)((float)n2 * f), (int)((float)n * f2), 2, 2);
                    }
                }
                ++n2;
            }
            ++n;
        }
        gC.setAlpha(128);
        gC.setBackground(this.green);
        gC.fillRectangle((int)((float)rectangle3.x * f), (int)((float)rectangle3.y * f2), (int)((float)rectangle3.width * f), (int)((float)rectangle3.height * f2));
        gC.setBackground(this.red);
        gC.fillRectangle((int)((float)rectangle2.x * f), (int)((float)rectangle2.y * f2), (int)((float)rectangle2.width * f), (int)((float)rectangle2.height * f2));
    }

    @Override
    protected void resizeGrid(int n, int n2) {
        super.resizeGrid(n, n2);
        this.canvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                org.eclipse.swt.graphics.Rectangle rectangle = SWTImageGrid.this.canvas.getClientArea();
                int n = rectangle.width / SWTImageGrid.this.gridWidth;
                int n2 = rectangle.height / SWTImageGrid.this.gridHeight;
                int n3 = Math.min(n, n2);
                n = Math.min(n3, MAXTHUMBWIDTH);
                n2 = Math.min(n3, MAXTHUMBHEIGHT);
                SWTImageGrid.this.currentTileWidth = Math.max(n3, MINTHUMBWIDTH);
                SWTImageGrid.this.currentTileHeight = Math.max(n3, MINTHUMBHEIGHT);
                SWTImageGrid.this.currentTileWidth = Math.min(SWTImageGrid.this.currentTileWidth, MAXTHUMBWIDTH);
                SWTImageGrid.this.currentTileHeight = Math.min(SWTImageGrid.this.currentTileHeight, MAXTHUMBHEIGHT);
                SWTImageGrid.this.vBar.setMinimum(0);
                SWTImageGrid.this.hBar.setMinimum(0);
                SWTImageGrid.this.vBar.setIncrement(SWTImageGrid.this.currentTileHeight + 5);
                SWTImageGrid.this.hBar.setIncrement(SWTImageGrid.this.currentTileWidth + 5);
                int n4 = (SWTImageGrid.this.currentTileWidth + 5) * SWTImageGrid.this.gridWidth - rectangle.width;
                int n5 = (SWTImageGrid.this.currentTileHeight + 5) * SWTImageGrid.this.gridHeight - rectangle.height;
                SWTImageGrid.this.hBar.setMaximum(Math.max(n4, 1));
                SWTImageGrid.this.vBar.setMaximum(Math.max(n5, 1));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paintControl(PaintEvent paintEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        GC gC = paintEvent.gc;
        if (this.background == null) {
            this.background = new Color((Device)this.canvas.getDisplay(), new RGB(64, 64, 64));
            this.white = new Color((Device)this.canvas.getDisplay(), new RGB(255, 255, 255));
            this.blue = new Color((Device)this.canvas.getDisplay(), new RGB(0, 0, 255));
        }
        org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
        gC.setAlpha(255);
        gC.setForeground(this.white);
        gC.setBackground(this.background);
        gC.fillRectangle(rectangle);
        if (this.currentTileWidth == 0 || this.currentTileHeight == 0) {
            n4 = rectangle.width / this.gridWidth;
            n3 = rectangle.height / this.gridHeight;
            int n5 = Math.min(n4, n3);
            n4 = Math.min(n5, MAXTHUMBWIDTH);
            n3 = Math.min(n5, MAXTHUMBHEIGHT);
            this.currentTileWidth = Math.max(n5, MINTHUMBWIDTH);
            this.currentTileHeight = Math.max(n5, MINTHUMBHEIGHT);
            this.currentTileWidth = Math.min(this.currentTileWidth, MAXTHUMBWIDTH);
            this.currentTileHeight = Math.min(this.currentTileHeight, MAXTHUMBHEIGHT);
            this.vBar.setMinimum(0);
            this.hBar.setMinimum(0);
            this.vBar.setIncrement(this.currentTileHeight + 5);
            this.hBar.setIncrement(this.currentTileWidth + 5);
            n2 = (this.currentTileWidth + 5) * this.gridWidth - rectangle.width;
            n = (this.currentTileHeight + 5) * this.gridHeight - rectangle.height;
            this.hBar.setMaximum(Math.max(n2, 1));
            this.vBar.setMaximum(Math.max(n, 1));
        }
        if (this.visualizeCache) {
            this.displayCaches(gC);
            gC.setBackground(this.background);
            return;
        }
        if (this.overviewWindow) {
            this.displayWindowOverview(gC);
            return;
        }
        n4 = -1;
        n3 = -1;
        this.toolTipEntry = null;
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            n2 = 0;
            while (n2 < this.gridHeight) {
                n = 0;
                while (n < this.gridWidth) {
                    if (this.table[n + n2 * this.gridWidth] != null) {
                        int n6 = this.scrollX + n * (this.currentTileWidth + 5);
                        int n7 = this.scrollY + n2 * (this.currentTileHeight + 5);
                        if (n6 > -this.currentTileWidth * 3 && n6 < this.canvas.getBounds().width + this.currentTileWidth * 3 && n7 > -this.currentTileHeight * 3 && n7 < this.canvas.getBounds().height + this.currentTileHeight * 3) {
                            SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n + n2 * this.gridWidth];
                            if (this.mouseButtonMode == 1) {
                                sWTGridEntry.setStatus(0);
                            }
                            if ((this.mouseButtonMode & 8) == 0 && this.mouseX >= n6 && this.mouseX <= n6 + this.currentTileWidth && this.mouseY >= n7 && this.mouseY <= n7 + this.currentTileHeight) {
                                n4 = n6;
                                n3 = n7;
                                this.toolTipEntry = sWTGridEntry;
                                if (this.mouseButtonMode > 0) {
                                    sWTGridEntry.setStatus(666);
                                }
                            }
                            if (sWTGridEntry != this.toolTipEntry) {
                                sWTGridEntry.paint(gC, n6, n7, this.currentTileWidth, this.currentTileHeight);
                            }
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            if (this.toolTipEntry == null) return;
            this.toolTipEntry.paint(gC, n4, n3, MAXTHUMBWIDTH, MAXTHUMBHEIGHT);
            gC.setAlpha(128);
            gC.setBackground(this.blue);
            gC.fillRectangle(n4, n3, MAXTHUMBWIDTH, MAXTHUMBHEIGHT);
            return;
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 11) {
            org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
            int n = rectangle.width / MINTHUMBWIDTH;
            int n2 = rectangle.height / MINTHUMBHEIGHT;
            this.monitor.resizeDisplayArea(n, n2);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.vBar) || selectionEvent.getSource().equals(this.hBar)) {
            this.scrollX = -this.hBar.getSelection();
            this.scrollY = -this.vBar.getSelection();
            int n = Math.round((float)(-this.scrollX) / (float)this.currentTileWidth);
            int n2 = Math.round((float)(-this.scrollY) / (float)this.currentTileHeight);
            this.monitor.updateMonitorPosition(n, n2);
            this.canvas.redraw();
        } else if (selectionEvent.getSource() instanceof MenuItem && this.imageFileToLoad != null) {
            ArrayList<String> arrayList = this.getSelection();
            if (arrayList == null || arrayList.size() == 0) {
                arrayList = new ArrayList();
                arrayList.add(this.imageFileToLoad);
            }
            this.sendOffLoadRequest(arrayList, ((MenuItem)selectionEvent.getSource()).getText());
        }
    }

    @Override
    public void dispose() {
        this.nextEntryY = 0;
        this.nextEntryX = 0;
        int n = 0;
        while (n < this.gridHeight) {
            int n2 = 0;
            while (n2 < this.gridWidth) {
                AbstractGridEntry abstractGridEntry = this.table[n2 + n * this.gridWidth];
                if (abstractGridEntry != null) {
                    abstractGridEntry.dispose();
                }
                this.table[n2 + n * this.gridWidth] = null;
                ++n2;
            }
            ++n;
        }
        System.gc();
        this.monitor.dispose();
        if (this.blue != null) {
            this.blue.dispose();
            this.blue = null;
        }
        if (this.green != null) {
            this.green.dispose();
            this.green = null;
        }
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
        if (this.background != null) {
            this.background.dispose();
            this.background = null;
        }
        if (this.white != null) {
            this.white.dispose();
            this.white = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.character == 'v' || keyEvent.character == 'V') {
            this.visualizeCache = !this.visualizeCache;
            this.canvas.redraw();
        }
        if (keyEvent.character == 'o' || keyEvent.character == 'O') {
            this.overviewWindow = !this.overviewWindow;
            this.canvas.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineFileToLoad() {
        String string = null;
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            int n = 0;
            while (n < this.gridHeight) {
                int n2 = 0;
                while (n2 < this.gridWidth) {
                    if (this.table[n2 + n * this.gridWidth] != null) {
                        SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n2 + n * this.gridWidth];
                        int n3 = this.scrollX + n2 * (this.currentTileWidth + 5);
                        int n4 = this.scrollY + n * (this.currentTileHeight + 5);
                        if (this.mouseButtonMode == 1) {
                            sWTGridEntry.setStatus(0);
                        }
                        if ((this.mouseButtonMode & 8) == 0 && this.mouseX >= n3 && this.mouseX <= n3 + this.currentTileWidth && this.mouseY >= n4 && this.mouseY <= n4 + this.currentTileHeight) {
                            string = sWTGridEntry.getFilename();
                            break;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string;
        }
    }

    private void sendOffLoadRequest(List<String> list, String string) {
        if (this.usePlotServer) {
            GuiBean guiBean = null;
            try {
                guiBean = PlotServerProvider.getPlotServer().getGuiState(this.viewName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (guiBean == null) {
                guiBean = new GuiBean();
            }
            FileOperationBean fileOperationBean = new FileOperationBean(2);
            fileOperationBean.setFiles(list);
            guiBean.put(GuiParameters.FILEOPERATION, (Serializable)fileOperationBean);
            guiBean.put(GuiParameters.DISPLAYFILEONVIEW, (Serializable)((Object)string));
            try {
                PlotServerProvider.getPlotServer().updateGui(this.viewName, guiBean);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                EclipseUtils.openExternalEditor((String)list.get(0));
            }
            catch (PartInitException partInitException) {
                logger.error("Cannot open " + list.get(0), (Throwable)partInitException);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        String string;
        if (!this.overviewWindow && (string = this.determineFileToLoad()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.sendOffLoadRequest(arrayList, this.plotViews.get(0));
        }
    }

    private void shiftSelect() {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.gridHeight) {
            n2 = 0;
            while (n2 < this.gridWidth) {
                if (this.table[n2 + n7 * this.gridWidth] != null) {
                    SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n2 + n7 * this.gridWidth];
                    n = this.scrollX + n2 * (this.currentTileWidth + 5);
                    int n8 = this.scrollY + n7 * (this.currentTileHeight + 5);
                    if (this.mouseX >= n && this.mouseX <= n + this.currentTileWidth && this.mouseY >= n8 && this.mouseY <= n8 + this.currentTileHeight) {
                        n3 = n2;
                        n4 = n7;
                        sWTGridEntry.setStatus(666);
                    } else if (sWTGridEntry.getStatus() == 666 && (n3 == -1 && n4 == -1 || n5 == 0 && n6 == 0)) {
                        n5 = n2;
                        n6 = n7;
                    }
                }
                ++n2;
            }
            ++n7;
        }
        n2 = n3 + n4 * this.gridWidth;
        n7 = n5 + n6 * this.gridWidth;
        if (n2 < n7) {
            int n9 = n2;
            n2 = n7;
            n7 = n9;
        }
        int n10 = this.gridWidth * this.gridHeight;
        if (n3 != -1 && n4 != -1) {
            n = n7;
            while (n < n2) {
                if (this.table[n] != null) {
                    SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n];
                    sWTGridEntry.setStatus(666);
                }
                ++n;
            }
            if ((this.mouseButtonMode & 4) != 4) {
                n = 0;
                while (n < n7) {
                    if (this.table[n] != null) {
                        SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n];
                        sWTGridEntry.setStatus(0);
                    }
                    ++n;
                }
                n = n2 + 1;
                while (n < n10) {
                    if (this.table[n] != null) {
                        SWTGridEntry sWTGridEntry = (SWTGridEntry)this.table[n];
                        sWTGridEntry.setStatus(0);
                    }
                    ++n;
                }
            }
        }
    }

    private void doRightMouseButton() {
        this.imageFileToLoad = this.determineFileToLoad();
        if (this.imageFileToLoad != null) {
            this.popupMenu.setVisible(true);
        }
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (!this.overviewWindow) {
            if (mouseEvent.button == 1) {
                this.mouseButtonMode = 1;
                if ((mouseEvent.stateMask & 0x40000) != 0) {
                    this.mouseButtonMode += 4;
                }
                if ((mouseEvent.stateMask & 0x20000) != 0) {
                    this.mouseButtonMode += 8;
                    this.shiftSelect();
                }
            } else if (mouseEvent.button == 3) {
                this.doRightMouseButton();
            }
        } else {
            org.eclipse.swt.graphics.Rectangle rectangle = this.canvas.getClientArea();
            float f = (float)(rectangle.width - this.vBar.getSize().x) / (float)this.gridWidth;
            float f2 = (float)(rectangle.height - this.hBar.getSize().y) / (float)this.gridHeight;
            float f3 = (float)rectangle.width / (float)(this.currentTileWidth + 5);
            float f4 = (float)(rectangle.height - this.hBar.getSize().y) / (float)(this.currentTileHeight + 5);
            float f5 = (float)mouseEvent.x / f;
            float f6 = (float)mouseEvent.y / f2;
            f5 -= f3 * 0.5f;
            f6 -= f4 * 0.5f;
            if (f5 + f3 >= (float)this.gridWidth) {
                f5 -= f5 + f3 - (float)this.gridWidth;
            }
            if (f6 + f4 >= (float)this.gridHeight) {
                f6 -= f6 + f4 - (float)this.gridHeight;
            }
            if ((double)f5 < 0.0) {
                f5 = 0.0f;
            }
            if ((double)f6 < 0.0) {
                f6 = 0.0f;
            }
            this.monitor.updateMonitorPosition(Math.round(f5), Math.round(f6));
            this.scrollX = -((int)(f5 * (float)(this.currentTileWidth + 5)));
            this.scrollY = -((int)(f6 * (float)(this.currentTileHeight + 5)));
            this.vBar.setSelection(-this.scrollY);
            this.hBar.setSelection(-this.scrollX);
        }
        this.canvas.redraw();
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.mouseButtonMode = 0;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.x;
        this.mouseY = mouseEvent.y;
        this.canvas.redraw();
        if (this.toolTipEntry != null && !this.overviewWindow) {
            this.canvas.setToolTipText(this.toolTipEntry.getToolTipText());
        } else {
            this.canvas.setToolTipText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getSelection() {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            int n = 0;
            while (n < this.gridHeight) {
                int n2 = 0;
                while (n2 < this.gridWidth) {
                    SWTGridEntry sWTGridEntry;
                    if (this.table[n2 + n * this.gridWidth] != null && (sWTGridEntry = (SWTGridEntry)this.table[n2 + n * this.gridWidth]).getStatus() == 666) {
                        arrayList.add(sWTGridEntry.getFilename());
                    }
                    ++n2;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return arrayList;
        }
    }

    @Override
    public void setOverviewMode(boolean bl) {
        this.overviewWindow = bl;
    }

    @Override
    public boolean getOverviewMode() {
        return this.overviewWindow;
    }

    @Override
    public void stopLoading() {
        this.monitor.stopLoading();
    }
}

