/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.SWTImageUtils;

public class SWTGridEntry
extends AbstractGridEntry {
    private static final Logger logger = LoggerFactory.getLogger(SWTGridEntry.class);
    private double loThreshold = 0.0;
    private double hiThreshold = 0.98;
    private static Color green = null;
    private static Color red = null;
    private static Color blue = null;
    private static long lastREDRAWinMillis = 0L;
    private Image gridImage = null;
    private Dimension imageDim;
    private Canvas canvas;
    private String toolTipText = null;
    private int colourMapChoice = 0;

    public SWTGridEntry(String string) {
        super(string);
    }

    public SWTGridEntry(String string, Object object) {
        super(string, object);
    }

    public SWTGridEntry(String string, Object object, Canvas canvas, int n, double d, double d2) {
        this(string, object);
        this.canvas = canvas;
        this.colourMapChoice = n;
        this.loThreshold = d;
        this.hiThreshold = d2;
    }

    @Override
    public void setNewfilename(String string) {
        this.filename = string;
        this.additionalInfo = null;
        if (this.gridImage != null) {
            this.gridImage.dispose();
        }
        if (this.thumbnailFilename != null) {
            File file = new File(this.thumbnailFilename);
            file.delete();
            this.thumbnailFilename = null;
        }
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    public void deActivate() {
        if (this.gridImage != null) {
            try {
                if (this.thumbnailFilename == null) {
                    File file = File.createTempFile("tmp_thumb", ".png");
                    String string = Platform.getInstanceLocation().getURL().getPath();
                    if (SWT.getPlatform().equals("win32") || SWT.getPlatform().equals("wpf")) {
                        string = string.substring(1);
                    }
                    this.thumbnailFilename = String.valueOf(string) + file.getName();
                    file.delete();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{this.gridImage.getImageData()};
                    imageLoader.save(this.thumbnailFilename, 5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.gridImage.dispose();
            this.gridImage = null;
        }
    }

    public void loadThumbImage() {
        if (this.gridImage == null) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SWTGridEntry.this.gridImage = new Image((Device)SWTGridEntry.this.canvas.getDisplay(), SWTGridEntry.this.thumbnailFilename);
                    if (System.currentTimeMillis() - lastREDRAWinMillis > 20L) {
                        SWTGridEntry.this.canvas.redraw();
                        lastREDRAWinMillis = System.currentTimeMillis();
                    }
                }
            });
        } else {
            logger.warn("Something is wrong");
        }
    }

    @Override
    public boolean isDeactivated() {
        return this.gridImage == null;
    }

    @Override
    public void createImage(final AbstractDataset abstractDataset) {
        this.canvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int[] nArray = abstractDataset.getShape();
                try {
                    if (nArray.length == 2) {
                        double d;
                        double d2;
                        double d3;
                        Object object;
                        double[] dArray;
                        RGBDataset rGBDataset;
                        if (SWTGridEntry.this.hiThreshold < 1.0) {
                            if (SWTGridEntry.this.loThreshold > 0.0) {
                                if (abstractDataset instanceof RGBDataset) {
                                    rGBDataset = (RGBDataset)abstractDataset;
                                    dArray = Stats.quantile((AbstractDataset)rGBDataset.createRedDataset(2), (double[])new double[]{SWTGridEntry.this.loThreshold, SWTGridEntry.this.hiThreshold});
                                    double[] dArray2 = new double[]{SWTGridEntry.this.loThreshold, SWTGridEntry.this.hiThreshold};
                                    object = Stats.quantile((AbstractDataset)rGBDataset.createGreenDataset(2), (double[])dArray2);
                                    if (dArray[0] > object[0]) {
                                        dArray[0] = (double)object[0];
                                    }
                                    if (dArray[1] < object[1]) {
                                        dArray[1] = (double)object[1];
                                    }
                                    double[] dArray3 = new double[]{SWTGridEntry.this.loThreshold, SWTGridEntry.this.hiThreshold};
                                    object = Stats.quantile((AbstractDataset)rGBDataset.createBlueDataset(2), (double[])dArray3);
                                    if (dArray[0] > object[0]) {
                                        dArray[0] = (double)object[0];
                                    }
                                    if (dArray[1] < object[1]) {
                                        dArray[1] = (double)object[1];
                                    }
                                } else {
                                    dArray = Stats.quantile((AbstractDataset)abstractDataset, (double[])new double[]{SWTGridEntry.this.loThreshold, SWTGridEntry.this.hiThreshold});
                                }
                            } else if (abstractDataset instanceof RGBDataset) {
                                rGBDataset = (RGBDataset)abstractDataset;
                                object = rGBDataset.createRedDataset(2);
                                d3 = object.min().doubleValue();
                                d2 = Stats.quantile((AbstractDataset)object, (double)SWTGridEntry.this.hiThreshold);
                                object = rGBDataset.createGreenDataset(2);
                                d = object.min().doubleValue();
                                if (d3 > d) {
                                    d3 = d;
                                }
                                if (d2 < (d = Stats.quantile((AbstractDataset)object, (double)SWTGridEntry.this.hiThreshold))) {
                                    d2 = d;
                                }
                                if (d3 > (d = (object = rGBDataset.createBlueDataset(2)).min().doubleValue())) {
                                    d3 = d;
                                }
                                if (d2 < (d = Stats.quantile((AbstractDataset)object, (double)SWTGridEntry.this.hiThreshold))) {
                                    d2 = d;
                                }
                                dArray = new double[]{d3, d2};
                            } else {
                                dArray = new double[]{abstractDataset.min().doubleValue(), Stats.quantile((AbstractDataset)abstractDataset, (double)SWTGridEntry.this.hiThreshold)};
                            }
                        } else if (SWTGridEntry.this.loThreshold > 0.0) {
                            if (abstractDataset instanceof RGBDataset) {
                                rGBDataset = (RGBDataset)abstractDataset;
                                object = rGBDataset.createRedDataset(2);
                                d3 = Stats.quantile((AbstractDataset)object, (double)SWTGridEntry.this.loThreshold);
                                d2 = object.max().doubleValue();
                                object = rGBDataset.createGreenDataset(2);
                                d = Stats.quantile((AbstractDataset)object, (double)SWTGridEntry.this.loThreshold);
                                if (d3 > d) {
                                    d3 = d;
                                }
                                if (d2 < (d = object.max().doubleValue())) {
                                    d2 = d;
                                }
                                if (d3 > (d = Stats.quantile((AbstractDataset)(object = rGBDataset.createBlueDataset(2)), (double)SWTGridEntry.this.loThreshold))) {
                                    d3 = d;
                                }
                                if (d2 < (d = object.max().doubleValue())) {
                                    d2 = d;
                                }
                                dArray = new double[]{d3, d2};
                            } else {
                                dArray = new double[]{Stats.quantile((AbstractDataset)abstractDataset, (double)SWTGridEntry.this.loThreshold), abstractDataset.max().doubleValue()};
                            }
                        } else if (abstractDataset instanceof RGBDataset) {
                            rGBDataset = (RGBDataset)abstractDataset;
                            object = rGBDataset.createRedDataset(2);
                            d3 = object.min().doubleValue();
                            d2 = object.max().doubleValue();
                            object = rGBDataset.createGreenDataset(2);
                            d = object.min().doubleValue();
                            if (d3 > d) {
                                d3 = d;
                            }
                            if (d2 < (d = object.max().doubleValue())) {
                                d2 = d;
                            }
                            if (d3 > (d = (object = rGBDataset.createBlueDataset(2)).min().doubleValue())) {
                                d3 = d;
                            }
                            if (d2 < (d = object.max().doubleValue())) {
                                d2 = d;
                            }
                            dArray = new double[]{d3, d2};
                        } else {
                            dArray = new double[]{abstractDataset.min().doubleValue(), abstractDataset.max().doubleValue()};
                        }
                        int n = GlobalColourMaps.colourSelectList.get(SWTGridEntry.this.colourMapChoice * 4);
                        int n2 = GlobalColourMaps.colourSelectList.get(SWTGridEntry.this.colourMapChoice * 4 + 1);
                        int n3 = GlobalColourMaps.colourSelectList.get(SWTGridEntry.this.colourMapChoice * 4 + 2);
                        AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(Math.abs(n));
                        AbstractMapFunction abstractMapFunction2 = GlobalColourMaps.mappingFunctions.get(Math.abs(n2));
                        AbstractMapFunction abstractMapFunction3 = GlobalColourMaps.mappingFunctions.get(Math.abs(n3));
                        ImageData imageData = SWTImageUtils.createImageData(abstractDataset, dArray[0], dArray[1], abstractMapFunction, abstractMapFunction2, abstractMapFunction3, n < 0, n2 < 0, n3 < 0);
                        SWTGridEntry.this.gridImage = new Image((Device)SWTGridEntry.this.canvas.getDisplay(), imageData);
                        SWTGridEntry.this.imageDim = new Dimension(nArray[1], nArray[0]);
                        SWTGridEntry.this.canvas.redraw();
                    } else {
                        SWTGridEntry.this.setStatus(-1);
                    }
                }
                catch (Exception exception) {
                    SWTGridEntry.this.setStatus(-1);
                }
            }
        });
    }

    public void paint(GC gC, int n, int n2, int n3, int n4) {
        if (this.gridImage != null && !this.gridImage.isDisposed()) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.imageDim.width > this.imageDim.height) {
                n8 = n3;
                n7 = 0;
                n6 = n4 * this.imageDim.height / this.imageDim.width;
                n5 = (n4 - n6) / 2;
            } else {
                n6 = n4;
                n5 = 0;
                n8 = n3 * this.imageDim.width / this.imageDim.height;
                n7 = (n3 - n8) / 2;
            }
            gC.drawImage(this.gridImage, 0, 0, this.imageDim.width, this.imageDim.height, n + n7, n2 + n5, n8, n6);
            switch (this.status) {
                case 1: {
                    if (green == null) {
                        green = new Color((Device)this.canvas.getDisplay(), new RGB(0, 255, 0));
                    }
                    gC.setForeground(green);
                    gC.drawRectangle(n, n2, n3, n4);
                    break;
                }
                case 2: {
                    if (red == null) {
                        red = new Color((Device)this.canvas.getDisplay(), new RGB(255, 0, 0));
                    }
                    gC.setForeground(red);
                    gC.drawRectangle(n, n2, n3, n4);
                    break;
                }
                case 666: {
                    if (blue == null) {
                        blue = new Color((Device)this.canvas.getDisplay(), new RGB(64, 64, 255));
                    }
                    gC.setAlpha(128);
                    gC.setBackground(blue);
                    gC.fillRectangle(n, n2, n3, n4);
                    gC.setAlpha(255);
                }
            }
        } else {
            if (red == null) {
                red = new Color((Device)this.canvas.getDisplay(), new RGB(255, 0, 0));
            }
            gC.setForeground(red);
            gC.drawLine(n + 8, n2 + 8, n + n3 - 8, n2 + n4 - 8);
            gC.drawLine(n + n3 - 8, n2 + 8, n + 8, n2 + n4 - 8);
        }
    }

    public Dimension getImageDimension() {
        return this.imageDim;
    }

    public boolean hasThumbnailImage() {
        return this.thumbnailFilename != null;
    }

    public boolean hasImage() {
        return this.gridImage != null && !this.gridImage.isDisposed();
    }

    @Override
    public void dispose() {
        if (this.gridImage != null && !this.gridImage.isDisposed()) {
            this.gridImage.dispose();
        }
        if (this.thumbnailFilename != null) {
            File file = new File(this.thumbnailFilename);
            file.delete();
        }
    }

    @Override
    public String getToolTipText() {
        if (this.additionalInfo == null && this.toolTipText == null) {
            this.toolTipText = new File(this.filename).getName();
        }
        return this.toolTipText;
    }
}

