/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveJobAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveQueue;

public class ImagePlayBack
implements Runnable {
    private static final transient Logger logger = LoggerFactory.getLogger(ImagePlayBack.class);
    private ArrayList<String> jobFiles = new ArrayList();
    private ArrayList<String> allFiles = new ArrayList();
    private int playPos = 0;
    private boolean terminate = false;
    private String viewName;
    private boolean hasOpenedView = false;
    private boolean waitTillfinished = false;
    private boolean paused = false;
    private boolean autoRewind = false;
    private IWorkbenchPage page;
    private int delay = 250;
    private int step = 1;
    private Slider sldProgress;
    private InteractiveQueue jobQueue;

    public ImagePlayBack(String string, IWorkbenchPage iWorkbenchPage, Slider slider, int n, int n2) {
        this.viewName = string;
        this.page = iWorkbenchPage;
        this.delay = n;
        this.step = n2;
        this.sldProgress = slider;
        this.jobQueue = new InteractiveQueue();
    }

    private void sendOffLoadRequest(String string) {
        IViewDescriptor[] iViewDescriptorArray;
        if (!this.hasOpenedView) {
            this.waitTillfinished = true;
            if (this.sldProgress.getDisplay().getThread() != Thread.currentThread()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IViewDescriptor[] iViewDescriptorArray = PlatformUI.getWorkbench().getViewRegistry().getViews();
                            int n = 0;
                            while (n < iViewDescriptorArray.length) {
                                if (iViewDescriptorArray[n].getLabel().equals(ImagePlayBack.this.viewName)) {
                                    ImagePlayBack.this.page.showView(iViewDescriptorArray[n].getId());
                                }
                                ++n;
                            }
                        }
                        catch (PartInitException partInitException) {
                            partInitException.printStackTrace();
                        }
                        ImagePlayBack.this.waitTillfinished = false;
                    }
                });
            } else {
                try {
                    iViewDescriptorArray = PlatformUI.getWorkbench().getViewRegistry().getViews();
                    int n = 0;
                    while (n < iViewDescriptorArray.length) {
                        if (iViewDescriptorArray[n].getLabel().equals(this.viewName)) {
                            this.page.showView(iViewDescriptorArray[n].getId());
                        }
                        ++n;
                    }
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
                this.waitTillfinished = false;
            }
            this.hasOpenedView = true;
        }
        while (this.waitTillfinished) {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        iViewDescriptorArray = new ArrayList();
        iViewDescriptorArray.add(string);
        GuiBean guiBean = new GuiBean();
        FileOperationBean fileOperationBean = new FileOperationBean(2);
        fileOperationBean.setFiles((List)iViewDescriptorArray);
        guiBean.put(GuiParameters.FILEOPERATION, (Serializable)fileOperationBean);
        guiBean.put(GuiParameters.DISPLAYFILEONVIEW, (Serializable)((Object)this.viewName));
        try {
            logger.debug("Sending request for " + string);
            PlotServerProvider.getPlotServer().updateGui(this.viewName, guiBean);
            logger.debug("Returned from sending request");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminate) {
            String string = null;
            Object object = this.jobFiles;
            synchronized (object) {
                if (this.playPos < this.jobFiles.size() && !this.paused) {
                    string = this.jobFiles.get(this.playPos);
                    final int n = this.playPos;
                    this.playPos += this.step;
                    if (this.autoRewind && this.playPos > this.jobFiles.size()) {
                        this.playPos = 0;
                    }
                    this.sldProgress.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ImagePlayBack.this.sldProgress.setSelection(n);
                        }
                    });
                }
            }
            if (string != null) {
                this.sendOffLoadRequest(string);
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public synchronized void stop() {
        this.playPos = 0;
        this.terminate = true;
        this.paused = false;
        this.notify();
    }

    public synchronized void rewind() {
        this.playPos = 0;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forward() {
        ArrayList<String> arrayList = this.jobFiles;
        synchronized (arrayList) {
            this.playPos = this.jobFiles.size() - 1;
        }
        this.notify();
    }

    public synchronized void start() {
        if (this.paused) {
            this.notify();
        }
        this.terminate = false;
        this.paused = false;
    }

    public synchronized void setDelay(int n) {
        this.delay = n;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearPlayback() {
        ArrayList<String> arrayList = this.jobFiles;
        synchronized (arrayList) {
            this.jobFiles.clear();
            this.allFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFile(String string) {
        ArrayList<String> arrayList = this.jobFiles;
        synchronized (arrayList) {
            this.jobFiles.add(string);
            this.allFiles.add(string);
            if (this.sldProgress.getDisplay().getThread() != Thread.currentThread()) {
                this.sldProgress.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImagePlayBack.this.sldProgress.setMaximum(ImagePlayBack.this.jobFiles.size());
                    }
                });
            } else {
                this.sldProgress.setMaximum(this.jobFiles.size());
            }
            this.notify();
        }
    }

    public synchronized void setSelection(ArrayList<String> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            this.jobFiles.clear();
            this.jobFiles.addAll(arrayList);
        } else {
            this.jobFiles.clear();
            this.jobFiles.addAll(this.allFiles);
        }
        this.sldProgress.setMaximum(this.jobFiles.size());
    }

    public synchronized void moveToLast() {
        String string;
        this.forward();
        if ((this.paused || this.terminate) && (string = this.jobFiles.get(this.playPos)) != null) {
            this.sendOffLoadRequest(string);
        }
    }

    public synchronized void setPlayPos(int n) {
        this.playPos = n;
        this.notify();
        if (this.paused || this.terminate) {
            if (this.playPos < 0 || this.playPos >= this.jobFiles.size()) {
                this.playPos = 0;
                return;
            }
            String string = this.jobFiles.get(this.playPos);
            if (string != null) {
                try {
                    IJob iJob = new IJob(string);
                    this.jobQueue.addJob(iJob);
                }
                catch (Exception exception) {
                    logger.error("Cannot generate new job", (Throwable)exception);
                }
            }
            this.playPos += this.step;
        }
    }

    public synchronized void setStepping(int n) {
        this.step = n;
    }

    public synchronized void setAutoRewind(boolean bl) {
        this.autoRewind = bl;
    }

    public void dispose() {
        this.jobQueue.dispose();
    }

    class IJob
    extends InteractiveJobAdapter {
        private String file;

        public IJob(String string) {
            this.file = string;
        }

        @Override
        public void run(IProgressMonitor iProgressMonitor) {
            if (!this.isNull()) {
                ImagePlayBack.this.sendOffLoadRequest(this.file);
            }
        }

        @Override
        public boolean isNull() {
            return this.file == null;
        }
    }
}

