/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions;

import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class GeoGreenMapFunction
extends AbstractMapFunction {
    private static final double region1 = 0.14285714285714285;
    private static final double region2 = 0.2;
    private static final double region3 = 0.3333333333333333;
    private static final double region4 = 0.4;
    private static final double region5 = 0.6666666666666666;
    private static final double region6 = 0.8333333333333334;

    @Override
    public String getMapFunctionName() {
        return "GeoGreen";
    }

    @Override
    public double mapFunction(double d) {
        if (d < 0.14285714285714285) {
            return 0.0;
        }
        if (d >= 0.14285714285714285 && d < 0.2) {
            return 3.75 * Math.sqrt(d - 0.14285714285714285);
        }
        if (d >= 0.2 && d < 0.3333333333333333) {
            return 0.9;
        }
        if (d >= 0.3333333333333333 && d < 0.4) {
            return 0.9 + (d - 0.3333333333333333);
        }
        if (d >= 0.4 && d < 0.6666666666666666) {
            return 0.9742 - 1.25 * (d - 0.4);
        }
        if (d >= 0.6666666666666666 && d < 0.8333333333333334) {
            return 0.6408666666666667 - 0.75 * Math.sqrt(d - 0.6666666666666666);
        }
        return 0.6408666666666667 - 0.75 * Math.sqrt(0.16666666666666674) + 28.0 * (d - 0.8333333333333334) * (d - 0.8333333333333334);
    }
}

