/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram;

import gda.observable.IObserver;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IActionBars;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AbstractPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class HistogramUI
extends AbstractPlotUI {
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private static HashMap<String, Boolean> autoScaleSettings = new HashMap();
    private Action zoomAction;
    private Action activateZoom;
    private Action lockScale;
    private Action autoScale;
    private Action showGraphLines;
    private HistogramView histoView;

    public HistogramUI(HistogramView histogramView, IActionBars iActionBars, DataSetPlotter dataSetPlotter) {
        this.histoView = histogramView;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter);
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter) {
        this.zoomAction = new Action(){

            public void run() {
                dataSetPlotter.undoZoom();
            }
        };
        this.zoomAction.setText("Undo zoom");
        this.zoomAction.setToolTipText("Undo a zoom level");
        this.zoomAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/minify.png"));
        this.activateZoom = new Action("", 2){

            public void run() {
                dataSetPlotter.setZoomEnabled(HistogramUI.this.activateZoom.isChecked());
            }
        };
        this.activateZoom.setText("Zoom");
        this.activateZoom.setToolTipText("Zoom mode");
        this.activateZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/magnify.png"));
        this.autoScale = new Action("", 2){

            public void run() {
                if (!HistogramUI.this.lockScale.isChecked()) {
                    HistogramUI.this.histoView.setAutoContrastScaling(HistogramUI.this.autoScale.isChecked());
                    autoScaleSettings.put(HistogramUI.this.histoView.getPartName(), HistogramUI.this.autoScale.isChecked());
                    HistogramUI.this.histoView.createInitialHistogram();
                } else {
                    HistogramUI.this.autoScale.setChecked(false);
                }
            }
        };
        this.autoScale.setText("Autoscale contrast");
        this.autoScale.setToolTipText("Automatically scale contrast");
        this.autoScale.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/contrast_out.png"));
        this.autoScale.setChecked(this.getPreferenceAutoConstrastChoice());
        this.histoView.setAutoContrastScaling(this.autoScale.isChecked());
        this.lockScale = new Action("", 2){

            public void run() {
                HistogramUI.this.histoView.setHistogramLock(HistogramUI.this.lockScale.isChecked());
                if (HistogramUI.this.lockScale.isChecked()) {
                    HistogramUI.this.histoView.setAutoContrastScaling(false);
                    HistogramUI.this.autoScale.setChecked(false);
                }
            }
        };
        this.lockScale.setText("Lock range");
        this.lockScale.setToolTipText("Lock mapping range for subsequent images");
        this.lockScale.setChecked(false);
        this.lockScale.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/lock.png"));
        this.showGraphLines = new Action("", 2){

            public void run() {
                HistogramUI.this.histoView.setGraphLines(HistogramUI.this.showGraphLines.isChecked());
            }
        };
        this.showGraphLines.setText("Show channel graphs");
        this.showGraphLines.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/chart_curve.png"));
        this.showGraphLines.setToolTipText("Active/deactivate colour channel graphs");
        this.showGraphLines.setChecked(true);
        iToolBarManager.add((IAction)this.activateZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.autoScale);
        iToolBarManager.add((IAction)this.lockScale);
        iToolBarManager.add((IAction)this.showGraphLines);
    }

    @Override
    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    @Override
    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    @Override
    public void deleteIObservers() {
        this.observers.clear();
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
    }

    private void notifyObservers(Object object) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, object);
        }
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        this.notifyObservers(areaSelectEvent);
    }

    private boolean getPreferenceAutoConstrastChoice() {
        if (this.histoView != null && autoScaleSettings.get(this.histoView.getPartName()) != null) {
            return autoScaleSettings.get(this.histoView.getPartName());
        }
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("plotView.plot2DautoContrast") ? iPreferenceStore.getDefaultBoolean("plotView.plot2DautoContrast") : iPreferenceStore.getBoolean("plotView.plot2DautoContrast");
    }
}

