/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.hdf5;

import gda.analysis.io.ScanFileHolderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Selection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.gda.monitor.IMonitor;

public class HDF5Utils {
    private static final Logger logger = LoggerFactory.getLogger(HDF5Utils.class);
    private static final String NXAXES = "axes";
    private static final String NXAXIS = "axis";
    private static final String NXLABEL = "label";
    private static final String NXPRIMARY = "primary";
    private static final String NXSIGNAL = "signal";
    private static final String NXDATA = "NXdata";
    private static final String NXNAME = "long_name";
    private static final String SDS = "SDS";
    private static final String NXENTRY = "NXentry";
    private static final String NXPROGRAM = "program_name";
    private static final String GDAVERSIONSTRING = "GDA ";

    public static HDF5Selection createDatasetSelection(HDF5NodeLink hDF5NodeLink, boolean bl) {
        Object object;
        Object object2;
        Object object322;
        Object object4;
        String[] stringArray;
        HDF5NodeLink hDF5NodeLink222;
        ILazyDataset iLazyDataset22;
        String string;
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HDF5Group hDF5Group = null;
        HDF5Dataset hDF5Dataset = null;
        HDF5Attribute hDF5Attribute = hDF5Node.getAttribute("NX_class");
        String string2 = string = hDF5Attribute != null ? hDF5Attribute.getFirstElement() : null;
        if (string == null || string.equals(SDS)) {
            if (!(hDF5Node instanceof HDF5Dataset)) {
                return null;
            }
            hDF5Dataset = (HDF5Dataset)hDF5Node;
            if (!hDF5Dataset.isSupported()) {
                return null;
            }
            hDF5Group = (HDF5Group)hDF5NodeLink.getSource();
        } else if (string.equals(NXDATA)) {
            assert (hDF5Node instanceof HDF5Group);
            hDF5Group = (HDF5Group)hDF5Node;
            for (ILazyDataset iLazyDataset22 : (HDF5Group)hDF5Node) {
                if (!iLazyDataset22.isDestinationADataset()) continue;
                hDF5Dataset = (HDF5Dataset)iLazyDataset22.getDestination();
                if (hDF5Dataset.containsAttribute(NXSIGNAL) && hDF5Dataset.isSupported()) {
                    hDF5NodeLink = iLazyDataset22;
                    break;
                }
                hDF5Dataset = null;
            }
        }
        if (hDF5Dataset == null || hDF5Group == null) {
            return null;
        }
        iLazyDataset22 = hDF5Dataset.getDataset();
        Iterator iterator = hDF5Dataset.getAttribute(NXAXES);
        hDF5Attribute = hDF5Dataset.getAttribute(NXNAME);
        if (hDF5Attribute != null && hDF5Attribute.isString()) {
            iLazyDataset22.setName(hDF5Attribute.getFirstElement());
        }
        iLazyDataset22.squeeze(true);
        int[] nArray = iLazyDataset22.getShape();
        int n = nArray.length;
        for (HDF5NodeLink hDF5NodeLink222 : hDF5Group) {
            if (!hDF5NodeLink222.isDestinationADataset() || !(stringArray = (String[])hDF5NodeLink222.getDestination()).isSupported() || stringArray.isString() || hDF5Dataset == stringArray || stringArray.containsAttribute(NXSIGNAL)) continue;
            object4 = stringArray.getDataset();
            try {
                int n2;
                Object object3;
                int[] nArray2 = object4.getShape();
                nArray2 = AbstractDataset.squeezeShape((int[])nArray2, (boolean)true);
                if (nArray2.length != 0) {
                    object4.squeeze(true);
                }
                object322 = object4.getShape();
                object2 = new AxisChoice((ILazyDataset)object4);
                hDF5Attribute = stringArray.getAttribute(NXNAME);
                if (hDF5Attribute != null && hDF5Attribute.isString()) {
                    ((AxisChoice)object2).setLongName(hDF5Attribute.getFirstElement());
                }
                HDF5Attribute hDF5Attribute2 = stringArray.getAttribute(NXAXIS);
                HDF5Attribute axisChoice = stringArray.getAttribute(NXLABEL);
                Object object5 = null;
                if (hDF5Attribute2 != null) {
                    String[] linkedHashMap;
                    if (hDF5Attribute2.isString()) {
                        linkedHashMap = hDF5Attribute2.getFirstElement().split(",");
                        if (linkedHashMap.length == ((Object)object322).length) {
                            object5 = new int[linkedHashMap.length];
                            int object7 = 0;
                            while (object7 < linkedHashMap.length) {
                                object3 = Integer.parseInt(linkedHashMap[object7]) - 1;
                                object5[object7] = bl ? object3 : n - 1 - object3;
                                ++object7;
                            }
                        }
                    } else {
                        linkedHashMap = hDF5Attribute2.getValue();
                        if (linkedHashMap.getSize() == ((Object)object322).length) {
                            object5 = new int[linkedHashMap.getSize()];
                            IndexIterator n5 = linkedHashMap.getIterator();
                            object3 = false;
                            while (n5.hasNext()) {
                                n2 = (int)linkedHashMap.getElementLongAbs(n5.index) - 1;
                                object5[object3++] = bl ? n2 : n - 1 - n2;
                            }
                        }
                    }
                    if (object5 == null) {
                        logger.warn("Axis attribute {} does not match rank", (Object)object4.getName());
                    } else {
                        int n6 = 0;
                        while (n6 < ((Object)object5).length) {
                            Object object6 = object322[n6];
                            object3 = object5[n6];
                            if (object3 < 0 || object3 >= n || object6 != nArray[object3]) {
                                object5 = null;
                                logger.warn("Axis attribute {} does not match shape", (Object)object4.getName());
                                break;
                            }
                            ++n6;
                        }
                    }
                }
                if (object5 == null) {
                    logger.warn("Creating index mapping from axis shape");
                    LinkedHashMap<Integer, Integer> n7 = new LinkedHashMap<Integer, Integer>();
                    int n3 = 0;
                    while (n3 < n) {
                        n7.put(n3, nArray[n3]);
                        ++n3;
                    }
                    object5 = new int[((Object)object322).length];
                    n3 = 0;
                    while (n3 < ((Object)object5).length) {
                        object3 = object322[n3];
                        object5[n3] = -1;
                        Iterator iterator2 = n7.keySet().iterator();
                        while (iterator2.hasNext()) {
                            n2 = (Integer)iterator2.next();
                            if (object3 != (Integer)n7.get(n2)) continue;
                            object5[n3] = n2;
                            n7.remove(n2);
                            break;
                        }
                        if (object5[n3] == -1) {
                            throw new IllegalArgumentException("Axis dimension does not match any data dimension");
                        }
                        ++n3;
                    }
                }
                ((AxisChoice)object2).setIndexMapping((int[])object5);
                if (axisChoice != null) {
                    if (axisChoice.isString()) {
                        int n8 = Integer.parseInt(axisChoice.getFirstElement()) - 1;
                        ((AxisChoice)object2).setAxisNumber(bl ? n8 : n - 1 - n8);
                    } else {
                        int abstractDataset = axisChoice.getValue().getInt(new int[]{0}) - 1;
                        ((AxisChoice)object2).setAxisNumber(bl ? abstractDataset : n - 1 - abstractDataset);
                    }
                } else {
                    ((AxisChoice)object2).setAxisNumber((int)object5[((Object)object5).length - 1]);
                }
                hDF5Attribute2 = stringArray.getAttribute(NXPRIMARY);
                if (hDF5Attribute2 != null) {
                    if (hDF5Attribute2.isString()) {
                        Integer n4 = Integer.parseInt(hDF5Attribute2.getFirstElement());
                        ((AxisChoice)object2).setPrimary(n4);
                    } else {
                        AbstractDataset abstractDataset = hDF5Attribute2.getValue();
                        ((AxisChoice)object2).setPrimary(abstractDataset.getInt(new int[]{0}));
                    }
                }
                arrayList.add(object2);
            }
            catch (Exception exception) {
                logger.warn("Axis attributes in {} are invalid - {}", (Object)object4.getName(), (Object)exception.getMessage());
            }
        }
        hDF5NodeLink222 = new ArrayList();
        if (iterator != null) {
            object = iterator.getFirstElement().trim();
            if (((String)object).startsWith("[")) {
                object = ((String)object).substring(1, ((String)object).length() - 1);
            }
            stringArray = null;
            stringArray = ((String)object).split("[:,]");
            object2 = stringArray;
            int n9 = stringArray.length;
            int n10 = 0;
            while (n10 < n9) {
                object4 = object2[n10];
                boolean bl2 = false;
                for (AxisChoice axisChoice : arrayList) {
                    if (!axisChoice.equals(object4)) continue;
                    if (axisChoice.getRank() == 1) {
                        bl2 = true;
                        break;
                    }
                    logger.warn("Referenced axis {} in tree node {} is not 1D", object4, (Object)hDF5Node);
                }
                if (bl2) {
                    hDF5NodeLink222.add(object4);
                } else {
                    logger.warn("Referenced axis {} does not exist in tree node {}", object4, (Object)hDF5Node);
                    hDF5NodeLink222.add(null);
                }
                ++n10;
            }
        }
        object = new ArrayList();
        int n11 = 0;
        while (n11 < n) {
            int n12 = nArray[n11];
            AxisSelection axisSelection = new AxisSelection(n12, n11);
            object.add(axisSelection);
            for (Object object322 : arrayList) {
                if (((AxisChoice)object322).getAxisNumber() == n11) {
                    axisSelection.addChoice((AxisChoice)object322, ((AxisChoice)object322).getPrimary());
                    continue;
                }
                if (((AxisChoice)object322).isDimensionUsed(n11)) {
                    axisSelection.addChoice((AxisChoice)object322, 0);
                    continue;
                }
                if (!hDF5NodeLink222.contains(((AxisChoice)object322).getName()) || hDF5NodeLink222.indexOf(((AxisChoice)object322).getName()) != n11 || !ArrayUtils.contains((int[])((AxisChoice)object322).getValues().getShape(), (int)n12)) continue;
                axisSelection.addChoice((AxisChoice)object322, 1);
            }
            object322 = AbstractDataset.arange((double)n12, (int)3);
            object322.setName("dim:" + (n11 + 1));
            object2 = new AxisChoice((ILazyDataset)object322);
            ((AxisChoice)object2).setAxisNumber(n11);
            axisSelection.addChoice((AxisChoice)object2, axisSelection.getMaxOrder() + 1);
            ++n11;
        }
        return new HDF5Selection(DatasetSelection.InspectorType.LINE, null, hDF5NodeLink.getFullName(), (List<AxisSelection>)object, iLazyDataset22);
    }

    public static boolean isOldGDAFile(String string, IMonitor iMonitor) throws ScanFileHolderException {
        HDF5File hDF5File = new HDF5Loader(string).loadTree(iMonitor);
        return HDF5Utils.isOldGDAFile(hDF5File);
    }

    public static boolean isOldGDAFile(HDF5File hDF5File) {
        for (HDF5NodeLink hDF5NodeLink : hDF5File.getGroup()) {
            HDF5Dataset hDF5Dataset;
            HDF5Group hDF5Group;
            HDF5Attribute hDF5Attribute;
            if (!hDF5NodeLink.isDestinationAGroup() || (hDF5Attribute = (hDF5Group = (HDF5Group)hDF5NodeLink.getDestination()).getAttribute("NX_class")) == null || !hDF5Attribute.isString() || !NXENTRY.equals(hDF5Attribute.getFirstElement()) || !hDF5Group.containsDataset(NXPROGRAM) || !(hDF5Dataset = hDF5Group.getDataset(NXPROGRAM)).isString()) continue;
            String string = hDF5Dataset.getString().trim();
            return string.contains(GDAVERSIONSTRING);
        }
        return false;
    }
}

