/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.hdf5;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.AbstractExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.MetadataSelection;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Selection;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5TableTree;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Utils;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.diamond.scisoft.analysis.rcp.views.AsciiTextView;
import uk.ac.gda.monitor.IMonitor;

public class HDF5TreeExplorer
extends AbstractExplorer
implements ISelectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(HDF5TreeExplorer.class);
    HDF5File tree = null;
    private HDF5TableTree tableTree = null;
    private Display display;
    private String filename;
    public static final String HDF5FILENAME_NODEPATH_SEPARATOR = "#";
    private HDF5Selection hdf5Selection;
    private Set<ISelectionChangedListener> cListeners;
    private Listener contextListener = null;
    private DataHolder holder;
    private boolean isOldGDA = false;
    private HDF5Loader loader = null;

    public HDF5TreeExplorer(Composite composite, IWorkbenchPartSite iWorkbenchPartSite, ISelectionChangedListener iSelectionChangedListener) {
        super(composite, iWorkbenchPartSite, iSelectionChangedListener);
        this.display = composite.getDisplay();
        this.setLayout((Layout)new FillLayout());
        if (this.metaValueListener != null) {
            this.contextListener = new Listener(){

                public void handleEvent(Event event) {
                    HDF5TreeExplorer.this.handleContextClick();
                }
            };
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    HDF5TreeExplorer.this.handleSingleClick();
                }
            }
        };
        this.tableTree = new HDF5TableTree(this, listener, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    HDF5TreeExplorer.this.handleDoubleClick();
                }
            }
        }, this.contextListener);
        this.cListeners = new HashSet<ISelectionChangedListener>();
    }

    public void selectHDF5Node(HDF5NodeLink hDF5NodeLink, DatasetSelection.InspectorType inspectorType) {
        if (hDF5NodeLink == null) {
            return;
        }
        if (this.processTextNode(hDF5NodeLink)) {
            return;
        }
        HDF5Selection hDF5Selection = HDF5Utils.createDatasetSelection(hDF5NodeLink, this.isOldGDA);
        if (hDF5Selection == null) {
            logger.error("Could not process update of selected node: {}", (Object)hDF5NodeLink.getName());
            return;
        }
        hDF5Selection.setFileName(this.filename);
        hDF5Selection.setType(inspectorType);
        this.setSelection((ISelection)hDF5Selection);
    }

    public void selectHDF5Node(String string, DatasetSelection.InspectorType inspectorType) {
        HDF5NodeLink hDF5NodeLink = this.tree.findNodeLink(string);
        if (hDF5NodeLink != null) {
            this.selectHDF5Node(hDF5NodeLink, inspectorType);
        } else {
            logger.debug("Could not find selected node: {}", (Object)string);
        }
    }

    private void handleContextClick() {
        IStructuredSelection iStructuredSelection = this.tableTree.getSelection();
        try {
            if (iStructuredSelection != null) {
                Object object = iStructuredSelection.getFirstElement();
                String string = null;
                if (object instanceof HDF5NodeLink) {
                    string = ((HDF5NodeLink)object).getFullName();
                } else if (object instanceof HDF5Attribute) {
                    string = ((HDF5Attribute)object).getFullName();
                }
                if (string != null) {
                    SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new MetadataSelection(string));
                    this.metaValueListener.selectionChanged(selectionChangedEvent);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Error processing selection: {}", (Object)exception.getMessage());
        }
    }

    private void handleSingleClick() {
        IStructuredSelection iStructuredSelection = this.tableTree.getSelection();
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)iStructuredSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.cListeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    private void handleDoubleClick() {
        Cursor cursor = this.getCursor();
        Cursor cursor2 = this.getDisplay().getSystemCursor(1);
        if (cursor2 != null) {
            this.setCursor(cursor2);
        }
        IStructuredSelection iStructuredSelection = this.tableTree.getSelection();
        try {
            try {
                if (iStructuredSelection != null && iStructuredSelection.getFirstElement() instanceof HDF5NodeLink) {
                    HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)iStructuredSelection.getFirstElement();
                    this.selectHDF5Node(hDF5NodeLink, DatasetSelection.InspectorType.LINE);
                }
            }
            catch (Exception exception) {
                logger.error("Error processing selection: {}", (Object)exception.getMessage());
                if (cursor2 != null) {
                    this.setCursor(cursor);
                }
            }
        }
        finally {
            if (cursor2 != null) {
                this.setCursor(cursor);
            }
        }
    }

    private boolean processTextNode(HDF5NodeLink hDF5NodeLink) {
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        if (!(hDF5Node instanceof HDF5Dataset)) {
            return false;
        }
        HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5Node;
        if (!hDF5Dataset.isString()) {
            return false;
        }
        try {
            this.getTextView().setData(hDF5Dataset.getString());
            return true;
        }
        catch (Exception exception) {
            logger.error("Error processing text node {}: {}", (Object)hDF5NodeLink.getName(), (Object)exception);
            return false;
        }
    }

    public void dispose() {
        if (this.loader != null) {
            this.loader.stopAsyncLoading();
        }
        this.cListeners.clear();
        super.dispose();
    }

    private AsciiTextView getTextView() {
        AsciiTextView asciiTextView = null;
        try {
            asciiTextView = (AsciiTextView)this.site.getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.results.navigator.AsciiTextView");
        }
        catch (PartInitException partInitException) {
            logger.error("All over now! Cannot find ASCII text view: {} ", (Throwable)partInitException);
        }
        return asciiTextView;
    }

    @Override
    public DataHolder loadFile(String string, IMonitor iMonitor) throws Exception {
        if (string == this.filename) {
            return this.holder;
        }
        return new HDF5Loader(string).loadFile(iMonitor);
    }

    @Override
    public void loadFileAndDisplay(String string, IMonitor iMonitor) throws Exception {
        this.loader = new HDF5Loader(string);
        this.loader.setAsyncLoad(true);
        HDF5File hDF5File = this.loader.loadTree(iMonitor);
        if (hDF5File != null) {
            this.holder = new DataHolder();
            Map map = HDF5Loader.createDatasetsMap((HDF5Group)hDF5File.getGroup());
            for (String string2 : map.keySet()) {
                this.holder.addDataset(string2, (ILazyDataset)map.get(string2));
            }
            this.holder.setMetadata(HDF5Loader.createMetaData((HDF5File)hDF5File));
            this.setFilename(string);
            this.setHDF5Tree(hDF5File);
        }
    }

    public HDF5File getHDF5Tree() {
        return this.tree;
    }

    public void setHDF5Tree(HDF5File hDF5File) {
        if (hDF5File == null) {
            return;
        }
        this.tree = hDF5File;
        this.isOldGDA = HDF5Utils.isOldGDAFile(this.tree);
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HDF5TreeExplorer.this.tableTree.setInput(HDF5TreeExplorer.this.tree.getNodeLink());
                    HDF5TreeExplorer.this.display.update();
                }
            });
        }
    }

    public void expandAll() {
        this.tableTree.expandAll();
    }

    public void expandToLevel(int n) {
        this.tableTree.expandToLevel(n);
    }

    public void expandToLevel(Object object, int n) {
        this.tableTree.expandToLevel(object, n);
    }

    public TreePath[] getExpandedTreePaths() {
        return this.tableTree.getExpandedTreePaths();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.cListeners.add(iSelectionChangedListener)) {
            return;
        }
    }

    public ISelection getSelection() {
        return this.hdf5Selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.cListeners.remove(iSelectionChangedListener)) {
            return;
        }
    }

    public void setSelection(ISelection iSelection) {
        if (!(iSelection instanceof HDF5Selection)) {
            return;
        }
        this.hdf5Selection = (HDF5Selection)iSelection;
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.hdf5Selection);
        for (ISelectionChangedListener iSelectionChangedListener : this.cListeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public HDF5TableTree getTableTree() {
        return this.tableTree;
    }
}

