/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.hdf5;

import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5LabelProvider;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5LazyContentProvider;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.TreeFilter;

public class HDF5TableTree
extends Composite {
    private TreeViewer tViewer = null;
    private Listener clistener;
    private Listener slistener;
    private Listener dlistener;
    private TreeFilter treeFilter;
    private Menu headerMenu;
    private Menu treeMenu;
    private static final String MSG_ENABLED = "Use this item as comparison value";
    private static final String MSG_DISABLED = "Cannot use the item";

    public HDF5TableTree(Composite composite, Listener listener, Listener listener2, Listener listener3) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.slistener = listener;
        this.dlistener = listener2;
        this.clistener = listener3;
        this.treeFilter = new TreeFilter(new String[]{"target", "NX_class"});
        this.tViewer = new TreeViewer((Composite)this, 0x10000800);
        this.tViewer.setUseHashlookup(true);
        final Tree tree = this.tViewer.getTree();
        tree.setHeaderVisible(true);
        String[] stringArray = new String[]{"Name", "Class", "Dims", "Type", "Data"};
        int[] nArray = new int[]{250, 120, 80, 60, 300};
        this.headerMenu = new Menu((Decorations)composite.getShell(), 8);
        int n = 0;
        while (n < stringArray.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.tViewer, 0);
            final TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(stringArray[n]);
            treeColumn.setWidth(nArray[n]);
            treeColumn.setMoveable(true);
            final MenuItem menuItem = new MenuItem(this.headerMenu, 32);
            menuItem.setText(stringArray[n]);
            menuItem.setSelection(true);
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (!menuItem.getSelection()) {
                        int n = treeColumn.getWidth();
                        treeColumn.setData("restoredWidth", (Object)n);
                        treeColumn.setWidth(0);
                    } else {
                        int n = (Integer)treeColumn.getData("restoredWidth");
                        treeColumn.setWidth(n);
                    }
                }
            });
            ++n;
        }
        this.treeMenu = new Menu((Decorations)composite.getShell(), 8);
        if (listener3 != null) {
            this.treeMenu.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    HDF5NodeLink hDF5NodeLink;
                    ITreeSelection iTreeSelection = (ITreeSelection)HDF5TableTree.this.tViewer.getSelection();
                    Object object = iTreeSelection.getFirstElement();
                    boolean bl = false;
                    if (object instanceof HDF5NodeLink) {
                        hDF5NodeLink = (HDF5NodeLink)object;
                        bl = hDF5NodeLink.isDestinationADataset() && !((HDF5Dataset)hDF5NodeLink.getDestination()).isString();
                    } else if (object instanceof HDF5Attribute) {
                        bl = !((HDF5Attribute)object).isString();
                    }
                    MenuItem[] menuItemArray = HDF5TableTree.this.treeMenu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        hDF5NodeLink = menuItemArray[n2];
                        hDF5NodeLink.setEnabled(bl);
                        hDF5NodeLink.setText(bl ? HDF5TableTree.MSG_ENABLED : HDF5TableTree.MSG_DISABLED);
                        ++n2;
                    }
                }
            });
            MenuItem menuItem = new MenuItem(this.treeMenu, 8);
            menuItem.addListener(13, listener3);
        }
        tree.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = HDF5TableTree.this.getDisplay().map(null, (Control)tree, new Point(event.x, event.y));
                Rectangle rectangle = tree.getClientArea();
                boolean bl = rectangle.y <= point.y && point.y < rectangle.y + tree.getHeaderHeight();
                tree.setMenu(bl ? HDF5TableTree.this.headerMenu : HDF5TableTree.this.treeMenu);
            }
        });
        this.tViewer.setContentProvider((IContentProvider)new HDF5LazyContentProvider(this.tViewer, this.treeFilter));
        this.tViewer.setLabelProvider((IBaseLabelProvider)new HDF5LabelProvider());
        if (listener != null) {
            tree.addListener(4, listener);
        }
        if (listener2 != null) {
            tree.addListener(8, listener2);
        }
    }

    public Viewer getViewer() {
        return this.tViewer;
    }

    public void dispose() {
        if (this.slistener != null) {
            this.tViewer.getTree().removeListener(4, this.slistener);
        }
        if (this.dlistener != null) {
            this.tViewer.getTree().removeListener(8, this.dlistener);
        }
        if (this.clistener != null) {
            MenuItem[] menuItemArray = this.treeMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.removeListener(13, this.clistener);
                ++n2;
            }
        }
        this.tViewer.getTree().dispose();
        if (this.headerMenu != null && !this.headerMenu.isDisposed()) {
            this.headerMenu.dispose();
        }
        if (this.treeMenu != null && !this.treeMenu.isDisposed()) {
            this.treeMenu.dispose();
        }
        super.dispose();
    }

    public static int countChildren(Object object, TreeFilter treeFilter) {
        int n = 0;
        if (object instanceof HDF5Attribute) {
            return 0;
        }
        if (object instanceof HDF5NodeLink) {
            HDF5Node hDF5Node = ((HDF5NodeLink)object).getDestination();
            Iterator iterator = hDF5Node.getAttributeNameIterator();
            while (iterator.hasNext()) {
                if (!treeFilter.select((String)iterator.next())) continue;
                ++n;
            }
            if (hDF5Node instanceof HDF5Group) {
                HDF5Group hDF5Group = (HDF5Group)hDF5Node;
                Iterator iterator2 = hDF5Group.getNodeNameIterator();
                while (iterator2.hasNext()) {
                    if (!treeFilter.select((String)iterator2.next())) continue;
                    ++n;
                }
            }
            boolean cfr_ignored_0 = hDF5Node instanceof HDF5Dataset;
        }
        return n;
    }

    public void setInput(HDF5NodeLink hDF5NodeLink) {
        if (this.tViewer != null && this.tViewer.getContentProvider() != null) {
            this.tViewer.setInput((Object)hDF5NodeLink);
        }
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.tViewer.getSelection();
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.tViewer.setSelection((ISelection)iStructuredSelection);
    }

    public void expandAll() {
        this.tViewer.expandAll();
    }

    public void expandToLevel(int n) {
        this.tViewer.expandToLevel(n);
    }

    public void expandToLevel(Object object, int n) {
        this.tViewer.expandToLevel(object, n);
    }

    public TreePath[] getExpandedTreePaths() {
        return this.tViewer.getExpandedTreePaths();
    }
}

