/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.hdf5;

import java.util.Iterator;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5TableTree;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.TreeFilter;

class HDF5LazyContentProvider
implements ILazyTreeContentProvider {
    private TreeViewer viewer;
    private TreeFilter filter;

    public HDF5LazyContentProvider(TreeViewer treeViewer, TreeFilter treeFilter) {
        this.filter = treeFilter;
        this.viewer = treeViewer;
    }

    public Object getParent(Object object) {
        if (object == null || !(object instanceof HDF5NodeLink)) {
            return null;
        }
        HDF5Node hDF5Node = ((HDF5NodeLink)object).getSource();
        if (hDF5Node == null) {
            return object;
        }
        return hDF5Node;
    }

    public void updateChildCount(Object object, int n) {
        int n2 = HDF5TableTree.countChildren(object, this.filter);
        if (n2 != n) {
            this.viewer.setChildCount(object, n2);
        }
    }

    public void updateElement(Object object, int n) {
        if (object instanceof HDF5Attribute) {
            return;
        }
        assert (object instanceof HDF5NodeLink) : "Not an attribute or a link";
        HDF5Node hDF5Node = ((HDF5NodeLink)object).getDestination();
        int n2 = 0;
        Iterator iterator = hDF5Node.getAttributeNameIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!this.filter.select(string2)) continue;
            if (n == n2) {
                HDF5Attribute hDF5Attribute = hDF5Node.getAttribute(string2);
                this.viewer.replace(object, n, (Object)hDF5Attribute);
                this.updateChildCount(hDF5Attribute, -1);
                return;
            }
            ++n2;
        }
        if (hDF5Node instanceof HDF5Group) {
            String string;
            for (String string2 : (HDF5Group)hDF5Node) {
                if (!string2.isDestinationAGroup()) continue;
                string = string2.getName();
                if (this.filter.select(string) && n == n2) {
                    this.viewer.replace(object, n, (Object)string2);
                    this.updateChildCount(string2, -1);
                    return;
                }
                ++n2;
            }
            for (String string2 : (HDF5Group)hDF5Node) {
                if (!string2.isDestinationADataset()) continue;
                string = string2.getName();
                if (this.filter.select(string) && n == n2) {
                    this.viewer.replace(object, n, (Object)string2);
                    this.updateChildCount(string2, -1);
                    return;
                }
                ++n2;
            }
        } else {
            boolean cfr_ignored_0 = hDF5Node instanceof HDF5Dataset;
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }
}

