/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.hdf5;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;

class HDF5LabelProvider
implements ITableLabelProvider {
    HDF5LabelProvider() {
    }

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        HDF5Attribute hDF5Attribute;
        String string = "";
        if (object instanceof HDF5Attribute) {
            HDF5Attribute hDF5Attribute2 = (HDF5Attribute)object;
            switch (n) {
                case 0: {
                    string = hDF5Attribute2.getName();
                    break;
                }
                case 1: {
                    string = "Attr";
                    break;
                }
                case 2: {
                    if (hDF5Attribute2.getSize() <= 1) break;
                    int[] nArray = hDF5Attribute2.getShape();
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray[n3];
                        string = String.valueOf(string) + n4 + ", ";
                        ++n3;
                    }
                    if (string.length() <= 2) break;
                    string = string.substring(0, string.length() - 2);
                    break;
                }
                case 3: {
                    string = hDF5Attribute2.getTypeName();
                    break;
                }
                case 4: {
                    string = hDF5Attribute2.getSize() == 1 ? hDF5Attribute2.getFirstElement() : hDF5Attribute2.toString();
                }
            }
            return string;
        }
        assert (object instanceof HDF5NodeLink) : "Not an attribute or a link";
        HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        switch (n) {
            case 0: {
                string = hDF5NodeLink.getName();
                break;
            }
            case 1: {
                hDF5Attribute = hDF5Node.getAttribute("NX_class");
                String string2 = string = hDF5Attribute != null ? hDF5Attribute.getFirstElement() : "Group";
            }
        }
        if (hDF5Node instanceof HDF5Dataset) {
            hDF5Attribute = (HDF5Dataset)hDF5Node;
            if (n == 1) {
                return "SDS";
            }
            if (hDF5Attribute.isString()) {
                switch (n) {
                    case 3: {
                        string = hDF5Attribute.getTypeName();
                        break;
                    }
                    case 4: {
                        string = hDF5Attribute.getString();
                        if (string.length() <= 100) break;
                        string = String.valueOf(string.substring(0, 100)) + "...";
                    }
                }
                return string;
            }
            if (!hDF5Attribute.isSupported()) {
                return n == 4 ? "Not supported" : string;
            }
            ILazyDataset iLazyDataset = hDF5Attribute.getDataset();
            int[] nArray = iLazyDataset.getShape();
            switch (n) {
                case 2: {
                    int[] nArray2 = nArray;
                    int n5 = nArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = nArray2[n6];
                        string = String.valueOf(string) + n7 + ", ";
                        ++n6;
                    }
                    if (string.length() <= 2) break;
                    string = string.substring(0, string.length() - 2);
                    break;
                }
                case 3: {
                    string = hDF5Attribute.getTypeName();
                    break;
                }
                case 4: {
                    string = iLazyDataset instanceof AbstractDataset ? ((AbstractDataset)iLazyDataset).getString(new int[]{0}) : "double-click to view";
                }
            }
        }
        return string;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

