/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.explorers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.AbstractExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.explorers.MetadataSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.gda.monitor.IMonitor;

public class ImageExplorer
extends AbstractExplorer
implements ISelectionProvider {
    private TableViewer viewer;
    private DataHolder data = null;
    private ISelectionChangedListener listener;
    private Display display = null;
    private SelectionAdapter contextListener = null;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private DatasetSelection dSelection = null;
    private ArrayList<String> metaNames;
    private String fileName;

    public ImageExplorer(Composite composite, IWorkbenchPartSite iWorkbenchPartSite, ISelectionChangedListener iSelectionChangedListener) {
        super(composite, iWorkbenchPartSite, iSelectionChangedListener);
        this.display = composite.getDisplay();
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer((Composite)this, 770);
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText("Name");
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText("min");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText("max");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText("Class");
        tableColumn.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ImageExplorer.this.selectItemSelection();
            }
        };
        this.viewer.addSelectionChangedListener(this.listener);
        if (this.metaValueListener != null) {
            final ImageExplorer imageExplorer = this;
            this.contextListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = ImageExplorer.this.viewer.getTable().getMenu().indexOf((MenuItem)selectionEvent.widget);
                    SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)imageExplorer, (ISelection)new MetadataSelection((String)ImageExplorer.this.metaNames.get(n)));
                    ImageExplorer.this.metaValueListener.selectionChanged(selectionChangedEvent);
                }
            };
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.listeners.contains(iSelectionChangedListener)) {
            this.listeners.add(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        return this.dSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (!(iSelection instanceof DatasetSelection)) {
            return;
        }
        this.dSelection = (DatasetSelection)iSelection;
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.dSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener(this.listener);
    }

    @Override
    public DataHolder loadFile(String string, IMonitor iMonitor) throws Exception {
        if (string == this.fileName) {
            return this.data;
        }
        return LoaderFactory.getData((String)string, (IMonitor)iMonitor);
    }

    @Override
    public void loadFileAndDisplay(String string, IMonitor iMonitor) throws Exception {
        this.fileName = string;
        this.data = LoaderFactory.getData((String)string, (IMonitor)iMonitor);
        if (this.data != null) {
            if (this.display != null) {
                final IMetaData iMetaData = this.data.getMetadata();
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageExplorer.this.viewer.setInput((Object)ImageExplorer.this.data);
                        ImageExplorer.this.display.update();
                        if (ImageExplorer.this.metaValueListener != null) {
                            ImageExplorer.this.addMenu(iMetaData);
                        }
                    }
                });
            }
            this.selectItemSelection();
        }
    }

    private ILazyDataset getActiveData() {
        ILazyDataset iLazyDataset;
        ISelection iSelection = this.viewer.getSelection();
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object == null) {
            iLazyDataset = this.data.getLazyDataset(0);
        } else if (object instanceof ILazyDataset) {
            iLazyDataset = (ILazyDataset)object;
        } else {
            return null;
        }
        if (iLazyDataset.getRank() > 2) {
            return null;
        }
        if (iLazyDataset.getRank() == 1) {
            iLazyDataset.setShape(new int[]{1, iLazyDataset.getShape()[0]});
        }
        return iLazyDataset;
    }

    private List<AxisSelection> getAxes(ILazyDataset iLazyDataset) {
        ArrayList<AxisSelection> arrayList = new ArrayList<AxisSelection>();
        int[] nArray = iLazyDataset.getShape();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            AxisSelection axisSelection = new AxisSelection(n2, n);
            arrayList.add(axisSelection);
            AbstractDataset abstractDataset = AbstractDataset.arange((double)n2, (int)3);
            abstractDataset.setName("dim:" + (n + 1));
            AxisChoice axisChoice = new AxisChoice((ILazyDataset)abstractDataset);
            axisChoice.setAxisNumber(n);
            axisSelection.addChoice(axisChoice, 0);
            int n3 = 0;
            int n4 = this.data.size();
            while (n3 < n4) {
                ILazyDataset iLazyDataset2 = this.data.getLazyDataset(n3);
                if (!iLazyDataset2.equals(iLazyDataset) && ArrayUtils.contains((int[])iLazyDataset2.getShape(), (int)n2)) {
                    axisChoice = new AxisChoice(iLazyDataset2);
                    axisChoice.setAxisNumber(n);
                    axisSelection.addChoice(axisChoice, n3 + 1);
                }
                ++n3;
            }
            ++n;
        }
        return arrayList;
    }

    public void selectItemSelection() {
        ILazyDataset iLazyDataset = this.getActiveData();
        if (iLazyDataset == null) {
            return;
        }
        iLazyDataset = iLazyDataset.clone();
        iLazyDataset.setName(String.valueOf(new File(this.fileName).getName()) + ":" + iLazyDataset.getName());
        DatasetSelection datasetSelection = new DatasetSelection(DatasetSelection.InspectorType.IMAGE, this.getAxes(iLazyDataset), iLazyDataset);
        this.setSelection((ISelection)datasetSelection);
    }

    private void addMenu(IMetaData iMetaData) {
        if (iMetaData != null) {
            Collection collection = null;
            try {
                collection = iMetaData.getMetaNames();
            }
            catch (Exception exception) {
                return;
            }
            if (collection == null) {
                return;
            }
            try {
                Menu menu = new Menu(this.viewer.getControl());
                this.metaNames = new ArrayList();
                for (String string : collection) {
                    try {
                        String string2 = iMetaData.getMetaValue(string).toString();
                        Double.parseDouble(string2);
                        this.metaNames.add(string);
                        MenuItem menuItem = new MenuItem(menu, 8);
                        menuItem.addSelectionListener((SelectionListener)this.contextListener);
                        menuItem.setText(String.valueOf(string) + " = " + string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.viewer.getTable().setMenu(menu);
            }
            catch (Exception exception) {}
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ImageExplorer.this.data.getList().toArray();
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            IDataset iDataset;
            if (object instanceof IDataset) {
                iDataset = (IDataset)object;
                if (n == 0) {
                    return iDataset.getName();
                }
                if (n == 1) {
                    return iDataset.min().toString();
                }
                if (n == 2) {
                    return iDataset.max().toString();
                }
                if (n == 3) {
                    String[] stringArray = iDataset.elementClass().toString().split("\\.");
                    return stringArray[stringArray.length - 1];
                }
            }
            if (object instanceof ILazyDataset) {
                iDataset = (ILazyDataset)object;
                if (n == 0) {
                    return iDataset.getName();
                }
                if (n == 1) {
                    return "Not Available";
                }
                if (n == 2) {
                    return "Not Available";
                }
                if (n == 3) {
                    return "Not Available";
                }
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return this.getImage(object);
            }
            return null;
        }

        public Image getImage(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

